"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const logger_1 = require("../../logger");
const web_1 = require("../../web");
const util_1 = require("../util");
test('defaults', () => {
    const p = new TestReactProject();
    expect(util_1.synthSnapshot(p)).toMatchSnapshot();
});
test('rewire creates config-overrides.js', () => {
    const p = new TestReactProject({
        rewire: {
            'module.prop1': false,
            'module.prop2': 5,
            'module.prop3': [1, 2],
            'module.prop4': { one: 2 },
            'module.prop5': 'one',
        },
    });
    const snapshot = util_1.synthSnapshot(p)['.projen/react-config-overrides.js'];
    expect(snapshot).toMatchSnapshot();
});
test('rewire replaces react-scripts', () => {
    const p = new TestReactProject({
        rewire: { 'module.prop1': false },
    });
    function assertExec(taskName, script) {
        const task = p.tasks.tryFind(taskName);
        if (!task) {
            throw new Error(`Task not found: ${taskName}`);
        }
        expect(task.steps[task.steps.length - 1].exec).toEqual(script);
    }
    assertExec('build', 'react-app-rewired build');
    assertExec('test', 'react-app-rewired test --watchAll=false');
    assertExec('dev', 'react-app-rewired start');
    assertExec('eject', 'react-scripts eject');
});
test('rewire add a dependency on react-app-rewired', () => {
    const p = new TestReactProject({
        rewire: { 'module.prop1': false },
    });
    expect(p.deps.getDependency('react-app-rewired')).toBeDefined();
});
class TestReactProject extends web_1.ReactProject {
    constructor(options = {}) {
        super({
            ...options,
            clobber: false,
            name: 'test-nextjs-project',
            outdir: util_1.mkdtemp(),
            logging: { level: logger_1.LogLevel.OFF },
            defaultReleaseBranch: 'main',
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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