"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolve = void 0;
function isResolvable(obj) {
    return obj.toJSON !== undefined;
}
function resolve(value, options = {}) {
    var _a, _b, _c, _d;
    const args = (_a = options.args) !== null && _a !== void 0 ? _a : [];
    const omitEmpty = (_b = options.omitEmpty) !== null && _b !== void 0 ? _b : false;
    if (value == null) {
        return value;
    }
    if (isResolvable(value)) {
        const resolved = value.toJSON();
        return resolve(resolved, options);
    }
    // if value is a function, call it and resolve the result.
    if (typeof (value) === 'function') {
        const resolved = value.apply(undefined, args);
        return resolve(resolved, options);
    }
    if (typeof (value) !== 'object') {
        return value;
    }
    if (Array.isArray(value)) {
        if (omitEmpty && value.length === 0) {
            return undefined;
        }
        return value
            .map(x => resolve(x, options))
            .filter(x => x != null); // filter undefined/null/omitted
    }
    // only allow data types (i.e. objects without constructors)
    if (value.constructor && ((_c = value.constructor) === null || _c === void 0 ? void 0 : _c.name) !== 'Object') {
        throw new Error(`only data types can be resolved. trying to resolve object of type ${(_d = value.constructor) === null || _d === void 0 ? void 0 : _d.name}`);
    }
    const result = {};
    for (const [k, v] of Object.entries(value)) {
        const resolved = resolve(v, options);
        // skip undefined values
        if (resolved === undefined) {
            continue;
        }
        result[k] = resolved;
    }
    if (omitEmpty && Object.keys(result).length === 0) {
        return undefined;
    }
    return result;
}
exports.resolve = resolve;
//# sourceMappingURL=data:application/json;base64,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