"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cdk8sTypeScriptApp = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const fs = require("fs-extra");
const component_1 = require("./component");
const typescript_1 = require("./typescript");
/**
 * (experimental) CDK8s app in TypeScript.
 *
 * @experimental
 * @pjid cdk8s-app-ts
 */
class Cdk8sTypeScriptApp extends typescript_1.TypeScriptAppProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _b, _c;
        super({
            ...options,
            sampleCode: false,
        });
        // encode a hidden assumption further down the chain
        if (this.srcdir !== 'src') {
            throw new Error('sources are expected under the "src" directory');
        }
        // encode a hidden assumption further down the chain
        if (this.testdir !== 'test') {
            throw new Error('test sources are expected under the "test" directory');
        }
        this.appEntrypoint = (_b = options.appEntrypoint) !== null && _b !== void 0 ? _b : 'main.ts';
        this.cdk8sVersion = options.cdk8sVersionPinning ? options.cdk8sVersion : `^${options.cdk8sVersion}`;
        if (!!options.cdk8sPlusVersion) {
            this.cdk8sPlusVersion = options.cdk8sPlusVersionPinning ? options.cdk8sPlusVersion : `^${options.cdk8sPlusVersion}`;
        }
        else {
            this.cdk8sPlusVersion = this.cdk8sVersion;
        }
        if (options.constructsVersion) {
            this.constructsVersion = options.constructsVersionPinning ? options.constructsVersion : `^${options.constructsVersion}`;
        }
        else {
            this.constructsVersion = '^3.2.34';
        }
        if (!!options.cdk8sCliVersion) {
            this.cdk8sCliVersion = options.cdk8sCliVersionPinning ? options.cdk8sCliVersion : `^${options.cdk8sCliVersion}`;
        }
        else {
            this.cdk8sCliVersion = this.cdk8sVersion;
        }
        // CLI
        this.addDeps(`cdk8s@${this.cdk8sVersion}`, `constructs@${this.constructsVersion}`, `cdk8s-plus-17@${this.cdk8sPlusVersion}`);
        this.addDevDeps('ts-node@^9', `cdk8s-cli@${this.cdk8sCliVersion}`, `cdk8s@${this.cdk8sVersion}`, `constructs@${this.constructsVersion}`, `cdk8s-plus-17@${this.cdk8sPlusVersion}`);
        const synth = this.addTask('synth', {
            description: 'Synthesizes your cdk8s app into dist (part of "yarn build")',
            exec: 'cdk8s synth',
        });
        this.addTask('import', {
            description: 'Imports API objects to your app by generating constructs.',
            exec: 'cdk8s import',
        });
        this.gitignore.include('imports/');
        this.gitignore.include('cdk8s.yaml');
        // add synth to the build
        this.buildTask.spawn(synth);
        if ((_c = options.sampleCode) !== null && _c !== void 0 ? _c : true) {
            new SampleCode(this);
        }
    }
}
exports.Cdk8sTypeScriptApp = Cdk8sTypeScriptApp;
_a = JSII_RTTI_SYMBOL_1;
Cdk8sTypeScriptApp[_a] = { fqn: "projen.Cdk8sTypeScriptApp", version: "0.27.22" };
class SampleCode extends component_1.Component {
    constructor(project) {
        super(project);
        this.appProject = project;
    }
    synthesize() {
        const outdir = this.project.outdir;
        const srcdir = path.join(outdir, this.appProject.srcdir);
        if (fs.pathExistsSync(srcdir) && fs.readdirSync(srcdir).filter(x => x.endsWith('.ts'))) {
            return;
        }
        const srcCode = `import { Construct } from 'constructs';
import { App, Chart, ChartProps, ApiObject } from 'cdk8s';

export class MyChart extends Chart {
  constructor(scope: Construct, id: string, props: ChartProps = { }) {
    super(scope, id, props);

    const label = { app: 'hello-k8s' };



    new ApiObject(this, 'deployment', {
      apiVersion: "v1",
      kind: "Pod",
      metadata: {
          namespace: "frontend",
          name: "nginx",
          labels: label,
      },
      spec: {
          containers: [{
              name: "nginx",
              image: "nginx:1.14-alpine",
              resources: {
                  limits: {
                      memory: "20Mi",
                      cpu: 0.2,
                  },
              },
          }],
      },
    });
  }
}

const app = new App();
new MyChart(app, 'hello');
app.synth();`;
        fs.mkdirpSync(srcdir);
        fs.writeFileSync(path.join(srcdir, this.appProject.appEntrypoint), srcCode);
        const appEntrypointName = path.basename(this.appProject.appEntrypoint, '.ts');
        const cdk8sYaml = `language: typescript
app: node lib/${appEntrypointName}.js
imports:
  - k8s
    `;
        fs.writeFileSync(path.join(outdir, 'cdk8s.yaml'), cdk8sYaml);
    }
}
//# sourceMappingURL=data:application/json;base64,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