"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConstructLibraryCdk8s = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const construct_lib_1 = require("./construct-lib");
/**
 * (experimental) CDK8s construct library project.
 *
 * A multi-language (jsii) construct library which vends constructs designed to
 * use within the CDK for Kubernetes (CDK8s), with a friendly workflow and
 * automatic publishing to the construct catalog.
 *
 * @experimental
 * @pjid cdk8s-construct
 */
class ConstructLibraryCdk8s extends construct_lib_1.ConstructLibrary {
    /**
     * @experimental
     */
    constructor(options) {
        super(options);
        this.cdk8sVersion = options.cdk8sVersionPinning ? options.cdk8sVersion : `^${options.cdk8sVersion}`;
        if (options.constructsVersion) {
            this.constructsVersion = options.constructsVersionPinning ? options.constructsVersion : `^${options.constructsVersion}`;
        }
        else {
            this.constructsVersion = '^3.2.34';
        }
        if (!!options.cdk8sPlusVersion) {
            this.cdk8sPlusVersion = options.cdk8sPlusVersionPinning ? options.cdk8sPlusVersion : `^${options.cdk8sPlusVersion}`;
        }
        else {
            this.cdk8sPlusVersion = this.cdk8sVersion;
        }
        this.addPeerDeps(`constructs@${this.constructsVersion}`, `cdk8s@${this.cdk8sVersion}`, `cdk8s-plus-17@${this.cdk8sPlusVersion}`);
    }
}
exports.ConstructLibraryCdk8s = ConstructLibraryCdk8s;
_a = JSII_RTTI_SYMBOL_1;
ConstructLibraryCdk8s[_a] = { fqn: "projen.ConstructLibraryCdk8s", version: "0.27.22" };
//# sourceMappingURL=data:application/json;base64,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