"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitAttributesFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const file_1 = require("../file");
/**
 * (experimental) Assign attributes to file names in a git repository.
 *
 * @see https://git-scm.com/docs/gitattributes
 * @experimental
 */
class GitAttributesFile extends file_1.FileBase {
    /**
     * @experimental
     */
    constructor(project) {
        super(project, '.gitattributes', {
            editGitignore: false,
        });
        this.attributes = new Map();
    }
    /**
     * (experimental) Maps a set of attributes to a set of files.
     *
     * @param glob Glob pattern to match files in the repo.
     * @param attributes Attributes to assign to these files.
     * @experimental
     */
    addAttributes(glob, ...attributes) {
        if (!this.attributes.has(glob)) {
            this.attributes.set(glob, new Set());
        }
        const set = this.attributes.get(glob);
        for (const attribute of attributes) {
            set.add(attribute);
        }
    }
    /**
     * (experimental) Implemented by derived classes and returns the contents of the file to emit.
     *
     * @experimental
     */
    synthesizeContent(_) {
        // We can assume the file map is never empty.
        const entries = Array.from(this.attributes.entries())
            .sort(([l], [r]) => l.localeCompare(r));
        const maxLen = Math.max(...entries.map(([glob]) => glob.length));
        return [
            `# ${file_1.FileBase.PROJEN_MARKER}`,
            '',
            ...entries.map(([name, attributes]) => `${name.padEnd(maxLen, ' ')}\t${Array.from(attributes).join(' ')}`),
        ].join('\n');
    }
}
exports.GitAttributesFile = GitAttributesFile;
_a = JSII_RTTI_SYMBOL_1;
GitAttributesFile[_a] = { fqn: "projen.git.GitAttributesFile", version: "0.27.22" };
//# sourceMappingURL=data:application/json;base64,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