import { Component } from '../component';
import { GitHub } from './github';
/**
 * @experimental
 */
export interface DependabotOptions {
    /**
     * (experimental) How often to check for new versions and raise pull requests.
     *
     * @default ScheduleInterval.DAILY
     * @experimental
     */
    readonly scheduleInterval?: DependabotScheduleInterval;
    /**
     * (experimental) The strategy to use when edits manifest and lock files.
     *
     * @default VersioningStrategy.LOCKFILE_ONLY The default is to only update the
     * lock file because package.json is controlled by projen and any outside
     * updates will fail the build.
     * @experimental
     */
    readonly versioningStrategy?: VersioningStrategy;
    /**
     * (experimental) You can use the `ignore` option to customize which dependencies are updated.
     *
     * The ignore option supports the following options.
     *
     * @default []
     * @experimental
     */
    readonly ignore?: DependabotIgnore[];
    /**
     * (experimental) Ignores updates to `projen`.
     *
     * This is required since projen updates may cause changes in committed files
     * and anti-tamper checks will fail.
     *
     * Projen upgrades are covered through the `ProjenUpgrade` class.
     *
     * @default true
     * @experimental
     */
    readonly ignoreProjen?: boolean;
    /**
     * (experimental) List of labels to apply to the created PR's.
     *
     * @experimental
     */
    readonly labels?: string[];
    /**
     * (experimental) Map of package registries to use.
     *
     * @default - use public registries
     * @experimental
     */
    readonly registries?: {
        [name: string]: DependabotRegistry;
    };
}
/**
 * (experimental) Use to add private registry support for dependabot.
 *
 * @see https://docs.github.com/en/code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/configuration-options-for-dependency-updates#configuration-options-for-private-registries
 * @experimental
 */
export interface DependabotRegistry {
    /**
     * (experimental) Registry type e.g. 'npm-registry' or 'docker-registry'.
     *
     * @experimental
     */
    readonly type: DependabotRegistryType;
    /**
     * (experimental) Url for the registry e.g. 'https://npm.pkg.github.com' or 'registry.hub.docker.com'.
     *
     * @experimental
     */
    readonly url: string;
    /**
     * (experimental) The username that Dependabot uses to access the registry.
     *
     * @default - do not authenticate
     * @experimental
     */
    readonly username?: string;
    /**
     * (experimental) A reference to a Dependabot secret containing the password for the specified user.
     *
     * @default undefined
     * @experimental
     */
    readonly password?: string;
    /**
     * (experimental) A reference to a Dependabot secret containing an access key for this registry.
     *
     * @default undefined
     * @experimental
     */
    readonly key?: string;
    /**
     * (experimental) Secret token for dependabot access e.g. '${{ secrets.DEPENDABOT_PACKAGE_TOKEN }}'.
     *
     * @default undefined
     * @experimental
     */
    readonly token?: string;
    /**
     * (experimental) For registries with type: python-index, if the boolean value is true, pip esolves dependencies by using the specified URL rather than the base URL of the Python Package Index (by default https://pypi.org/simple).
     *
     * @default undefined
     * @experimental
     */
    readonly replacesBase?: boolean;
    /**
     * (experimental) Used with the hex-organization registry type.
     *
     * @default undefined
     * @see https://docs.github.com/en/code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/configuration-options-for-dependency-updates#hex-organization
     * @experimental
     */
    readonly organization?: string;
}
/**
 * (experimental) Each configuration type requires you to provide particular settings.
 *
 * Some types allow more than one way to connect
 *
 * @see https://docs.github.com/en/code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/configuration-options-for-dependency-updates#configuration-options-for-private-registries
 * @experimental
 */
export declare enum DependabotRegistryType {
    /**
     * (experimental) The composer-repository type supports username and password.
     *
     * @see https://docs.github.com/en/code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/configuration-options-for-dependency-updates#composer-repository
     * @experimental
     */
    COMPOSER_REGISTRY = "composer-registry",
    /**
     * (experimental) The docker-registry type supports username and password.
     *
     * The docker-registry type can also be used to pull from Amazon ECR using static AWS credentials
     *
     * @see https://docs.github.com/en/code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/configuration-options-for-dependency-updates#docker-registry
     * @experimental
     */
    DOCKER_REGISTRY = "docker-registry",
    /**
     * (experimental) The git type supports username and password.
     *
     * @see https://docs.github.com/en/code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/configuration-options-for-dependency-updates#git
     * @experimental
     */
    GIT = "git",
    /**
     * (experimental) The hex-organization type supports organization and key.
     *
     * @see https://docs.github.com/en/code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/configuration-options-for-dependency-updates#hex-organization
     * @experimental
     */
    HEX_ORGANIZATION = "hex-organization",
    /**
     * (experimental) The maven-repository type supports username and password, or token.
     *
     * @see https://docs.github.com/en/code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/configuration-options-for-dependency-updates#maven-repository
     * @experimental
     */
    MAVEN_REPOSITORY = "maven-repository",
    /**
     * (experimental) The npm-registry type supports username and password, or token.
     *
     * @see https://docs.github.com/en/code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/configuration-options-for-dependency-updates#npm-registry
     * @experimental
     */
    NPM_REGISTRY = "npm-registry",
    /**
     * (experimental) The nuget-feed type supports username and password, or token.
     *
     * @see https://docs.github.com/en/code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/configuration-options-for-dependency-updates#nuget-feed
     * @experimental
     */
    NUGET_FEED = "nuget-feed",
    /**
     * (experimental) The python-index type supports username and password, or token.
     *
     * @see https://docs.github.com/en/code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/configuration-options-for-dependency-updates#python-index
     * @experimental
     */
    PYTHON_INDEX = "python-index",
    /**
     * (experimental) The rubygems-server type supports username and password, or token.
     *
     * @see https://docs.github.com/en/code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/configuration-options-for-dependency-updates#rubygems-server
     * @experimental
     */
    RUBYGEMS_SERVER = "rubygems-server",
    /**
     * (experimental) The terraform-registry type supports a token.
     *
     * @see https://docs.github.com/en/code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/configuration-options-for-dependency-updates#terraform-registry
     * @experimental
     */
    TERRAFORM_REGISTRY = "terraform-registry"
}
/**
 * (experimental) You can use the `ignore` option to customize which dependencies are updated.
 *
 * The ignore option supports the following options.
 *
 * @experimental
 */
export interface DependabotIgnore {
    /**
     * (experimental) Use to ignore updates for dependencies with matching names, optionally using `*` to match zero or more characters.
     *
     * For Java dependencies, the format of the dependency-name attribute is:
     * `groupId:artifactId`, for example: `org.kohsuke:github-api`.
     *
     * @experimental
     */
    readonly dependencyName: string;
    /**
     * (experimental) Use to ignore specific versions or ranges of versions.
     *
     * If you want to
     * define a range, use the standard pattern for the package manager (for
     * example: `^1.0.0` for npm, or `~> 2.0` for Bundler).
     *
     * @experimental
     */
    readonly versions?: string[];
}
/**
 * (experimental) How often to check for new versions and raise pull requests for version updates.
 *
 * @experimental
 */
export declare enum DependabotScheduleInterval {
    /**
     * (experimental) Runs on every weekday, Monday to Friday.
     *
     * @experimental
     */
    DAILY = "daily",
    /**
     * (experimental) Runs once each week.
     *
     * By default, this is on Monday.
     *
     * @experimental
     */
    WEEKLY = "weekly",
    /**
     * (experimental) Runs once each month.
     *
     * This is on the first day of the month.
     *
     * @experimental
     */
    MONTHLY = "monthly"
}
/**
 * (experimental) The strategy to use when edits manifest and lock files.
 *
 * @experimental
 */
export declare enum VersioningStrategy {
    /**
     * (experimental) Only create pull requests to update lockfiles updates.
     *
     * Ignore any new
     * versions that would require package manifest changes.
     *
     * @experimental
     */
    LOCKFILE_ONLY = "lockfile-only",
    /**
     * (experimental) - For apps, the version requirements are increased.
     *
     * - For libraries, the range of versions is widened.
     *
     * @experimental
     */
    AUTO = "auto",
    /**
     * (experimental) Relax the version requirement to include both the new and old version, when possible.
     *
     * @experimental
     */
    WIDEN = "widen",
    /**
     * (experimental) Always increase the version requirement to match the new version.
     *
     * @experimental
     */
    INCREASE = "increase",
    /**
     * (experimental) Increase the version requirement only when required by the new version.
     *
     * @experimental
     */
    INCREASE_IF_NECESSARY = "increase-if-necessary"
}
/**
 * (experimental) Defines dependabot configuration for node projects.
 *
 * Since module versions are managed in projen, the versioning strategy will be
 * configured to "lockfile-only" which means that only updates that can be done
 * on the lockfile itself will be proposed.
 *
 * @experimental
 */
export declare class Dependabot extends Component {
    /**
     * (experimental) The raw dependabot configuration.
     *
     * @see https://docs.github.com/en/github/administering-a-repository/configuration-options-for-dependency-updates
     * @experimental
     */
    readonly config: any;
    private readonly ignore;
    /**
     * @experimental
     */
    constructor(github: GitHub, options?: DependabotOptions);
    /**
     * (experimental) Ignores a dependency from automatic updates.
     *
     * @param dependencyName Use to ignore updates for dependencies with matching names, optionally using `*` to match zero or more characters.
     * @param versions Use to ignore specific versions or ranges of versions.
     * @experimental
     */
    addIgnore(dependencyName: string, ...versions: string[]): void;
}
