"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Dependabot = exports.VersioningStrategy = exports.DependabotScheduleInterval = exports.DependabotRegistryType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const yargs_1 = require("yargs");
const component_1 = require("../component");
const util_1 = require("../util");
const yaml_1 = require("../yaml");
/**
 * (experimental) Each configuration type requires you to provide particular settings.
 *
 * Some types allow more than one way to connect
 *
 * @see https://docs.github.com/en/code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/configuration-options-for-dependency-updates#configuration-options-for-private-registries
 * @experimental
 */
var DependabotRegistryType;
(function (DependabotRegistryType) {
    DependabotRegistryType["COMPOSER_REGISTRY"] = "composer-registry";
    DependabotRegistryType["DOCKER_REGISTRY"] = "docker-registry";
    DependabotRegistryType["GIT"] = "git";
    DependabotRegistryType["HEX_ORGANIZATION"] = "hex-organization";
    DependabotRegistryType["MAVEN_REPOSITORY"] = "maven-repository";
    DependabotRegistryType["NPM_REGISTRY"] = "npm-registry";
    DependabotRegistryType["NUGET_FEED"] = "nuget-feed";
    DependabotRegistryType["PYTHON_INDEX"] = "python-index";
    DependabotRegistryType["RUBYGEMS_SERVER"] = "rubygems-server";
    DependabotRegistryType["TERRAFORM_REGISTRY"] = "terraform-registry";
})(DependabotRegistryType = exports.DependabotRegistryType || (exports.DependabotRegistryType = {}));
/**
 * (experimental) How often to check for new versions and raise pull requests for version updates.
 *
 * @experimental
 */
var DependabotScheduleInterval;
(function (DependabotScheduleInterval) {
    DependabotScheduleInterval["DAILY"] = "daily";
    DependabotScheduleInterval["WEEKLY"] = "weekly";
    DependabotScheduleInterval["MONTHLY"] = "monthly";
})(DependabotScheduleInterval = exports.DependabotScheduleInterval || (exports.DependabotScheduleInterval = {}));
/**
 * (experimental) The strategy to use when edits manifest and lock files.
 *
 * @experimental
 */
var VersioningStrategy;
(function (VersioningStrategy) {
    VersioningStrategy["LOCKFILE_ONLY"] = "lockfile-only";
    VersioningStrategy["AUTO"] = "auto";
    VersioningStrategy["WIDEN"] = "widen";
    VersioningStrategy["INCREASE"] = "increase";
    VersioningStrategy["INCREASE_IF_NECESSARY"] = "increase-if-necessary";
})(VersioningStrategy = exports.VersioningStrategy || (exports.VersioningStrategy = {}));
/**
 * (experimental) Defines dependabot configuration for node projects.
 *
 * Since module versions are managed in projen, the versioning strategy will be
 * configured to "lockfile-only" which means that only updates that can be done
 * on the lockfile itself will be proposed.
 *
 * @experimental
 */
class Dependabot extends component_1.Component {
    /**
     * @experimental
     */
    constructor(github, options = {}) {
        var _b, _c, _d, _e;
        super(github.project);
        const project = github.project;
        this.ignore = [];
        const registries = options.registries ? util_1.kebabCaseKeys(options.registries) : undefined;
        this.config = {
            version: 2,
            registries,
            updates: [
                {
                    'package-ecosystem': 'npm',
                    'versioning-strategy': 'lockfile-only',
                    'directory': '/',
                    'schedule': {
                        interval: (_b = options.scheduleInterval) !== null && _b !== void 0 ? _b : DependabotScheduleInterval.DAILY,
                    },
                    'ignore': () => this.ignore.length > 0 ? this.ignore : undefined,
                    'labels': options.labels ? options.labels : undefined,
                    'registries': registries ? Object.keys(registries) : undefined,
                },
            ],
        };
        new yaml_1.YamlFile(project, '.github/dependabot.yml', {
            obj: this.config,
            committed: true,
        });
        for (const i of (_c = options.ignore) !== null && _c !== void 0 ? _c : []) {
            this.addIgnore(i.dependencyName, ...((_d = i.versions) !== null && _d !== void 0 ? _d : []));
        }
        if ((_e = options.ignoreProjen) !== null && _e !== void 0 ? _e : true) {
            this.addIgnore('projen');
        }
    }
    /**
     * (experimental) Ignores a dependency from automatic updates.
     *
     * @param dependencyName Use to ignore updates for dependencies with matching names, optionally using `*` to match zero or more characters.
     * @param versions Use to ignore specific versions or ranges of versions.
     * @experimental
     */
    addIgnore(dependencyName, ...versions) {
        this.ignore.push({
            'dependency-name': dependencyName,
            'versions': () => versions.length > 0 ? yargs_1.version : undefined,
        });
    }
}
exports.Dependabot = Dependabot;
_a = JSII_RTTI_SYMBOL_1;
Dependabot[_a] = { fqn: "projen.github.Dependabot", version: "0.27.22" };
//# sourceMappingURL=data:application/json;base64,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