"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitHub = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const dependabot_1 = require("./dependabot");
const mergify_1 = require("./mergify");
const pr_template_1 = require("./pr-template");
const workflows_1 = require("./workflows");
/**
 * @experimental
 */
class GitHub extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options = {}) {
        var _b;
        super(project);
        if ((_b = options.mergify) !== null && _b !== void 0 ? _b : true) {
            this.mergify = new mergify_1.Mergify(this);
        }
    }
    /**
     * @experimental
     */
    addWorkflow(name) {
        return new workflows_1.GithubWorkflow(this, name);
    }
    /**
     * @experimental
     */
    addPullRequestTemplate(...content) {
        return new pr_template_1.PullRequestTemplate(this, { lines: content });
    }
    /**
     * @experimental
     */
    addDependabot(options) {
        return new dependabot_1.Dependabot(this, options);
    }
}
exports.GitHub = GitHub;
_a = JSII_RTTI_SYMBOL_1;
GitHub[_a] = { fqn: "projen.github.GitHub", version: "0.27.22" };
//# sourceMappingURL=data:application/json;base64,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