import { Component } from '../component';
import { GitHub } from './github';
/**
 * (experimental) The Mergify conditional operators that can be used are: `or` and `and`.
 *
 * Note: The number of nested conditions is limited to 3.
 *
 * @see https://docs.mergify.io/conditions/#combining-conditions-with-operators
 * @experimental
 */
export interface MergifyConditionalOperator {
    /**
     * @experimental
     */
    readonly or?: MergifyCondition[];
    /**
     * @experimental
     */
    readonly and?: MergifyCondition[];
}
export declare type MergifyCondition = string | MergifyConditionalOperator;
/**
 * @experimental
 */
export interface MergifyRule {
    /**
     * (experimental) The name of the rule.
     *
     * This is not used by the engine directly,
     * but is used when reporting information about a rule.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) A list of Conditions string that must match against the pull request for the rule to be applied.
     *
     * @see https://docs.mergify.io/conditions/#conditions
     * @experimental
     */
    readonly conditions: MergifyCondition[];
    /**
     * (experimental) A dictionary made of Actions that will be executed on the matching pull requests.
     *
     * @see https://docs.mergify.io/actions/#actions
     * @experimental
     */
    readonly actions: {
        [action: string]: any;
    };
}
/**
 * @experimental
 */
export interface MergifyOptions {
    /**
     * @experimental
     */
    readonly rules?: MergifyRule[];
}
/**
 * @experimental
 */
export declare class Mergify extends Component {
    private readonly rules;
    private yamlFile?;
    /**
     * @experimental
     */
    constructor(github: GitHub, options?: MergifyOptions);
    /**
     * @experimental
     */
    addRule(rule: MergifyRule): void;
}
