"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Jest = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const semver = require("semver");
const typescript_config_1 = require("./typescript-config");
const DEFAULT_TEST_REPORTS_DIR = 'test-reports';
/**
 * (experimental) Installs the following npm scripts:.
 *
 * - `test` will run `jest --passWithNoTests`
 * - `test:watch` will run `jest --watch`
 * - `test:update` will run `jest -u`
 *
 * @experimental
 */
class Jest {
    /**
     * @experimental
     */
    constructor(project, options = {}) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0, _1, _2;
        this.project = project;
        // Jest snapshot files are generated files!
        project.root.annotateGenerated('*.snap');
        const jestDep = options.jestVersion ? `jest@${options.jestVersion}` : 'jest';
        project.addDevDeps(jestDep);
        this.jestConfig = options.jestConfig;
        this.typescriptConfig = options.typescriptConfig;
        this.ignorePatterns = (_d = (_c = (_b = this.jestConfig) === null || _b === void 0 ? void 0 : _b.testPathIgnorePatterns) !== null && _c !== void 0 ? _c : options.ignorePatterns) !== null && _d !== void 0 ? _d : ['/node_modules/'];
        this.watchIgnorePatterns = (_f = (_e = this.jestConfig) === null || _e === void 0 ? void 0 : _e.watchPathIgnorePatterns) !== null && _f !== void 0 ? _f : ['/node_modules/'];
        this.coverageReporters = (_h = (_g = this.jestConfig) === null || _g === void 0 ? void 0 : _g.coverageReporters) !== null && _h !== void 0 ? _h : ['json', 'lcov', 'clover'];
        this.testMatch = (_k = (_j = this.jestConfig) === null || _j === void 0 ? void 0 : _j.testMatch) !== null && _k !== void 0 ? _k : ['**\/__tests__/**\/*.[jt]s?(x)', '**\/?(*.)+(spec|test).[tj]s?(x)'];
        const coverageDirectory = (_m = (_l = this.jestConfig) === null || _l === void 0 ? void 0 : _l.coverageDirectory) !== null && _m !== void 0 ? _m : 'coverage';
        this.reporters = [];
        if ((_o = options.preserveDefaultReporters) !== null && _o !== void 0 ? _o : true) {
            this.reporters.unshift('default');
        }
        this.config = {
            ...this.jestConfig,
            clearMocks: (_q = (_p = this.jestConfig) === null || _p === void 0 ? void 0 : _p.clearMocks) !== null && _q !== void 0 ? _q : true,
            collectCoverage: (_t = (_r = options.coverage) !== null && _r !== void 0 ? _r : (_s = this.jestConfig) === null || _s === void 0 ? void 0 : _s.collectCoverage) !== null && _t !== void 0 ? _t : true,
            coverageReporters: this.coverageReporters,
            coverageDirectory: coverageDirectory,
            coveragePathIgnorePatterns: (_v = (_u = this.jestConfig) === null || _u === void 0 ? void 0 : _u.coveragePathIgnorePatterns) !== null && _v !== void 0 ? _v : this.ignorePatterns,
            testPathIgnorePatterns: this.ignorePatterns,
            watchPathIgnorePatterns: this.watchIgnorePatterns,
            testMatch: this.testMatch,
            reporters: this.reporters,
            snapshotResolver: (() => this._snapshotResolver),
        };
        if ((_w = options.junitReporting) !== null && _w !== void 0 ? _w : true) {
            const reportsDir = DEFAULT_TEST_REPORTS_DIR;
            this.addReporter([
                'jest-junit',
                { outputDirectory: reportsDir },
            ]);
            project.addDevDeps('jest-junit@^12');
            project.gitignore.exclude('# jest-junit artifacts', `/${reportsDir}/`, 'junit.xml');
            (_x = project.npmignore) === null || _x === void 0 ? void 0 : _x.exclude('# jest-junit artifacts', `/${reportsDir}/`, 'junit.xml');
        }
        if ((_y = this.jestConfig) === null || _y === void 0 ? void 0 : _y.reporters) {
            for (const reporter of this.jestConfig.reporters) {
                this.addReporter(reporter);
            }
        }
        if ((_z = this.jestConfig) === null || _z === void 0 ? void 0 : _z.coverageThreshold) {
            this.config.coverageThreshold = {
                global: (_0 = this.jestConfig) === null || _0 === void 0 ? void 0 : _0.coverageThreshold,
            };
        }
        this.configureTestCommand();
        project.addFields({ jest: this.config });
        const coverageDirectoryPath = path.posix.join('/', coverageDirectory);
        (_1 = project.npmignore) === null || _1 === void 0 ? void 0 : _1.exclude(coverageDirectoryPath);
        project.gitignore.exclude(coverageDirectoryPath);
        if ((_2 = options.coverageText) !== null && _2 !== void 0 ? _2 : true) {
            this.coverageReporters.push('text');
        }
    }
    /**
     * (experimental) Adds a test match pattern.
     *
     * @param pattern glob pattern to match for tests.
     * @experimental
     */
    addTestMatch(pattern) {
        this.testMatch.push(pattern);
    }
    /**
     * (experimental) Adds a watch ignore pattern.
     *
     * @param pattern The pattern (regular expression).
     * @experimental
     */
    addWatchIgnorePattern(pattern) {
        this.watchIgnorePatterns.push(pattern);
    }
    /**
     * @experimental
     */
    addIgnorePattern(pattern) {
        this.ignorePatterns.push(pattern);
    }
    /**
     * @experimental
     */
    addReporter(reporter) {
        this.reporters.push(reporter);
    }
    /**
     * @experimental
     */
    addSnapshotResolver(file) {
        this._snapshotResolver = file;
    }
    /**
     * (experimental) Merges passed in typescript config options with jest configured typescript options from .projenrc Add Jest config settings for typescript options.
     *
     * @param options TypescriptConfigOptions.
     * @experimental
     */
    generateTypescriptConfig(options) {
        var _b, _c, _d, _e, _f, _g, _h, _j;
        const tsconfig = new typescript_config_1.TypescriptConfig(this.project, {
            fileName: (_b = options.fileName) !== null && _b !== void 0 ? _b : 'tsconfig.jest.json',
            include: [
                ...options.include ? options.include : [],
                ...((_c = this.typescriptConfig) === null || _c === void 0 ? void 0 : _c.include) ? (_d = this.typescriptConfig) === null || _d === void 0 ? void 0 : _d.include : [],
            ],
            exclude: [
                ...options.exclude ? options.exclude : [],
                ...((_e = this.typescriptConfig) === null || _e === void 0 ? void 0 : _e.exclude) ? (_f = this.typescriptConfig) === null || _f === void 0 ? void 0 : _f.exclude : [],
            ],
            compilerOptions: {
                ...options.compilerOptions,
                ...(_g = this.typescriptConfig) === null || _g === void 0 ? void 0 : _g.compilerOptions,
            },
        });
        this.config.preset = 'ts-jest';
        // only process .ts files
        this.config.testMatch = (_j = (_h = this.jestConfig) === null || _h === void 0 ? void 0 : _h.testMatch) !== null && _j !== void 0 ? _j : [
            '**/__tests__/**/*.ts?(x)',
            '**/?(*.)+(spec|test).ts?(x)',
        ];
        // specify tsconfig.json
        this.config.globals = {
            'ts-jest': {
                tsconfig: tsconfig.fileName,
            },
        };
        // add relevant deps
        this.project.addDevDeps('@types/jest', 'ts-jest');
        return tsconfig;
    }
    configureTestCommand() {
        const jestOpts = ['--passWithNoTests', '--all'];
        // if the project has anti-tamper configured, it should be safe to always run tests
        // with --updateSnapshot because if we forget to commit a snapshot change the CI build will fail.
        if (this.project.antitamper) {
            jestOpts.push('--updateSnapshot');
        }
        // as recommended in the jest docs, node > 14 may use native v8 coverage collection
        // https://jestjs.io/docs/en/cli#--coverageproviderprovider
        if (this.project.package.minNodeVersion && semver.gte(this.project.package.minNodeVersion, '14.0.0')) {
            jestOpts.push('--coverageProvider=v8');
        }
        this.project.testTask.exec(`jest ${jestOpts.join(' ')}`);
        const testWatch = this.project.tasks.tryFind('test:watch');
        if (!testWatch) {
            this.project.addTask('test:watch', {
                description: 'Run jest in watch mode',
                exec: 'jest --watch',
            });
        }
        const testUpdate = this.project.tasks.tryFind('test:update');
        if (!testUpdate) {
            this.project.addTask('test:update', {
                description: 'Update jest snapshots',
                exec: 'jest --updateSnapshot',
            });
        }
    }
}
exports.Jest = Jest;
_a = JSII_RTTI_SYMBOL_1;
Jest[_a] = { fqn: "projen.Jest", version: "0.27.22" };
//# sourceMappingURL=data:application/json;base64,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