"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsiiProject = exports.Stability = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const jsii_docgen_1 = require("./jsii-docgen");
const typescript_1 = require("./typescript");
const DEFAULT_JSII_IMAGE = 'jsii/superchain';
const EMAIL_REGEX = /(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|"(?:[\x01-\x08\x0b\x0c\x0e-\x1f\x21\x23-\x5b\x5d-\x7f]|\\[\x01-\x09\x0b\x0c\x0e-\x7f])*")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\x01-\x08\x0b\x0c\x0e-\x1f\x21-\x5a\x53-\x7f]|\\[\x01-\x09\x0b\x0c\x0e-\x7f])+)\])/;
const URL_REGEX = /((([A-Za-z]{3,9}:(?:\/\/)?)(?:[\-;:&=\+\$,\w]+@)?[A-Za-z0-9\.\-]+|(?:www\.|[\-;:&=\+\$,\w]+@)[A-Za-z0-9\.\-]+)((?:\/[\+~%\/\.\w\-_]*)?\??(?:[\-\+=&;%@\.\w_]*)#?(?:[\.\!\/\\\w]*))?)/;
/**
 * @experimental
 */
var Stability;
(function (Stability) {
    Stability["EXPERIMENTAL"] = "experimental";
    Stability["STABLE"] = "stable";
    Stability["DEPRECATED"] = "deprecated";
})(Stability = exports.Stability || (exports.Stability = {}));
/**
 * (experimental) Multi-language jsii library project.
 *
 * @experimental
 */
class JsiiProject extends typescript_1.TypeScriptProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q;
        const { authorEmail, authorUrl } = parseAuthorAddress(options);
        super({
            repository: options.repositoryUrl,
            authorName: options.author,
            authorEmail,
            authorUrl,
            ...options,
            workflowContainerImage: (_b = options.workflowContainerImage) !== null && _b !== void 0 ? _b : DEFAULT_JSII_IMAGE,
            // this is needed temporarily because our release workflows use the 'gh'
            // cli and its not yet available in jsii/superchain
            releaseWorkflowSetupSteps: options.releaseWorkflowSetupSteps,
            releaseToNpm: false,
            disableTsconfig: true,
            docgen: false,
        });
        const srcdir = this.srcdir;
        const libdir = this.libdir;
        this.addFields({ types: `${libdir}/index.d.ts` });
        // this is an unhelpful warning
        const jsiiFlags = [
            '--silence-warnings=reserved-word',
            '--no-fix-peer-dependencies',
        ].join(' ');
        const compatIgnore = (_c = options.compatIgnore) !== null && _c !== void 0 ? _c : '.compatignore';
        this.addFields({ stability: (_d = options.stability) !== null && _d !== void 0 ? _d : Stability.STABLE });
        if (options.stability === Stability.DEPRECATED) {
            this.addFields({ deprecated: true });
        }
        const compatTask = this.addTask('compat', {
            description: 'Perform API compatibility check against latest version',
            exec: `jsii-diff npm:$(node -p "require(\'./package.json\').name") -k --ignore-file ${compatIgnore} || (echo "\nUNEXPECTED BREAKING CHANGES: add keys such as \'removed:constructs.Node.of\' to ${compatIgnore} to skip.\n" && exit 1)`,
        });
        const compat = (_e = options.compat) !== null && _e !== void 0 ? _e : false;
        if (compat) {
            this.compileTask.spawn(compatTask);
        }
        this.compileTask.reset(`jsii ${jsiiFlags}`);
        this.watchTask.reset(`jsii -w ${jsiiFlags}`);
        (_f = this.packageTask) === null || _f === void 0 ? void 0 : _f.reset('jsii-pacmak');
        const targets = {};
        const jsii = {
            outdir: 'dist',
            targets,
            tsc: {
                outDir: libdir,
                rootDir: srcdir,
            },
        };
        if (options.excludeTypescript) {
            jsii.excludeTypescript = options.excludeTypescript;
        }
        this.addFields({ jsii });
        if (options.releaseToNpm != false) {
            (_g = this.publisher) === null || _g === void 0 ? void 0 : _g.publishToNpm({
                distTag: this.package.npmDistTag,
                registry: this.package.npmRegistry,
                npmTokenSecret: this.package.npmTokenSecret,
            });
        }
        // we cannot call an option `java` because the java code generated by jsii
        // does not compile due to a conflict between this option name and the `java`
        // package (e.g. when `java.util.Objects` is referenced).
        if ('java' in options) {
            throw new Error('the "java" option is now called "publishToMaven"');
        }
        if (options.publishToMaven) {
            targets.java = {
                package: options.publishToMaven.javaPackage,
                maven: {
                    groupId: options.publishToMaven.mavenGroupId,
                    artifactId: options.publishToMaven.mavenArtifactId,
                },
            };
            (_h = this.publisher) === null || _h === void 0 ? void 0 : _h.publishToMaven(options.publishToMaven);
        }
        const pypi = (_j = options.publishToPypi) !== null && _j !== void 0 ? _j : options.python;
        if (pypi) {
            targets.python = {
                distName: pypi.distName,
                module: pypi.module,
            };
            (_k = this.publisher) === null || _k === void 0 ? void 0 : _k.publishToPyPi(pypi);
        }
        const nuget = (_l = options.publishToNuget) !== null && _l !== void 0 ? _l : options.dotnet;
        if (nuget) {
            targets.dotnet = {
                namespace: nuget.dotNetNamespace,
                packageId: nuget.packageId,
            };
            (_m = this.publisher) === null || _m === void 0 ? void 0 : _m.publishToNuget(nuget);
        }
        const golang = options.publishToGo;
        if (golang) {
            targets.go = {
                moduleName: golang.moduleName,
            };
            (_o = this.publisher) === null || _o === void 0 ? void 0 : _o.publishToGo(golang);
        }
        this.addDevDeps('jsii', 'jsii-diff', 'jsii-pacmak');
        this.gitignore.exclude('.jsii', 'tsconfig.json');
        (_p = this.npmignore) === null || _p === void 0 ? void 0 : _p.include('.jsii');
        if ((_q = options.docgen) !== null && _q !== void 0 ? _q : true) {
            new jsii_docgen_1.JsiiDocgen(this);
        }
        // jsii updates .npmignore, so we make it writable
        if (this.npmignore) {
            this.npmignore.readonly = false;
        }
    }
}
exports.JsiiProject = JsiiProject;
_a = JSII_RTTI_SYMBOL_1;
JsiiProject[_a] = { fqn: "projen.JsiiProject", version: "0.27.22" };
function parseAuthorAddress(options) {
    let authorEmail = options.authorEmail;
    let authorUrl = options.authorUrl;
    if (options.authorAddress) {
        if (options.authorEmail && options.authorEmail !== options.authorAddress) {
            throw new Error('authorEmail is deprecated and cannot be used in conjunction with authorAddress');
        }
        if (options.authorUrl && options.authorUrl !== options.authorAddress) {
            throw new Error('authorUrl is deprecated and cannot be used in conjunction with authorAddress.');
        }
        if (EMAIL_REGEX.test(options.authorAddress)) {
            authorEmail = options.authorAddress;
        }
        else if (URL_REGEX.test(options.authorAddress)) {
            authorUrl = options.authorAddress;
        }
        else {
            throw new Error(`authorAddress must be either an email address or a URL: ${options.authorAddress}`);
        }
    }
    return { authorEmail, authorUrl };
}
//# sourceMappingURL=data:application/json;base64,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