import { FileBase, IResolver } from './file';
import { Project } from './project';
/**
 * @experimental
 */
export interface LicenseOptions {
    /**
     * (experimental) License type (SPDX).
     *
     * @see https://github.com/projen/projen/tree/main/license-text for list of supported licenses
     * @experimental
     */
    readonly spdx: string;
    /**
     * (experimental) Copyright owner.
     *
     * If the license text has $copyright_owner, this option must be specified.
     *
     * @default -
     * @experimental
     */
    readonly copyrightOwner?: string;
    /**
     * (experimental) Period of license (e.g. "1998-2023").
     *
     * The string `$copyright_period` will be substituted with this string.
     *
     * @default - current year (e.g. "2020")
     * @experimental
     */
    readonly copyrightPeriod?: string;
}
/**
 * @experimental
 */
export declare class License extends FileBase {
    private readonly text;
    /**
     * @experimental
     */
    constructor(project: Project, options: LicenseOptions);
    /**
     * (experimental) Implemented by derived classes and returns the contents of the file to emit.
     *
     * @experimental
     */
    protected synthesizeContent(_: IResolver): string | undefined;
}
