"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.disable = exports.warn = exports.error = exports.info = exports.verbose = exports.debug = void 0;
const chalk = require("chalk");
let enabled = true;
function log(color, ...text) {
    if (!enabled) {
        return;
    }
    console.error(`🤖 ${color(...text)}`);
}
function debug(...text) {
    if (process.env.DEBUG) {
        log(chalk.gray, ...text);
    }
}
exports.debug = debug;
function verbose(...text) {
    log(chalk.white, ...text);
}
exports.verbose = verbose;
function info(...text) {
    log(chalk.cyan, ...text);
}
exports.info = info;
function error(...text) {
    log(chalk.red, ...text);
}
exports.error = error;
function warn(...text) {
    log(chalk.yellow, ...text);
}
exports.warn = warn;
function disable() {
    enabled = false;
}
exports.disable = disable;
//# sourceMappingURL=data:application/json;base64,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