"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DependenciesUpgradeMechanism = exports.NodeProject = exports.AutoRelease = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("./common");
const github_1 = require("./github");
const workflows_model_1 = require("./github/workflows-model");
const ignore_file_1 = require("./ignore-file");
const projenrc_1 = require("./javascript/projenrc");
const jest_1 = require("./jest");
const license_1 = require("./license");
const node_package_1 = require("./node-package");
const project_1 = require("./project");
const release_1 = require("./release");
const upgrade_dependencies_1 = require("./upgrade-dependencies");
const version_1 = require("./version");
const PROJEN_SCRIPT = 'projen';
/**
 * (experimental) Automatic bump modes.
 *
 * @experimental
 */
var AutoRelease;
(function (AutoRelease) {
    AutoRelease[AutoRelease["EVERY_COMMIT"] = 0] = "EVERY_COMMIT";
    AutoRelease[AutoRelease["DAILY"] = 1] = "DAILY";
})(AutoRelease = exports.AutoRelease || (exports.AutoRelease = {}));
/**
 * (experimental) Node.js project.
 *
 * @experimental
 */
class NodeProject extends project_1.Project {
    /**
     * @experimental
     */
    constructor(options) {
        var _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0, _1, _2, _3, _4, _5, _6, _7, _8, _9;
        super(options);
        this.package = new node_package_1.NodePackage(this, options);
        this.workflowBootstrapSteps = (_c = options.workflowBootstrapSteps) !== null && _c !== void 0 ? _c : [];
        this.runScriptCommand = (() => {
            switch (this.packageManager) {
                case node_package_1.NodePackageManager.NPM: return 'npm run';
                case node_package_1.NodePackageManager.YARN: return 'yarn run';
                case node_package_1.NodePackageManager.PNPM: return 'pnpm run';
                default: throw new Error(`unexpected package manager ${this.packageManager}`);
            }
        })();
        this.nodeVersion = (_d = options.workflowNodeVersion) !== null && _d !== void 0 ? _d : this.package.minNodeVersion;
        // add PATH for all tasks which includes the project's npm .bin list
        this.tasks.addEnvironment('PATH', '$(npx -c "node -e \\\"console.log(process.env.PATH)\\\"")');
        this.compileTask = this.addTask('compile', {
            description: 'Only compile',
        });
        this.testCompileTask = this.addTask('test:compile', {
            description: 'compiles the test code',
        });
        this.testTask = this.addTask('test', {
            description: 'Run tests',
        });
        this.testTask.spawn(this.testCompileTask);
        this.buildTask = this.addTask('build', {
            description: 'Full release build (test+compile)',
        });
        // first, execute projen as the first thing during build
        if ((_e = options.projenDuringBuild) !== null && _e !== void 0 ? _e : true) {
            // skip for sub-projects (i.e. "parent" is defined) since synthing the
            // root project will include the subprojects.
            if (!this.parent) {
                this.buildTask.exec(this.projenCommand);
            }
        }
        this.addLicense(options);
        this.npmDistTag = this.package.npmDistTag;
        this.npmRegistry = this.package.npmRegistry;
        if ((_f = options.npmignoreEnabled) !== null && _f !== void 0 ? _f : true) {
            this.npmignore = new ignore_file_1.IgnoreFile(this, '.npmignore');
        }
        this.addDefaultGitIgnore();
        if ((_g = options.gitignore) === null || _g === void 0 ? void 0 : _g.length) {
            for (const i of options.gitignore) {
                this.gitignore.exclude(i);
            }
        }
        if ((_h = options.npmignore) === null || _h === void 0 ? void 0 : _h.length) {
            if (!this.npmignore) {
                throw new Error('.npmignore is not defined for an APP project type. Add "npmIgnore: true" to override this');
            }
            for (const i of options.npmignore) {
                this.npmignore.exclude(i);
            }
        }
        this.setScript(PROJEN_SCRIPT, this.package.projenCommand);
        (_j = this.npmignore) === null || _j === void 0 ? void 0 : _j.exclude(`/${common_1.PROJEN_RC}`);
        (_k = this.npmignore) === null || _k === void 0 ? void 0 : _k.exclude(`/${common_1.PROJEN_DIR}`);
        this.gitignore.include(`/${common_1.PROJEN_RC}`);
        const projen = (_l = options.projenDevDependency) !== null && _l !== void 0 ? _l : true;
        if (projen) {
            const postfix = options.projenVersion ? `@${options.projenVersion}` : '';
            this.addDevDeps(`projen${postfix}`);
        }
        if (!options.defaultReleaseBranch) {
            throw new Error('"defaultReleaseBranch" is temporarily a required option while we migrate its default value from "master" to "main"');
        }
        const buildEnabled = (_m = options.buildWorkflow) !== null && _m !== void 0 ? _m : (this.parent ? false : true);
        const mutableBuilds = (_o = options.mutableBuild) !== null && _o !== void 0 ? _o : true;
        // indicate if we have anti-tamper configured in our workflows. used by e.g. Jest
        // to decide if we can always run with --updateSnapshot
        this.antitamper = buildEnabled && ((_p = options.antitamper) !== null && _p !== void 0 ? _p : true);
        // configure jest if enabled
        // must be before the build/release workflows
        if ((_q = options.jest) !== null && _q !== void 0 ? _q : true) {
            this.jest = new jest_1.Jest(this, options.jestOptions);
        }
        if ((_r = options.buildWorkflow) !== null && _r !== void 0 ? _r : (this.parent ? false : true)) {
            const branch = '${{ github.event.pull_request.head.ref }}';
            const repo = '${{ github.event.pull_request.head.repo.full_name }}';
            const buildJobId = 'build';
            const postBuildSteps = new Array();
            const gitDiffStepId = 'git_diff';
            const hasChangesCondName = 'has_changes';
            const hasChanges = `steps.${gitDiffStepId}.outputs.${hasChangesCondName}`;
            const repoFullName = 'github.event.pull_request.head.repo.full_name';
            // disable anti-tamper if build workflow is mutable
            const antitamperSteps = ((_s = !mutableBuilds) !== null && _s !== void 0 ? _s : this.antitamper) ? [{
                    // anti-tamper check (fails if there were changes to committed files)
                    // this will identify any non-committed files generated during build (e.g. test snapshots)
                    name: 'Anti-tamper check',
                    run: 'git diff --ignore-space-at-eol --exit-code',
                }] : [];
            // run codecov if enabled or a secret token name is passed in
            // AND jest must be configured
            if ((options.codeCov || options.codeCovTokenSecret) && ((_t = this.jest) === null || _t === void 0 ? void 0 : _t.config)) {
                postBuildSteps.push({
                    name: 'Upload coverage to Codecov',
                    uses: 'codecov/codecov-action@v1',
                    with: options.codeCovTokenSecret ? {
                        token: `\${{ secrets.${options.codeCovTokenSecret} }}`,
                        directory: this.jest.config.coverageDirectory,
                    } : {
                        directory: this.jest.config.coverageDirectory,
                    },
                });
            }
            // use "git diff --exit code" to check if there were changes in the repo
            // and create a step output that will be used in subsequent steps.
            postBuildSteps.push({
                name: 'Check for changes',
                id: gitDiffStepId,
                run: `git diff --exit-code || echo "::set-output name=${hasChangesCondName}::true"`,
            });
            // only if we had changes, commit them and push to the repo note that for
            // forks, this will fail (because the workflow doesn't have permissions.
            // this indicates to users that they need to update their branch manually.
            postBuildSteps.push({
                if: hasChanges,
                name: 'Commit and push changes (if changed)',
                run: `git add . && git commit -m "chore: self mutation" && git push origin HEAD:${branch}`,
            });
            // if we pushed changes, we need to manually update the status check so
            // that the PR will be green (we won't get here for forks with updates
            // because the push would have failed).
            postBuildSteps.push({
                if: hasChanges,
                name: 'Update status check (if changed)',
                run: [
                    'gh api',
                    '-X POST',
                    `/repos/\${{ ${repoFullName} }}/check-runs`,
                    `-F name="${buildJobId}"`,
                    '-F head_sha="$(git rev-parse HEAD)"',
                    '-F status="completed"',
                    '-F conclusion="success"',
                ].join(' '),
                env: {
                    GITHUB_TOKEN: '${{ secrets.GITHUB_TOKEN }}',
                },
            });
            // if we pushed changes, we need to mark the current commit as failed, so
            // that GitHub auto-merge does not risk merging this commit before the
            // event for the new commit has registered.
            postBuildSteps.push({
                if: hasChanges,
                name: 'Fail check if self mutation happened',
                run: [
                    'echo "Self-mutation happened on this pull request, so this commit is marked as having failed checks."',
                    'echo "The self-mutation commit has been marked as successful, and no further action should be necessary."',
                    'exit 1',
                ].join('\n'),
            });
            postBuildSteps.push(...antitamperSteps);
            if (this.github) {
                this.buildWorkflow = new github_1.TaskWorkflow(this.github, {
                    name: 'build',
                    jobId: buildJobId,
                    triggers: {
                        pullRequest: {},
                    },
                    env: {
                        CI: 'true',
                    },
                    permissions: {
                        checks: workflows_model_1.JobPermission.WRITE,
                        contents: workflows_model_1.JobPermission.WRITE,
                    },
                    checkoutWith: mutableBuilds ? {
                        ref: branch,
                        repository: repo,
                    } : undefined,
                    preBuildSteps: [
                        ...antitamperSteps,
                        ...this.installWorkflowSteps,
                    ],
                    task: this.buildTask,
                    postBuildSteps,
                    container: options.workflowContainerImage ? { image: options.workflowContainerImage } : undefined,
                });
                this.buildWorkflowJobId = buildJobId;
            }
        }
        const release = (_v = (_u = options.release) !== null && _u !== void 0 ? _u : options.releaseWorkflow) !== null && _v !== void 0 ? _v : (this.parent ? false : true);
        if (release) {
            this.addDevDeps(version_1.Version.STANDARD_VERSION);
            this.release = new release_1.Release(this, {
                versionFile: 'package.json',
                task: this.buildTask,
                branch: (_w = options.defaultReleaseBranch) !== null && _w !== void 0 ? _w : 'main',
                ...options,
                releaseWorkflowSetupSteps: [
                    ...this.installWorkflowSteps,
                    ...(_x = options.releaseWorkflowSetupSteps) !== null && _x !== void 0 ? _x : [],
                ],
            });
            this.publisher = this.release.publisher;
            if ((_y = options.releaseToNpm) !== null && _y !== void 0 ? _y : false) {
                this.release.publisher.publishToNpm({
                    distTag: this.package.npmDistTag,
                    registry: this.package.npmRegistry,
                    npmTokenSecret: this.package.npmTokenSecret,
                });
            }
        }
        else {
            // validate that no release options are selected if the release workflow is disabled.
            if (options.releaseToNpm) {
                throw new Error('"releaseToNpm" is not supported for APP projects');
            }
            if (options.releaseEveryCommit) {
                throw new Error('"releaseEveryCommit" is not supported for APP projects');
            }
            if (options.releaseSchedule) {
                throw new Error('"releaseSchedule" is not supported for APP projects');
            }
        }
        if ((_z = this.github) === null || _z === void 0 ? void 0 : _z.mergify) {
            this.autoMerge = new github_1.AutoMerge(this.github, {
                buildJob: this.buildWorkflowJobId,
                ...options.autoMergeOptions,
            });
        }
        if (options.dependabot !== undefined && options.depsUpgrade) {
            throw new Error("'dependabot' cannot be configured together with 'depsUpgrade'");
        }
        if (options.projenUpgradeAutoMerge !== undefined && options.autoApproveProjenUpgrades !== undefined) {
            throw new Error("'projenUpgradeAutoMerge' cannot be configured together with 'autoApproveProjenUpgrades'");
        }
        const projenAutoApprove = (_0 = options.autoApproveProjenUpgrades) !== null && _0 !== void 0 ? _0 : ((_1 = options.projenUpgradeAutoMerge) !== null && _1 !== void 0 ? _1 : false);
        const depsAutoApprove = (_2 = options.autoApproveUpgrades) !== null && _2 !== void 0 ? _2 : false;
        if (projenAutoApprove && !this.autoApprove) {
            throw new Error('Autoamtic approval of projen upgrades requires configuring `autoApproveOptions`');
        }
        if (depsAutoApprove && !this.autoApprove) {
            throw new Error('Autoamtic approval of dependencies upgrades requires configuring `autoApproveOptions`');
        }
        const autoApproveLabel = (condition) => { var _c; return (condition && ((_c = this.autoApprove) === null || _c === void 0 ? void 0 : _c.label)) ? [this.autoApprove.label] : undefined; };
        const defaultDependenciesUpgrade = ((_3 = options.dependabot) !== null && _3 !== void 0 ? _3 : false)
            ? DependenciesUpgradeMechanism.dependabot({ labels: autoApproveLabel(depsAutoApprove) })
            : DependenciesUpgradeMechanism.githubWorkflow({
                // if projen secret is defined we can also upgrade projen here.
                ignoreProjen: !options.projenUpgradeSecret,
                workflowOptions: {
                    // if projen secret is defined, use it (otherwise default to GITHUB_TOKEN).
                    secret: options.projenUpgradeSecret,
                    container: options.workflowContainerImage ? {
                        image: options.workflowContainerImage,
                    } : undefined,
                    labels: autoApproveLabel(depsAutoApprove),
                },
            });
        const dependenciesUpgrade = (_4 = options.depsUpgrade) !== null && _4 !== void 0 ? _4 : defaultDependenciesUpgrade;
        dependenciesUpgrade.bind(this);
        if (dependenciesUpgrade.ignoresProjen && this.package.packageName !== 'projen') {
            new upgrade_dependencies_1.UpgradeDependencies(this, {
                include: ['projen'],
                taskName: 'upgrade-projen',
                pullRequestTitle: 'upgrade projen',
                ignoreProjen: false,
                workflow: !!options.projenUpgradeSecret,
                workflowOptions: {
                    schedule: upgrade_dependencies_1.UpgradeDependenciesSchedule.expressions((_5 = options.projenUpgradeSchedule) !== null && _5 !== void 0 ? _5 : ['0 6 * * *']),
                    container: options.workflowContainerImage ? { image: options.workflowContainerImage } : undefined,
                    secret: options.projenUpgradeSecret,
                    labels: autoApproveLabel(projenAutoApprove),
                },
            });
        }
        if ((_6 = options.pullRequestTemplate) !== null && _6 !== void 0 ? _6 : true) {
            (_7 = this.github) === null || _7 === void 0 ? void 0 : _7.addPullRequestTemplate(...(_8 = options.pullRequestTemplateContents) !== null && _8 !== void 0 ? _8 : []);
        }
        const projenrcJs = (_9 = options.projenrcJs) !== null && _9 !== void 0 ? _9 : true;
        if (projenrcJs) {
            new projenrc_1.Projenrc(this, options.projenrcJsOptions);
        }
    }
    /**
     * @deprecated use `package.allowLibraryDependencies`
     */
    get allowLibraryDependencies() { return this.package.allowLibraryDependencies; }
    /**
     * @deprecated use `package.entrypoint`
     */
    get entrypoint() { return this.package.entrypoint; }
    /**
     * (experimental) Minimum node.js version required by this package.
     *
     * @experimental
     */
    get minNodeVersion() { return this.package.minNodeVersion; }
    /**
     * (experimental) Maximum node version required by this pacakge.
     *
     * @experimental
     */
    get maxNodeVersion() { return this.package.maxNodeVersion; }
    /**
     * (deprecated) The package manager to use.
     *
     * @deprecated use `package.packageManager`
     */
    get packageManager() { return this.package.packageManager; }
    /**
     * (experimental) The command to use in order to run the projen CLI.
     *
     * @experimental
     */
    get projenCommand() { return this.package.projenCommand; }
    /**
     * @deprecated use `package.addField(x, y)`
     */
    get manifest() {
        return this.package.manifest;
    }
    /**
     * @experimental
     */
    addBins(bins) {
        this.package.addBin(bins);
    }
    /**
     * (experimental) Replaces the contents of an npm package.json script.
     *
     * @param name The script name.
     * @param command The command to execute.
     * @experimental
     */
    setScript(name, command) {
        this.package.setScript(name, command);
    }
    /**
     * (experimental) Removes the npm script (always successful).
     *
     * @param name The name of the script.
     * @experimental
     */
    removeScript(name) {
        this.package.removeScript(name);
    }
    /**
     * (experimental) Indicates if a script by the name name is defined.
     *
     * @param name The name of the script.
     * @experimental
     */
    hasScript(name) {
        return this.package.hasScript(name);
    }
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `project.compileTask.exec()`
     */
    addCompileCommand(...commands) {
        for (const c of commands) {
            this.compileTask.exec(c);
        }
    }
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `project.testTask.exec()`
     */
    addTestCommand(...commands) {
        for (const c of commands) {
            this.testTask.exec(c);
        }
    }
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `project.buildTask.exec()`
     */
    addBuildCommand(...commands) {
        for (const c of commands) {
            this.buildTask.exec(c);
        }
    }
    /**
     * (experimental) Directly set fields in `package.json`.
     *
     * @param fields The fields to set.
     * @experimental
     */
    addFields(fields) {
        for (const [name, value] of Object.entries(fields)) {
            this.package.addField(name, value);
        }
    }
    /**
     * (experimental) Adds keywords to package.json (deduplicated).
     *
     * @param keywords The keywords to add.
     * @experimental
     */
    addKeywords(...keywords) {
        this.package.addKeywords(...keywords);
    }
    /**
     * @experimental
     */
    get installWorkflowSteps() {
        const install = new Array();
        // first run the workflow bootstrap steps
        install.push(...this.workflowBootstrapSteps);
        if (this.nodeVersion) {
            install.push({
                name: 'Setup Node.js',
                uses: 'actions/setup-node@v2.2.0',
                with: { 'node-version': this.nodeVersion },
            });
        }
        install.push({
            name: 'Install dependencies',
            run: this.package.installCommand,
        });
        return install;
    }
    /**
     * (experimental) Defines normal dependencies.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addDeps(...deps) {
        return this.package.addDeps(...deps);
    }
    /**
     * (experimental) Defines development/test dependencies.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addDevDeps(...deps) {
        return this.package.addDevDeps(...deps);
    }
    /**
     * (experimental) Defines peer dependencies.
     *
     * When adding peer dependencies, a devDependency will also be added on the
     * pinned version of the declared peer. This will ensure that you are testing
     * your code against the minimum version required from your consumers.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addPeerDeps(...deps) {
        return this.package.addPeerDeps(...deps);
    }
    /**
     * (experimental) Defines bundled dependencies.
     *
     * Bundled dependencies will be added as normal dependencies as well as to the
     * `bundledDependencies` section of your `package.json`.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addBundledDeps(...deps) {
        return this.package.addBundledDeps(...deps);
    }
    /**
     * (experimental) Exclude these files from the bundled package.
     *
     * Implemented by project types based on the
     * packaging mechanism. For example, `NodeProject` delegates this to `.npmignore`.
     *
     * @experimental
     */
    addPackageIgnore(pattern) {
        var _c;
        (_c = this.npmignore) === null || _c === void 0 ? void 0 : _c.addPatterns(pattern);
    }
    addLicense(options) {
        var _c;
        if (this.package.license) {
            new license_1.License(this, {
                spdx: this.package.license,
                copyrightOwner: (_c = options.copyrightOwner) !== null && _c !== void 0 ? _c : options.authorName,
                copyrightPeriod: options.copyrightPeriod,
            });
        }
    }
    addDefaultGitIgnore() {
        this.gitignore.exclude('# Logs', 'logs', '*.log', 'npm-debug.log*', 'yarn-debug.log*', 'yarn-error.log*', 'lerna-debug.log*', '# Diagnostic reports (https://nodejs.org/api/report.html)', 'report.[0-9]*.[0-9]*.[0-9]*.[0-9]*.json', '# Runtime data', 'pids', '*.pid', '*.seed', '*.pid.lock', '# Directory for instrumented libs generated by jscoverage/JSCover', 'lib-cov', '# Coverage directory used by tools like istanbul', 'coverage', '*.lcov', '# nyc test coverage', '.nyc_output', '# Compiled binary addons (https://nodejs.org/api/addons.html)', 'build/Release', '# Dependency directories', 'node_modules/', 'jspm_packages/', '# TypeScript cache', '*.tsbuildinfo', '# Optional eslint cache', '.eslintcache', '# Output of \'npm pack\'', '*.tgz', '# Yarn Integrity file', '.yarn-integrity', '# parcel-bundler cache (https://parceljs.org/)', '.cache');
    }
    /**
     * (experimental) Returns the shell command to execute in order to run a task.
     *
     * This will
     * typically be `npx projen TASK`.
     *
     * @param task The task for which the command is required.
     * @experimental
     */
    runTaskCommand(task) {
        return `${this.package.projenCommand} ${task.name}`;
    }
}
exports.NodeProject = NodeProject;
_a = JSII_RTTI_SYMBOL_1;
NodeProject[_a] = { fqn: "projen.NodeProject", version: "0.27.22" };
/**
 * (experimental) Dependencies upgrade mechanism.
 *
 * @experimental
 */
class DependenciesUpgradeMechanism {
    constructor(binder, _ignoresProjen) {
        this.binder = binder;
        this._ignoresProjen = _ignoresProjen;
    }
    /**
     * (experimental) Upgrade via dependabot.
     *
     * @experimental
     */
    static dependabot(options = {}) {
        return new DependenciesUpgradeMechanism((project) => {
            var _c;
            (_c = project.github) === null || _c === void 0 ? void 0 : _c.addDependabot(options);
        }, options.ignoreProjen);
    }
    /**
     * (experimental) Upgrade via a custom github workflow.
     *
     * @experimental
     */
    static githubWorkflow(options = {}) {
        return new DependenciesUpgradeMechanism((project) => {
            new upgrade_dependencies_1.UpgradeDependencies(project, options);
        }, options.ignoreProjen);
    }
    /**
     * @experimental
     */
    get ignoresProjen() {
        var _c;
        // we ignore projen by default because it requires 'workflow' permissions to run.
        // nor depenedabot nor the default github token has those permissions.
        return (_c = this._ignoresProjen) !== null && _c !== void 0 ? _c : true;
    }
    /**
     * @experimental
     */
    bind(project) {
        this.binder(project);
    }
}
exports.DependenciesUpgradeMechanism = DependenciesUpgradeMechanism;
_b = JSII_RTTI_SYMBOL_1;
DependenciesUpgradeMechanism[_b] = { fqn: "projen.DependenciesUpgradeMechanism", version: "0.27.22" };
/**
 * (experimental) Disable.
 *
 * @experimental
 */
DependenciesUpgradeMechanism.NONE = new DependenciesUpgradeMechanism((_) => ({}), true);
//# sourceMappingURL=data:application/json;base64,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