"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PoetryPyproject = exports.Poetry = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const deps_1 = require("../deps");
const tasks_1 = require("../tasks");
const toml_1 = require("../toml");
const util_1 = require("../util");
/**
 * (experimental) Manage project dependencies, virtual environments, and packaging through the poetry CLI tool.
 *
 * @experimental
 */
class Poetry extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options) {
        var _c;
        super(project);
        this.installTask = project.addTask('install', {
            description: 'Install and upgrade dependencies',
            exec: 'poetry update',
        });
        this.project.tasks.addEnvironment('VIRTUAL_ENV', '$(poetry env info -p)');
        this.project.tasks.addEnvironment('PATH', '$(echo $(poetry env info -p)/bin:$PATH)');
        // declare the python versions for which the package is compatible
        this.addDependency('python@^3.6');
        this.packageTask = project.addTask('package', {
            description: 'Creates source archive and wheel for distribution.',
            exec: 'poetry build',
        });
        this.publishTestTask = project.addTask('publish:test', {
            description: 'Uploads the package against a test PyPI endpoint.',
            exec: 'poetry publish -r testpypi',
        });
        this.publishTask = project.addTask('publish', {
            description: 'Uploads the package to PyPI.',
            exec: 'poetry publish',
        });
        new PoetryPyproject(project, {
            name: project.name,
            version: options.version,
            description: (_c = options.description) !== null && _c !== void 0 ? _c : '',
            license: options.license,
            authors: [`${options.authorName} <${options.authorEmail}>`],
            homepage: options.homepage,
            classifiers: options.classifiers,
            ...options.poetryOptions,
            dependencies: () => this.synthDependencies(),
            devDependencies: () => this.synthDevDependencies(),
        });
        new toml_1.TomlFile(project, 'poetry.toml', {
            committed: false,
            obj: {
                repositories: {
                    testpypi: {
                        url: 'https://test.pypi.org/legacy/',
                    },
                },
            },
        });
    }
    synthDependencies() {
        const dependencies = {};
        for (const pkg of this.project.deps.all) {
            if (pkg.type === deps_1.DependencyType.RUNTIME) {
                dependencies[pkg.name] = pkg.version;
            }
        }
        return dependencies;
    }
    synthDevDependencies() {
        const dependencies = {};
        for (const pkg of this.project.deps.all) {
            if ([deps_1.DependencyType.DEVENV].includes(pkg.type)) {
                dependencies[pkg.name] = pkg.version;
            }
        }
        return dependencies;
    }
    /**
     * (experimental) Adds a runtime dependency.
     *
     * @param spec Format `<module>@<semver>`.
     * @experimental
     */
    addDependency(spec) {
        this.project.deps.addDependency(spec, deps_1.DependencyType.RUNTIME);
    }
    /**
     * (experimental) Adds a dev dependency.
     *
     * @param spec Format `<module>@<semver>`.
     * @experimental
     */
    addDevDependency(spec) {
        this.project.deps.addDependency(spec, deps_1.DependencyType.DEVENV);
    }
    /**
     * (experimental) Initializes the virtual environment if it doesn't exist (called during post-synthesis).
     *
     * @experimental
     */
    setupEnvironment() {
        const result = util_1.execOrUndefined('which poetry', { cwd: this.project.outdir });
        if (!result) {
            this.project.logger.info('Unable to setup an environment since poetry is not installed. Please install poetry (https://python-poetry.org/docs/) or use a different component for managing environments such as \'venv\'.');
        }
        let envPath = util_1.execOrUndefined('poetry env info -p', { cwd: this.project.outdir });
        if (!envPath) {
            this.project.logger.info('Setting up a virtual environment...');
            util_1.exec('poetry env use python', { cwd: this.project.outdir });
            envPath = util_1.execOrUndefined('poetry env info -p', { cwd: this.project.outdir });
            this.project.logger.info(`Environment successfully created (located in ${envPath}}).`);
        }
    }
    /**
     * (experimental) Installs dependencies (called during post-synthesis).
     *
     * @experimental
     */
    installDependencies() {
        this.project.logger.info('Installing dependencies...');
        const runtime = new tasks_1.TaskRuntime(this.project.outdir);
        runtime.runTask(this.installTask.name);
    }
}
exports.Poetry = Poetry;
_a = JSII_RTTI_SYMBOL_1;
Poetry[_a] = { fqn: "projen.python.Poetry", version: "0.27.22" };
/**
 * (experimental) Represents configuration of a pyproject.toml file for a Poetry project.
 *
 * @see https://python-poetry.org/docs/pyproject/
 * @experimental
 */
class PoetryPyproject extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options) {
        super(project);
        this.file = new toml_1.TomlFile(project, 'pyproject.toml', {
            omitEmpty: false,
            obj: {
                'build-system': {
                    'requires': ['poetry_core>=1.0.0'],
                    'build-backend': 'poetry.core.masonry.api',
                },
                'tool': {
                    poetry: {
                        'name': options.name,
                        'version': options.version,
                        'description': options.description,
                        'license': options.license,
                        'authors': options.authors,
                        'maintainers': options.maintainers,
                        'readme': options.readme,
                        'homepage': options.homepage,
                        'repository': options.repository,
                        'documentation': options.documentation,
                        'keywords': options.keywords,
                        'classifiers': options.classifiers,
                        'packages': options.packages,
                        'include': options.include,
                        'exclude': options.exclude,
                        'dependencies': options.dependencies,
                        'dev-dependencies': options.devDependencies,
                        'scripts': options.scripts,
                    },
                },
            },
        });
    }
}
exports.PoetryPyproject = PoetryPyproject;
_b = JSII_RTTI_SYMBOL_1;
PoetryPyproject[_b] = { fqn: "projen.python.PoetryPyproject", version: "0.27.22" };
//# sourceMappingURL=data:application/json;base64,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