"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Projenrc = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const fs_extra_1 = require("fs-extra");
const common_1 = require("../common");
const component_1 = require("../component");
const deps_1 = require("../deps");
const inventory_1 = require("../inventory");
const project_1 = require("../project");
// eslint-disable-next-line @typescript-eslint/no-require-imports
const decamelize = require('decamelize');
/**
 * (experimental) Allows writing projenrc files in python.
 *
 * This will install `projen` as a Python dependency and will add a
 * `synth` task which will run `.projenrc.py`.
 *
 * @experimental
 */
class Projenrc extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options = {}) {
        var _b, _c;
        super(project);
        const projenVersion = (_b = options.projenVersion) !== null && _b !== void 0 ? _b : common_1.PROJEN_VERSION; // ?
        this.rcfile = (_c = options.filename) !== null && _c !== void 0 ? _c : '.projenrc.py';
        project.deps.addDependency(`projen@${projenVersion}`, deps_1.DependencyType.DEVENV);
        // set up the "default" task which is the task executed when `projen` is executed for this project.
        const defaultTask = project.addTask(project_1.Project.DEFAULT_TASK, { description: 'Synthesize the project' });
        defaultTask.exec('python projenrc.py');
        // if this is a new project, generate a skeleton for projenrc.py
        this.generateProjenrc();
    }
    generateProjenrc() {
        var _b, _c, _d;
        const bootstrap = this.project.newProject;
        if (!bootstrap) {
            return;
        }
        const jsiiFqn = bootstrap.fqn;
        const jsiiManifest = inventory_1.readJsiiManifest(jsiiFqn);
        const jsiiType = jsiiManifest.types[jsiiFqn];
        const optionsTypeFqn = (_d = (_c = (_b = jsiiType.initializer) === null || _b === void 0 ? void 0 : _b.parameters) === null || _c === void 0 ? void 0 : _c[0].type) === null || _d === void 0 ? void 0 : _d.fqn;
        if (!optionsTypeFqn) {
            this.project.logger.warn('cannot determine jsii type for project options');
            return;
        }
        const pythonFile = path_1.join(this.project.outdir, this.rcfile);
        // skip if file exists
        if (fs_extra_1.existsSync(pythonFile)) {
            return;
        }
        const lines = new Array();
        let indent = 0;
        const emit = (line = '') => lines.push(' '.repeat(indent * 4) + line);
        // const openBlock = (line: string = '') => { emit(line + ' {'); indent++; };
        // const closeBlock = () => { indent--; emit('}'); };
        const optionFqns = {};
        for (const option of bootstrap.type.options) {
            if (option.fqn) {
                optionFqns[option.name] = option.fqn;
            }
        }
        const { renderedOptions, imports } = renderPythonOptions(indent, optionFqns, bootstrap.args);
        emit(toPythonImport(jsiiFqn));
        for (const fqn of imports) {
            emit(toPythonImport(fqn));
        }
        emit();
        emit(`project = ${jsiiType.name}(${renderedOptions});`);
        emit();
        emit('project.synth();');
        fs_extra_1.mkdirpSync(path_1.dirname(pythonFile));
        fs_extra_1.writeFileSync(pythonFile, lines.join('\n'));
        this.project.logger.info(`Project definition file was created at ${pythonFile}`);
    }
}
exports.Projenrc = Projenrc;
_a = JSII_RTTI_SYMBOL_1;
Projenrc[_a] = { fqn: "projen.python.Projenrc", version: "0.27.22" };
function renderPythonOptions(indent, optionFqns, initOptions) {
    const imports = new Set();
    if (!initOptions || Object.keys(initOptions).length === 0) { // no options
        return { renderedOptions: '', imports };
    }
    const lines = [''];
    for (const [name, value] of Object.entries(initOptions)) {
        const { pythonValue, importName } = toPythonValue(value, name, optionFqns);
        if (importName)
            imports.add(importName);
        lines.push(`${toPythonProperty(name)}=${pythonValue},`);
    }
    const renderedOptions = lines.join(`\n${' '.repeat((indent + 1) * 4)}`).concat('\n');
    return { renderedOptions, imports };
}
function toPythonProperty(prop) {
    return decamelize(prop);
}
function toPythonValue(value, name, optionFqns) {
    if (typeof value === 'boolean') {
        return { pythonValue: value ? 'True' : 'False' };
    }
    else if (typeof value === 'number') {
        return { pythonValue: JSON.stringify(value) };
    }
    else if (typeof value === 'string') {
        if (optionFqns[name] !== undefined) {
            const parts = optionFqns[name].split('.');
            const base = parts[parts.length - 1];
            const choice = String(value).toUpperCase().replace(/-/g, '_');
            return { pythonValue: `${base}.${choice}`, importName: optionFqns[name] };
        }
        else {
            return { pythonValue: JSON.stringify(value) };
        }
    }
    else if (value === undefined || value === null) {
        return { pythonValue: 'None' };
    }
    else {
        return { pythonValue: JSON.stringify(value) };
    }
}
function toPythonImport(fqn) {
    const parts = fqn.split('.');
    if (parts.length === 1) {
        return `import ${parts[0]}`;
    }
    else {
        return `from ${parts.slice(0, -1).join('.')} import ${parts[parts.length - 1]}`;
    }
}
//# sourceMappingURL=data:application/json;base64,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