export interface BumpOptions {
    /**
     * The name of a .json file to set `version`.
     */
    readonly versionFile: string;
    /**
     * The name of the changelog file to generate.
     */
    readonly changelog: string;
    /**
     * USe a pre-release suffix.
     * @default - normal versioning
     */
    readonly prerelease?: string;
    /**
     * Defines the major version line. This is used to select the latest version
     * and also enforce that new major versions are not released accidentally.
     *
     * @default - any version is supported
     */
    readonly majorVersion?: number;
    /**
     * The name of a file which will include the output version number (a text file).
     *
     * Relative to cwd.
     *
     * @example `.version.txt`
     */
    readonly bumpFile: string;
}
/**
 * Resolves the latest version from git tags and uses `standard-version` to bump
 * to the next version based on commits.
 *
 * This expects `standard-version` to be installed in the path.
 *
 * @param cwd working directory (git repository)
 * @param options options
 */
export declare function bump(cwd: string, options: BumpOptions): Promise<void>;
