"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Resolves the latest version from git tags and uses `standard-version` to bump
 * to the next version based on commits.
 *
 * This expects `standard-version` to be installed in the path.
 *
 * Environment variables:
 *
 * - OUTFILE: (required) the name of the JSON output file (the "version" field
 *   will be updated with the latest version)
 * - PRERELEASE: (optional) a prerelease tag to use (e.g. "beta")
 * - MAJOR: major version number NN to filter (tags are filtered by "vNN."
 *   prefix). if not specified, the last major version is selected
 * - CHANGELOG: name of changelog file to create
 *
 */
const bump_version_1 = require("./bump-version");
const versionFile = process.env.OUTFILE;
const prerelease = process.env.PRERELEASE;
const major = process.env.MAJOR;
const changelog = process.env.CHANGELOG;
const bumpFile = process.env.BUMPFILE;
if (!versionFile) {
    throw new Error('OUTFILE is required');
}
if (!changelog) {
    throw new Error('CHANGELOG is required');
}
if (!bumpFile) {
    throw new Error('BUMPFILE is required');
}
const majorVersion = (major == null || major === '') ? undefined : parseInt(major);
if (majorVersion === NaN) {
    throw new Error(`MAJOR must be a number: ${majorVersion}`);
}
const opts = {
    versionFile: versionFile,
    changelog: changelog,
    majorVersion: majorVersion,
    prerelease: prerelease,
    bumpFile: bumpFile,
};
bump_version_1.bump(process.cwd(), opts).catch((e) => {
    console.log(e.stack);
    process.exit(1);
});
//# sourceMappingURL=data:application/json;base64,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