"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Publisher = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const workflows_model_1 = require("../github/workflows-model");
const JSII_RELEASE_VERSION = 'latest';
const GITHUB_PACKAGES_REGISTRY = 'npm.pkg.github.com';
const GITHUB_PACKAGES_MAVEN_REPOSITORY = 'https://maven.pkg.github.com';
const ARTIFACTS_DIR = 'dist';
const JSII_RELEASE_IMAGE = 'jsii/superchain';
/**
 * (experimental) Implements GitHub jobs for publishing modules to package managers.
 *
 * Under the hood, it uses https://github.com/aws/jsii-release
 *
 * @experimental
 */
class Publisher extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options) {
        var _b;
        super(project);
        // the jobs to add to the release workflow
        this.jobs = {};
        this.buildJobId = options.buildJobId;
        this.artifactName = options.artifactName;
        this.jsiiReleaseVersion = (_b = options.jsiiReleaseVersion) !== null && _b !== void 0 ? _b : JSII_RELEASE_VERSION;
        this.condition = options.condition;
    }
    /**
     * (experimental) Renders a set of workflow jobs for all the publishers.
     *
     * @returns GitHub workflow jobs
     * @experimental
     */
    render() {
        return { ...this.jobs };
    }
    /**
     * (experimental) Creates a GitHub Release.
     *
     * @param options Options.
     * @experimental
     */
    publishToGitHubReleases(options) {
        const versionFile = `${ARTIFACTS_DIR}/${options.versionFile}`;
        const changelogFile = `${ARTIFACTS_DIR}/${options.changelogFile}`;
        // create a github release
        const getVersion = `v$(cat ${versionFile})`;
        this.addPublishJob({
            name: 'github',
            registryName: 'GitHub Releases',
            permissions: {
                contents: workflows_model_1.JobPermission.WRITE,
            },
            workflowEnv: {
                GITHUB_TOKEN: '${{ secrets.GITHUB_TOKEN }}',
            },
            run: [
                `gh release create ${getVersion}`,
                `-F ${changelogFile}`,
                `-t ${getVersion}`,
            ].join(' '),
        });
    }
    /**
     * (experimental) Publishes artifacts from `js/**` to npm.
     *
     * @param options Options.
     * @experimental
     */
    publishToNpm(options = {}) {
        var _b, _c;
        const isGitHubPackages = (_b = options.registry) === null || _b === void 0 ? void 0 : _b.startsWith(GITHUB_PACKAGES_REGISTRY);
        this.addPublishJob({
            name: 'npm',
            run: this.jsiiReleaseCommand('jsii-release-npm'),
            containerImage: JSII_RELEASE_IMAGE,
            registryName: 'npm',
            env: {
                NPM_DIST_TAG: options.distTag,
                NPM_REGISTRY: options.registry,
            },
            permissions: {
                contents: workflows_model_1.JobPermission.READ,
                packages: isGitHubPackages ? workflows_model_1.JobPermission.WRITE : undefined,
            },
            workflowEnv: {
                // if we are publishing to GitHub Packages, default to GITHUB_TOKEN.
                NPM_TOKEN: secret((_c = options.npmTokenSecret) !== null && _c !== void 0 ? _c : (isGitHubPackages ? 'GITHUB_TOKEN' : 'NPM_TOKEN')),
            },
        });
    }
    /**
     * (experimental) Publishes artifacts from `dotnet/**` to NuGet Gallery.
     *
     * @param options Options.
     * @experimental
     */
    publishToNuget(options = {}) {
        var _b;
        this.addPublishJob({
            name: 'nuget',
            containerImage: JSII_RELEASE_IMAGE,
            run: this.jsiiReleaseCommand('jsii-release-nuget'),
            registryName: 'NuGet Gallery',
            workflowEnv: {
                NUGET_API_KEY: secret((_b = options.nugetApiKeySecret) !== null && _b !== void 0 ? _b : 'NUGET_API_KEY'),
            },
        });
    }
    /**
     * (experimental) Publishes artifacts from `java/**` to Maven.
     *
     * @param options Options.
     * @experimental
     */
    publishToMaven(options = {}) {
        var _b, _c, _d, _e, _f, _g, _h;
        const isGitHubPackages = (_b = options.mavenRepositoryUrl) === null || _b === void 0 ? void 0 : _b.startsWith(GITHUB_PACKAGES_MAVEN_REPOSITORY);
        const isGitHubActor = isGitHubPackages && options.mavenUsername == undefined;
        const mavenServerId = (_c = options.mavenServerId) !== null && _c !== void 0 ? _c : (isGitHubPackages ? 'github' : undefined);
        if (isGitHubPackages && mavenServerId != 'github') {
            throw new Error('publishing to GitHub Packages requires the "mavenServerId" to be "github"');
        }
        this.addPublishJob({
            name: 'maven',
            registryName: 'Maven Central',
            containerImage: JSII_RELEASE_IMAGE,
            run: this.jsiiReleaseCommand('jsii-release-maven'),
            env: {
                MAVEN_ENDPOINT: options.mavenEndpoint,
                MAVEN_SERVER_ID: mavenServerId,
                MAVEN_REPOSITORY_URL: options.mavenRepositoryUrl,
            },
            workflowEnv: {
                MAVEN_GPG_PRIVATE_KEY: isGitHubPackages ? undefined : secret((_d = options.mavenGpgPrivateKeySecret) !== null && _d !== void 0 ? _d : 'MAVEN_GPG_PRIVATE_KEY'),
                MAVEN_GPG_PRIVATE_KEY_PASSPHRASE: isGitHubPackages ? undefined : secret((_e = options.mavenGpgPrivateKeyPassphrase) !== null && _e !== void 0 ? _e : 'MAVEN_GPG_PRIVATE_KEY_PASSPHRASE'),
                MAVEN_PASSWORD: secret((_f = options.mavenPassword) !== null && _f !== void 0 ? _f : (isGitHubPackages ? 'GITHUB_TOKEN' : 'MAVEN_PASSWORD')),
                MAVEN_USERNAME: isGitHubActor ? '${{ github.actor }}' : secret((_g = options.mavenUsername) !== null && _g !== void 0 ? _g : 'MAVEN_USERNAME'),
                MAVEN_STAGING_PROFILE_ID: isGitHubPackages ? undefined : secret((_h = options.mavenStagingProfileId) !== null && _h !== void 0 ? _h : 'MAVEN_STAGING_PROFILE_ID'),
            },
            permissions: {
                contents: workflows_model_1.JobPermission.READ,
                packages: isGitHubPackages ? workflows_model_1.JobPermission.WRITE : undefined,
            },
        });
    }
    /**
     * (experimental) Publishes wheel artifacts from `python` to PyPI.
     *
     * @param options Options.
     * @experimental
     */
    publishToPyPi(options = {}) {
        var _b, _c;
        this.addPublishJob({
            name: 'pypi',
            registryName: 'PyPI',
            run: this.jsiiReleaseCommand('jsii-release-pypi'),
            containerImage: JSII_RELEASE_IMAGE,
            env: {
                TWINE_REPOSITORY_URL: options.twineRegistryUrl,
            },
            workflowEnv: {
                TWINE_USERNAME: secret((_b = options.twineUsernameSecret) !== null && _b !== void 0 ? _b : 'TWINE_USERNAME'),
                TWINE_PASSWORD: secret((_c = options.twinePasswordSecret) !== null && _c !== void 0 ? _c : 'TWINE_PASSWORD'),
            },
        });
    }
    /**
     * (experimental) Adds a go publishing job.
     *
     * @param options Options.
     * @experimental
     */
    publishToGo(options = {}) {
        var _b, _c, _d;
        this.addPublishJob({
            name: 'golang',
            run: this.jsiiReleaseCommand('jsii-release-golang'),
            containerImage: JSII_RELEASE_IMAGE,
            registryName: 'GitHub',
            env: {
                GITHUB_REPO: options.githubRepo,
                GIT_BRANCH: options.gitBranch,
                GIT_USER_NAME: (_b = options.gitUserName) !== null && _b !== void 0 ? _b : 'GitHub Actions',
                GIT_USER_EMAIL: (_c = options.gitUserEmail) !== null && _c !== void 0 ? _c : 'github-actions@github.com',
                GIT_COMMIT_MESSAGE: options.gitCommitMessage,
            },
            workflowEnv: {
                GITHUB_TOKEN: secret((_d = options.githubTokenSecret) !== null && _d !== void 0 ? _d : 'GO_GITHUB_TOKEN'),
            },
        });
    }
    addPublishJob(opts) {
        var _b;
        const jobname = `release_${opts.name}`;
        if (jobname in this.jobs) {
            throw new Error(`Duplicate job with name "${jobname}"`);
        }
        const requiredEnv = new Array();
        // jobEnv is the env we pass to the github job (task environment + secrets/expressions).
        const jobEnv = { ...opts.env };
        const workflowEnvEntries = Object.entries((_b = opts.workflowEnv) !== null && _b !== void 0 ? _b : {})
            .filter(([_, value]) => value != undefined);
        for (const [name, expression] of workflowEnvEntries) {
            requiredEnv.push(name);
            jobEnv[name] = expression;
        }
        // define a task which can be used through `projen publish:xxx`.
        this.project.addTask(`publish:${opts.name.toLocaleLowerCase()}`, {
            description: `Publish this package to ${opts.registryName}`,
            env: opts.env,
            requiredEnv: requiredEnv,
            exec: opts.run,
        });
        const job = {
            name: `Publish to ${opts.registryName}`,
            permissions: opts.permissions ? opts.permissions : { contents: workflows_model_1.JobPermission.READ },
            if: this.condition,
            needs: [this.buildJobId],
            runsOn: 'ubuntu-latest',
            container: opts.containerImage ? {
                image: opts.containerImage,
            } : undefined,
            steps: [
                {
                    name: 'Download build artifacts',
                    uses: 'actions/download-artifact@v2',
                    with: {
                        name: this.artifactName,
                        path: ARTIFACTS_DIR,
                    },
                },
                {
                    name: 'Release',
                    // it would have been nice if we could just run "projen publish:xxx" here but that is not possible because this job does not checkout sources
                    run: opts.run,
                    env: jobEnv,
                },
            ],
        };
        this.jobs[jobname] = job;
    }
    jsiiReleaseCommand(command) {
        return `npx -p jsii-release@${this.jsiiReleaseVersion} ${command}`;
    }
}
exports.Publisher = Publisher;
_a = JSII_RTTI_SYMBOL_1;
Publisher[_a] = { fqn: "projen.release.Publisher", version: "0.27.22" };
function secret(secretName) {
    return `\${{ secrets.${secretName} }}`;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicHVibGlzaGVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL3JlbGVhc2UvcHVibGlzaGVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsNENBQXlDO0FBRXpDLCtEQUEwRTtBQUcxRSxNQUFNLG9CQUFvQixHQUFHLFFBQVEsQ0FBQztBQUN0QyxNQUFNLHdCQUF3QixHQUFHLG9CQUFvQixDQUFDO0FBQ3RELE1BQU0sZ0NBQWdDLEdBQUcsOEJBQThCLENBQUM7QUFDeEUsTUFBTSxhQUFhLEdBQUcsTUFBTSxDQUFDO0FBQzdCLE1BQU0sa0JBQWtCLEdBQUcsaUJBQWlCLENBQUM7Ozs7Ozs7O0FBa0I3QyxNQUFhLFNBQVUsU0FBUSxxQkFBUzs7OztJQVN0QyxZQUFZLE9BQWdCLEVBQUUsT0FBeUI7O1FBQ3JELEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUpqQiwwQ0FBMEM7UUFDekIsU0FBSSxHQUFzQyxFQUFFLENBQUM7UUFLNUQsSUFBSSxDQUFDLFVBQVUsR0FBRyxPQUFPLENBQUMsVUFBVSxDQUFDO1FBQ3JDLElBQUksQ0FBQyxZQUFZLEdBQUcsT0FBTyxDQUFDLFlBQVksQ0FBQztRQUN6QyxJQUFJLENBQUMsa0JBQWtCLFNBQUcsT0FBTyxDQUFDLGtCQUFrQixtQ0FBSSxvQkFBb0IsQ0FBQztRQUM3RSxJQUFJLENBQUMsU0FBUyxHQUFHLE9BQU8sQ0FBQyxTQUFTLENBQUM7SUFDckMsQ0FBQzs7Ozs7OztJQUdNLE1BQU07UUFDWCxPQUFPLEVBQUUsR0FBRyxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7SUFDMUIsQ0FBQzs7Ozs7OztJQUdNLHVCQUF1QixDQUFDLE9BQXFDO1FBQ2xFLE1BQU0sV0FBVyxHQUFHLEdBQUcsYUFBYSxJQUFJLE9BQU8sQ0FBQyxXQUFXLEVBQUUsQ0FBQztRQUM5RCxNQUFNLGFBQWEsR0FBRyxHQUFHLGFBQWEsSUFBSSxPQUFPLENBQUMsYUFBYSxFQUFFLENBQUM7UUFFbEUsMEJBQTBCO1FBQzFCLE1BQU0sVUFBVSxHQUFHLFVBQVUsV0FBVyxHQUFHLENBQUM7UUFFNUMsSUFBSSxDQUFDLGFBQWEsQ0FBQztZQUNqQixJQUFJLEVBQUUsUUFBUTtZQUNkLFlBQVksRUFBRSxpQkFBaUI7WUFDL0IsV0FBVyxFQUFFO2dCQUNYLFFBQVEsRUFBRSwrQkFBYSxDQUFDLEtBQUs7YUFDOUI7WUFDRCxXQUFXLEVBQUU7Z0JBQ1gsWUFBWSxFQUFFLDZCQUE2QjthQUM1QztZQUNELEdBQUcsRUFBRTtnQkFDSCxxQkFBcUIsVUFBVSxFQUFFO2dCQUNqQyxNQUFNLGFBQWEsRUFBRTtnQkFDckIsTUFBTSxVQUFVLEVBQUU7YUFDbkIsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDO1NBQ1osQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs7Ozs7OztJQUdNLFlBQVksQ0FBQyxVQUE2QixFQUFFOztRQUNqRCxNQUFNLGdCQUFnQixTQUFHLE9BQU8sQ0FBQyxRQUFRLDBDQUFFLFVBQVUsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDO1FBRWhGLElBQUksQ0FBQyxhQUFhLENBQUM7WUFDakIsSUFBSSxFQUFFLEtBQUs7WUFDWCxHQUFHLEVBQUUsSUFBSSxDQUFDLGtCQUFrQixDQUFDLGtCQUFrQixDQUFDO1lBQ2hELGNBQWMsRUFBRSxrQkFBa0I7WUFDbEMsWUFBWSxFQUFFLEtBQUs7WUFDbkIsR0FBRyxFQUFFO2dCQUNILFlBQVksRUFBRSxPQUFPLENBQUMsT0FBTztnQkFDN0IsWUFBWSxFQUFFLE9BQU8sQ0FBQyxRQUFRO2FBQy9CO1lBQ0QsV0FBVyxFQUFFO2dCQUNYLFFBQVEsRUFBRSwrQkFBYSxDQUFDLElBQUk7Z0JBQzVCLFFBQVEsRUFBRSxnQkFBZ0IsQ0FBQyxDQUFDLENBQUMsK0JBQWEsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLFNBQVM7YUFDN0Q7WUFDRCxXQUFXLEVBQUU7Z0JBQ1gsb0VBQW9FO2dCQUNwRSxTQUFTLEVBQUUsTUFBTSxPQUFDLE9BQU8sQ0FBQyxjQUFjLG1DQUFJLENBQUMsZ0JBQWdCLENBQUMsQ0FBQyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsV0FBVyxDQUFDLENBQUM7YUFDL0Y7U0FDRixDQUFDLENBQUM7SUFDTCxDQUFDOzs7Ozs7O0lBR00sY0FBYyxDQUFDLFVBQStCLEVBQUU7O1FBQ3JELElBQUksQ0FBQyxhQUFhLENBQUM7WUFDakIsSUFBSSxFQUFFLE9BQU87WUFDYixjQUFjLEVBQUUsa0JBQWtCO1lBQ2xDLEdBQUcsRUFBRSxJQUFJLENBQUMsa0JBQWtCLENBQUMsb0JBQW9CLENBQUM7WUFDbEQsWUFBWSxFQUFFLGVBQWU7WUFDN0IsV0FBVyxFQUFFO2dCQUNYLGFBQWEsRUFBRSxNQUFNLE9BQUMsT0FBTyxDQUFDLGlCQUFpQixtQ0FBSSxlQUFlLENBQUM7YUFDcEU7U0FDRixDQUFDLENBQUM7SUFDTCxDQUFDOzs7Ozs7O0lBR00sY0FBYyxDQUFDLFVBQStCLEVBQUU7O1FBQ3JELE1BQU0sZ0JBQWdCLFNBQUcsT0FBTyxDQUFDLGtCQUFrQiwwQ0FBRSxVQUFVLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztRQUNsRyxNQUFNLGFBQWEsR0FBRyxnQkFBZ0IsSUFBSSxPQUFPLENBQUMsYUFBYSxJQUFJLFNBQVMsQ0FBQztRQUM3RSxNQUFNLGFBQWEsU0FBRyxPQUFPLENBQUMsYUFBYSxtQ0FBSSxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO1FBRXpGLElBQUksZ0JBQWdCLElBQUksYUFBYSxJQUFJLFFBQVEsRUFBRTtZQUNqRCxNQUFNLElBQUksS0FBSyxDQUFDLDJFQUEyRSxDQUFDLENBQUM7U0FDOUY7UUFFRCxJQUFJLENBQUMsYUFBYSxDQUFDO1lBQ2pCLElBQUksRUFBRSxPQUFPO1lBQ2IsWUFBWSxFQUFFLGVBQWU7WUFDN0IsY0FBYyxFQUFFLGtCQUFrQjtZQUNsQyxHQUFHLEVBQUUsSUFBSSxDQUFDLGtCQUFrQixDQUFDLG9CQUFvQixDQUFDO1lBQ2xELEdBQUcsRUFBRTtnQkFDSCxjQUFjLEVBQUUsT0FBTyxDQUFDLGFBQWE7Z0JBQ3JDLGVBQWUsRUFBRSxhQUFhO2dCQUM5QixvQkFBb0IsRUFBRSxPQUFPLENBQUMsa0JBQWtCO2FBQ2pEO1lBQ0QsV0FBVyxFQUFFO2dCQUNYLHFCQUFxQixFQUFFLGdCQUFnQixDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDLE1BQU0sT0FBQyxPQUFPLENBQUMsd0JBQXdCLG1DQUFJLHVCQUF1QixDQUFDO2dCQUN6SCxnQ0FBZ0MsRUFBRSxnQkFBZ0IsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQyxNQUFNLE9BQUMsT0FBTyxDQUFDLDRCQUE0QixtQ0FBSSxrQ0FBa0MsQ0FBQztnQkFDbkosY0FBYyxFQUFFLE1BQU0sT0FBQyxPQUFPLENBQUMsYUFBYSxtQ0FBSSxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLGdCQUFnQixDQUFDLENBQUM7Z0JBQ3ZHLGNBQWMsRUFBRSxhQUFhLENBQUMsQ0FBQyxDQUFDLHFCQUFxQixDQUFDLENBQUMsQ0FBQyxNQUFNLE9BQUMsT0FBTyxDQUFDLGFBQWEsbUNBQUksZ0JBQWdCLENBQUM7Z0JBQ3pHLHdCQUF3QixFQUFFLGdCQUFnQixDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDLE1BQU0sT0FBQyxPQUFPLENBQUMscUJBQXFCLG1DQUFJLDBCQUEwQixDQUFDO2FBQzdIO1lBQ0QsV0FBVyxFQUFFO2dCQUNYLFFBQVEsRUFBRSwrQkFBYSxDQUFDLElBQUk7Z0JBQzVCLFFBQVEsRUFBRSxnQkFBZ0IsQ0FBQyxDQUFDLENBQUMsK0JBQWEsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLFNBQVM7YUFDN0Q7U0FDRixDQUFDLENBQUM7SUFDTCxDQUFDOzs7Ozs7O0lBR00sYUFBYSxDQUFDLFVBQThCLEVBQUU7O1FBQ25ELElBQUksQ0FBQyxhQUFhLENBQUM7WUFDakIsSUFBSSxFQUFFLE1BQU07WUFDWixZQUFZLEVBQUUsTUFBTTtZQUNwQixHQUFHLEVBQUUsSUFBSSxDQUFDLGtCQUFrQixDQUFDLG1CQUFtQixDQUFDO1lBQ2pELGNBQWMsRUFBRSxrQkFBa0I7WUFDbEMsR0FBRyxFQUFFO2dCQUNILG9CQUFvQixFQUFFLE9BQU8sQ0FBQyxnQkFBZ0I7YUFDL0M7WUFDRCxXQUFXLEVBQUU7Z0JBQ1gsY0FBYyxFQUFFLE1BQU0sT0FBQyxPQUFPLENBQUMsbUJBQW1CLG1DQUFJLGdCQUFnQixDQUFDO2dCQUN2RSxjQUFjLEVBQUUsTUFBTSxPQUFDLE9BQU8sQ0FBQyxtQkFBbUIsbUNBQUksZ0JBQWdCLENBQUM7YUFDeEU7U0FDRixDQUFDLENBQUM7SUFDTCxDQUFDOzs7Ozs7O0lBR00sV0FBVyxDQUFDLFVBQTRCLEVBQUU7O1FBQy9DLElBQUksQ0FBQyxhQUFhLENBQUM7WUFDakIsSUFBSSxFQUFFLFFBQVE7WUFDZCxHQUFHLEVBQUUsSUFBSSxDQUFDLGtCQUFrQixDQUFDLHFCQUFxQixDQUFDO1lBQ25ELGNBQWMsRUFBRSxrQkFBa0I7WUFDbEMsWUFBWSxFQUFFLFFBQVE7WUFDdEIsR0FBRyxFQUFFO2dCQUNILFdBQVcsRUFBRSxPQUFPLENBQUMsVUFBVTtnQkFDL0IsVUFBVSxFQUFFLE9BQU8sQ0FBQyxTQUFTO2dCQUM3QixhQUFhLFFBQUUsT0FBTyxDQUFDLFdBQVcsbUNBQUksZ0JBQWdCO2dCQUN0RCxjQUFjLFFBQUUsT0FBTyxDQUFDLFlBQVksbUNBQUksMkJBQTJCO2dCQUNuRSxrQkFBa0IsRUFBRSxPQUFPLENBQUMsZ0JBQWdCO2FBQzdDO1lBQ0QsV0FBVyxFQUFFO2dCQUNYLFlBQVksRUFBRSxNQUFNLE9BQUMsT0FBTyxDQUFDLGlCQUFpQixtQ0FBSSxpQkFBaUIsQ0FBQzthQUNyRTtTQUNGLENBQUMsQ0FBQztJQUNMLENBQUM7SUFFTyxhQUFhLENBQUMsSUFBdUI7O1FBQzNDLE1BQU0sT0FBTyxHQUFHLFdBQVcsSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDO1FBQ3ZDLElBQUksT0FBTyxJQUFJLElBQUksQ0FBQyxJQUFJLEVBQUU7WUFDeEIsTUFBTSxJQUFJLEtBQUssQ0FBQyw0QkFBNEIsT0FBTyxHQUFHLENBQUMsQ0FBQztTQUN6RDtRQUVELE1BQU0sV0FBVyxHQUFHLElBQUksS0FBSyxFQUFVLENBQUM7UUFFeEMsd0ZBQXdGO1FBQ3hGLE1BQU0sTUFBTSxHQUEyQixFQUFFLEdBQUcsSUFBSSxDQUFDLEdBQUcsRUFBRSxDQUFDO1FBQ3ZELE1BQU0sa0JBQWtCLEdBQUcsTUFBTSxDQUFDLE9BQU8sT0FBQyxJQUFJLENBQUMsV0FBVyxtQ0FBSSxFQUFFLENBQUM7YUFDOUQsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsS0FBSyxDQUFDLEVBQUUsRUFBRSxDQUFDLEtBQUssSUFBSSxTQUFTLENBQWdCLENBQUM7UUFDN0QsS0FBSyxNQUFNLENBQUMsSUFBSSxFQUFFLFVBQVUsQ0FBQyxJQUFJLGtCQUFrQixFQUFFO1lBQ25ELFdBQVcsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7WUFDdkIsTUFBTSxDQUFDLElBQUksQ0FBQyxHQUFHLFVBQVUsQ0FBQztTQUMzQjtRQUVELGdFQUFnRTtRQUNoRSxJQUFJLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxXQUFXLElBQUksQ0FBQyxJQUFJLENBQUMsaUJBQWlCLEVBQUUsRUFBRSxFQUFFO1lBQy9ELFdBQVcsRUFBRSwyQkFBMkIsSUFBSSxDQUFDLFlBQVksRUFBRTtZQUMzRCxHQUFHLEVBQUUsSUFBSSxDQUFDLEdBQUc7WUFDYixXQUFXLEVBQUUsV0FBVztZQUN4QixJQUFJLEVBQUUsSUFBSSxDQUFDLEdBQUc7U0FDZixDQUFDLENBQUM7UUFFSCxNQUFNLEdBQUcsR0FBRztZQUNWLElBQUksRUFBRSxjQUFjLElBQUksQ0FBQyxZQUFZLEVBQUU7WUFDdkMsV0FBVyxFQUFFLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDLEVBQUUsUUFBUSxFQUFFLCtCQUFhLENBQUMsSUFBSSxFQUFFO1lBQ25GLEVBQUUsRUFBRSxJQUFJLENBQUMsU0FBUztZQUNsQixLQUFLLEVBQUUsQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDO1lBQ3hCLE1BQU0sRUFBRSxlQUFlO1lBQ3ZCLFNBQVMsRUFBRSxJQUFJLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQztnQkFDL0IsS0FBSyxFQUFFLElBQUksQ0FBQyxjQUFjO2FBQzNCLENBQUMsQ0FBQyxDQUFDLFNBQVM7WUFDYixLQUFLLEVBQUU7Z0JBQ0w7b0JBQ0UsSUFBSSxFQUFFLDBCQUEwQjtvQkFDaEMsSUFBSSxFQUFFLDhCQUE4QjtvQkFDcEMsSUFBSSxFQUFFO3dCQUNKLElBQUksRUFBRSxJQUFJLENBQUMsWUFBWTt3QkFDdkIsSUFBSSxFQUFFLGFBQWE7cUJBQ3BCO2lCQUNGO2dCQUNEO29CQUNFLElBQUksRUFBRSxTQUFTO29CQUNmLDZJQUE2STtvQkFDN0ksR0FBRyxFQUFFLElBQUksQ0FBQyxHQUFHO29CQUNiLEdBQUcsRUFBRSxNQUFNO2lCQUNaO2FBQ0Y7U0FDRixDQUFDO1FBRUYsSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsR0FBRyxHQUFHLENBQUM7SUFDM0IsQ0FBQztJQUVPLGtCQUFrQixDQUFDLE9BQWU7UUFDeEMsT0FBTyx1QkFBdUIsSUFBSSxDQUFDLGtCQUFrQixJQUFJLE9BQU8sRUFBRSxDQUFDO0lBQ3JFLENBQUM7O0FBck5ILDhCQXNOQzs7O0FBRUQsU0FBUyxNQUFNLENBQUMsVUFBa0I7SUFDaEMsT0FBTyxnQkFBZ0IsVUFBVSxLQUFLLENBQUM7QUFDekMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbXBvbmVudCB9IGZyb20gJy4uL2NvbXBvbmVudCc7XG5pbXBvcnQgeyB3b3JrZmxvd3MgfSBmcm9tICcuLi9naXRodWInO1xuaW1wb3J0IHsgSm9iUGVybWlzc2lvbiwgSm9iUGVybWlzc2lvbnMgfSBmcm9tICcuLi9naXRodWIvd29ya2Zsb3dzLW1vZGVsJztcbmltcG9ydCB7IFByb2plY3QgfSBmcm9tICcuLi9wcm9qZWN0JztcblxuY29uc3QgSlNJSV9SRUxFQVNFX1ZFUlNJT04gPSAnbGF0ZXN0JztcbmNvbnN0IEdJVEhVQl9QQUNLQUdFU19SRUdJU1RSWSA9ICducG0ucGtnLmdpdGh1Yi5jb20nO1xuY29uc3QgR0lUSFVCX1BBQ0tBR0VTX01BVkVOX1JFUE9TSVRPUlkgPSAnaHR0cHM6Ly9tYXZlbi5wa2cuZ2l0aHViLmNvbSc7XG5jb25zdCBBUlRJRkFDVFNfRElSID0gJ2Rpc3QnO1xuY29uc3QgSlNJSV9SRUxFQVNFX0lNQUdFID0gJ2pzaWkvc3VwZXJjaGFpbic7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIFB1Ymxpc2hlck9wdGlvbnMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBidWlsZEpvYklkOiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgY29uZGl0aW9uPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBhcnRpZmFjdE5hbWU6IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGpzaWlSZWxlYXNlVmVyc2lvbj86IHN0cmluZztcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBQdWJsaXNoZXIgZXh0ZW5kcyBDb21wb25lbnQge1xuICBwdWJsaWMgcmVhZG9ubHkgYnVpbGRKb2JJZDogc3RyaW5nO1xuICBwdWJsaWMgcmVhZG9ubHkgYXJ0aWZhY3ROYW1lOiBzdHJpbmc7XG4gIHB1YmxpYyByZWFkb25seSBqc2lpUmVsZWFzZVZlcnNpb246IHN0cmluZztcbiAgcHVibGljIHJlYWRvbmx5IGNvbmRpdGlvbj86IHN0cmluZztcblxuICAvLyB0aGUgam9icyB0byBhZGQgdG8gdGhlIHJlbGVhc2Ugd29ya2Zsb3dcbiAgcHJpdmF0ZSByZWFkb25seSBqb2JzOiB7IFtuYW1lOiBzdHJpbmddOiB3b3JrZmxvd3MuSm9iIH0gPSB7fTtcblxuICBjb25zdHJ1Y3Rvcihwcm9qZWN0OiBQcm9qZWN0LCBvcHRpb25zOiBQdWJsaXNoZXJPcHRpb25zKSB7XG4gICAgc3VwZXIocHJvamVjdCk7XG5cbiAgICB0aGlzLmJ1aWxkSm9iSWQgPSBvcHRpb25zLmJ1aWxkSm9iSWQ7XG4gICAgdGhpcy5hcnRpZmFjdE5hbWUgPSBvcHRpb25zLmFydGlmYWN0TmFtZTtcbiAgICB0aGlzLmpzaWlSZWxlYXNlVmVyc2lvbiA9IG9wdGlvbnMuanNpaVJlbGVhc2VWZXJzaW9uID8/IEpTSUlfUkVMRUFTRV9WRVJTSU9OO1xuICAgIHRoaXMuY29uZGl0aW9uID0gb3B0aW9ucy5jb25kaXRpb247XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVuZGVyKCk6IFJlY29yZDxzdHJpbmcsIHdvcmtmbG93cy5Kb2I+IHtcbiAgICByZXR1cm4geyAuLi50aGlzLmpvYnMgfTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBwdWJsaXNoVG9HaXRIdWJSZWxlYXNlcyhvcHRpb25zOiBHaXRIdWJSZWxlYXNlc1B1Ymxpc2hPcHRpb25zKSB7XG4gICAgY29uc3QgdmVyc2lvbkZpbGUgPSBgJHtBUlRJRkFDVFNfRElSfS8ke29wdGlvbnMudmVyc2lvbkZpbGV9YDtcbiAgICBjb25zdCBjaGFuZ2Vsb2dGaWxlID0gYCR7QVJUSUZBQ1RTX0RJUn0vJHtvcHRpb25zLmNoYW5nZWxvZ0ZpbGV9YDtcblxuICAgIC8vIGNyZWF0ZSBhIGdpdGh1YiByZWxlYXNlXG4gICAgY29uc3QgZ2V0VmVyc2lvbiA9IGB2JChjYXQgJHt2ZXJzaW9uRmlsZX0pYDtcblxuICAgIHRoaXMuYWRkUHVibGlzaEpvYih7XG4gICAgICBuYW1lOiAnZ2l0aHViJyxcbiAgICAgIHJlZ2lzdHJ5TmFtZTogJ0dpdEh1YiBSZWxlYXNlcycsXG4gICAgICBwZXJtaXNzaW9uczoge1xuICAgICAgICBjb250ZW50czogSm9iUGVybWlzc2lvbi5XUklURSxcbiAgICAgIH0sXG4gICAgICB3b3JrZmxvd0Vudjoge1xuICAgICAgICBHSVRIVUJfVE9LRU46ICcke3sgc2VjcmV0cy5HSVRIVUJfVE9LRU4gfX0nLFxuICAgICAgfSxcbiAgICAgIHJ1bjogW1xuICAgICAgICBgZ2ggcmVsZWFzZSBjcmVhdGUgJHtnZXRWZXJzaW9ufWAsXG4gICAgICAgIGAtRiAke2NoYW5nZWxvZ0ZpbGV9YCxcbiAgICAgICAgYC10ICR7Z2V0VmVyc2lvbn1gLFxuICAgICAgXS5qb2luKCcgJyksXG4gICAgfSk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcHVibGlzaFRvTnBtKG9wdGlvbnM6IE5wbVB1Ymxpc2hPcHRpb25zID0ge30pIHtcbiAgICBjb25zdCBpc0dpdEh1YlBhY2thZ2VzID0gb3B0aW9ucy5yZWdpc3RyeT8uc3RhcnRzV2l0aChHSVRIVUJfUEFDS0FHRVNfUkVHSVNUUlkpO1xuXG4gICAgdGhpcy5hZGRQdWJsaXNoSm9iKHtcbiAgICAgIG5hbWU6ICducG0nLFxuICAgICAgcnVuOiB0aGlzLmpzaWlSZWxlYXNlQ29tbWFuZCgnanNpaS1yZWxlYXNlLW5wbScpLFxuICAgICAgY29udGFpbmVySW1hZ2U6IEpTSUlfUkVMRUFTRV9JTUFHRSxcbiAgICAgIHJlZ2lzdHJ5TmFtZTogJ25wbScsXG4gICAgICBlbnY6IHtcbiAgICAgICAgTlBNX0RJU1RfVEFHOiBvcHRpb25zLmRpc3RUYWcsXG4gICAgICAgIE5QTV9SRUdJU1RSWTogb3B0aW9ucy5yZWdpc3RyeSxcbiAgICAgIH0sXG4gICAgICBwZXJtaXNzaW9uczoge1xuICAgICAgICBjb250ZW50czogSm9iUGVybWlzc2lvbi5SRUFELFxuICAgICAgICBwYWNrYWdlczogaXNHaXRIdWJQYWNrYWdlcyA/IEpvYlBlcm1pc3Npb24uV1JJVEUgOiB1bmRlZmluZWQsXG4gICAgICB9LFxuICAgICAgd29ya2Zsb3dFbnY6IHtcbiAgICAgICAgLy8gaWYgd2UgYXJlIHB1Ymxpc2hpbmcgdG8gR2l0SHViIFBhY2thZ2VzLCBkZWZhdWx0IHRvIEdJVEhVQl9UT0tFTi5cbiAgICAgICAgTlBNX1RPS0VOOiBzZWNyZXQob3B0aW9ucy5ucG1Ub2tlblNlY3JldCA/PyAoaXNHaXRIdWJQYWNrYWdlcyA/ICdHSVRIVUJfVE9LRU4nIDogJ05QTV9UT0tFTicpKSxcbiAgICAgIH0sXG4gICAgfSk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBwdWJsaXNoVG9OdWdldChvcHRpb25zOiBOdWdldFB1Ymxpc2hPcHRpb25zID0ge30pIHtcbiAgICB0aGlzLmFkZFB1Ymxpc2hKb2Ioe1xuICAgICAgbmFtZTogJ251Z2V0JyxcbiAgICAgIGNvbnRhaW5lckltYWdlOiBKU0lJX1JFTEVBU0VfSU1BR0UsXG4gICAgICBydW46IHRoaXMuanNpaVJlbGVhc2VDb21tYW5kKCdqc2lpLXJlbGVhc2UtbnVnZXQnKSxcbiAgICAgIHJlZ2lzdHJ5TmFtZTogJ051R2V0IEdhbGxlcnknLFxuICAgICAgd29ya2Zsb3dFbnY6IHtcbiAgICAgICAgTlVHRVRfQVBJX0tFWTogc2VjcmV0KG9wdGlvbnMubnVnZXRBcGlLZXlTZWNyZXQgPz8gJ05VR0VUX0FQSV9LRVknKSxcbiAgICAgIH0sXG4gICAgfSk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHB1Ymxpc2hUb01hdmVuKG9wdGlvbnM6IE1hdmVuUHVibGlzaE9wdGlvbnMgPSB7fSkge1xuICAgIGNvbnN0IGlzR2l0SHViUGFja2FnZXMgPSBvcHRpb25zLm1hdmVuUmVwb3NpdG9yeVVybD8uc3RhcnRzV2l0aChHSVRIVUJfUEFDS0FHRVNfTUFWRU5fUkVQT1NJVE9SWSk7XG4gICAgY29uc3QgaXNHaXRIdWJBY3RvciA9IGlzR2l0SHViUGFja2FnZXMgJiYgb3B0aW9ucy5tYXZlblVzZXJuYW1lID09IHVuZGVmaW5lZDtcbiAgICBjb25zdCBtYXZlblNlcnZlcklkID0gb3B0aW9ucy5tYXZlblNlcnZlcklkID8/IChpc0dpdEh1YlBhY2thZ2VzID8gJ2dpdGh1YicgOiB1bmRlZmluZWQpO1xuXG4gICAgaWYgKGlzR2l0SHViUGFja2FnZXMgJiYgbWF2ZW5TZXJ2ZXJJZCAhPSAnZ2l0aHViJykge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdwdWJsaXNoaW5nIHRvIEdpdEh1YiBQYWNrYWdlcyByZXF1aXJlcyB0aGUgXCJtYXZlblNlcnZlcklkXCIgdG8gYmUgXCJnaXRodWJcIicpO1xuICAgIH1cblxuICAgIHRoaXMuYWRkUHVibGlzaEpvYih7XG4gICAgICBuYW1lOiAnbWF2ZW4nLFxuICAgICAgcmVnaXN0cnlOYW1lOiAnTWF2ZW4gQ2VudHJhbCcsXG4gICAgICBjb250YWluZXJJbWFnZTogSlNJSV9SRUxFQVNFX0lNQUdFLFxuICAgICAgcnVuOiB0aGlzLmpzaWlSZWxlYXNlQ29tbWFuZCgnanNpaS1yZWxlYXNlLW1hdmVuJyksXG4gICAgICBlbnY6IHtcbiAgICAgICAgTUFWRU5fRU5EUE9JTlQ6IG9wdGlvbnMubWF2ZW5FbmRwb2ludCxcbiAgICAgICAgTUFWRU5fU0VSVkVSX0lEOiBtYXZlblNlcnZlcklkLFxuICAgICAgICBNQVZFTl9SRVBPU0lUT1JZX1VSTDogb3B0aW9ucy5tYXZlblJlcG9zaXRvcnlVcmwsXG4gICAgICB9LFxuICAgICAgd29ya2Zsb3dFbnY6IHtcbiAgICAgICAgTUFWRU5fR1BHX1BSSVZBVEVfS0VZOiBpc0dpdEh1YlBhY2thZ2VzID8gdW5kZWZpbmVkIDogc2VjcmV0KG9wdGlvbnMubWF2ZW5HcGdQcml2YXRlS2V5U2VjcmV0ID8/ICdNQVZFTl9HUEdfUFJJVkFURV9LRVknKSxcbiAgICAgICAgTUFWRU5fR1BHX1BSSVZBVEVfS0VZX1BBU1NQSFJBU0U6IGlzR2l0SHViUGFja2FnZXMgPyB1bmRlZmluZWQgOiBzZWNyZXQob3B0aW9ucy5tYXZlbkdwZ1ByaXZhdGVLZXlQYXNzcGhyYXNlID8/ICdNQVZFTl9HUEdfUFJJVkFURV9LRVlfUEFTU1BIUkFTRScpLFxuICAgICAgICBNQVZFTl9QQVNTV09SRDogc2VjcmV0KG9wdGlvbnMubWF2ZW5QYXNzd29yZCA/PyAoaXNHaXRIdWJQYWNrYWdlcyA/ICdHSVRIVUJfVE9LRU4nIDogJ01BVkVOX1BBU1NXT1JEJykpLFxuICAgICAgICBNQVZFTl9VU0VSTkFNRTogaXNHaXRIdWJBY3RvciA/ICcke3sgZ2l0aHViLmFjdG9yIH19JyA6IHNlY3JldChvcHRpb25zLm1hdmVuVXNlcm5hbWUgPz8gJ01BVkVOX1VTRVJOQU1FJyksXG4gICAgICAgIE1BVkVOX1NUQUdJTkdfUFJPRklMRV9JRDogaXNHaXRIdWJQYWNrYWdlcyA/IHVuZGVmaW5lZCA6IHNlY3JldChvcHRpb25zLm1hdmVuU3RhZ2luZ1Byb2ZpbGVJZCA/PyAnTUFWRU5fU1RBR0lOR19QUk9GSUxFX0lEJyksXG4gICAgICB9LFxuICAgICAgcGVybWlzc2lvbnM6IHtcbiAgICAgICAgY29udGVudHM6IEpvYlBlcm1pc3Npb24uUkVBRCxcbiAgICAgICAgcGFja2FnZXM6IGlzR2l0SHViUGFja2FnZXMgPyBKb2JQZXJtaXNzaW9uLldSSVRFIDogdW5kZWZpbmVkLFxuICAgICAgfSxcbiAgICB9KTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHB1Ymxpc2hUb1B5UGkob3B0aW9uczogUHlQaVB1Ymxpc2hPcHRpb25zID0ge30pIHtcbiAgICB0aGlzLmFkZFB1Ymxpc2hKb2Ioe1xuICAgICAgbmFtZTogJ3B5cGknLFxuICAgICAgcmVnaXN0cnlOYW1lOiAnUHlQSScsXG4gICAgICBydW46IHRoaXMuanNpaVJlbGVhc2VDb21tYW5kKCdqc2lpLXJlbGVhc2UtcHlwaScpLFxuICAgICAgY29udGFpbmVySW1hZ2U6IEpTSUlfUkVMRUFTRV9JTUFHRSxcbiAgICAgIGVudjoge1xuICAgICAgICBUV0lORV9SRVBPU0lUT1JZX1VSTDogb3B0aW9ucy50d2luZVJlZ2lzdHJ5VXJsLFxuICAgICAgfSxcbiAgICAgIHdvcmtmbG93RW52OiB7XG4gICAgICAgIFRXSU5FX1VTRVJOQU1FOiBzZWNyZXQob3B0aW9ucy50d2luZVVzZXJuYW1lU2VjcmV0ID8/ICdUV0lORV9VU0VSTkFNRScpLFxuICAgICAgICBUV0lORV9QQVNTV09SRDogc2VjcmV0KG9wdGlvbnMudHdpbmVQYXNzd29yZFNlY3JldCA/PyAnVFdJTkVfUEFTU1dPUkQnKSxcbiAgICAgIH0sXG4gICAgfSk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcHVibGlzaFRvR28ob3B0aW9uczogR29QdWJsaXNoT3B0aW9ucyA9IHt9KSB7XG4gICAgdGhpcy5hZGRQdWJsaXNoSm9iKHtcbiAgICAgIG5hbWU6ICdnb2xhbmcnLFxuICAgICAgcnVuOiB0aGlzLmpzaWlSZWxlYXNlQ29tbWFuZCgnanNpaS1yZWxlYXNlLWdvbGFuZycpLFxuICAgICAgY29udGFpbmVySW1hZ2U6IEpTSUlfUkVMRUFTRV9JTUFHRSxcbiAgICAgIHJlZ2lzdHJ5TmFtZTogJ0dpdEh1YicsXG4gICAgICBlbnY6IHtcbiAgICAgICAgR0lUSFVCX1JFUE86IG9wdGlvbnMuZ2l0aHViUmVwbyxcbiAgICAgICAgR0lUX0JSQU5DSDogb3B0aW9ucy5naXRCcmFuY2gsXG4gICAgICAgIEdJVF9VU0VSX05BTUU6IG9wdGlvbnMuZ2l0VXNlck5hbWUgPz8gJ0dpdEh1YiBBY3Rpb25zJyxcbiAgICAgICAgR0lUX1VTRVJfRU1BSUw6IG9wdGlvbnMuZ2l0VXNlckVtYWlsID8/ICdnaXRodWItYWN0aW9uc0BnaXRodWIuY29tJyxcbiAgICAgICAgR0lUX0NPTU1JVF9NRVNTQUdFOiBvcHRpb25zLmdpdENvbW1pdE1lc3NhZ2UsXG4gICAgICB9LFxuICAgICAgd29ya2Zsb3dFbnY6IHtcbiAgICAgICAgR0lUSFVCX1RPS0VOOiBzZWNyZXQob3B0aW9ucy5naXRodWJUb2tlblNlY3JldCA/PyAnR09fR0lUSFVCX1RPS0VOJyksXG4gICAgICB9LFxuICAgIH0pO1xuICB9XG5cbiAgcHJpdmF0ZSBhZGRQdWJsaXNoSm9iKG9wdHM6IFB1Ymxpc2hKb2JPcHRpb25zKSB7XG4gICAgY29uc3Qgam9ibmFtZSA9IGByZWxlYXNlXyR7b3B0cy5uYW1lfWA7XG4gICAgaWYgKGpvYm5hbWUgaW4gdGhpcy5qb2JzKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoYER1cGxpY2F0ZSBqb2Igd2l0aCBuYW1lIFwiJHtqb2JuYW1lfVwiYCk7XG4gICAgfVxuXG4gICAgY29uc3QgcmVxdWlyZWRFbnYgPSBuZXcgQXJyYXk8c3RyaW5nPigpO1xuXG4gICAgLy8gam9iRW52IGlzIHRoZSBlbnYgd2UgcGFzcyB0byB0aGUgZ2l0aHViIGpvYiAodGFzayBlbnZpcm9ubWVudCArIHNlY3JldHMvZXhwcmVzc2lvbnMpLlxuICAgIGNvbnN0IGpvYkVudjogUmVjb3JkPHN0cmluZywgc3RyaW5nPiA9IHsgLi4ub3B0cy5lbnYgfTtcbiAgICBjb25zdCB3b3JrZmxvd0VudkVudHJpZXMgPSBPYmplY3QuZW50cmllcyhvcHRzLndvcmtmbG93RW52ID8/IHt9KVxuICAgICAgLmZpbHRlcigoW18sIHZhbHVlXSkgPT4gdmFsdWUgIT0gdW5kZWZpbmVkKSBhcyBzdHJpbmcgW11bXTtcbiAgICBmb3IgKGNvbnN0IFtuYW1lLCBleHByZXNzaW9uXSBvZiB3b3JrZmxvd0VudkVudHJpZXMpIHtcbiAgICAgIHJlcXVpcmVkRW52LnB1c2gobmFtZSk7XG4gICAgICBqb2JFbnZbbmFtZV0gPSBleHByZXNzaW9uO1xuICAgIH1cblxuICAgIC8vIGRlZmluZSBhIHRhc2sgd2hpY2ggY2FuIGJlIHVzZWQgdGhyb3VnaCBgcHJvamVuIHB1Ymxpc2g6eHh4YC5cbiAgICB0aGlzLnByb2plY3QuYWRkVGFzayhgcHVibGlzaDoke29wdHMubmFtZS50b0xvY2FsZUxvd2VyQ2FzZSgpfWAsIHtcbiAgICAgIGRlc2NyaXB0aW9uOiBgUHVibGlzaCB0aGlzIHBhY2thZ2UgdG8gJHtvcHRzLnJlZ2lzdHJ5TmFtZX1gLFxuICAgICAgZW52OiBvcHRzLmVudixcbiAgICAgIHJlcXVpcmVkRW52OiByZXF1aXJlZEVudixcbiAgICAgIGV4ZWM6IG9wdHMucnVuLFxuICAgIH0pO1xuXG4gICAgY29uc3Qgam9iID0ge1xuICAgICAgbmFtZTogYFB1Ymxpc2ggdG8gJHtvcHRzLnJlZ2lzdHJ5TmFtZX1gLFxuICAgICAgcGVybWlzc2lvbnM6IG9wdHMucGVybWlzc2lvbnMgPyBvcHRzLnBlcm1pc3Npb25zIDogeyBjb250ZW50czogSm9iUGVybWlzc2lvbi5SRUFEIH0sXG4gICAgICBpZjogdGhpcy5jb25kaXRpb24sXG4gICAgICBuZWVkczogW3RoaXMuYnVpbGRKb2JJZF0sXG4gICAgICBydW5zT246ICd1YnVudHUtbGF0ZXN0JyxcbiAgICAgIGNvbnRhaW5lcjogb3B0cy5jb250YWluZXJJbWFnZSA/IHtcbiAgICAgICAgaW1hZ2U6IG9wdHMuY29udGFpbmVySW1hZ2UsXG4gICAgICB9IDogdW5kZWZpbmVkLFxuICAgICAgc3RlcHM6IFtcbiAgICAgICAge1xuICAgICAgICAgIG5hbWU6ICdEb3dubG9hZCBidWlsZCBhcnRpZmFjdHMnLFxuICAgICAgICAgIHVzZXM6ICdhY3Rpb25zL2Rvd25sb2FkLWFydGlmYWN0QHYyJyxcbiAgICAgICAgICB3aXRoOiB7XG4gICAgICAgICAgICBuYW1lOiB0aGlzLmFydGlmYWN0TmFtZSxcbiAgICAgICAgICAgIHBhdGg6IEFSVElGQUNUU19ESVIsIC8vIHRoaXMgbXVzdCBiZSBcImRpc3RcIiBmb3IganNpaS1yZWxlYXNlXG4gICAgICAgICAgfSxcbiAgICAgICAgfSxcbiAgICAgICAge1xuICAgICAgICAgIG5hbWU6ICdSZWxlYXNlJyxcbiAgICAgICAgICAvLyBpdCB3b3VsZCBoYXZlIGJlZW4gbmljZSBpZiB3ZSBjb3VsZCBqdXN0IHJ1biBcInByb2plbiBwdWJsaXNoOnh4eFwiIGhlcmUgYnV0IHRoYXQgaXMgbm90IHBvc3NpYmxlIGJlY2F1c2UgdGhpcyBqb2IgZG9lcyBub3QgY2hlY2tvdXQgc291cmNlc1xuICAgICAgICAgIHJ1bjogb3B0cy5ydW4sXG4gICAgICAgICAgZW52OiBqb2JFbnYsXG4gICAgICAgIH0sXG4gICAgICBdLFxuICAgIH07XG5cbiAgICB0aGlzLmpvYnNbam9ibmFtZV0gPSBqb2I7XG4gIH1cblxuICBwcml2YXRlIGpzaWlSZWxlYXNlQ29tbWFuZChjb21tYW5kOiBzdHJpbmcpIHtcbiAgICByZXR1cm4gYG5weCAtcCBqc2lpLXJlbGVhc2VAJHt0aGlzLmpzaWlSZWxlYXNlVmVyc2lvbn0gJHtjb21tYW5kfWA7XG4gIH1cbn1cblxuZnVuY3Rpb24gc2VjcmV0KHNlY3JldE5hbWU6IHN0cmluZykge1xuICByZXR1cm4gYFxcJHt7IHNlY3JldHMuJHtzZWNyZXROYW1lfSB9fWA7XG59XG5cbmludGVyZmFjZSBQdWJsaXNoSm9iT3B0aW9ucyB7XG4gIC8qKlxuICAgKiBUaGUgY29tbWFuZCB0byBleGVjdXRlLlxuICAgKi9cbiAgcmVhZG9ubHkgcnVuOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEVudmlyb25tZW50IHZhcmlhYmxlcyB0byBzZXRcbiAgICovXG4gIHJlYWRvbmx5IGVudj86IFJlY29yZDxzdHJpbmcsIGFueT47XG5cbiAgLyoqXG4gICAqIFRoZSBkaXNwbGF5IG5hbWUgb2YgdGhlIHJlZ2lzdHJ5IChmb3IgZGVzY3JpcHRpb24pXG4gICAqL1xuICByZWFkb25seSByZWdpc3RyeU5hbWU6IHN0cmluZztcblxuICAvKipcbiAgICogSm9iIHBlcm1pc3Npb25zXG4gICAqL1xuICByZWFkb25seSBwZXJtaXNzaW9ucz86IEpvYlBlcm1pc3Npb25zO1xuXG4gIC8qKlxuICAgKiBDdXN0b20gY29udGFpbmVyIGltYWdlIHRvIHVzZS5cbiAgICogQGRlZmF1bHQgLSBubyBjdXN0b20gaW1hZ2VcbiAgICovXG4gIHJlYWRvbmx5IGNvbnRhaW5lckltYWdlPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgbmFtZSBvZiB0aGUgcHVibGlzaCBqb2IgKHNob3VsZCBiZSBsb3dlcmNhc2UpLlxuICAgKi9cbiAgcmVhZG9ubHkgbmFtZTogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBFbnZpcm9ubWVudCB0byBpbmNsdWRlIG9ubHkgaW4gdGhlIHdvcmtmbG93IChhbmQgbm90IHRhc2tzKS5cbiAgICovXG4gIHJlYWRvbmx5IHdvcmtmbG93RW52PzogeyBbbmFtZTogc3RyaW5nXTogc3RyaW5nIHwgdW5kZWZpbmVkIH07XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgSnNpaVJlbGVhc2VOcG0gZXh0ZW5kcyBOcG1QdWJsaXNoT3B0aW9ucyB7IH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBOcG1QdWJsaXNoT3B0aW9ucyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBkaXN0VGFnPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSByZWdpc3RyeT86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBucG1Ub2tlblNlY3JldD86IHN0cmluZztcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgSnNpaVJlbGVhc2VQeVBpIGV4dGVuZHMgUHlQaVB1Ymxpc2hPcHRpb25zIHsgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBQeVBpUHVibGlzaE9wdGlvbnMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSB0d2luZVJlZ2lzdHJ5VXJsPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdHdpbmVVc2VybmFtZVNlY3JldD86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdHdpbmVQYXNzd29yZFNlY3JldD86IHN0cmluZztcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIEpzaWlSZWxlYXNlTnVnZXQgZXh0ZW5kcyBOdWdldFB1Ymxpc2hPcHRpb25zIHsgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIE51Z2V0UHVibGlzaE9wdGlvbnMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBudWdldEFwaUtleVNlY3JldD86IHN0cmluZztcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIEpzaWlSZWxlYXNlTWF2ZW4gZXh0ZW5kcyBNYXZlblB1Ymxpc2hPcHRpb25zIHsgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIE1hdmVuUHVibGlzaE9wdGlvbnMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBtYXZlbkVuZHBvaW50Pzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBtYXZlblNlcnZlcklkPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IG1hdmVuUmVwb3NpdG9yeVVybD86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbWF2ZW5HcGdQcml2YXRlS2V5U2VjcmV0Pzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBtYXZlbkdwZ1ByaXZhdGVLZXlQYXNzcGhyYXNlPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBtYXZlblVzZXJuYW1lPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbWF2ZW5QYXNzd29yZD86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBtYXZlblN0YWdpbmdQcm9maWxlSWQ/OiBzdHJpbmc7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBHb1B1Ymxpc2hPcHRpb25zIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBnaXRodWJUb2tlblNlY3JldD86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGdpdGh1YlJlcG8/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZ2l0QnJhbmNoPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZ2l0VXNlck5hbWU/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBnaXRVc2VyRW1haWw/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZ2l0Q29tbWl0TWVzc2FnZT86IHN0cmluZztcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgR2l0SHViUmVsZWFzZXNQdWJsaXNoT3B0aW9ucyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSB2ZXJzaW9uRmlsZTogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGNoYW5nZWxvZ0ZpbGU6IHN0cmluZztcbn0iXX0=