"use strict";
// a builtin task that sets the "version" field of the file
// specified in OUTFILE to "0.0.0"
Object.defineProperty(exports, "__esModule", { value: true });
const fs_1 = require("fs");
const fs_extra_1 = require("fs-extra");
const outfile = process.env.OUTFILE;
if (!outfile) {
    throw new Error('OUTFILE is required');
}
if (!fs_extra_1.pathExistsSync(outfile)) {
    process.exit(0); // nothing to do
}
const content = JSON.parse(fs_1.readFileSync(outfile, 'utf8'));
content.version = '0.0.0';
fs_1.writeFileSync(outfile, JSON.stringify(content, undefined, 2));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVzZXQtdmVyc2lvbi50YXNrLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL3JlbGVhc2UvcmVzZXQtdmVyc2lvbi50YXNrLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQSwyREFBMkQ7QUFDM0Qsa0NBQWtDOztBQUVsQywyQkFBaUQ7QUFDakQsdUNBQTBDO0FBRTFDLE1BQU0sT0FBTyxHQUFHLE9BQU8sQ0FBQyxHQUFHLENBQUMsT0FBTyxDQUFDO0FBQ3BDLElBQUksQ0FBQyxPQUFPLEVBQUU7SUFDWixNQUFNLElBQUksS0FBSyxDQUFDLHFCQUFxQixDQUFDLENBQUM7Q0FDeEM7QUFFRCxJQUFJLENBQUMseUJBQWMsQ0FBQyxPQUFPLENBQUMsRUFBRTtJQUM1QixPQUFPLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsZ0JBQWdCO0NBQ2xDO0FBRUQsTUFBTSxPQUFPLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxpQkFBWSxDQUFDLE9BQU8sRUFBRSxNQUFNLENBQUMsQ0FBQyxDQUFDO0FBQzFELE9BQU8sQ0FBQyxPQUFPLEdBQUcsT0FBTyxDQUFDO0FBQzFCLGtCQUFhLENBQUMsT0FBTyxFQUFFLElBQUksQ0FBQyxTQUFTLENBQUMsT0FBTyxFQUFFLFNBQVMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gYSBidWlsdGluIHRhc2sgdGhhdCBzZXRzIHRoZSBcInZlcnNpb25cIiBmaWVsZCBvZiB0aGUgZmlsZVxuLy8gc3BlY2lmaWVkIGluIE9VVEZJTEUgdG8gXCIwLjAuMFwiXG5cbmltcG9ydCB7IHJlYWRGaWxlU3luYywgd3JpdGVGaWxlU3luYyB9IGZyb20gJ2ZzJztcbmltcG9ydCB7IHBhdGhFeGlzdHNTeW5jIH0gZnJvbSAnZnMtZXh0cmEnO1xuXG5jb25zdCBvdXRmaWxlID0gcHJvY2Vzcy5lbnYuT1VURklMRTtcbmlmICghb3V0ZmlsZSkge1xuICB0aHJvdyBuZXcgRXJyb3IoJ09VVEZJTEUgaXMgcmVxdWlyZWQnKTtcbn1cblxuaWYgKCFwYXRoRXhpc3RzU3luYyhvdXRmaWxlKSkge1xuICBwcm9jZXNzLmV4aXQoMCk7IC8vIG5vdGhpbmcgdG8gZG9cbn1cblxuY29uc3QgY29udGVudCA9IEpTT04ucGFyc2UocmVhZEZpbGVTeW5jKG91dGZpbGUsICd1dGY4JykpO1xuY29udGVudC52ZXJzaW9uID0gJzAuMC4wJztcbndyaXRlRmlsZVN5bmMob3V0ZmlsZSwgSlNPTi5zdHJpbmdpZnkoY29udGVudCwgdW5kZWZpbmVkLCAyKSk7XG4iXX0=