"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Tasks = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const common_1 = require("../common");
const component_1 = require("../component");
const json_1 = require("../json");
const task_1 = require("./task");
/**
 * (experimental) Defines project tasks.
 *
 * Tasks extend the projen CLI by adding subcommands to it. Task definitions are
 * synthesized into `.projen/tasks.json`.
 *
 * @experimental
 */
class Tasks extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project) {
        super(project);
        const manifestFile = Tasks.MANIFEST_FILE;
        this._tasks = {};
        this._env = {};
        new json_1.JsonFile(project, manifestFile, {
            omitEmpty: true,
            obj: {
                tasks: (() => this.renderTasks()),
                env: (() => this._env),
            },
        });
    }
    /**
     * (experimental) All tasks.
     *
     * @experimental
     */
    get all() {
        return Object.values(this._tasks);
    }
    /**
     * (experimental) Adds a task to a project.
     *
     * @param name The name of the task.
     * @param options Task options.
     * @experimental
     */
    addTask(name, options = {}) {
        const task = new task_1.Task(name, options);
        if (this._tasks[name]) {
            throw new Error(`A task with the name ${name} already exists. To override it, call removeTask first and then create the new task.`);
        }
        this._tasks[name] = task;
        return task;
    }
    /**
     * (experimental) Removes a task from a project.
     *
     * @param name The name of the task to remove.
     * @returns The `Task` that was removed, otherwise `undefined`.
     * @experimental
     */
    removeTask(name) {
        const dependentTasks = this.all.filter(task => task.steps.find(step => step.spawn == name));
        if (dependentTasks.length > 0) {
            const errList = dependentTasks.map(depTask => depTask.name).join(', ');
            throw new Error(`Unable to remove task "${name}" because the following tasks depend on it: ${errList}`);
        }
        const task = this._tasks[name];
        if (task) {
            delete this._tasks[name];
            return task;
        }
        else {
            return undefined;
        }
    }
    /**
     * (experimental) Adds global environment.
     *
     * @param name Environment variable name.
     * @param value Value.
     * @experimental
     */
    addEnvironment(name, value) {
        this._env[name] = value;
    }
    /**
     * (experimental) Returns a copy of the currently global environment for this project.
     *
     * @experimental
     */
    get env() {
        return {
            ...this._env,
        };
    }
    /**
     * (experimental) Finds a task by name.
     *
     * Returns `undefined` if the task cannot be found.
     *
     * @param name The name of the task.
     * @experimental
     */
    tryFind(name) {
        return this._tasks[name];
    }
    renderTasks() {
        const tasks = {};
        for (const task of Object.values(this._tasks)) {
            tasks[task.name] = task._renderSpec();
        }
        return tasks;
    }
}
exports.Tasks = Tasks;
_a = JSII_RTTI_SYMBOL_1;
Tasks[_a] = { fqn: "projen.tasks.Tasks", version: "0.27.22" };
/**
 * (experimental) The project-relative path of the tasks manifest file.
 *
 * @experimental
 */
Tasks.MANIFEST_FILE = path.posix.join(common_1.PROJEN_DIR, 'tasks.json');
//# sourceMappingURL=data:application/json;base64,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