"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypedocDocgen = void 0;
/**
  Adds a simple Typescript documentation generator
 */
class TypedocDocgen {
    constructor(project) {
        project.addDevDeps('typedoc@^0.21.4');
        const docgen = project.addTask('docgen', {
            description: `Generate TypeScript API reference ${project.docsDirectory}`,
            exec: `typedoc ${project.srcdir} --disableSources --out ${project.docsDirectory}`,
        });
        project.buildTask.spawn(docgen);
    }
}
exports.TypedocDocgen = TypedocDocgen;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidHlwZXNjcmlwdC10eXBlZG9jLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL3R5cGVzY3JpcHQtdHlwZWRvYy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFFQTs7R0FFRztBQUNILE1BQWEsYUFBYTtJQUN4QixZQUFZLE9BQTBCO1FBQ3BDLE9BQU8sQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUMsQ0FBQztRQUV0QyxNQUFNLE1BQU0sR0FBRyxPQUFPLENBQUMsT0FBTyxDQUFDLFFBQVEsRUFBRTtZQUN2QyxXQUFXLEVBQUUscUNBQXFDLE9BQU8sQ0FBQyxhQUFhLEVBQUU7WUFDekUsSUFBSSxFQUFFLFdBQVcsT0FBTyxDQUFDLE1BQU0sMkJBQTJCLE9BQU8sQ0FBQyxhQUFhLEVBQUU7U0FDbEYsQ0FBQyxDQUFDO1FBRUgsT0FBTyxDQUFDLFNBQVMsQ0FBQyxLQUFLLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDbEMsQ0FBQztDQUNGO0FBWEQsc0NBV0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBUeXBlU2NyaXB0UHJvamVjdCB9IGZyb20gJy4vdHlwZXNjcmlwdCc7XG5cbi8qKlxuICBBZGRzIGEgc2ltcGxlIFR5cGVzY3JpcHQgZG9jdW1lbnRhdGlvbiBnZW5lcmF0b3JcbiAqL1xuZXhwb3J0IGNsYXNzIFR5cGVkb2NEb2NnZW4ge1xuICBjb25zdHJ1Y3Rvcihwcm9qZWN0OiBUeXBlU2NyaXB0UHJvamVjdCkge1xuICAgIHByb2plY3QuYWRkRGV2RGVwcygndHlwZWRvY0BeMC4yMS40Jyk7XG5cbiAgICBjb25zdCBkb2NnZW4gPSBwcm9qZWN0LmFkZFRhc2soJ2RvY2dlbicsIHtcbiAgICAgIGRlc2NyaXB0aW9uOiBgR2VuZXJhdGUgVHlwZVNjcmlwdCBBUEkgcmVmZXJlbmNlICR7cHJvamVjdC5kb2NzRGlyZWN0b3J5fWAsXG4gICAgICBleGVjOiBgdHlwZWRvYyAke3Byb2plY3Quc3JjZGlyfSAtLWRpc2FibGVTb3VyY2VzIC0tb3V0ICR7cHJvamVjdC5kb2NzRGlyZWN0b3J5fWAsXG4gICAgfSk7XG5cbiAgICBwcm9qZWN0LmJ1aWxkVGFzay5zcGF3bihkb2NnZW4pO1xuICB9XG59XG4iXX0=