"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeTsconfigOptions = exports.TypeScriptLibraryProject = exports.TypeScriptAppProject = exports.TypeScriptProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const common_1 = require("./common");
const component_1 = require("./component");
const eslint_1 = require("./eslint");
const node_project_1 = require("./node-project");
const sample_file_1 = require("./sample-file");
const textfile_1 = require("./textfile");
const typescript_config_1 = require("./typescript-config");
const typescript_typedoc_1 = require("./typescript-typedoc");
const projenrc_1 = require("./typescript/projenrc");
/**
 * (experimental) TypeScript project.
 *
 * @experimental
 * @pjid typescript
 */
class TypeScriptProject extends node_project_1.NodeProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0, _1, _2, _3;
        super({
            ...options,
            // disable .projenrc.js if typescript is enabled
            projenrcJs: options.projenrcTs ? false : options.projenrcJs,
            jestOptions: {
                ...options.jestOptions,
                jestConfig: {
                    ...(_d = options.jestOptions) === null || _d === void 0 ? void 0 : _d.jestConfig,
                    testMatch: [],
                },
            },
        });
        this.srcdir = (_e = options.srcdir) !== null && _e !== void 0 ? _e : 'src';
        this.libdir = (_f = options.libdir) !== null && _f !== void 0 ? _f : 'lib';
        this.docgen = options.docgen;
        this.docsDirectory = (_g = options.docsDirectory) !== null && _g !== void 0 ? _g : 'docs/';
        this.compileTask.exec('tsc --build');
        this.watchTask = this.addTask('watch', {
            description: 'Watch & compile in the background',
            exec: 'tsc --build -w',
        });
        this.testdir = (_h = options.testdir) !== null && _h !== void 0 ? _h : 'test';
        this.gitignore.include(`/${this.testdir}`);
        (_j = this.npmignore) === null || _j === void 0 ? void 0 : _j.exclude(`/${this.testdir}`);
        // if the test directory is under `src/`, then we will run our tests against
        // the javascript files and not let jest compile it for us.
        const compiledTests = this.testdir.startsWith(this.srcdir + path.posix.sep);
        // by default, we first run tests (jest compiles the typescript in the background) and only then we compile.
        const compileBeforeTest = (_k = options.compileBeforeTest) !== null && _k !== void 0 ? _k : compiledTests;
        if (compileBeforeTest) {
            this.buildTask.spawn(this.compileTask);
            this.buildTask.spawn(this.testTask);
        }
        else {
            this.buildTask.spawn(this.testTask);
            this.buildTask.spawn(this.compileTask);
        }
        if ((_l = options.package) !== null && _l !== void 0 ? _l : true) {
            this.packageTask = this.addTask('package', {
                description: 'Create an npm tarball',
            });
            this.packageTask.exec('mkdir -p dist/js');
            this.packageTask.exec(`${this.package.packageManager} pack`);
            this.packageTask.exec('mv *.tgz dist/js/');
            this.buildTask.spawn(this.packageTask);
        }
        if (options.entrypointTypes || this.entrypoint !== '') {
            const entrypointTypes = (_m = options.entrypointTypes) !== null && _m !== void 0 ? _m : `${path.join(path.dirname(this.entrypoint), path.basename(this.entrypoint, '.js')).replace(/\\/g, '/')}.d.ts`;
            this.package.addField('types', entrypointTypes);
        }
        const compilerOptionDefaults = {
            alwaysStrict: true,
            declaration: true,
            experimentalDecorators: true,
            inlineSourceMap: true,
            inlineSources: true,
            lib: ['es2018'],
            module: 'CommonJS',
            noEmitOnError: false,
            noFallthroughCasesInSwitch: true,
            noImplicitAny: true,
            noImplicitReturns: true,
            noImplicitThis: true,
            noUnusedLocals: true,
            noUnusedParameters: true,
            resolveJsonModule: true,
            strict: true,
            strictNullChecks: true,
            strictPropertyInitialization: true,
            stripInternal: true,
            target: 'ES2018',
        };
        if (!options.disableTsconfig) {
            const baseTsconfig = {
                include: [`${this.srcdir}/**/*.ts`],
                compilerOptions: {
                    rootDir: this.srcdir,
                    outDir: this.libdir,
                    ...compilerOptionDefaults,
                },
            };
            this.tsconfig = new typescript_config_1.TypescriptConfig(this, mergeTsconfigOptions([baseTsconfig, options.tsconfig]));
        }
        if (this.srcdir !== this.libdir) {
            // separated, can ignore the entire libdir
            this.gitignore.exclude(`/${this.libdir}`);
        }
        else {
            // collocated, can only ignore the compiled output
            this.gitignore.exclude(`/${this.libdir}/**/*.js`);
            this.gitignore.exclude(`/${this.libdir}/**/*.d.ts`);
        }
        (_o = this.npmignore) === null || _o === void 0 ? void 0 : _o.include(`/${this.libdir}`);
        this.gitignore.include(`/${this.srcdir}`);
        (_p = this.npmignore) === null || _p === void 0 ? void 0 : _p.exclude(`/${this.srcdir}`);
        (_q = this.npmignore) === null || _q === void 0 ? void 0 : _q.include(`/${this.libdir}/**/*.js`);
        (_r = this.npmignore) === null || _r === void 0 ? void 0 : _r.include(`/${this.libdir}/**/*.d.ts`);
        this.gitignore.exclude('/dist');
        (_s = this.npmignore) === null || _s === void 0 ? void 0 : _s.exclude('dist'); // jsii-pacmak expects this to be "dist" and not "/dist". otherwise it will tamper with it
        (_t = this.npmignore) === null || _t === void 0 ? void 0 : _t.exclude('/tsconfig.json');
        (_u = this.npmignore) === null || _u === void 0 ? void 0 : _u.exclude('/.github');
        (_v = this.npmignore) === null || _v === void 0 ? void 0 : _v.exclude('/.vscode');
        (_w = this.npmignore) === null || _w === void 0 ? void 0 : _w.exclude('/.idea');
        (_x = this.npmignore) === null || _x === void 0 ? void 0 : _x.exclude('/.projenrc.js');
        (_y = this.npmignore) === null || _y === void 0 ? void 0 : _y.exclude('tsconfig.tsbuildinfo');
        // tests are compiled to `lib/TESTDIR`, so we don't need jest to compile them for us.
        // just run them directly from javascript.
        if (this.jest && compiledTests) {
            this.addDevDeps('@types/jest');
            const testout = path.posix.relative(this.srcdir, this.testdir);
            const libtest = path.posix.join(this.libdir, testout);
            const srctest = this.testdir;
            (_z = this.npmignore) === null || _z === void 0 ? void 0 : _z.addPatterns(`/${libtest}`);
            this.jest.addTestMatch(`**/${libtest}/**/?(*.)+(spec|test).js?(x)`);
            this.jest.addWatchIgnorePattern(`/${this.srcdir}/`);
            const resolveSnapshotPath = (test, ext) => {
                const fullpath = test.replace(libtest, srctest);
                return path.join(path.dirname(fullpath), '__snapshots__', path.basename(fullpath, '.js') + '.ts' + ext);
            };
            const resolveTestPath = (snap, ext) => {
                const filename = path.basename(snap, '.ts' + ext) + '.js';
                const dir = path.dirname(path.dirname(snap)).replace(srctest, libtest);
                return path.join(dir, filename);
            };
            const resolver = new textfile_1.TextFile(this, path.posix.join(common_1.PROJEN_DIR, 'jest-snapshot-resolver.js'));
            resolver.addLine('const path = require("path");');
            resolver.addLine(`const libtest = "${libtest}";`);
            resolver.addLine(`const srctest= "${srctest}";`);
            resolver.addLine('module.exports = {');
            resolver.addLine(`  resolveSnapshotPath: ${resolveSnapshotPath.toString()},`);
            resolver.addLine(`  resolveTestPath: ${resolveTestPath.toString()},`);
            resolver.addLine('  testPathForConsistencyCheck: path.join(\'some\', \'__tests__\', \'example.test.js\')');
            resolver.addLine('};');
            this.jest.addSnapshotResolver(`./${resolver.path}`);
        }
        if (this.jest && !compiledTests) {
            this.jest.addTestMatch('**\/__tests__/**\/*.ts?(x)');
            this.jest.addTestMatch('**\/?(*.)+(spec|test).ts?(x)');
            const baseTsconfig = {
                fileName: 'tsconfig.jest.json',
                include: [
                    common_1.PROJEN_RC,
                    `${this.srcdir}/**/*.ts`,
                    `${this.testdir}/**/*.ts`,
                ],
                exclude: [
                    'node_modules',
                ],
                compilerOptions: compilerOptionDefaults,
            };
            // create a tsconfig for jest that does NOT include outDir and rootDir and
            // includes both "src" and "test" as inputs.
            const tsconfig = this.jest.generateTypescriptConfig(mergeTsconfigOptions([baseTsconfig, options.tsconfig]));
            // if we test before compilation, remove the lib/ directory before running
            // tests so that we get a clean slate for testing.
            if (!compileBeforeTest) {
                // make sure to delete "lib" *before* running tests to ensure that
                // test code does not take a dependency on "lib" and instead on "src".
                this.testTask.prependExec(`rm -fr ${this.libdir}/`);
            }
            // compile test code
            this.testCompileTask.exec(`tsc --noEmit --project ${tsconfig.fileName}`);
        }
        if ((_0 = options.eslint) !== null && _0 !== void 0 ? _0 : true) {
            this.eslint = new eslint_1.Eslint(this, {
                tsconfigPath: './tsconfig.eslint.json',
                dirs: [this.srcdir],
                devdirs: [this.testdir, 'build-tools'],
                fileExtensions: ['.ts', '.tsx'],
                ...options.eslintOptions,
            });
            const baseTsconfig = {
                fileName: 'tsconfig.eslint.json',
                include: [
                    common_1.PROJEN_RC,
                    `${this.srcdir}/**/*.ts`,
                    `${this.testdir}/**/*.ts`,
                ],
                exclude: [
                    'node_modules',
                ],
                compilerOptions: compilerOptionDefaults,
            };
            this.tsconfigEslint = new typescript_config_1.TypescriptConfig(this, mergeTsconfigOptions([baseTsconfig, options.tsconfig]));
        }
        const tsver = options.typescriptVersion ? `@${options.typescriptVersion}` : '';
        this.addDevDeps(`typescript${tsver}`, `@types/node@^${(_1 = this.package.minNodeVersion) !== null && _1 !== void 0 ? _1 : '10.17.0'}`);
        // generate sample code in `src` and `lib` if these directories are empty or non-existent.
        if ((_2 = options.sampleCode) !== null && _2 !== void 0 ? _2 : true) {
            new SampleCode(this);
        }
        if (this.docgen) {
            new typescript_typedoc_1.TypedocDocgen(this);
        }
        const projenrcTypeScript = (_3 = options.projenrcTs) !== null && _3 !== void 0 ? _3 : false;
        if (projenrcTypeScript) {
            new projenrc_1.Projenrc(this, options.projenrcTsOptions);
        }
    }
}
exports.TypeScriptProject = TypeScriptProject;
_a = JSII_RTTI_SYMBOL_1;
TypeScriptProject[_a] = { fqn: "projen.TypeScriptProject", version: "0.27.22" };
class SampleCode extends component_1.Component {
    constructor(project) {
        super(project);
        const srcCode = [
            'export class Hello {',
            '  public sayHello() {',
            '    return \'hello, world!\';',
            '  }',
            '}',
        ].join('\n');
        const testCode = [
            "import { Hello } from '../src';",
            '',
            "test('hello', () => {",
            "  expect(new Hello().sayHello()).toBe('hello, world!');",
            '});',
        ].join('\n');
        new sample_file_1.SampleDir(project, project.srcdir, {
            files: {
                'index.ts': srcCode,
            },
        });
        new sample_file_1.SampleDir(project, project.testdir, {
            files: {
                'hello.test.ts': testCode,
            },
        });
    }
}
/**
 * (experimental) TypeScript app.
 *
 * @experimental
 * @pjid typescript-app
 */
class TypeScriptAppProject extends TypeScriptProject {
    /**
     * @experimental
     */
    constructor(options) {
        super({
            allowLibraryDependencies: false,
            releaseWorkflow: false,
            entrypoint: '',
            package: false,
            ...options,
        });
    }
}
exports.TypeScriptAppProject = TypeScriptAppProject;
_b = JSII_RTTI_SYMBOL_1;
TypeScriptAppProject[_b] = { fqn: "projen.TypeScriptAppProject", version: "0.27.22" };
/**
 * @deprecated use `TypeScriptProject`
 */
class TypeScriptLibraryProject extends TypeScriptProject {
}
exports.TypeScriptLibraryProject = TypeScriptLibraryProject;
_c = JSII_RTTI_SYMBOL_1;
TypeScriptLibraryProject[_c] = { fqn: "projen.TypeScriptLibraryProject", version: "0.27.22" };
;
/**
 * @internal
 */
function mergeTsconfigOptions(options) {
    const definedOptions = options.filter(Boolean);
    return definedOptions.reduce((previous, current) => {
        var _d, _e, _f, _g;
        return ({
            ...previous,
            ...current,
            include: [
                ...(_d = previous.include) !== null && _d !== void 0 ? _d : [],
                ...(_e = current.include) !== null && _e !== void 0 ? _e : [],
            ],
            exclude: [
                ...(_f = previous.exclude) !== null && _f !== void 0 ? _f : [],
                ...(_g = current.exclude) !== null && _g !== void 0 ? _g : [],
            ],
            compilerOptions: {
                ...previous.compilerOptions,
                ...current.compilerOptions,
            },
        });
    }, { compilerOptions: {} });
}
exports.mergeTsconfigOptions = mergeTsconfigOptions;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidHlwZXNjcmlwdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy90eXBlc2NyaXB0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsNkJBQTZCO0FBQzdCLHFDQUFpRDtBQUNqRCwyQ0FBd0M7QUFDeEMscUNBQWlEO0FBQ2pELGlEQUFpRTtBQUNqRSwrQ0FBMEM7QUFFMUMseUNBQXNDO0FBQ3RDLDJEQUEyRztBQUMzRyw2REFBcUQ7QUFDckQsb0RBQXVGOzs7Ozs7O0FBcUR2RixNQUFhLGlCQUFrQixTQUFRLDBCQUFXOzs7O0lBc0JoRCxZQUFZLE9BQWlDOztRQUMzQyxLQUFLLENBQUM7WUFDSixHQUFHLE9BQU87WUFFVixnREFBZ0Q7WUFDaEQsVUFBVSxFQUFFLE9BQU8sQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsT0FBTyxDQUFDLFVBQVU7WUFFM0QsV0FBVyxFQUFFO2dCQUNYLEdBQUcsT0FBTyxDQUFDLFdBQVc7Z0JBQ3RCLFVBQVUsRUFBRTtvQkFDVixTQUFHLE9BQU8sQ0FBQyxXQUFXLDBDQUFFLFVBQVU7b0JBQ2xDLFNBQVMsRUFBRSxFQUFFO2lCQUNkO2FBQ0Y7U0FDRixDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsTUFBTSxTQUFHLE9BQU8sQ0FBQyxNQUFNLG1DQUFJLEtBQUssQ0FBQztRQUN0QyxJQUFJLENBQUMsTUFBTSxTQUFHLE9BQU8sQ0FBQyxNQUFNLG1DQUFJLEtBQUssQ0FBQztRQUV0QyxJQUFJLENBQUMsTUFBTSxHQUFHLE9BQU8sQ0FBQyxNQUFNLENBQUM7UUFDN0IsSUFBSSxDQUFDLGFBQWEsU0FBRyxPQUFPLENBQUMsYUFBYSxtQ0FBSSxPQUFPLENBQUM7UUFFdEQsSUFBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLENBQUM7UUFFckMsSUFBSSxDQUFDLFNBQVMsR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDLE9BQU8sRUFBRTtZQUNyQyxXQUFXLEVBQUUsbUNBQW1DO1lBQ2hELElBQUksRUFBRSxnQkFBZ0I7U0FDdkIsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLE9BQU8sU0FBRyxPQUFPLENBQUMsT0FBTyxtQ0FBSSxNQUFNLENBQUM7UUFDekMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxPQUFPLENBQUMsSUFBSSxJQUFJLENBQUMsT0FBTyxFQUFFLENBQUMsQ0FBQztRQUMzQyxNQUFBLElBQUksQ0FBQyxTQUFTLDBDQUFFLE9BQU8sQ0FBQyxJQUFJLElBQUksQ0FBQyxPQUFPLEVBQUUsRUFBRTtRQUU1Qyw0RUFBNEU7UUFDNUUsMkRBQTJEO1FBQzNELE1BQU0sYUFBYSxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQztRQUU1RSw0R0FBNEc7UUFDNUcsTUFBTSxpQkFBaUIsU0FBRyxPQUFPLENBQUMsaUJBQWlCLG1DQUFJLGFBQWEsQ0FBQztRQUVyRSxJQUFJLGlCQUFpQixFQUFFO1lBQ3JCLElBQUksQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQztZQUN2QyxJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLENBQUM7U0FDckM7YUFBTTtZQUNMLElBQUksQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQztZQUNwQyxJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLENBQUM7U0FDeEM7UUFFRCxVQUFJLE9BQU8sQ0FBQyxPQUFPLG1DQUFJLElBQUksRUFBRTtZQUMzQixJQUFJLENBQUMsV0FBVyxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsU0FBUyxFQUFFO2dCQUN6QyxXQUFXLEVBQUUsdUJBQXVCO2FBQ3JDLENBQUMsQ0FBQztZQUVILElBQUksQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLGtCQUFrQixDQUFDLENBQUM7WUFDMUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDLGNBQWMsT0FBTyxDQUFDLENBQUM7WUFDN0QsSUFBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsbUJBQW1CLENBQUMsQ0FBQztZQUUzQyxJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLENBQUM7U0FDeEM7UUFFRCxJQUFJLE9BQU8sQ0FBQyxlQUFlLElBQUksSUFBSSxDQUFDLFVBQVUsS0FBSyxFQUFFLEVBQUU7WUFDckQsTUFBTSxlQUFlLFNBQUcsT0FBTyxDQUFDLGVBQWUsbUNBQUksR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxFQUFFLElBQUksQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLFVBQVUsRUFBRSxLQUFLLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxLQUFLLEVBQUUsR0FBRyxDQUFDLE9BQU8sQ0FBQztZQUNqSyxJQUFJLENBQUMsT0FBTyxDQUFDLFFBQVEsQ0FBQyxPQUFPLEVBQUUsZUFBZSxDQUFDLENBQUM7U0FDakQ7UUFFRCxNQUFNLHNCQUFzQixHQUE4QjtZQUN4RCxZQUFZLEVBQUUsSUFBSTtZQUNsQixXQUFXLEVBQUUsSUFBSTtZQUNqQixzQkFBc0IsRUFBRSxJQUFJO1lBQzVCLGVBQWUsRUFBRSxJQUFJO1lBQ3JCLGFBQWEsRUFBRSxJQUFJO1lBQ25CLEdBQUcsRUFBRSxDQUFDLFFBQVEsQ0FBQztZQUNmLE1BQU0sRUFBRSxVQUFVO1lBQ2xCLGFBQWEsRUFBRSxLQUFLO1lBQ3BCLDBCQUEwQixFQUFFLElBQUk7WUFDaEMsYUFBYSxFQUFFLElBQUk7WUFDbkIsaUJBQWlCLEVBQUUsSUFBSTtZQUN2QixjQUFjLEVBQUUsSUFBSTtZQUNwQixjQUFjLEVBQUUsSUFBSTtZQUNwQixrQkFBa0IsRUFBRSxJQUFJO1lBQ3hCLGlCQUFpQixFQUFFLElBQUk7WUFDdkIsTUFBTSxFQUFFLElBQUk7WUFDWixnQkFBZ0IsRUFBRSxJQUFJO1lBQ3RCLDRCQUE0QixFQUFFLElBQUk7WUFDbEMsYUFBYSxFQUFFLElBQUk7WUFDbkIsTUFBTSxFQUFFLFFBQVE7U0FDakIsQ0FBQztRQUVGLElBQUksQ0FBQyxPQUFPLENBQUMsZUFBZSxFQUFFO1lBQzVCLE1BQU0sWUFBWSxHQUE0QjtnQkFDNUMsT0FBTyxFQUFFLENBQUMsR0FBRyxJQUFJLENBQUMsTUFBTSxVQUFVLENBQUM7Z0JBQ25DLGVBQWUsRUFBRTtvQkFDZixPQUFPLEVBQUUsSUFBSSxDQUFDLE1BQU07b0JBQ3BCLE1BQU0sRUFBRSxJQUFJLENBQUMsTUFBTTtvQkFDbkIsR0FBRyxzQkFBc0I7aUJBQzFCO2FBQ0YsQ0FBQztZQUVGLElBQUksQ0FBQyxRQUFRLEdBQUcsSUFBSSxvQ0FBZ0IsQ0FBQyxJQUFJLEVBQ3ZDLG9CQUFvQixDQUFDLENBQUMsWUFBWSxFQUFFLE9BQU8sQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDLENBQUM7U0FDM0Q7UUFFRCxJQUFJLElBQUksQ0FBQyxNQUFNLEtBQUssSUFBSSxDQUFDLE1BQU0sRUFBRTtZQUMvQiwwQ0FBMEM7WUFDMUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxPQUFPLENBQUMsSUFBSSxJQUFJLENBQUMsTUFBTSxFQUFFLENBQUMsQ0FBQztTQUMzQzthQUFNO1lBQ0wsa0RBQWtEO1lBQ2xELElBQUksQ0FBQyxTQUFTLENBQUMsT0FBTyxDQUFDLElBQUksSUFBSSxDQUFDLE1BQU0sVUFBVSxDQUFDLENBQUM7WUFDbEQsSUFBSSxDQUFDLFNBQVMsQ0FBQyxPQUFPLENBQUMsSUFBSSxJQUFJLENBQUMsTUFBTSxZQUFZLENBQUMsQ0FBQztTQUNyRDtRQUVELE1BQUEsSUFBSSxDQUFDLFNBQVMsMENBQUUsT0FBTyxDQUFDLElBQUksSUFBSSxDQUFDLE1BQU0sRUFBRSxFQUFFO1FBRTNDLElBQUksQ0FBQyxTQUFTLENBQUMsT0FBTyxDQUFDLElBQUksSUFBSSxDQUFDLE1BQU0sRUFBRSxDQUFDLENBQUM7UUFDMUMsTUFBQSxJQUFJLENBQUMsU0FBUywwQ0FBRSxPQUFPLENBQUMsSUFBSSxJQUFJLENBQUMsTUFBTSxFQUFFLEVBQUU7UUFFM0MsTUFBQSxJQUFJLENBQUMsU0FBUywwQ0FBRSxPQUFPLENBQUMsSUFBSSxJQUFJLENBQUMsTUFBTSxVQUFVLEVBQUU7UUFDbkQsTUFBQSxJQUFJLENBQUMsU0FBUywwQ0FBRSxPQUFPLENBQUMsSUFBSSxJQUFJLENBQUMsTUFBTSxZQUFZLEVBQUU7UUFFckQsSUFBSSxDQUFDLFNBQVMsQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLENBQUM7UUFDaEMsTUFBQSxJQUFJLENBQUMsU0FBUywwQ0FBRSxPQUFPLENBQUMsTUFBTSxFQUFFLENBQUMsMEZBQTBGO1FBRTNILE1BQUEsSUFBSSxDQUFDLFNBQVMsMENBQUUsT0FBTyxDQUFDLGdCQUFnQixFQUFFO1FBQzFDLE1BQUEsSUFBSSxDQUFDLFNBQVMsMENBQUUsT0FBTyxDQUFDLFVBQVUsRUFBRTtRQUNwQyxNQUFBLElBQUksQ0FBQyxTQUFTLDBDQUFFLE9BQU8sQ0FBQyxVQUFVLEVBQUU7UUFDcEMsTUFBQSxJQUFJLENBQUMsU0FBUywwQ0FBRSxPQUFPLENBQUMsUUFBUSxFQUFFO1FBQ2xDLE1BQUEsSUFBSSxDQUFDLFNBQVMsMENBQUUsT0FBTyxDQUFDLGVBQWUsRUFBRTtRQUN6QyxNQUFBLElBQUksQ0FBQyxTQUFTLDBDQUFFLE9BQU8sQ0FBQyxzQkFBc0IsRUFBRTtRQUVoRCxxRkFBcUY7UUFDckYsMENBQTBDO1FBQzFDLElBQUksSUFBSSxDQUFDLElBQUksSUFBSSxhQUFhLEVBQUU7WUFDOUIsSUFBSSxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUMsQ0FBQztZQUUvQixNQUFNLE9BQU8sR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsTUFBTSxFQUFFLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQztZQUMvRCxNQUFNLE9BQU8sR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxFQUFFLE9BQU8sQ0FBQyxDQUFDO1lBQ3RELE1BQU0sT0FBTyxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUM7WUFFN0IsTUFBQSxJQUFJLENBQUMsU0FBUywwQ0FBRSxXQUFXLENBQUMsSUFBSSxPQUFPLEVBQUUsRUFBRTtZQUMzQyxJQUFJLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxNQUFNLE9BQU8sOEJBQThCLENBQUMsQ0FBQztZQUNwRSxJQUFJLENBQUMsSUFBSSxDQUFDLHFCQUFxQixDQUFDLElBQUksSUFBSSxDQUFDLE1BQU0sR0FBRyxDQUFDLENBQUM7WUFFcEQsTUFBTSxtQkFBbUIsR0FBRyxDQUFDLElBQVksRUFBRSxHQUFXLEVBQUUsRUFBRTtnQkFDeEQsTUFBTSxRQUFRLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLENBQUM7Z0JBQ2hELE9BQU8sSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLFFBQVEsQ0FBQyxFQUFFLGVBQWUsRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLFFBQVEsRUFBRSxLQUFLLENBQUMsR0FBRyxLQUFLLEdBQUcsR0FBRyxDQUFDLENBQUM7WUFDMUcsQ0FBQyxDQUFDO1lBRUYsTUFBTSxlQUFlLEdBQUcsQ0FBQyxJQUFZLEVBQUUsR0FBVyxFQUFFLEVBQUU7Z0JBQ3BELE1BQU0sUUFBUSxHQUFHLElBQUksQ0FBQyxRQUFRLENBQUMsSUFBSSxFQUFFLEtBQUssR0FBRyxHQUFHLENBQUMsR0FBRyxLQUFLLENBQUM7Z0JBQzFELE1BQU0sR0FBRyxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLENBQUM7Z0JBQ3ZFLE9BQU8sSUFBSSxDQUFDLElBQUksQ0FBQyxHQUFHLEVBQUUsUUFBUSxDQUFDLENBQUM7WUFDbEMsQ0FBQyxDQUFDO1lBRUYsTUFBTSxRQUFRLEdBQUcsSUFBSSxtQkFBUSxDQUFDLElBQUksRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxtQkFBVSxFQUFFLDJCQUEyQixDQUFDLENBQUMsQ0FBQztZQUM5RixRQUFRLENBQUMsT0FBTyxDQUFDLCtCQUErQixDQUFDLENBQUM7WUFDbEQsUUFBUSxDQUFDLE9BQU8sQ0FBQyxvQkFBb0IsT0FBTyxJQUFJLENBQUMsQ0FBQztZQUNsRCxRQUFRLENBQUMsT0FBTyxDQUFDLG1CQUFtQixPQUFPLElBQUksQ0FBQyxDQUFDO1lBQ2pELFFBQVEsQ0FBQyxPQUFPLENBQUMsb0JBQW9CLENBQUMsQ0FBQztZQUN2QyxRQUFRLENBQUMsT0FBTyxDQUFDLDBCQUEwQixtQkFBbUIsQ0FBQyxRQUFRLEVBQUUsR0FBRyxDQUFDLENBQUM7WUFDOUUsUUFBUSxDQUFDLE9BQU8sQ0FBQyxzQkFBc0IsZUFBZSxDQUFDLFFBQVEsRUFBRSxHQUFHLENBQUMsQ0FBQztZQUN0RSxRQUFRLENBQUMsT0FBTyxDQUFDLHdGQUF3RixDQUFDLENBQUM7WUFDM0csUUFBUSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsQ0FBQztZQUV2QixJQUFJLENBQUMsSUFBSSxDQUFDLG1CQUFtQixDQUFDLEtBQUssUUFBUSxDQUFDLElBQUksRUFBRSxDQUFDLENBQUM7U0FDckQ7UUFFRCxJQUFJLElBQUksQ0FBQyxJQUFJLElBQUksQ0FBQyxhQUFhLEVBQUU7WUFDL0IsSUFBSSxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsNEJBQTRCLENBQUMsQ0FBQztZQUNyRCxJQUFJLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyw4QkFBOEIsQ0FBQyxDQUFDO1lBRXZELE1BQU0sWUFBWSxHQUE0QjtnQkFDNUMsUUFBUSxFQUFFLG9CQUFvQjtnQkFDOUIsT0FBTyxFQUFFO29CQUNQLGtCQUFTO29CQUNULEdBQUcsSUFBSSxDQUFDLE1BQU0sVUFBVTtvQkFDeEIsR0FBRyxJQUFJLENBQUMsT0FBTyxVQUFVO2lCQUMxQjtnQkFDRCxPQUFPLEVBQUU7b0JBQ1AsY0FBYztpQkFDZjtnQkFDRCxlQUFlLEVBQUUsc0JBQXNCO2FBQ3hDLENBQUM7WUFFRiwwRUFBMEU7WUFDMUUsNENBQTRDO1lBQzVDLE1BQU0sUUFBUSxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsd0JBQXdCLENBQ2pELG9CQUFvQixDQUFDLENBQUMsWUFBWSxFQUFFLE9BQU8sQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDLENBQUM7WUFFMUQsMEVBQTBFO1lBQzFFLGtEQUFrRDtZQUNsRCxJQUFJLENBQUMsaUJBQWlCLEVBQUU7Z0JBQ3RCLGtFQUFrRTtnQkFDbEUsc0VBQXNFO2dCQUN0RSxJQUFJLENBQUMsUUFBUSxDQUFDLFdBQVcsQ0FBQyxVQUFVLElBQUksQ0FBQyxNQUFNLEdBQUcsQ0FBQyxDQUFDO2FBQ3JEO1lBRUQsb0JBQW9CO1lBQ3BCLElBQUksQ0FBQyxlQUFlLENBQUMsSUFBSSxDQUFDLDBCQUEwQixRQUFRLENBQUMsUUFBUSxFQUFFLENBQUMsQ0FBQztTQUMxRTtRQUVELFVBQUksT0FBTyxDQUFDLE1BQU0sbUNBQUksSUFBSSxFQUFFO1lBQzFCLElBQUksQ0FBQyxNQUFNLEdBQUcsSUFBSSxlQUFNLENBQUMsSUFBSSxFQUFFO2dCQUM3QixZQUFZLEVBQUUsd0JBQXdCO2dCQUN0QyxJQUFJLEVBQUUsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDO2dCQUNuQixPQUFPLEVBQUUsQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLGFBQWEsQ0FBQztnQkFDdEMsY0FBYyxFQUFFLENBQUMsS0FBSyxFQUFFLE1BQU0sQ0FBQztnQkFDL0IsR0FBRyxPQUFPLENBQUMsYUFBYTthQUN6QixDQUFDLENBQUM7WUFFSCxNQUFNLFlBQVksR0FBRztnQkFDbkIsUUFBUSxFQUFFLHNCQUFzQjtnQkFDaEMsT0FBTyxFQUFFO29CQUNQLGtCQUFTO29CQUNULEdBQUcsSUFBSSxDQUFDLE1BQU0sVUFBVTtvQkFDeEIsR0FBRyxJQUFJLENBQUMsT0FBTyxVQUFVO2lCQUMxQjtnQkFDRCxPQUFPLEVBQUU7b0JBQ1AsY0FBYztpQkFDZjtnQkFDRCxlQUFlLEVBQUUsc0JBQXNCO2FBQ3hDLENBQUM7WUFFRixJQUFJLENBQUMsY0FBYyxHQUFHLElBQUksb0NBQWdCLENBQUMsSUFBSSxFQUFFLG9CQUFvQixDQUFDLENBQUMsWUFBWSxFQUFFLE9BQU8sQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDLENBQUM7U0FDMUc7UUFFRCxNQUFNLEtBQUssR0FBRyxPQUFPLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDLElBQUksT0FBTyxDQUFDLGlCQUFpQixFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQztRQUUvRSxJQUFJLENBQUMsVUFBVSxDQUNiLGFBQWEsS0FBSyxFQUFFLEVBQ3BCLGdCQUFnQixNQUFBLElBQUksQ0FBQyxPQUFPLENBQUMsY0FBYyxtQ0FBSSxTQUFTLEVBQUUsQ0FDM0QsQ0FBQztRQUVGLDBGQUEwRjtRQUMxRixVQUFJLE9BQU8sQ0FBQyxVQUFVLG1DQUFJLElBQUksRUFBRTtZQUM5QixJQUFJLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQztTQUN0QjtRQUVELElBQUksSUFBSSxDQUFDLE1BQU0sRUFBRTtZQUNmLElBQUksa0NBQWEsQ0FBQyxJQUFJLENBQUMsQ0FBQztTQUN6QjtRQUVELE1BQU0sa0JBQWtCLFNBQUcsT0FBTyxDQUFDLFVBQVUsbUNBQUksS0FBSyxDQUFDO1FBQ3ZELElBQUksa0JBQWtCLEVBQUU7WUFDdEIsSUFBSSxtQkFBUSxDQUFDLElBQUksRUFBRSxPQUFPLENBQUMsaUJBQWlCLENBQUMsQ0FBQztTQUMvQztJQUNILENBQUM7O0FBM1FILDhDQTRRQzs7O0FBRUQsTUFBTSxVQUFXLFNBQVEscUJBQVM7SUFDaEMsWUFBWSxPQUEwQjtRQUNwQyxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUM7UUFDZixNQUFNLE9BQU8sR0FBRztZQUNkLHNCQUFzQjtZQUN0Qix1QkFBdUI7WUFDdkIsK0JBQStCO1lBQy9CLEtBQUs7WUFDTCxHQUFHO1NBQ0osQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7UUFFYixNQUFNLFFBQVEsR0FBRztZQUNmLGlDQUFpQztZQUNqQyxFQUFFO1lBQ0YsdUJBQXVCO1lBQ3ZCLHlEQUF5RDtZQUN6RCxLQUFLO1NBQ04sQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7UUFFYixJQUFJLHVCQUFTLENBQUMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxNQUFNLEVBQUU7WUFDckMsS0FBSyxFQUFFO2dCQUNMLFVBQVUsRUFBRSxPQUFPO2FBQ3BCO1NBQ0YsQ0FBQyxDQUFDO1FBRUgsSUFBSSx1QkFBUyxDQUFDLE9BQU8sRUFBRSxPQUFPLENBQUMsT0FBTyxFQUFFO1lBQ3RDLEtBQUssRUFBRTtnQkFDTCxlQUFlLEVBQUUsUUFBUTthQUMxQjtTQUNGLENBQUMsQ0FBQztJQUNMLENBQUM7Q0FDRjs7Ozs7OztBQUdELE1BQWEsb0JBQXFCLFNBQVEsaUJBQWlCOzs7O0lBQ3pELFlBQVksT0FBaUM7UUFDM0MsS0FBSyxDQUFDO1lBQ0osd0JBQXdCLEVBQUUsS0FBSztZQUMvQixlQUFlLEVBQUUsS0FBSztZQUN0QixVQUFVLEVBQUUsRUFBRTtZQUNkLE9BQU8sRUFBRSxLQUFLO1lBQ2QsR0FBRyxPQUFPO1NBQ1gsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs7QUFUSCxvREFVQzs7Ozs7O0FBR0QsTUFBYSx3QkFBeUIsU0FBUSxpQkFBaUI7O0FBQS9ELDREQUNDOzs7QUFBQSxDQUFDO0FBTUY7O0dBRUc7QUFDSCxTQUFnQixvQkFBb0IsQ0FBQyxPQUFnRDtJQUNuRixNQUFNLGNBQWMsR0FBRyxPQUFPLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBOEIsQ0FBQztJQUM1RSxPQUFPLGNBQWMsQ0FBQyxNQUFNLENBQTBCLENBQUMsUUFBUSxFQUFFLE9BQU8sRUFBRSxFQUFFOztRQUFDLE9BQUEsQ0FBQztZQUM1RSxHQUFHLFFBQVE7WUFDWCxHQUFHLE9BQU87WUFDVixPQUFPLEVBQUU7Z0JBQ1AsU0FBRyxRQUFRLENBQUMsT0FBTyxtQ0FBSSxFQUFFO2dCQUN6QixTQUFHLE9BQU8sQ0FBQyxPQUFPLG1DQUFJLEVBQUU7YUFDekI7WUFDRCxPQUFPLEVBQUU7Z0JBQ1AsU0FBRyxRQUFRLENBQUMsT0FBTyxtQ0FBSSxFQUFFO2dCQUN6QixTQUFHLE9BQU8sQ0FBQyxPQUFPLG1DQUFJLEVBQUU7YUFDekI7WUFDRCxlQUFlLEVBQUU7Z0JBQ2YsR0FBRyxRQUFRLENBQUMsZUFBZTtnQkFDM0IsR0FBRyxPQUFPLENBQUMsZUFBZTthQUMzQjtTQUNGLENBQUMsQ0FBQTtLQUFBLEVBQUUsRUFBRSxlQUFlLEVBQUUsRUFBRSxFQUFFLENBQUMsQ0FBQztBQUMvQixDQUFDO0FBbEJELG9EQWtCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHBhdGggZnJvbSAncGF0aCc7XG5pbXBvcnQgeyBQUk9KRU5fRElSLCBQUk9KRU5fUkMgfSBmcm9tICcuL2NvbW1vbic7XG5pbXBvcnQgeyBDb21wb25lbnQgfSBmcm9tICcuL2NvbXBvbmVudCc7XG5pbXBvcnQgeyBFc2xpbnQsIEVzbGludE9wdGlvbnMgfSBmcm9tICcuL2VzbGludCc7XG5pbXBvcnQgeyBOb2RlUHJvamVjdCwgTm9kZVByb2plY3RPcHRpb25zIH0gZnJvbSAnLi9ub2RlLXByb2plY3QnO1xuaW1wb3J0IHsgU2FtcGxlRGlyIH0gZnJvbSAnLi9zYW1wbGUtZmlsZSc7XG5pbXBvcnQgeyBUYXNrIH0gZnJvbSAnLi90YXNrcyc7XG5pbXBvcnQgeyBUZXh0RmlsZSB9IGZyb20gJy4vdGV4dGZpbGUnO1xuaW1wb3J0IHsgVHlwZVNjcmlwdENvbXBpbGVyT3B0aW9ucywgVHlwZXNjcmlwdENvbmZpZywgVHlwZXNjcmlwdENvbmZpZ09wdGlvbnMgfSBmcm9tICcuL3R5cGVzY3JpcHQtY29uZmlnJztcbmltcG9ydCB7IFR5cGVkb2NEb2NnZW4gfSBmcm9tICcuL3R5cGVzY3JpcHQtdHlwZWRvYyc7XG5pbXBvcnQgeyBQcm9qZW5yYywgUHJvamVucmNPcHRpb25zIGFzIFByb2plbnJjVHNPcHRpb25zIH0gZnJvbSAnLi90eXBlc2NyaXB0L3Byb2plbnJjJztcblxuZXhwb3J0IGludGVyZmFjZSBUeXBlU2NyaXB0UHJvamVjdE9wdGlvbnMgZXh0ZW5kcyBOb2RlUHJvamVjdE9wdGlvbnMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbGliZGlyPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzcmNkaXI/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHRlc3RkaXI/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBlc2xpbnQ/OiBib29sZWFuO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZXNsaW50T3B0aW9ucz86IEVzbGludE9wdGlvbnM7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdHlwZXNjcmlwdFZlcnNpb24/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGRvY2dlbj86IGJvb2xlYW47XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBkb2NzRGlyZWN0b3J5Pzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSB0c2NvbmZpZz86IFR5cGVzY3JpcHRDb25maWdPcHRpb25zO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBkaXNhYmxlVHNjb25maWc/OiBib29sZWFuO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBjb21waWxlQmVmb3JlVGVzdD86IGJvb2xlYW47XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzYW1wbGVDb2RlPzogYm9vbGVhbjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGVudHJ5cG9pbnRUeXBlcz86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBwYWNrYWdlPzogYm9vbGVhbjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBwcm9qZW5yY1RzPzogYm9vbGVhbjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcHJvamVucmNUc09wdGlvbnM/OiBQcm9qZW5yY1RzT3B0aW9ucztcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIFR5cGVTY3JpcHRQcm9qZWN0IGV4dGVuZHMgTm9kZVByb2plY3Qge1xuICBwdWJsaWMgcmVhZG9ubHkgZG9jZ2VuPzogYm9vbGVhbjtcbiAgcHVibGljIHJlYWRvbmx5IGRvY3NEaXJlY3Rvcnk6IHN0cmluZztcbiAgcHVibGljIHJlYWRvbmx5IGVzbGludD86IEVzbGludDtcbiAgcHVibGljIHJlYWRvbmx5IHRzY29uZmlnRXNsaW50PzogVHlwZXNjcmlwdENvbmZpZztcbiAgcHVibGljIHJlYWRvbmx5IHRzY29uZmlnPzogVHlwZXNjcmlwdENvbmZpZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBzcmNkaXI6IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBsaWJkaXI6IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IHRlc3RkaXI6IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgd2F0Y2hUYXNrOiBUYXNrO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBwYWNrYWdlVGFzaz86IFRhc2s7XG5cbiAgY29uc3RydWN0b3Iob3B0aW9uczogVHlwZVNjcmlwdFByb2plY3RPcHRpb25zKSB7XG4gICAgc3VwZXIoe1xuICAgICAgLi4ub3B0aW9ucyxcblxuICAgICAgLy8gZGlzYWJsZSAucHJvamVucmMuanMgaWYgdHlwZXNjcmlwdCBpcyBlbmFibGVkXG4gICAgICBwcm9qZW5yY0pzOiBvcHRpb25zLnByb2plbnJjVHMgPyBmYWxzZSA6IG9wdGlvbnMucHJvamVucmNKcyxcblxuICAgICAgamVzdE9wdGlvbnM6IHtcbiAgICAgICAgLi4ub3B0aW9ucy5qZXN0T3B0aW9ucyxcbiAgICAgICAgamVzdENvbmZpZzoge1xuICAgICAgICAgIC4uLm9wdGlvbnMuamVzdE9wdGlvbnM/Lmplc3RDb25maWcsXG4gICAgICAgICAgdGVzdE1hdGNoOiBbXSxcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgfSk7XG5cbiAgICB0aGlzLnNyY2RpciA9IG9wdGlvbnMuc3JjZGlyID8/ICdzcmMnO1xuICAgIHRoaXMubGliZGlyID0gb3B0aW9ucy5saWJkaXIgPz8gJ2xpYic7XG5cbiAgICB0aGlzLmRvY2dlbiA9IG9wdGlvbnMuZG9jZ2VuO1xuICAgIHRoaXMuZG9jc0RpcmVjdG9yeSA9IG9wdGlvbnMuZG9jc0RpcmVjdG9yeSA/PyAnZG9jcy8nO1xuXG4gICAgdGhpcy5jb21waWxlVGFzay5leGVjKCd0c2MgLS1idWlsZCcpO1xuXG4gICAgdGhpcy53YXRjaFRhc2sgPSB0aGlzLmFkZFRhc2soJ3dhdGNoJywge1xuICAgICAgZGVzY3JpcHRpb246ICdXYXRjaCAmIGNvbXBpbGUgaW4gdGhlIGJhY2tncm91bmQnLFxuICAgICAgZXhlYzogJ3RzYyAtLWJ1aWxkIC13JyxcbiAgICB9KTtcblxuICAgIHRoaXMudGVzdGRpciA9IG9wdGlvbnMudGVzdGRpciA/PyAndGVzdCc7XG4gICAgdGhpcy5naXRpZ25vcmUuaW5jbHVkZShgLyR7dGhpcy50ZXN0ZGlyfWApO1xuICAgIHRoaXMubnBtaWdub3JlPy5leGNsdWRlKGAvJHt0aGlzLnRlc3RkaXJ9YCk7XG5cbiAgICAvLyBpZiB0aGUgdGVzdCBkaXJlY3RvcnkgaXMgdW5kZXIgYHNyYy9gLCB0aGVuIHdlIHdpbGwgcnVuIG91ciB0ZXN0cyBhZ2FpbnN0XG4gICAgLy8gdGhlIGphdmFzY3JpcHQgZmlsZXMgYW5kIG5vdCBsZXQgamVzdCBjb21waWxlIGl0IGZvciB1cy5cbiAgICBjb25zdCBjb21waWxlZFRlc3RzID0gdGhpcy50ZXN0ZGlyLnN0YXJ0c1dpdGgodGhpcy5zcmNkaXIgKyBwYXRoLnBvc2l4LnNlcCk7XG5cbiAgICAvLyBieSBkZWZhdWx0LCB3ZSBmaXJzdCBydW4gdGVzdHMgKGplc3QgY29tcGlsZXMgdGhlIHR5cGVzY3JpcHQgaW4gdGhlIGJhY2tncm91bmQpIGFuZCBvbmx5IHRoZW4gd2UgY29tcGlsZS5cbiAgICBjb25zdCBjb21waWxlQmVmb3JlVGVzdCA9IG9wdGlvbnMuY29tcGlsZUJlZm9yZVRlc3QgPz8gY29tcGlsZWRUZXN0cztcblxuICAgIGlmIChjb21waWxlQmVmb3JlVGVzdCkge1xuICAgICAgdGhpcy5idWlsZFRhc2suc3Bhd24odGhpcy5jb21waWxlVGFzayk7XG4gICAgICB0aGlzLmJ1aWxkVGFzay5zcGF3bih0aGlzLnRlc3RUYXNrKTtcbiAgICB9IGVsc2Uge1xuICAgICAgdGhpcy5idWlsZFRhc2suc3Bhd24odGhpcy50ZXN0VGFzayk7XG4gICAgICB0aGlzLmJ1aWxkVGFzay5zcGF3bih0aGlzLmNvbXBpbGVUYXNrKTtcbiAgICB9XG5cbiAgICBpZiAob3B0aW9ucy5wYWNrYWdlID8/IHRydWUpIHtcbiAgICAgIHRoaXMucGFja2FnZVRhc2sgPSB0aGlzLmFkZFRhc2soJ3BhY2thZ2UnLCB7XG4gICAgICAgIGRlc2NyaXB0aW9uOiAnQ3JlYXRlIGFuIG5wbSB0YXJiYWxsJyxcbiAgICAgIH0pO1xuXG4gICAgICB0aGlzLnBhY2thZ2VUYXNrLmV4ZWMoJ21rZGlyIC1wIGRpc3QvanMnKTtcbiAgICAgIHRoaXMucGFja2FnZVRhc2suZXhlYyhgJHt0aGlzLnBhY2thZ2UucGFja2FnZU1hbmFnZXJ9IHBhY2tgKTtcbiAgICAgIHRoaXMucGFja2FnZVRhc2suZXhlYygnbXYgKi50Z3ogZGlzdC9qcy8nKTtcblxuICAgICAgdGhpcy5idWlsZFRhc2suc3Bhd24odGhpcy5wYWNrYWdlVGFzayk7XG4gICAgfVxuXG4gICAgaWYgKG9wdGlvbnMuZW50cnlwb2ludFR5cGVzIHx8IHRoaXMuZW50cnlwb2ludCAhPT0gJycpIHtcbiAgICAgIGNvbnN0IGVudHJ5cG9pbnRUeXBlcyA9IG9wdGlvbnMuZW50cnlwb2ludFR5cGVzID8/IGAke3BhdGguam9pbihwYXRoLmRpcm5hbWUodGhpcy5lbnRyeXBvaW50KSwgcGF0aC5iYXNlbmFtZSh0aGlzLmVudHJ5cG9pbnQsICcuanMnKSkucmVwbGFjZSgvXFxcXC9nLCAnLycpfS5kLnRzYDtcbiAgICAgIHRoaXMucGFja2FnZS5hZGRGaWVsZCgndHlwZXMnLCBlbnRyeXBvaW50VHlwZXMpO1xuICAgIH1cblxuICAgIGNvbnN0IGNvbXBpbGVyT3B0aW9uRGVmYXVsdHM6IFR5cGVTY3JpcHRDb21waWxlck9wdGlvbnMgPSB7XG4gICAgICBhbHdheXNTdHJpY3Q6IHRydWUsXG4gICAgICBkZWNsYXJhdGlvbjogdHJ1ZSxcbiAgICAgIGV4cGVyaW1lbnRhbERlY29yYXRvcnM6IHRydWUsXG4gICAgICBpbmxpbmVTb3VyY2VNYXA6IHRydWUsXG4gICAgICBpbmxpbmVTb3VyY2VzOiB0cnVlLFxuICAgICAgbGliOiBbJ2VzMjAxOCddLFxuICAgICAgbW9kdWxlOiAnQ29tbW9uSlMnLFxuICAgICAgbm9FbWl0T25FcnJvcjogZmFsc2UsXG4gICAgICBub0ZhbGx0aHJvdWdoQ2FzZXNJblN3aXRjaDogdHJ1ZSxcbiAgICAgIG5vSW1wbGljaXRBbnk6IHRydWUsXG4gICAgICBub0ltcGxpY2l0UmV0dXJuczogdHJ1ZSxcbiAgICAgIG5vSW1wbGljaXRUaGlzOiB0cnVlLFxuICAgICAgbm9VbnVzZWRMb2NhbHM6IHRydWUsXG4gICAgICBub1VudXNlZFBhcmFtZXRlcnM6IHRydWUsXG4gICAgICByZXNvbHZlSnNvbk1vZHVsZTogdHJ1ZSxcbiAgICAgIHN0cmljdDogdHJ1ZSxcbiAgICAgIHN0cmljdE51bGxDaGVja3M6IHRydWUsXG4gICAgICBzdHJpY3RQcm9wZXJ0eUluaXRpYWxpemF0aW9uOiB0cnVlLFxuICAgICAgc3RyaXBJbnRlcm5hbDogdHJ1ZSxcbiAgICAgIHRhcmdldDogJ0VTMjAxOCcsXG4gICAgfTtcblxuICAgIGlmICghb3B0aW9ucy5kaXNhYmxlVHNjb25maWcpIHtcbiAgICAgIGNvbnN0IGJhc2VUc2NvbmZpZzogVHlwZXNjcmlwdENvbmZpZ09wdGlvbnMgPSB7XG4gICAgICAgIGluY2x1ZGU6IFtgJHt0aGlzLnNyY2Rpcn0vKiovKi50c2BdLFxuICAgICAgICBjb21waWxlck9wdGlvbnM6IHtcbiAgICAgICAgICByb290RGlyOiB0aGlzLnNyY2RpcixcbiAgICAgICAgICBvdXREaXI6IHRoaXMubGliZGlyLFxuICAgICAgICAgIC4uLmNvbXBpbGVyT3B0aW9uRGVmYXVsdHMsXG4gICAgICAgIH0sXG4gICAgICB9O1xuXG4gICAgICB0aGlzLnRzY29uZmlnID0gbmV3IFR5cGVzY3JpcHRDb25maWcodGhpcyxcbiAgICAgICAgbWVyZ2VUc2NvbmZpZ09wdGlvbnMoW2Jhc2VUc2NvbmZpZywgb3B0aW9ucy50c2NvbmZpZ10pKTtcbiAgICB9XG5cbiAgICBpZiAodGhpcy5zcmNkaXIgIT09IHRoaXMubGliZGlyKSB7XG4gICAgICAvLyBzZXBhcmF0ZWQsIGNhbiBpZ25vcmUgdGhlIGVudGlyZSBsaWJkaXJcbiAgICAgIHRoaXMuZ2l0aWdub3JlLmV4Y2x1ZGUoYC8ke3RoaXMubGliZGlyfWApO1xuICAgIH0gZWxzZSB7XG4gICAgICAvLyBjb2xsb2NhdGVkLCBjYW4gb25seSBpZ25vcmUgdGhlIGNvbXBpbGVkIG91dHB1dFxuICAgICAgdGhpcy5naXRpZ25vcmUuZXhjbHVkZShgLyR7dGhpcy5saWJkaXJ9LyoqLyouanNgKTtcbiAgICAgIHRoaXMuZ2l0aWdub3JlLmV4Y2x1ZGUoYC8ke3RoaXMubGliZGlyfS8qKi8qLmQudHNgKTtcbiAgICB9XG5cbiAgICB0aGlzLm5wbWlnbm9yZT8uaW5jbHVkZShgLyR7dGhpcy5saWJkaXJ9YCk7XG5cbiAgICB0aGlzLmdpdGlnbm9yZS5pbmNsdWRlKGAvJHt0aGlzLnNyY2Rpcn1gKTtcbiAgICB0aGlzLm5wbWlnbm9yZT8uZXhjbHVkZShgLyR7dGhpcy5zcmNkaXJ9YCk7XG5cbiAgICB0aGlzLm5wbWlnbm9yZT8uaW5jbHVkZShgLyR7dGhpcy5saWJkaXJ9LyoqLyouanNgKTtcbiAgICB0aGlzLm5wbWlnbm9yZT8uaW5jbHVkZShgLyR7dGhpcy5saWJkaXJ9LyoqLyouZC50c2ApO1xuXG4gICAgdGhpcy5naXRpZ25vcmUuZXhjbHVkZSgnL2Rpc3QnKTtcbiAgICB0aGlzLm5wbWlnbm9yZT8uZXhjbHVkZSgnZGlzdCcpOyAvLyBqc2lpLXBhY21hayBleHBlY3RzIHRoaXMgdG8gYmUgXCJkaXN0XCIgYW5kIG5vdCBcIi9kaXN0XCIuIG90aGVyd2lzZSBpdCB3aWxsIHRhbXBlciB3aXRoIGl0XG5cbiAgICB0aGlzLm5wbWlnbm9yZT8uZXhjbHVkZSgnL3RzY29uZmlnLmpzb24nKTtcbiAgICB0aGlzLm5wbWlnbm9yZT8uZXhjbHVkZSgnLy5naXRodWInKTtcbiAgICB0aGlzLm5wbWlnbm9yZT8uZXhjbHVkZSgnLy52c2NvZGUnKTtcbiAgICB0aGlzLm5wbWlnbm9yZT8uZXhjbHVkZSgnLy5pZGVhJyk7XG4gICAgdGhpcy5ucG1pZ25vcmU/LmV4Y2x1ZGUoJy8ucHJvamVucmMuanMnKTtcbiAgICB0aGlzLm5wbWlnbm9yZT8uZXhjbHVkZSgndHNjb25maWcudHNidWlsZGluZm8nKTtcblxuICAgIC8vIHRlc3RzIGFyZSBjb21waWxlZCB0byBgbGliL1RFU1RESVJgLCBzbyB3ZSBkb24ndCBuZWVkIGplc3QgdG8gY29tcGlsZSB0aGVtIGZvciB1cy5cbiAgICAvLyBqdXN0IHJ1biB0aGVtIGRpcmVjdGx5IGZyb20gamF2YXNjcmlwdC5cbiAgICBpZiAodGhpcy5qZXN0ICYmIGNvbXBpbGVkVGVzdHMpIHtcbiAgICAgIHRoaXMuYWRkRGV2RGVwcygnQHR5cGVzL2plc3QnKTtcblxuICAgICAgY29uc3QgdGVzdG91dCA9IHBhdGgucG9zaXgucmVsYXRpdmUodGhpcy5zcmNkaXIsIHRoaXMudGVzdGRpcik7XG4gICAgICBjb25zdCBsaWJ0ZXN0ID0gcGF0aC5wb3NpeC5qb2luKHRoaXMubGliZGlyLCB0ZXN0b3V0KTtcbiAgICAgIGNvbnN0IHNyY3Rlc3QgPSB0aGlzLnRlc3RkaXI7XG5cbiAgICAgIHRoaXMubnBtaWdub3JlPy5hZGRQYXR0ZXJucyhgLyR7bGlidGVzdH1gKTtcbiAgICAgIHRoaXMuamVzdC5hZGRUZXN0TWF0Y2goYCoqLyR7bGlidGVzdH0vKiovPygqLikrKHNwZWN8dGVzdCkuanM/KHgpYCk7XG4gICAgICB0aGlzLmplc3QuYWRkV2F0Y2hJZ25vcmVQYXR0ZXJuKGAvJHt0aGlzLnNyY2Rpcn0vYCk7XG5cbiAgICAgIGNvbnN0IHJlc29sdmVTbmFwc2hvdFBhdGggPSAodGVzdDogc3RyaW5nLCBleHQ6IHN0cmluZykgPT4ge1xuICAgICAgICBjb25zdCBmdWxscGF0aCA9IHRlc3QucmVwbGFjZShsaWJ0ZXN0LCBzcmN0ZXN0KTtcbiAgICAgICAgcmV0dXJuIHBhdGguam9pbihwYXRoLmRpcm5hbWUoZnVsbHBhdGgpLCAnX19zbmFwc2hvdHNfXycsIHBhdGguYmFzZW5hbWUoZnVsbHBhdGgsICcuanMnKSArICcudHMnICsgZXh0KTtcbiAgICAgIH07XG5cbiAgICAgIGNvbnN0IHJlc29sdmVUZXN0UGF0aCA9IChzbmFwOiBzdHJpbmcsIGV4dDogc3RyaW5nKSA9PiB7XG4gICAgICAgIGNvbnN0IGZpbGVuYW1lID0gcGF0aC5iYXNlbmFtZShzbmFwLCAnLnRzJyArIGV4dCkgKyAnLmpzJztcbiAgICAgICAgY29uc3QgZGlyID0gcGF0aC5kaXJuYW1lKHBhdGguZGlybmFtZShzbmFwKSkucmVwbGFjZShzcmN0ZXN0LCBsaWJ0ZXN0KTtcbiAgICAgICAgcmV0dXJuIHBhdGguam9pbihkaXIsIGZpbGVuYW1lKTtcbiAgICAgIH07XG5cbiAgICAgIGNvbnN0IHJlc29sdmVyID0gbmV3IFRleHRGaWxlKHRoaXMsIHBhdGgucG9zaXguam9pbihQUk9KRU5fRElSLCAnamVzdC1zbmFwc2hvdC1yZXNvbHZlci5qcycpKTtcbiAgICAgIHJlc29sdmVyLmFkZExpbmUoJ2NvbnN0IHBhdGggPSByZXF1aXJlKFwicGF0aFwiKTsnKTtcbiAgICAgIHJlc29sdmVyLmFkZExpbmUoYGNvbnN0IGxpYnRlc3QgPSBcIiR7bGlidGVzdH1cIjtgKTtcbiAgICAgIHJlc29sdmVyLmFkZExpbmUoYGNvbnN0IHNyY3Rlc3Q9IFwiJHtzcmN0ZXN0fVwiO2ApO1xuICAgICAgcmVzb2x2ZXIuYWRkTGluZSgnbW9kdWxlLmV4cG9ydHMgPSB7Jyk7XG4gICAgICByZXNvbHZlci5hZGRMaW5lKGAgIHJlc29sdmVTbmFwc2hvdFBhdGg6ICR7cmVzb2x2ZVNuYXBzaG90UGF0aC50b1N0cmluZygpfSxgKTtcbiAgICAgIHJlc29sdmVyLmFkZExpbmUoYCAgcmVzb2x2ZVRlc3RQYXRoOiAke3Jlc29sdmVUZXN0UGF0aC50b1N0cmluZygpfSxgKTtcbiAgICAgIHJlc29sdmVyLmFkZExpbmUoJyAgdGVzdFBhdGhGb3JDb25zaXN0ZW5jeUNoZWNrOiBwYXRoLmpvaW4oXFwnc29tZVxcJywgXFwnX190ZXN0c19fXFwnLCBcXCdleGFtcGxlLnRlc3QuanNcXCcpJyk7XG4gICAgICByZXNvbHZlci5hZGRMaW5lKCd9OycpO1xuXG4gICAgICB0aGlzLmplc3QuYWRkU25hcHNob3RSZXNvbHZlcihgLi8ke3Jlc29sdmVyLnBhdGh9YCk7XG4gICAgfVxuXG4gICAgaWYgKHRoaXMuamVzdCAmJiAhY29tcGlsZWRUZXN0cykge1xuICAgICAgdGhpcy5qZXN0LmFkZFRlc3RNYXRjaCgnKipcXC9fX3Rlc3RzX18vKipcXC8qLnRzPyh4KScpO1xuICAgICAgdGhpcy5qZXN0LmFkZFRlc3RNYXRjaCgnKipcXC8/KCouKSsoc3BlY3x0ZXN0KS50cz8oeCknKTtcblxuICAgICAgY29uc3QgYmFzZVRzY29uZmlnOiBUeXBlc2NyaXB0Q29uZmlnT3B0aW9ucyA9IHtcbiAgICAgICAgZmlsZU5hbWU6ICd0c2NvbmZpZy5qZXN0Lmpzb24nLFxuICAgICAgICBpbmNsdWRlOiBbXG4gICAgICAgICAgUFJPSkVOX1JDLFxuICAgICAgICAgIGAke3RoaXMuc3JjZGlyfS8qKi8qLnRzYCxcbiAgICAgICAgICBgJHt0aGlzLnRlc3RkaXJ9LyoqLyoudHNgLFxuICAgICAgICBdLFxuICAgICAgICBleGNsdWRlOiBbXG4gICAgICAgICAgJ25vZGVfbW9kdWxlcycsXG4gICAgICAgIF0sXG4gICAgICAgIGNvbXBpbGVyT3B0aW9uczogY29tcGlsZXJPcHRpb25EZWZhdWx0cyxcbiAgICAgIH07XG5cbiAgICAgIC8vIGNyZWF0ZSBhIHRzY29uZmlnIGZvciBqZXN0IHRoYXQgZG9lcyBOT1QgaW5jbHVkZSBvdXREaXIgYW5kIHJvb3REaXIgYW5kXG4gICAgICAvLyBpbmNsdWRlcyBib3RoIFwic3JjXCIgYW5kIFwidGVzdFwiIGFzIGlucHV0cy5cbiAgICAgIGNvbnN0IHRzY29uZmlnID0gdGhpcy5qZXN0LmdlbmVyYXRlVHlwZXNjcmlwdENvbmZpZyhcbiAgICAgICAgbWVyZ2VUc2NvbmZpZ09wdGlvbnMoW2Jhc2VUc2NvbmZpZywgb3B0aW9ucy50c2NvbmZpZ10pKTtcblxuICAgICAgLy8gaWYgd2UgdGVzdCBiZWZvcmUgY29tcGlsYXRpb24sIHJlbW92ZSB0aGUgbGliLyBkaXJlY3RvcnkgYmVmb3JlIHJ1bm5pbmdcbiAgICAgIC8vIHRlc3RzIHNvIHRoYXQgd2UgZ2V0IGEgY2xlYW4gc2xhdGUgZm9yIHRlc3RpbmcuXG4gICAgICBpZiAoIWNvbXBpbGVCZWZvcmVUZXN0KSB7XG4gICAgICAgIC8vIG1ha2Ugc3VyZSB0byBkZWxldGUgXCJsaWJcIiAqYmVmb3JlKiBydW5uaW5nIHRlc3RzIHRvIGVuc3VyZSB0aGF0XG4gICAgICAgIC8vIHRlc3QgY29kZSBkb2VzIG5vdCB0YWtlIGEgZGVwZW5kZW5jeSBvbiBcImxpYlwiIGFuZCBpbnN0ZWFkIG9uIFwic3JjXCIuXG4gICAgICAgIHRoaXMudGVzdFRhc2sucHJlcGVuZEV4ZWMoYHJtIC1mciAke3RoaXMubGliZGlyfS9gKTtcbiAgICAgIH1cblxuICAgICAgLy8gY29tcGlsZSB0ZXN0IGNvZGVcbiAgICAgIHRoaXMudGVzdENvbXBpbGVUYXNrLmV4ZWMoYHRzYyAtLW5vRW1pdCAtLXByb2plY3QgJHt0c2NvbmZpZy5maWxlTmFtZX1gKTtcbiAgICB9XG5cbiAgICBpZiAob3B0aW9ucy5lc2xpbnQgPz8gdHJ1ZSkge1xuICAgICAgdGhpcy5lc2xpbnQgPSBuZXcgRXNsaW50KHRoaXMsIHtcbiAgICAgICAgdHNjb25maWdQYXRoOiAnLi90c2NvbmZpZy5lc2xpbnQuanNvbicsXG4gICAgICAgIGRpcnM6IFt0aGlzLnNyY2Rpcl0sXG4gICAgICAgIGRldmRpcnM6IFt0aGlzLnRlc3RkaXIsICdidWlsZC10b29scyddLFxuICAgICAgICBmaWxlRXh0ZW5zaW9uczogWycudHMnLCAnLnRzeCddLFxuICAgICAgICAuLi5vcHRpb25zLmVzbGludE9wdGlvbnMsXG4gICAgICB9KTtcblxuICAgICAgY29uc3QgYmFzZVRzY29uZmlnID0ge1xuICAgICAgICBmaWxlTmFtZTogJ3RzY29uZmlnLmVzbGludC5qc29uJyxcbiAgICAgICAgaW5jbHVkZTogW1xuICAgICAgICAgIFBST0pFTl9SQyxcbiAgICAgICAgICBgJHt0aGlzLnNyY2Rpcn0vKiovKi50c2AsXG4gICAgICAgICAgYCR7dGhpcy50ZXN0ZGlyfS8qKi8qLnRzYCxcbiAgICAgICAgXSxcbiAgICAgICAgZXhjbHVkZTogW1xuICAgICAgICAgICdub2RlX21vZHVsZXMnLFxuICAgICAgICBdLFxuICAgICAgICBjb21waWxlck9wdGlvbnM6IGNvbXBpbGVyT3B0aW9uRGVmYXVsdHMsXG4gICAgICB9O1xuXG4gICAgICB0aGlzLnRzY29uZmlnRXNsaW50ID0gbmV3IFR5cGVzY3JpcHRDb25maWcodGhpcywgbWVyZ2VUc2NvbmZpZ09wdGlvbnMoW2Jhc2VUc2NvbmZpZywgb3B0aW9ucy50c2NvbmZpZ10pKTtcbiAgICB9XG5cbiAgICBjb25zdCB0c3ZlciA9IG9wdGlvbnMudHlwZXNjcmlwdFZlcnNpb24gPyBgQCR7b3B0aW9ucy50eXBlc2NyaXB0VmVyc2lvbn1gIDogJyc7XG5cbiAgICB0aGlzLmFkZERldkRlcHMoXG4gICAgICBgdHlwZXNjcmlwdCR7dHN2ZXJ9YCxcbiAgICAgIGBAdHlwZXMvbm9kZUBeJHt0aGlzLnBhY2thZ2UubWluTm9kZVZlcnNpb24gPz8gJzEwLjE3LjAnfWAsIC8vIGluc3RhbGwgdGhlIG1pbmltdW0gdmVyc2lvbiB0byBlbnN1cmUgY29tcGF0aWJpbGl0eVxuICAgICk7XG5cbiAgICAvLyBnZW5lcmF0ZSBzYW1wbGUgY29kZSBpbiBgc3JjYCBhbmQgYGxpYmAgaWYgdGhlc2UgZGlyZWN0b3JpZXMgYXJlIGVtcHR5IG9yIG5vbi1leGlzdGVudC5cbiAgICBpZiAob3B0aW9ucy5zYW1wbGVDb2RlID8/IHRydWUpIHtcbiAgICAgIG5ldyBTYW1wbGVDb2RlKHRoaXMpO1xuICAgIH1cblxuICAgIGlmICh0aGlzLmRvY2dlbikge1xuICAgICAgbmV3IFR5cGVkb2NEb2NnZW4odGhpcyk7XG4gICAgfVxuXG4gICAgY29uc3QgcHJvamVucmNUeXBlU2NyaXB0ID0gb3B0aW9ucy5wcm9qZW5yY1RzID8/IGZhbHNlO1xuICAgIGlmIChwcm9qZW5yY1R5cGVTY3JpcHQpIHtcbiAgICAgIG5ldyBQcm9qZW5yYyh0aGlzLCBvcHRpb25zLnByb2plbnJjVHNPcHRpb25zKTtcbiAgICB9XG4gIH1cbn1cblxuY2xhc3MgU2FtcGxlQ29kZSBleHRlbmRzIENvbXBvbmVudCB7XG4gIGNvbnN0cnVjdG9yKHByb2plY3Q6IFR5cGVTY3JpcHRQcm9qZWN0KSB7XG4gICAgc3VwZXIocHJvamVjdCk7XG4gICAgY29uc3Qgc3JjQ29kZSA9IFtcbiAgICAgICdleHBvcnQgY2xhc3MgSGVsbG8geycsXG4gICAgICAnICBwdWJsaWMgc2F5SGVsbG8oKSB7JyxcbiAgICAgICcgICAgcmV0dXJuIFxcJ2hlbGxvLCB3b3JsZCFcXCc7JyxcbiAgICAgICcgIH0nLFxuICAgICAgJ30nLFxuICAgIF0uam9pbignXFxuJyk7XG5cbiAgICBjb25zdCB0ZXN0Q29kZSA9IFtcbiAgICAgIFwiaW1wb3J0IHsgSGVsbG8gfSBmcm9tICcuLi9zcmMnO1wiLFxuICAgICAgJycsXG4gICAgICBcInRlc3QoJ2hlbGxvJywgKCkgPT4ge1wiLFxuICAgICAgXCIgIGV4cGVjdChuZXcgSGVsbG8oKS5zYXlIZWxsbygpKS50b0JlKCdoZWxsbywgd29ybGQhJyk7XCIsXG4gICAgICAnfSk7JyxcbiAgICBdLmpvaW4oJ1xcbicpO1xuXG4gICAgbmV3IFNhbXBsZURpcihwcm9qZWN0LCBwcm9qZWN0LnNyY2Rpciwge1xuICAgICAgZmlsZXM6IHtcbiAgICAgICAgJ2luZGV4LnRzJzogc3JjQ29kZSxcbiAgICAgIH0sXG4gICAgfSk7XG5cbiAgICBuZXcgU2FtcGxlRGlyKHByb2plY3QsIHByb2plY3QudGVzdGRpciwge1xuICAgICAgZmlsZXM6IHtcbiAgICAgICAgJ2hlbGxvLnRlc3QudHMnOiB0ZXN0Q29kZSxcbiAgICAgIH0sXG4gICAgfSk7XG4gIH1cbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBUeXBlU2NyaXB0QXBwUHJvamVjdCBleHRlbmRzIFR5cGVTY3JpcHRQcm9qZWN0IHtcbiAgY29uc3RydWN0b3Iob3B0aW9uczogVHlwZVNjcmlwdFByb2plY3RPcHRpb25zKSB7XG4gICAgc3VwZXIoe1xuICAgICAgYWxsb3dMaWJyYXJ5RGVwZW5kZW5jaWVzOiBmYWxzZSxcbiAgICAgIHJlbGVhc2VXb3JrZmxvdzogZmFsc2UsXG4gICAgICBlbnRyeXBvaW50OiAnJywgLy8gXCJtYWluXCIgaXMgbm90IG5lZWRlZCBpbiB0eXBlc2NyaXB0IGFwcHNcbiAgICAgIHBhY2thZ2U6IGZhbHNlLFxuICAgICAgLi4ub3B0aW9ucyxcbiAgICB9KTtcbiAgfVxufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgVHlwZVNjcmlwdExpYnJhcnlQcm9qZWN0IGV4dGVuZHMgVHlwZVNjcmlwdFByb2plY3Qge1xufTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIFR5cGVTY3JpcHRMaWJyYXJ5UHJvamVjdE9wdGlvbnMgZXh0ZW5kcyBUeXBlU2NyaXB0UHJvamVjdE9wdGlvbnMge1xufVxuXG4vKipcbiAqIEBpbnRlcm5hbFxuICovXG5leHBvcnQgZnVuY3Rpb24gbWVyZ2VUc2NvbmZpZ09wdGlvbnMob3B0aW9uczogKFR5cGVzY3JpcHRDb25maWdPcHRpb25zIHwgdW5kZWZpbmVkKVtdKTogVHlwZXNjcmlwdENvbmZpZ09wdGlvbnMge1xuICBjb25zdCBkZWZpbmVkT3B0aW9ucyA9IG9wdGlvbnMuZmlsdGVyKEJvb2xlYW4pIGFzIFR5cGVzY3JpcHRDb25maWdPcHRpb25zW107XG4gIHJldHVybiBkZWZpbmVkT3B0aW9ucy5yZWR1Y2U8VHlwZXNjcmlwdENvbmZpZ09wdGlvbnM+KChwcmV2aW91cywgY3VycmVudCkgPT4gKHtcbiAgICAuLi5wcmV2aW91cyxcbiAgICAuLi5jdXJyZW50LFxuICAgIGluY2x1ZGU6IFtcbiAgICAgIC4uLnByZXZpb3VzLmluY2x1ZGUgPz8gW10sXG4gICAgICAuLi5jdXJyZW50LmluY2x1ZGUgPz8gW10sXG4gICAgXSxcbiAgICBleGNsdWRlOiBbXG4gICAgICAuLi5wcmV2aW91cy5leGNsdWRlID8/IFtdLFxuICAgICAgLi4uY3VycmVudC5leGNsdWRlID8/IFtdLFxuICAgIF0sXG4gICAgY29tcGlsZXJPcHRpb25zOiB7XG4gICAgICAuLi5wcmV2aW91cy5jb21waWxlck9wdGlvbnMsXG4gICAgICAuLi5jdXJyZW50LmNvbXBpbGVyT3B0aW9ucyxcbiAgICB9LFxuICB9KSwgeyBjb21waWxlck9wdGlvbnM6IHt9IH0pO1xufVxuIl19