"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpgradeDependenciesSchedule = exports.UpgradeDependencies = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("./component");
const github_1 = require("./github");
function context(value) {
    return `\${{ ${value} }}`;
}
function setOutput(name, value) {
    return `echo "::set-output name=${name}::${value}"`;
}
const RUNNER_TEMP = context('runner.temp');
const DEFAULT_TOKEN = context('secrets.GITHUB_TOKEN');
const REPO = context('github.repository');
const RUN_ID = context('github.run_id');
const RUN_URL = `https://github.com/${REPO}/actions/runs/${RUN_ID}`;
const UBUNTU_LATEST = 'ubuntu-latest';
/**
 * (experimental) Upgrade node project dependencies.
 *
 * @experimental
 */
class UpgradeDependencies extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options = {}) {
        var _c, _d;
        super(project);
        this._project = project;
        this.options = options;
        this.pullRequestTitle = (_c = options.pullRequestTitle) !== null && _c !== void 0 ? _c : 'upgrade dependencies';
        project.addDevDeps('npm-check-updates@^11');
        const task = this.createTask();
        if (project.github && ((_d = options.workflow) !== null && _d !== void 0 ? _d : true)) {
            this.workflow = this.createWorkflow(task, project.github);
        }
    }
    createTask() {
        var _c, _d, _e;
        const taskName = (_c = this.options.taskName) !== null && _c !== void 0 ? _c : 'upgrade-dependencies';
        const task = this._project.addTask(taskName, {
            // this task should not run in CI mode because its designed to
            // update package.json and lock files.
            env: { CI: '0' },
            description: this.pullRequestTitle,
        });
        const exclude = (_d = this.options.exclude) !== null && _d !== void 0 ? _d : [];
        if ((_e = this.options.ignoreProjen) !== null && _e !== void 0 ? _e : true) {
            exclude.push('projen');
        }
        const ncuCommand = ['npm-check-updates', '--upgrade', '--target=minor'];
        if (exclude.length > 0) {
            ncuCommand.push(`--reject='${exclude.join(',')}'`);
        }
        if (this.options.include) {
            ncuCommand.push(`--filter='${this.options.include.join(',')}'`);
        }
        task.exec(ncuCommand.join(' '));
        // run "yarn/npm install" to update the lockfile and install any deps (such as projen)
        task.exec(this._project.package.installAndUpdateLockfileCommand);
        // run upgrade command to upgrade transitive deps as well
        task.exec(this._project.package.renderUpgradePackagesCommand(exclude, this.options.include));
        // run "projen" to give projen a chance to update dependencies (it will also run "yarn install")
        task.exec(this._project.projenCommand);
        return task;
    }
    createWorkflow(task, github) {
        var _c, _d;
        const schedule = (_d = (_c = this.options.workflowOptions) === null || _c === void 0 ? void 0 : _c.schedule) !== null && _d !== void 0 ? _d : UpgradeDependenciesSchedule.DAILY;
        const workflow = github.addWorkflow(task.name);
        const triggers = {
            workflowDispatch: {},
            schedule: schedule.cron ? schedule.cron.map(e => ({ cron: e })) : undefined,
        };
        workflow.on(triggers);
        const upgrade = this.createUpgrade(task);
        const pr = this.createPr(workflow, upgrade);
        const jobs = {};
        jobs[upgrade.jobId] = upgrade.job;
        jobs[pr.jobId] = pr.job;
        workflow.addJobs(jobs);
        return workflow;
    }
    createUpgrade(task) {
        var _c, _d, _e;
        const build = (_d = (_c = this.options.workflowOptions) === null || _c === void 0 ? void 0 : _c.rebuild) !== null && _d !== void 0 ? _d : true;
        const patchFile = '.upgrade.tmp.patch';
        const buildStepId = 'build';
        const conclusion = 'conclusion';
        // thats all we should need at this stage since all we do is clone.
        // note that this also prevents new code that is introduced in the upgrade
        // to have write access to anything, in case its somehow executed. (for example during build)
        const permissions = {
            contents: github_1.workflows.JobPermission.READ,
        };
        const outputs = {};
        const steps = [
            {
                name: 'Checkout',
                uses: 'actions/checkout@v2',
            },
            ...this._project.installWorkflowSteps,
            {
                name: 'Upgrade dependencies',
                run: this._project.runTaskCommand(task),
            },
        ];
        if (build) {
            steps.push({
                name: 'Build',
                id: buildStepId,
                run: `${this._project.runTaskCommand(this._project.buildTask)} && ${setOutput(conclusion, 'success')} || ${setOutput(conclusion, 'failure')}`,
            });
            outputs[conclusion] = {
                stepId: buildStepId,
                outputName: conclusion,
            };
        }
        steps.push({
            name: 'Create Patch',
            run: [
                'git add .',
                `git diff --patch --staged > ${patchFile}`,
            ].join('\n'),
        }, {
            name: 'Upload patch',
            uses: 'actions/upload-artifact@v2',
            with: { name: patchFile, path: patchFile },
        });
        return {
            job: {
                name: 'Upgrade',
                container: (_e = this.options.workflowOptions) === null || _e === void 0 ? void 0 : _e.container,
                permissions: permissions,
                runsOn: UBUNTU_LATEST,
                outputs: outputs,
                steps: steps,
            },
            jobId: 'upgrade',
            patchFile: patchFile,
            build: build,
            buildConclusionOutput: conclusion,
        };
    }
    createPr(workflow, upgrade) {
        var _c, _d, _e;
        const customToken = ((_c = this.options.workflowOptions) === null || _c === void 0 ? void 0 : _c.secret) ? context(`secrets.${this.options.workflowOptions.secret}`) : undefined;
        const workflowName = workflow.name;
        const branchName = `github-actions/${workflowName}`;
        const prStepId = 'create-pr';
        const title = `chore(deps): ${this.pullRequestTitle}`;
        const description = [
            'Upgrades project dependencies. See details in [workflow run].',
            '',
            `[Workflow Run]: ${RUN_URL}`,
            '',
            '------',
            '',
            `*Automatically created by projen via the "${workflow.name}" workflow*`,
        ].join('\n');
        const steps = [
            {
                name: 'Checkout',
                uses: 'actions/checkout@v2',
            },
            {
                name: 'Download patch',
                uses: 'actions/download-artifact@v2',
                with: { name: upgrade.patchFile, path: RUNNER_TEMP },
            },
            {
                name: 'Apply patch',
                run: `[ -s ${RUNNER_TEMP}/${upgrade.patchFile} ] && git apply ${RUNNER_TEMP}/${upgrade.patchFile} || echo "Empty patch. Skipping."`,
            },
            {
                name: 'Create Pull Request',
                id: prStepId,
                uses: 'peter-evans/create-pull-request@v3',
                with: {
                    // the pr can modify workflow files, so we need to use the custom
                    // secret if one is configured.
                    'token': customToken !== null && customToken !== void 0 ? customToken : DEFAULT_TOKEN,
                    'commit-message': `${title}\n\n${description}`,
                    'branch': branchName,
                    'title': title,
                    'labels': ((_e = (_d = this.options.workflowOptions) === null || _d === void 0 ? void 0 : _d.labels) === null || _e === void 0 ? void 0 : _e.join(',')) || undefined,
                    'body': description,
                },
            },
        ];
        let writeChecksPermission = false;
        if (this._project.buildWorkflowJobId && upgrade.build) {
            const body = {
                name: this._project.buildWorkflowJobId,
                head_sha: branchName,
                status: 'completed',
                conclusion: context(`needs.${upgrade.jobId}.outputs.${upgrade.buildConclusionOutput}`),
                output: {
                    title: `Created via the ${workflowName} workflow.`,
                    summary: `Action run URL: ${RUN_URL}`,
                },
            };
            steps.push({
                name: 'Update status check',
                if: `steps.${prStepId}.outputs.pull-request-url != \'\'`,
                run: 'curl -i --fail '
                    + '-X POST '
                    + '-H "Accept: application/vnd.github.v3+json" '
                    + `-H "Authorization: token \${GITHUB_TOKEN}" https://api.github.com/repos/${REPO}/check-runs `
                    + `-d '${JSON.stringify(body)}'`,
                env: { GITHUB_TOKEN: DEFAULT_TOKEN },
            });
            // necessary to update status checks
            writeChecksPermission = true;
        }
        return {
            job: {
                name: 'Create Pull Request',
                needs: [upgrade.jobId],
                permissions: {
                    contents: github_1.workflows.JobPermission.WRITE,
                    pullRequests: github_1.workflows.JobPermission.WRITE,
                    checks: writeChecksPermission ? github_1.workflows.JobPermission.WRITE : undefined,
                },
                runsOn: UBUNTU_LATEST,
                steps: steps,
            },
            jobId: 'pr',
        };
    }
}
exports.UpgradeDependencies = UpgradeDependencies;
_a = JSII_RTTI_SYMBOL_1;
UpgradeDependencies[_a] = { fqn: "projen.UpgradeDependencies", version: "0.27.22" };
/**
 * (experimental) How often to check for new versions and raise pull requests for version upgrades.
 *
 * @experimental
 */
class UpgradeDependenciesSchedule {
    constructor(cron) {
        this.cron = cron;
    }
    /**
     * (experimental) Create a schedule from a raw cron expression.
     *
     * @experimental
     */
    static expressions(cron) {
        return new UpgradeDependenciesSchedule(cron);
    }
}
exports.UpgradeDependenciesSchedule = UpgradeDependenciesSchedule;
_b = JSII_RTTI_SYMBOL_1;
UpgradeDependenciesSchedule[_b] = { fqn: "projen.UpgradeDependenciesSchedule", version: "0.27.22" };
/**
 * (experimental) Disables automatic upgrades.
 *
 * @experimental
 */
UpgradeDependenciesSchedule.NEVER = new UpgradeDependenciesSchedule([]);
/**
 * (experimental) At 00:00.
 *
 * @experimental
 */
UpgradeDependenciesSchedule.DAILY = new UpgradeDependenciesSchedule(['0 0 * * *']);
/**
 * (experimental) At 00:00 on every day-of-week from Monday through Friday.
 *
 * @experimental
 */
UpgradeDependenciesSchedule.WEEKDAY = new UpgradeDependenciesSchedule(['0 0 * * 1-5']);
/**
 * (experimental) At 00:00 on Monday.
 *
 * @experimental
 */
UpgradeDependenciesSchedule.WEEKLY = new UpgradeDependenciesSchedule(['0 0 * * 1']);
/**
 * (experimental) At 00:00 on day-of-month 1.
 *
 * @experimental
 */
UpgradeDependenciesSchedule.MONTHLY = new UpgradeDependenciesSchedule(['0 0 1 * *']);
//# sourceMappingURL=data:application/json;base64,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