import { Component } from './component';
import { Project } from './project';
import { Task } from './tasks';
/**
 * (experimental) Options for `Version`.
 *
 * @experimental
 */
export interface VersionOptions {
    /**
     * (experimental) A name of a .json file to set the `version` field in after a bump.
     *
     * @experimental
     * @example
     *
     * "package.json"
     */
    readonly versionInputFile: string;
    /**
     * (experimental) The name of the directory into which `changelog.md` and `version.txt` files are emitted.
     *
     * @experimental
     */
    readonly artifactsDirectory: string;
}
/**
 * @experimental
 */
export declare class Version extends Component {
    /**
     * @experimental
     */
    static readonly STANDARD_VERSION = "standard-version@^9";
    /**
     * @experimental
     */
    readonly bumpTask: Task;
    /**
     * @experimental
     */
    readonly unbumpTask: Task;
    /**
     * (experimental) The name of the changelog file (under `artifactsDirectory`).
     *
     * @experimental
     */
    readonly changelogFileName: string;
    /**
     * (experimental) The name of the file that contains the version (under `artifactsDirectory`).
     *
     * @experimental
     */
    readonly versionFileName: string;
    /**
     * @experimental
     */
    constructor(project: Project, options: VersionOptions);
}
