"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Version = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const component_1 = require("./component");
/**
 * @experimental
 */
class Version extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options) {
        super(project);
        this.changelogFileName = 'changelog.md';
        this.versionFileName = 'version.txt';
        const versionInputFile = options.versionInputFile;
        // this command determines if there were any changes since the last release
        // (the top-most commit is not a bump). it is used as a condition for both
        // the `bump` and the `release` tasks.
        const changesSinceLastRelease = '! git log --oneline -1 | grep -q "chore(release):"';
        const changelogFile = path_1.posix.join(options.artifactsDirectory, this.changelogFileName);
        const bumpFile = path_1.posix.join(options.artifactsDirectory, this.versionFileName);
        const env = {
            OUTFILE: versionInputFile,
            CHANGELOG: changelogFile,
            BUMPFILE: bumpFile,
        };
        this.bumpTask = project.addTask('bump', {
            description: 'Bumps version based on latest git tag and generates a changelog entry',
            condition: changesSinceLastRelease,
            env: env,
        });
        this.bumpTask.builtin('release/bump-version');
        this.unbumpTask = project.addTask('unbump', {
            description: 'Restores version to 0.0.0',
            env: env,
        });
        this.unbumpTask.builtin('release/reset-version');
        project.addGitIgnore(`/${changelogFile}`);
        project.addGitIgnore(`/${bumpFile}`);
        project.addPackageIgnore(`/${changelogFile}`);
        project.addPackageIgnore(`/${bumpFile}`);
    }
}
exports.Version = Version;
_a = JSII_RTTI_SYMBOL_1;
Version[_a] = { fqn: "projen.Version", version: "0.27.22" };
/**
 * @experimental
 */
Version.STANDARD_VERSION = 'standard-version@^9';
//# sourceMappingURL=data:application/json;base64,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