# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    The version of the OpenAPI document: 0.11.2668
    Contact: info@finbourne.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from lusid.api_client import ApiClient
from lusid.exceptions import (
    ApiTypeError,
    ApiValueError
)


class PersonsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_person(self, id_type_scope, id_type_code, code, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Delete person  # noqa: E501

        Delete a person. Deletion will be valid from the person's creation datetime.  This means that the person will no longer exist at any effective datetime from the asAt datetime of deletion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_person(id_type_scope, id_type_code, code, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: The scope of the person identifier type. (required)
        :param str id_type_code: The code of the person identifier type. (required)
        :param str code: Code of the person under specified identifier type scope and code. This together with defined              identifier type uniquely identifies the person to delete. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeletedEntityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_person_with_http_info(id_type_scope, id_type_code, code, **kwargs)  # noqa: E501

    def delete_person_with_http_info(self, id_type_scope, id_type_code, code, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Delete person  # noqa: E501

        Delete a person. Deletion will be valid from the person's creation datetime.  This means that the person will no longer exist at any effective datetime from the asAt datetime of deletion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_person_with_http_info(id_type_scope, id_type_code, code, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: The scope of the person identifier type. (required)
        :param str id_type_code: The code of the person identifier type. (required)
        :param str code: Code of the person under specified identifier type scope and code. This together with defined              identifier type uniquely identifies the person to delete. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id_type_scope', 'id_type_code', 'code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_person" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id_type_scope' is set
        if ('id_type_scope' not in local_var_params or
                local_var_params['id_type_scope'] is None):
            raise ApiValueError("Missing the required parameter `id_type_scope` when calling `delete_person`")  # noqa: E501
        # verify the required parameter 'id_type_code' is set
        if ('id_type_code' not in local_var_params or
                local_var_params['id_type_code'] is None):
            raise ApiValueError("Missing the required parameter `id_type_code` when calling `delete_person`")  # noqa: E501
        # verify the required parameter 'code' is set
        if ('code' not in local_var_params or
                local_var_params['code'] is None):
            raise ApiValueError("Missing the required parameter `code` when calling `delete_person`")  # noqa: E501

        if ('code' in local_var_params and
                len(local_var_params['code']) > 64):
            raise ApiValueError("Invalid value for parameter `code` when calling `delete_person`, length must be less than or equal to `64`")  # noqa: E501
        if ('code' in local_var_params and
                len(local_var_params['code']) < 1):
            raise ApiValueError("Invalid value for parameter `code` when calling `delete_person`, length must be greater than or equal to `1`")  # noqa: E501
        if 'code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `delete_person`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id_type_scope' in local_var_params:
            path_params['idTypeScope'] = local_var_params['id_type_scope']  # noqa: E501
        if 'id_type_code' in local_var_params:
            path_params['idTypeCode'] = local_var_params['id_type_code']  # noqa: E501
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501


        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.11.2668'

        return self.api_client.call_api(
            '/api/persons/{idTypeScope}/{idTypeCode}/{code}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeletedEntityResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_person_access_metadata(self, id_type_scope, id_type_code, code, metadata_key, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Delete a Person Access Metadata entry  # noqa: E501

        Deletes the Person Access Metadata entry that exactly matches the provided identifier parts.    It is important to always check to verify success (or failure).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_person_access_metadata(id_type_scope, id_type_code, code, metadata_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the person identifier. (required)
        :param str id_type_code: Code of the person identifier. (required)
        :param str code: Code of the person under specified identifier type's scope and code. (required)
        :param str metadata_key: Key of the metadata entry to retrieve (required)
        :param str effective_at: The effective date to delete at, if this is not supplied, it will delete all data found
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeletedEntityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_person_access_metadata_with_http_info(id_type_scope, id_type_code, code, metadata_key, **kwargs)  # noqa: E501

    def delete_person_access_metadata_with_http_info(self, id_type_scope, id_type_code, code, metadata_key, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Delete a Person Access Metadata entry  # noqa: E501

        Deletes the Person Access Metadata entry that exactly matches the provided identifier parts.    It is important to always check to verify success (or failure).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_person_access_metadata_with_http_info(id_type_scope, id_type_code, code, metadata_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the person identifier. (required)
        :param str id_type_code: Code of the person identifier. (required)
        :param str code: Code of the person under specified identifier type's scope and code. (required)
        :param str metadata_key: Key of the metadata entry to retrieve (required)
        :param str effective_at: The effective date to delete at, if this is not supplied, it will delete all data found
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id_type_scope', 'id_type_code', 'code', 'metadata_key', 'effective_at']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_person_access_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id_type_scope' is set
        if ('id_type_scope' not in local_var_params or
                local_var_params['id_type_scope'] is None):
            raise ApiValueError("Missing the required parameter `id_type_scope` when calling `delete_person_access_metadata`")  # noqa: E501
        # verify the required parameter 'id_type_code' is set
        if ('id_type_code' not in local_var_params or
                local_var_params['id_type_code'] is None):
            raise ApiValueError("Missing the required parameter `id_type_code` when calling `delete_person_access_metadata`")  # noqa: E501
        # verify the required parameter 'code' is set
        if ('code' not in local_var_params or
                local_var_params['code'] is None):
            raise ApiValueError("Missing the required parameter `code` when calling `delete_person_access_metadata`")  # noqa: E501
        # verify the required parameter 'metadata_key' is set
        if ('metadata_key' not in local_var_params or
                local_var_params['metadata_key'] is None):
            raise ApiValueError("Missing the required parameter `metadata_key` when calling `delete_person_access_metadata`")  # noqa: E501

        if ('code' in local_var_params and
                len(local_var_params['code']) > 64):
            raise ApiValueError("Invalid value for parameter `code` when calling `delete_person_access_metadata`, length must be less than or equal to `64`")  # noqa: E501
        if ('code' in local_var_params and
                len(local_var_params['code']) < 1):
            raise ApiValueError("Invalid value for parameter `code` when calling `delete_person_access_metadata`, length must be greater than or equal to `1`")  # noqa: E501
        if 'code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `delete_person_access_metadata`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id_type_scope' in local_var_params:
            path_params['idTypeScope'] = local_var_params['id_type_scope']  # noqa: E501
        if 'id_type_code' in local_var_params:
            path_params['idTypeCode'] = local_var_params['id_type_code']  # noqa: E501
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501
        if 'metadata_key' in local_var_params:
            path_params['metadataKey'] = local_var_params['metadata_key']  # noqa: E501

        query_params = []
        if 'effective_at' in local_var_params:
            query_params.append(('effectiveAt', local_var_params['effective_at']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501


        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.11.2668'

        return self.api_client.call_api(
            '/api/persons/{idTypeScope}/{idTypeCode}/{code}/metadata/{metadataKey}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeletedEntityResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_person_identifiers(self, id_type_scope, id_type_code, code, property_keys, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Delete Person Identifiers  # noqa: E501

        Delete identifiers belong to the given property keys of the person  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_person_identifiers(id_type_scope, id_type_code, code, property_keys, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the person identifier type. (required)
        :param str id_type_code: Code of the person identifier type. (required)
        :param str code: Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person. (required)
        :param list[str] property_keys: The property keys of the identifiers to delete. These take the format              {domain}/{scope}/{code} e.g. \"Person/CompanyDetails/Role\". Each property must be from the \"Person\" domain. Identifiers or identifiers not specified in request will not be changed. (required)
        :param str effective_at: The effective datetime or cut label at which to delete the identifiers. Defaults to the current LUSID system datetime if not specified.              Must not include an effective datetime of identifiers are perpetual.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeletedEntityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_person_identifiers_with_http_info(id_type_scope, id_type_code, code, property_keys, **kwargs)  # noqa: E501

    def delete_person_identifiers_with_http_info(self, id_type_scope, id_type_code, code, property_keys, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Delete Person Identifiers  # noqa: E501

        Delete identifiers belong to the given property keys of the person  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_person_identifiers_with_http_info(id_type_scope, id_type_code, code, property_keys, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the person identifier type. (required)
        :param str id_type_code: Code of the person identifier type. (required)
        :param str code: Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person. (required)
        :param list[str] property_keys: The property keys of the identifiers to delete. These take the format              {domain}/{scope}/{code} e.g. \"Person/CompanyDetails/Role\". Each property must be from the \"Person\" domain. Identifiers or identifiers not specified in request will not be changed. (required)
        :param str effective_at: The effective datetime or cut label at which to delete the identifiers. Defaults to the current LUSID system datetime if not specified.              Must not include an effective datetime of identifiers are perpetual.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id_type_scope', 'id_type_code', 'code', 'property_keys', 'effective_at']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_person_identifiers" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'property_keys' is set
        if ('property_keys' not in local_var_params or
                local_var_params['property_keys'] is None):
            raise ApiValueError("Missing the required parameter `property_keys` when calling `delete_person_identifiers`")  # noqa: E501

        if ('code' in local_var_params and
                len(local_var_params['code']) > 64):
            raise ApiValueError("Invalid value for parameter `code` when calling `delete_person_identifiers`, length must be less than or equal to `64`")  # noqa: E501
        if ('code' in local_var_params and
                len(local_var_params['code']) < 1):
            raise ApiValueError("Invalid value for parameter `code` when calling `delete_person_identifiers`, length must be greater than or equal to `1`")  # noqa: E501
        if 'code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `delete_person_identifiers`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id_type_scope' in local_var_params:
            path_params['idTypeScope'] = local_var_params['id_type_scope']  # noqa: E501
        if 'id_type_code' in local_var_params:
            path_params['idTypeCode'] = local_var_params['id_type_code']  # noqa: E501
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501

        query_params = []
        if 'property_keys' in local_var_params:
            query_params.append(('propertyKeys', local_var_params['property_keys']))  # noqa: E501
            collection_formats['propertyKeys'] = 'multi'  # noqa: E501
        if 'effective_at' in local_var_params:
            query_params.append(('effectiveAt', local_var_params['effective_at']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501


        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.11.2668'

        return self.api_client.call_api(
            '/api/persons/{idTypeScope}/{idTypeCode}/{code}/identifiers', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeletedEntityResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_person_properties(self, id_type_scope, id_type_code, code, property_keys, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Delete Person Properties  # noqa: E501

        Delete all properties belong to the given property keys of the person  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_person_properties(id_type_scope, id_type_code, code, property_keys, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the person identifier type. (required)
        :param str id_type_code: Code of the person identifier type. (required)
        :param str code: Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person. (required)
        :param list[str] property_keys: The property keys of the person's properties to delete. These take the format              {domain}/{scope}/{code} e.g. \"Person/CompanyDetails/Role\". Each property must be from the \"Person\" domain. Properties or identifiers not specified in request will not be changed. (required)
        :param str effective_at: The effective datetime or cut label at which to delete the properties. Defaults to the current LUSID system datetime if not specified.              Must not include an effective datetime of properties are perpetual.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeletedEntityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_person_properties_with_http_info(id_type_scope, id_type_code, code, property_keys, **kwargs)  # noqa: E501

    def delete_person_properties_with_http_info(self, id_type_scope, id_type_code, code, property_keys, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Delete Person Properties  # noqa: E501

        Delete all properties belong to the given property keys of the person  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_person_properties_with_http_info(id_type_scope, id_type_code, code, property_keys, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the person identifier type. (required)
        :param str id_type_code: Code of the person identifier type. (required)
        :param str code: Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person. (required)
        :param list[str] property_keys: The property keys of the person's properties to delete. These take the format              {domain}/{scope}/{code} e.g. \"Person/CompanyDetails/Role\". Each property must be from the \"Person\" domain. Properties or identifiers not specified in request will not be changed. (required)
        :param str effective_at: The effective datetime or cut label at which to delete the properties. Defaults to the current LUSID system datetime if not specified.              Must not include an effective datetime of properties are perpetual.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id_type_scope', 'id_type_code', 'code', 'property_keys', 'effective_at']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_person_properties" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'property_keys' is set
        if ('property_keys' not in local_var_params or
                local_var_params['property_keys'] is None):
            raise ApiValueError("Missing the required parameter `property_keys` when calling `delete_person_properties`")  # noqa: E501

        if ('code' in local_var_params and
                len(local_var_params['code']) > 64):
            raise ApiValueError("Invalid value for parameter `code` when calling `delete_person_properties`, length must be less than or equal to `64`")  # noqa: E501
        if ('code' in local_var_params and
                len(local_var_params['code']) < 1):
            raise ApiValueError("Invalid value for parameter `code` when calling `delete_person_properties`, length must be greater than or equal to `1`")  # noqa: E501
        if 'code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `delete_person_properties`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id_type_scope' in local_var_params:
            path_params['idTypeScope'] = local_var_params['id_type_scope']  # noqa: E501
        if 'id_type_code' in local_var_params:
            path_params['idTypeCode'] = local_var_params['id_type_code']  # noqa: E501
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501

        query_params = []
        if 'property_keys' in local_var_params:
            query_params.append(('propertyKeys', local_var_params['property_keys']))  # noqa: E501
            collection_formats['propertyKeys'] = 'multi'  # noqa: E501
        if 'effective_at' in local_var_params:
            query_params.append(('effectiveAt', local_var_params['effective_at']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501


        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.11.2668'

        return self.api_client.call_api(
            '/api/persons/{idTypeScope}/{idTypeCode}/{code}/properties', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeletedEntityResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_person_access_metadata(self, id_type_scope, id_type_code, code, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Get Access Metadata rules for a Person  # noqa: E501

        Pass the Scope and Code of the Person identifier along with the person code parameter to retrieve the associated Access Metadata  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_person_access_metadata(id_type_scope, id_type_code, code, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the person identifier. (required)
        :param str id_type_code: Code of the person identifier. (required)
        :param str code: Code of the person under specified identifier type's scope and code. (required)
        :param str effective_at: The effectiveAt datetime at which to retrieve the Access Metadata
        :param datetime as_at: The asAt datetime at which to retrieve the Access Metadata
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: dict(str, list[AccessMetadataValue])
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_all_person_access_metadata_with_http_info(id_type_scope, id_type_code, code, **kwargs)  # noqa: E501

    def get_all_person_access_metadata_with_http_info(self, id_type_scope, id_type_code, code, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Get Access Metadata rules for a Person  # noqa: E501

        Pass the Scope and Code of the Person identifier along with the person code parameter to retrieve the associated Access Metadata  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_person_access_metadata_with_http_info(id_type_scope, id_type_code, code, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the person identifier. (required)
        :param str id_type_code: Code of the person identifier. (required)
        :param str code: Code of the person under specified identifier type's scope and code. (required)
        :param str effective_at: The effectiveAt datetime at which to retrieve the Access Metadata
        :param datetime as_at: The asAt datetime at which to retrieve the Access Metadata
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(dict(str, list[AccessMetadataValue]), status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id_type_scope', 'id_type_code', 'code', 'effective_at', 'as_at']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_person_access_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id_type_scope' is set
        if ('id_type_scope' not in local_var_params or
                local_var_params['id_type_scope'] is None):
            raise ApiValueError("Missing the required parameter `id_type_scope` when calling `get_all_person_access_metadata`")  # noqa: E501
        # verify the required parameter 'id_type_code' is set
        if ('id_type_code' not in local_var_params or
                local_var_params['id_type_code'] is None):
            raise ApiValueError("Missing the required parameter `id_type_code` when calling `get_all_person_access_metadata`")  # noqa: E501
        # verify the required parameter 'code' is set
        if ('code' not in local_var_params or
                local_var_params['code'] is None):
            raise ApiValueError("Missing the required parameter `code` when calling `get_all_person_access_metadata`")  # noqa: E501

        if ('code' in local_var_params and
                len(local_var_params['code']) > 64):
            raise ApiValueError("Invalid value for parameter `code` when calling `get_all_person_access_metadata`, length must be less than or equal to `64`")  # noqa: E501
        if ('code' in local_var_params and
                len(local_var_params['code']) < 1):
            raise ApiValueError("Invalid value for parameter `code` when calling `get_all_person_access_metadata`, length must be greater than or equal to `1`")  # noqa: E501
        if 'code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `get_all_person_access_metadata`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id_type_scope' in local_var_params:
            path_params['idTypeScope'] = local_var_params['id_type_scope']  # noqa: E501
        if 'id_type_code' in local_var_params:
            path_params['idTypeCode'] = local_var_params['id_type_code']  # noqa: E501
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501

        query_params = []
        if 'effective_at' in local_var_params:
            query_params.append(('effectiveAt', local_var_params['effective_at']))  # noqa: E501
        if 'as_at' in local_var_params:
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501


        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.11.2668'

        return self.api_client.call_api(
            '/api/persons/{idTypeScope}/{idTypeCode}/{code}/metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, list[AccessMetadataValue])',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_person(self, id_type_scope, id_type_code, code, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Get Person  # noqa: E501

        Retrieve the definition of a person.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_person(id_type_scope, id_type_code, code, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the person identifier type. (required)
        :param str id_type_code: Code of the person identifier type. (required)
        :param str code: Code of the person under specified scope and code. This together with stated identifier type uniquely              identifies the person. (required)
        :param list[str] property_keys: A list of property keys from the \"Person\" domain to decorate onto each person.              These take the format {domain}/{scope}/{code} e.g. \"Person/ContactDetails/Address\". Defaults to include all properties if not specified.
        :param str effective_at: The effective datetime or cut label at which to retrieve the person. Defaults to the current LUSID system datetime if not specified.
        :param datetime as_at: The asAt datetime at which to retrieve the person. Defaults to return the latest version of the person if not specified.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Person
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_person_with_http_info(id_type_scope, id_type_code, code, **kwargs)  # noqa: E501

    def get_person_with_http_info(self, id_type_scope, id_type_code, code, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Get Person  # noqa: E501

        Retrieve the definition of a person.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_person_with_http_info(id_type_scope, id_type_code, code, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the person identifier type. (required)
        :param str id_type_code: Code of the person identifier type. (required)
        :param str code: Code of the person under specified scope and code. This together with stated identifier type uniquely              identifies the person. (required)
        :param list[str] property_keys: A list of property keys from the \"Person\" domain to decorate onto each person.              These take the format {domain}/{scope}/{code} e.g. \"Person/ContactDetails/Address\". Defaults to include all properties if not specified.
        :param str effective_at: The effective datetime or cut label at which to retrieve the person. Defaults to the current LUSID system datetime if not specified.
        :param datetime as_at: The asAt datetime at which to retrieve the person. Defaults to return the latest version of the person if not specified.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Person, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id_type_scope', 'id_type_code', 'code', 'property_keys', 'effective_at', 'as_at']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_person" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if ('code' in local_var_params and
                len(local_var_params['code']) > 64):
            raise ApiValueError("Invalid value for parameter `code` when calling `get_person`, length must be less than or equal to `64`")  # noqa: E501
        if ('code' in local_var_params and
                len(local_var_params['code']) < 1):
            raise ApiValueError("Invalid value for parameter `code` when calling `get_person`, length must be greater than or equal to `1`")  # noqa: E501
        if 'code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `get_person`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id_type_scope' in local_var_params:
            path_params['idTypeScope'] = local_var_params['id_type_scope']  # noqa: E501
        if 'id_type_code' in local_var_params:
            path_params['idTypeCode'] = local_var_params['id_type_code']  # noqa: E501
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501

        query_params = []
        if 'property_keys' in local_var_params:
            query_params.append(('propertyKeys', local_var_params['property_keys']))  # noqa: E501
            collection_formats['propertyKeys'] = 'multi'  # noqa: E501
        if 'effective_at' in local_var_params:
            query_params.append(('effectiveAt', local_var_params['effective_at']))  # noqa: E501
        if 'as_at' in local_var_params:
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501


        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.11.2668'

        return self.api_client.call_api(
            '/api/persons/{idTypeScope}/{idTypeCode}/{code}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Person',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_person_access_metadata_by_key(self, id_type_scope, id_type_code, code, metadata_key, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Get an entry identified by a metadataKey in the Access Metadata of a Person  # noqa: E501

        Get a specific Person Access Metadata by specifying the corresponding identifier parts and Person code                No matching will be performed through this endpoint. To retrieve an entry, it is necessary to specify, exactly, the identifier of the entry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_person_access_metadata_by_key(id_type_scope, id_type_code, code, metadata_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the person identifier. (required)
        :param str id_type_code: Code of the person identifier. (required)
        :param str code: Code of the person under specified identifier type's scope and code. (required)
        :param str metadata_key: Key of the metadata entry to retrieve (required)
        :param str effective_at: The effectiveAt datetime at which to retrieve the Access Metadata
        :param datetime as_at: The asAt datetime at which to retrieve the Access Metadata
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[AccessMetadataValue]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_person_access_metadata_by_key_with_http_info(id_type_scope, id_type_code, code, metadata_key, **kwargs)  # noqa: E501

    def get_person_access_metadata_by_key_with_http_info(self, id_type_scope, id_type_code, code, metadata_key, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Get an entry identified by a metadataKey in the Access Metadata of a Person  # noqa: E501

        Get a specific Person Access Metadata by specifying the corresponding identifier parts and Person code                No matching will be performed through this endpoint. To retrieve an entry, it is necessary to specify, exactly, the identifier of the entry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_person_access_metadata_by_key_with_http_info(id_type_scope, id_type_code, code, metadata_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the person identifier. (required)
        :param str id_type_code: Code of the person identifier. (required)
        :param str code: Code of the person under specified identifier type's scope and code. (required)
        :param str metadata_key: Key of the metadata entry to retrieve (required)
        :param str effective_at: The effectiveAt datetime at which to retrieve the Access Metadata
        :param datetime as_at: The asAt datetime at which to retrieve the Access Metadata
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[AccessMetadataValue], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id_type_scope', 'id_type_code', 'code', 'metadata_key', 'effective_at', 'as_at']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_person_access_metadata_by_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id_type_scope' is set
        if ('id_type_scope' not in local_var_params or
                local_var_params['id_type_scope'] is None):
            raise ApiValueError("Missing the required parameter `id_type_scope` when calling `get_person_access_metadata_by_key`")  # noqa: E501
        # verify the required parameter 'id_type_code' is set
        if ('id_type_code' not in local_var_params or
                local_var_params['id_type_code'] is None):
            raise ApiValueError("Missing the required parameter `id_type_code` when calling `get_person_access_metadata_by_key`")  # noqa: E501
        # verify the required parameter 'code' is set
        if ('code' not in local_var_params or
                local_var_params['code'] is None):
            raise ApiValueError("Missing the required parameter `code` when calling `get_person_access_metadata_by_key`")  # noqa: E501
        # verify the required parameter 'metadata_key' is set
        if ('metadata_key' not in local_var_params or
                local_var_params['metadata_key'] is None):
            raise ApiValueError("Missing the required parameter `metadata_key` when calling `get_person_access_metadata_by_key`")  # noqa: E501

        if ('code' in local_var_params and
                len(local_var_params['code']) > 64):
            raise ApiValueError("Invalid value for parameter `code` when calling `get_person_access_metadata_by_key`, length must be less than or equal to `64`")  # noqa: E501
        if ('code' in local_var_params and
                len(local_var_params['code']) < 1):
            raise ApiValueError("Invalid value for parameter `code` when calling `get_person_access_metadata_by_key`, length must be greater than or equal to `1`")  # noqa: E501
        if 'code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `get_person_access_metadata_by_key`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id_type_scope' in local_var_params:
            path_params['idTypeScope'] = local_var_params['id_type_scope']  # noqa: E501
        if 'id_type_code' in local_var_params:
            path_params['idTypeCode'] = local_var_params['id_type_code']  # noqa: E501
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501
        if 'metadata_key' in local_var_params:
            path_params['metadataKey'] = local_var_params['metadata_key']  # noqa: E501

        query_params = []
        if 'effective_at' in local_var_params:
            query_params.append(('effectiveAt', local_var_params['effective_at']))  # noqa: E501
        if 'as_at' in local_var_params:
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501


        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.11.2668'

        return self.api_client.call_api(
            '/api/persons/{idTypeScope}/{idTypeCode}/{code}/metadata/{metadataKey}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AccessMetadataValue]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_person_relations(self, id_type_scope, id_type_code, code, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Get Relations for Person  # noqa: E501

        Get relations for the specified Person  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_person_relations(id_type_scope, id_type_code, code, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the person identifier type. (required)
        :param str id_type_code: Code of the person identifier type. (required)
        :param str code: Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person. (required)
        :param str effective_at: The effective datetime or cut label at which to get relations. Defaults to the current LUSID system datetime if not specified.
        :param datetime as_at: The asAt datetime at which to retrieve the person's relations. Defaults to return the latest LUSID AsAt time if not specified.
        :param str filter: Expression to filter the relations. Users should provide null or empty string for this field until further notice.
        :param list[str] identifier_types: Identifiers types (as property keys) used for referencing Persons or Legal Entities. These take the format              {domain}/{scope}/{code} e.g. \"Person/CompanyDetails/Role\". They must be from the \"Person\" or \"LegalEntity\" domain.              Only identifier types stated will be used to look up relevant entities in relations. If not applicable, provide an empty array.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ResourceListOfRelation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_person_relations_with_http_info(id_type_scope, id_type_code, code, **kwargs)  # noqa: E501

    def get_person_relations_with_http_info(self, id_type_scope, id_type_code, code, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Get Relations for Person  # noqa: E501

        Get relations for the specified Person  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_person_relations_with_http_info(id_type_scope, id_type_code, code, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the person identifier type. (required)
        :param str id_type_code: Code of the person identifier type. (required)
        :param str code: Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person. (required)
        :param str effective_at: The effective datetime or cut label at which to get relations. Defaults to the current LUSID system datetime if not specified.
        :param datetime as_at: The asAt datetime at which to retrieve the person's relations. Defaults to return the latest LUSID AsAt time if not specified.
        :param str filter: Expression to filter the relations. Users should provide null or empty string for this field until further notice.
        :param list[str] identifier_types: Identifiers types (as property keys) used for referencing Persons or Legal Entities. These take the format              {domain}/{scope}/{code} e.g. \"Person/CompanyDetails/Role\". They must be from the \"Person\" or \"LegalEntity\" domain.              Only identifier types stated will be used to look up relevant entities in relations. If not applicable, provide an empty array.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ResourceListOfRelation, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id_type_scope', 'id_type_code', 'code', 'effective_at', 'as_at', 'filter', 'identifier_types']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_person_relations" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if ('code' in local_var_params and
                len(local_var_params['code']) > 64):
            raise ApiValueError("Invalid value for parameter `code` when calling `get_person_relations`, length must be less than or equal to `64`")  # noqa: E501
        if ('code' in local_var_params and
                len(local_var_params['code']) < 1):
            raise ApiValueError("Invalid value for parameter `code` when calling `get_person_relations`, length must be greater than or equal to `1`")  # noqa: E501
        if 'code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `get_person_relations`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id_type_scope' in local_var_params:
            path_params['idTypeScope'] = local_var_params['id_type_scope']  # noqa: E501
        if 'id_type_code' in local_var_params:
            path_params['idTypeCode'] = local_var_params['id_type_code']  # noqa: E501
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501

        query_params = []
        if 'effective_at' in local_var_params:
            query_params.append(('effectiveAt', local_var_params['effective_at']))  # noqa: E501
        if 'as_at' in local_var_params:
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501
        if 'filter' in local_var_params:
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501
        if 'identifier_types' in local_var_params:
            query_params.append(('identifierTypes', local_var_params['identifier_types']))  # noqa: E501
            collection_formats['identifierTypes'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501


        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.11.2668'

        return self.api_client.call_api(
            '/api/persons/{idTypeScope}/{idTypeCode}/{code}/relations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceListOfRelation',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_persons(self, id_type_scope, id_type_code, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] List Persons  # noqa: E501

        List persons which has identifier of specific identifier type's scope and code, and satisfies filter criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_persons(id_type_scope, id_type_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the person identifier type. (required)
        :param str id_type_code: Code of the person identifier type. (required)
        :param str effective_at: The effective datetime or cut label at which to list the people. Defaults to the current LUSID              system datetime if not specified.
        :param datetime as_at: The asAt datetime at which to list the people. Defaults to return the latest version              of each people if not specified.
        :param str page: The pagination token to use to continue listing portfolios from a previous call to list portfolios. This  value is returned from the previous call. If a pagination token is provided the filter, effectiveAt  and asAt fields must not have changed since the original request. Also, if set, a start value cannot be provided.
        :param int start: When paginating, skip this number of results.
        :param int limit: When paginating, limit the number of returned results to this many. Defaults to 65,535 if not specified.
        :param str filter: Expression to filter the result set.               For example, to filter on the LUPID, use \"lusidPersonId eq 'string'\"              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :param list[str] property_keys: A list of property keys from the \"Person\" domain to decorate onto each person.              These take the format {domain}/{scope}/{code} e.g. \"Person/ContactDetails/Address\". Defaults to include all properties if not specified.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PagedResourceListOfPerson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_persons_with_http_info(id_type_scope, id_type_code, **kwargs)  # noqa: E501

    def list_persons_with_http_info(self, id_type_scope, id_type_code, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] List Persons  # noqa: E501

        List persons which has identifier of specific identifier type's scope and code, and satisfies filter criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_persons_with_http_info(id_type_scope, id_type_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the person identifier type. (required)
        :param str id_type_code: Code of the person identifier type. (required)
        :param str effective_at: The effective datetime or cut label at which to list the people. Defaults to the current LUSID              system datetime if not specified.
        :param datetime as_at: The asAt datetime at which to list the people. Defaults to return the latest version              of each people if not specified.
        :param str page: The pagination token to use to continue listing portfolios from a previous call to list portfolios. This  value is returned from the previous call. If a pagination token is provided the filter, effectiveAt  and asAt fields must not have changed since the original request. Also, if set, a start value cannot be provided.
        :param int start: When paginating, skip this number of results.
        :param int limit: When paginating, limit the number of returned results to this many. Defaults to 65,535 if not specified.
        :param str filter: Expression to filter the result set.               For example, to filter on the LUPID, use \"lusidPersonId eq 'string'\"              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :param list[str] property_keys: A list of property keys from the \"Person\" domain to decorate onto each person.              These take the format {domain}/{scope}/{code} e.g. \"Person/ContactDetails/Address\". Defaults to include all properties if not specified.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PagedResourceListOfPerson, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id_type_scope', 'id_type_code', 'effective_at', 'as_at', 'page', 'start', 'limit', 'filter', 'property_keys']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_persons" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if 'limit' in local_var_params and local_var_params['limit'] > 5000:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_persons`, must be a value less than or equal to `5000`")  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_persons`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id_type_scope' in local_var_params:
            path_params['idTypeScope'] = local_var_params['id_type_scope']  # noqa: E501
        if 'id_type_code' in local_var_params:
            path_params['idTypeCode'] = local_var_params['id_type_code']  # noqa: E501

        query_params = []
        if 'effective_at' in local_var_params:
            query_params.append(('effectiveAt', local_var_params['effective_at']))  # noqa: E501
        if 'as_at' in local_var_params:
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501
        if 'page' in local_var_params:
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'start' in local_var_params:
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'limit' in local_var_params:
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'filter' in local_var_params:
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501
        if 'property_keys' in local_var_params:
            query_params.append(('propertyKeys', local_var_params['property_keys']))  # noqa: E501
            collection_formats['propertyKeys'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501


        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.11.2668'

        return self.api_client.call_api(
            '/api/persons/{idTypeScope}/{idTypeCode}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResourceListOfPerson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_person_identifiers(self, id_type_scope, id_type_code, code, set_person_identifiers_request, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Set Person Identifiers  # noqa: E501

        Set identifiers of the person  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_person_identifiers(id_type_scope, id_type_code, code, set_person_identifiers_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the person identifier type. (required)
        :param str id_type_code: Code of the person identifier type. (required)
        :param str code: Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person. (required)
        :param SetPersonIdentifiersRequest set_person_identifiers_request: Request containing identifiers to set for the person. Identifiers not specified in request will not be changed. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Person
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.set_person_identifiers_with_http_info(id_type_scope, id_type_code, code, set_person_identifiers_request, **kwargs)  # noqa: E501

    def set_person_identifiers_with_http_info(self, id_type_scope, id_type_code, code, set_person_identifiers_request, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Set Person Identifiers  # noqa: E501

        Set identifiers of the person  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_person_identifiers_with_http_info(id_type_scope, id_type_code, code, set_person_identifiers_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the person identifier type. (required)
        :param str id_type_code: Code of the person identifier type. (required)
        :param str code: Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person. (required)
        :param SetPersonIdentifiersRequest set_person_identifiers_request: Request containing identifiers to set for the person. Identifiers not specified in request will not be changed. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Person, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id_type_scope', 'id_type_code', 'code', 'set_person_identifiers_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_person_identifiers" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'set_person_identifiers_request' is set
        if ('set_person_identifiers_request' not in local_var_params or
                local_var_params['set_person_identifiers_request'] is None):
            raise ApiValueError("Missing the required parameter `set_person_identifiers_request` when calling `set_person_identifiers`")  # noqa: E501

        if ('code' in local_var_params and
                len(local_var_params['code']) > 64):
            raise ApiValueError("Invalid value for parameter `code` when calling `set_person_identifiers`, length must be less than or equal to `64`")  # noqa: E501
        if ('code' in local_var_params and
                len(local_var_params['code']) < 1):
            raise ApiValueError("Invalid value for parameter `code` when calling `set_person_identifiers`, length must be greater than or equal to `1`")  # noqa: E501
        if 'code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `set_person_identifiers`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id_type_scope' in local_var_params:
            path_params['idTypeScope'] = local_var_params['id_type_scope']  # noqa: E501
        if 'id_type_code' in local_var_params:
            path_params['idTypeCode'] = local_var_params['id_type_code']  # noqa: E501
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'set_person_identifiers_request' in local_var_params:
            body_params = local_var_params['set_person_identifiers_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.11.2668'

        return self.api_client.call_api(
            '/api/persons/{idTypeScope}/{idTypeCode}/{code}/identifiers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Person',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_person_properties(self, id_type_scope, id_type_code, code, set_person_properties_request, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Set Person Properties  # noqa: E501

        Set properties of the person  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_person_properties(id_type_scope, id_type_code, code, set_person_properties_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the person identifier type. (required)
        :param str id_type_code: Code of the person identifier type. (required)
        :param str code: Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person. (required)
        :param SetPersonPropertiesRequest set_person_properties_request: Request containing properties to set for the person. Properties not specified in request will not be changed. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Person
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.set_person_properties_with_http_info(id_type_scope, id_type_code, code, set_person_properties_request, **kwargs)  # noqa: E501

    def set_person_properties_with_http_info(self, id_type_scope, id_type_code, code, set_person_properties_request, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Set Person Properties  # noqa: E501

        Set properties of the person  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_person_properties_with_http_info(id_type_scope, id_type_code, code, set_person_properties_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the person identifier type. (required)
        :param str id_type_code: Code of the person identifier type. (required)
        :param str code: Code of the person under specified identifier type's scope and code. This together with stated identifier type uniquely              identifies the person. (required)
        :param SetPersonPropertiesRequest set_person_properties_request: Request containing properties to set for the person. Properties not specified in request will not be changed. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Person, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id_type_scope', 'id_type_code', 'code', 'set_person_properties_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_person_properties" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'set_person_properties_request' is set
        if ('set_person_properties_request' not in local_var_params or
                local_var_params['set_person_properties_request'] is None):
            raise ApiValueError("Missing the required parameter `set_person_properties_request` when calling `set_person_properties`")  # noqa: E501

        if ('code' in local_var_params and
                len(local_var_params['code']) > 64):
            raise ApiValueError("Invalid value for parameter `code` when calling `set_person_properties`, length must be less than or equal to `64`")  # noqa: E501
        if ('code' in local_var_params and
                len(local_var_params['code']) < 1):
            raise ApiValueError("Invalid value for parameter `code` when calling `set_person_properties`, length must be greater than or equal to `1`")  # noqa: E501
        if 'code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `set_person_properties`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id_type_scope' in local_var_params:
            path_params['idTypeScope'] = local_var_params['id_type_scope']  # noqa: E501
        if 'id_type_code' in local_var_params:
            path_params['idTypeCode'] = local_var_params['id_type_code']  # noqa: E501
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'set_person_properties_request' in local_var_params:
            body_params = local_var_params['set_person_properties_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.11.2668'

        return self.api_client.call_api(
            '/api/persons/{idTypeScope}/{idTypeCode}/{code}/properties', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Person',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upsert_person(self, upsert_person_request, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Upsert Person  # noqa: E501

        Create or update new person under specified scope  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upsert_person(upsert_person_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param UpsertPersonRequest upsert_person_request: Request to create or update a person. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Person
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.upsert_person_with_http_info(upsert_person_request, **kwargs)  # noqa: E501

    def upsert_person_with_http_info(self, upsert_person_request, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Upsert Person  # noqa: E501

        Create or update new person under specified scope  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upsert_person_with_http_info(upsert_person_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param UpsertPersonRequest upsert_person_request: Request to create or update a person. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Person, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['upsert_person_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_person" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'upsert_person_request' is set
        if ('upsert_person_request' not in local_var_params or
                local_var_params['upsert_person_request'] is None):
            raise ApiValueError("Missing the required parameter `upsert_person_request` when calling `upsert_person`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'upsert_person_request' in local_var_params:
            body_params = local_var_params['upsert_person_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.11.2668'

        return self.api_client.call_api(
            '/api/persons', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Person',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upsert_person_access_metadata(self, id_type_scope, id_type_code, code, metadata_key, upsert_person_access_metadata_request, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Upsert a Person Access Metadata entry associated with a specific metadataKey. This creates or updates the data in LUSID.  # noqa: E501

        Update or insert one Person Access Metadata entry in a single scope. An item will be updated if it already exists  and inserted if it does not.                The response will return the successfully updated or inserted Person Access Metadata rule or failure message if unsuccessful.                It is important to always check to verify success (or failure).                Multiple rules for a metadataKey can exist with different effective at dates, when resources are accessed the rule that is active for the current time will be fetched.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upsert_person_access_metadata(id_type_scope, id_type_code, code, metadata_key, upsert_person_access_metadata_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the person identifier. (required)
        :param str id_type_code: Code of the person identifier. (required)
        :param str code: Code of the person under specified identifier type's scope and code. (required)
        :param str metadata_key: Key of the metadata entry to retrieve (required)
        :param UpsertPersonAccessMetadataRequest upsert_person_access_metadata_request: The Person Access Metadata entry to upsert (required)
        :param str effective_at: The effectiveAt datetime at which to upsert the Access Metadata
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ResourceListOfAccessMetadataValueOf
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.upsert_person_access_metadata_with_http_info(id_type_scope, id_type_code, code, metadata_key, upsert_person_access_metadata_request, **kwargs)  # noqa: E501

    def upsert_person_access_metadata_with_http_info(self, id_type_scope, id_type_code, code, metadata_key, upsert_person_access_metadata_request, **kwargs):  # noqa: E501
        """[EXPERIMENTAL] Upsert a Person Access Metadata entry associated with a specific metadataKey. This creates or updates the data in LUSID.  # noqa: E501

        Update or insert one Person Access Metadata entry in a single scope. An item will be updated if it already exists  and inserted if it does not.                The response will return the successfully updated or inserted Person Access Metadata rule or failure message if unsuccessful.                It is important to always check to verify success (or failure).                Multiple rules for a metadataKey can exist with different effective at dates, when resources are accessed the rule that is active for the current time will be fetched.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upsert_person_access_metadata_with_http_info(id_type_scope, id_type_code, code, metadata_key, upsert_person_access_metadata_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id_type_scope: Scope of the person identifier. (required)
        :param str id_type_code: Code of the person identifier. (required)
        :param str code: Code of the person under specified identifier type's scope and code. (required)
        :param str metadata_key: Key of the metadata entry to retrieve (required)
        :param UpsertPersonAccessMetadataRequest upsert_person_access_metadata_request: The Person Access Metadata entry to upsert (required)
        :param str effective_at: The effectiveAt datetime at which to upsert the Access Metadata
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ResourceListOfAccessMetadataValueOf, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['id_type_scope', 'id_type_code', 'code', 'metadata_key', 'upsert_person_access_metadata_request', 'effective_at']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_person_access_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id_type_scope' is set
        if ('id_type_scope' not in local_var_params or
                local_var_params['id_type_scope'] is None):
            raise ApiValueError("Missing the required parameter `id_type_scope` when calling `upsert_person_access_metadata`")  # noqa: E501
        # verify the required parameter 'id_type_code' is set
        if ('id_type_code' not in local_var_params or
                local_var_params['id_type_code'] is None):
            raise ApiValueError("Missing the required parameter `id_type_code` when calling `upsert_person_access_metadata`")  # noqa: E501
        # verify the required parameter 'code' is set
        if ('code' not in local_var_params or
                local_var_params['code'] is None):
            raise ApiValueError("Missing the required parameter `code` when calling `upsert_person_access_metadata`")  # noqa: E501
        # verify the required parameter 'metadata_key' is set
        if ('metadata_key' not in local_var_params or
                local_var_params['metadata_key'] is None):
            raise ApiValueError("Missing the required parameter `metadata_key` when calling `upsert_person_access_metadata`")  # noqa: E501
        # verify the required parameter 'upsert_person_access_metadata_request' is set
        if ('upsert_person_access_metadata_request' not in local_var_params or
                local_var_params['upsert_person_access_metadata_request'] is None):
            raise ApiValueError("Missing the required parameter `upsert_person_access_metadata_request` when calling `upsert_person_access_metadata`")  # noqa: E501

        if ('code' in local_var_params and
                len(local_var_params['code']) > 64):
            raise ApiValueError("Invalid value for parameter `code` when calling `upsert_person_access_metadata`, length must be less than or equal to `64`")  # noqa: E501
        if ('code' in local_var_params and
                len(local_var_params['code']) < 1):
            raise ApiValueError("Invalid value for parameter `code` when calling `upsert_person_access_metadata`, length must be greater than or equal to `1`")  # noqa: E501
        if 'code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `upsert_person_access_metadata`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id_type_scope' in local_var_params:
            path_params['idTypeScope'] = local_var_params['id_type_scope']  # noqa: E501
        if 'id_type_code' in local_var_params:
            path_params['idTypeCode'] = local_var_params['id_type_code']  # noqa: E501
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501
        if 'metadata_key' in local_var_params:
            path_params['metadataKey'] = local_var_params['metadata_key']  # noqa: E501

        query_params = []
        if 'effective_at' in local_var_params:
            query_params.append(('effectiveAt', local_var_params['effective_at']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'upsert_person_access_metadata_request' in local_var_params:
            body_params = local_var_params['upsert_person_access_metadata_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.11.2668'

        return self.api_client.call_api(
            '/api/persons/{idTypeScope}/{idTypeCode}/{code}/metadata/{metadataKey}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceListOfAccessMetadataValueOf',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
