"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.struct_pb2
import google.protobuf.wrappers_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class PromptTruncationOptions(google.protobuf.message.Message):
    """Defines the options for truncating thread messages within a prompt."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class AutoStrategy(google.protobuf.message.Message):
        """Auto truncation strategy.
        No specific parameters are required for this strategy.
        The system will handle truncation in a way that aims to preserve the most relevant context.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        def __init__(
            self,
        ) -> None: ...

    @typing.final
    class LastMessagesStrategy(google.protobuf.message.Message):
        """Truncates the prompt by retaining only the last `num_messages` messages in the thread."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NUM_MESSAGES_FIELD_NUMBER: builtins.int
        num_messages: builtins.int
        """The number of most recent messages to retain in the prompt.
        If these messages exceed `max_prompt_tokens`, older messages will be further truncated to fit the limit.
        """
        def __init__(
            self,
            *,
            num_messages: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["num_messages", b"num_messages"]) -> None: ...

    MAX_PROMPT_TOKENS_FIELD_NUMBER: builtins.int
    AUTO_STRATEGY_FIELD_NUMBER: builtins.int
    LAST_MESSAGES_STRATEGY_FIELD_NUMBER: builtins.int
    @property
    def max_prompt_tokens(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The maximum number of tokens allowed in the prompt.
        If the prompt exceeds this limit, the thread messages will be truncated.
        Default max_prompt_tokens: 7000
        """

    @property
    def auto_strategy(self) -> global___PromptTruncationOptions.AutoStrategy: ...
    @property
    def last_messages_strategy(self) -> global___PromptTruncationOptions.LastMessagesStrategy:
        """Retains only the last `num_messages` messages in the thread.
        If these messages exceed `max_prompt_tokens`, older messages will be further truncated to fit the limit.
        """

    def __init__(
        self,
        *,
        max_prompt_tokens: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        auto_strategy: global___PromptTruncationOptions.AutoStrategy | None = ...,
        last_messages_strategy: global___PromptTruncationOptions.LastMessagesStrategy | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["TruncationStrategy", b"TruncationStrategy", "auto_strategy", b"auto_strategy", "last_messages_strategy", b"last_messages_strategy", "max_prompt_tokens", b"max_prompt_tokens"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["TruncationStrategy", b"TruncationStrategy", "auto_strategy", b"auto_strategy", "last_messages_strategy", b"last_messages_strategy", "max_prompt_tokens", b"max_prompt_tokens"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["TruncationStrategy", b"TruncationStrategy"]) -> typing.Literal["auto_strategy", "last_messages_strategy"] | None: ...

global___PromptTruncationOptions = PromptTruncationOptions

@typing.final
class CompletionOptions(google.protobuf.message.Message):
    """Defines the options for completion generation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MAX_TOKENS_FIELD_NUMBER: builtins.int
    TEMPERATURE_FIELD_NUMBER: builtins.int
    @property
    def max_tokens(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The limit on the number of tokens used for single completion generation.
        Must be greater than zero. This maximum allowed parameter value may depend on the model being used.
        """

    @property
    def temperature(self) -> google.protobuf.wrappers_pb2.DoubleValue:
        """Affects creativity and randomness of responses. Should be a double number between 0 (inclusive) and 1 (inclusive).
        Lower values produce more straightforward responses while higher values lead to increased creativity and randomness.
        Default temperature: 0.3
        """

    def __init__(
        self,
        *,
        max_tokens: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        temperature: google.protobuf.wrappers_pb2.DoubleValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["max_tokens", b"max_tokens", "temperature", b"temperature"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["max_tokens", b"max_tokens", "temperature", b"temperature"]) -> None: ...

global___CompletionOptions = CompletionOptions

@typing.final
class Tool(google.protobuf.message.Message):
    """Represents a general tool that can be one of several types."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SEARCH_INDEX_FIELD_NUMBER: builtins.int
    FUNCTION_FIELD_NUMBER: builtins.int
    GEN_SEARCH_FIELD_NUMBER: builtins.int
    @property
    def search_index(self) -> global___SearchIndexTool:
        """SearchIndexTool tool that performs search across specified indexes."""

    @property
    def function(self) -> global___FunctionTool:
        """Function tool that can be invoked by the assistant."""

    @property
    def gen_search(self) -> global___GenSearchTool:
        """Performs web retrieval and generative synthesis."""

    def __init__(
        self,
        *,
        search_index: global___SearchIndexTool | None = ...,
        function: global___FunctionTool | None = ...,
        gen_search: global___GenSearchTool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["ToolType", b"ToolType", "function", b"function", "gen_search", b"gen_search", "search_index", b"search_index"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["ToolType", b"ToolType", "function", b"function", "gen_search", b"gen_search", "search_index", b"search_index"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["ToolType", b"ToolType"]) -> typing.Literal["search_index", "function", "gen_search"] | None: ...

global___Tool = Tool

@typing.final
class ToolCall(google.protobuf.message.Message):
    """Represents a call to a tool."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FUNCTION_CALL_FIELD_NUMBER: builtins.int
    @property
    def function_call(self) -> global___FunctionCall:
        """Represents a call to a function."""

    def __init__(
        self,
        *,
        function_call: global___FunctionCall | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["ToolCallType", b"ToolCallType", "function_call", b"function_call"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["ToolCallType", b"ToolCallType", "function_call", b"function_call"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["ToolCallType", b"ToolCallType"]) -> typing.Literal["function_call"] | None: ...

global___ToolCall = ToolCall

@typing.final
class ToolCallList(google.protobuf.message.Message):
    """Represents a list of tool calls."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOOL_CALLS_FIELD_NUMBER: builtins.int
    @property
    def tool_calls(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ToolCall]:
        """A list of tool calls to be executed."""

    def __init__(
        self,
        *,
        tool_calls: collections.abc.Iterable[global___ToolCall] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["tool_calls", b"tool_calls"]) -> None: ...

global___ToolCallList = ToolCallList

@typing.final
class ToolResult(google.protobuf.message.Message):
    """Represents the result of a tool call."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FUNCTION_RESULT_FIELD_NUMBER: builtins.int
    @property
    def function_result(self) -> global___FunctionResult:
        """Represents the result of a function call."""

    def __init__(
        self,
        *,
        function_result: global___FunctionResult | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["ToolResultType", b"ToolResultType", "function_result", b"function_result"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["ToolResultType", b"ToolResultType", "function_result", b"function_result"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["ToolResultType", b"ToolResultType"]) -> typing.Literal["function_result"] | None: ...

global___ToolResult = ToolResult

@typing.final
class ToolResultList(google.protobuf.message.Message):
    """Represents a list of tool results."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOOL_RESULTS_FIELD_NUMBER: builtins.int
    @property
    def tool_results(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ToolResult]:
        """A list of tool results."""

    def __init__(
        self,
        *,
        tool_results: collections.abc.Iterable[global___ToolResult] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["tool_results", b"tool_results"]) -> None: ...

global___ToolResultList = ToolResultList

@typing.final
class SearchIndexTool(google.protobuf.message.Message):
    """Configures a tool that enables Retrieval-Augmented Generation (RAG) by allowing the assistant to search across a specified search index."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SEARCH_INDEX_IDS_FIELD_NUMBER: builtins.int
    MAX_NUM_RESULTS_FIELD_NUMBER: builtins.int
    REPHRASER_OPTIONS_FIELD_NUMBER: builtins.int
    CALL_STRATEGY_FIELD_NUMBER: builtins.int
    @property
    def search_index_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A list of search index IDs that this tool will query. Currently, only a single index ID is supported."""

    @property
    def max_num_results(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The maximum number of results to return from the search.
        Fewer results may be returned if necessary to fit within the prompt's token limit.
        This ensures that the combined prompt and search results do not exceed the token constraints.
        """

    @property
    def rephraser_options(self) -> global___RephraserOptions:
        """Options for rephrasing user queries.
        Used to rewrite the last user message for search,
        incorporating context from the previous conversation.
        """

    @property
    def call_strategy(self) -> global___CallStrategy:
        """Defines the strategy for triggering search.
        Controls whether search results are always included or returned only when
        the model explicitly calls the tool.
        """

    def __init__(
        self,
        *,
        search_index_ids: collections.abc.Iterable[builtins.str] | None = ...,
        max_num_results: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        rephraser_options: global___RephraserOptions | None = ...,
        call_strategy: global___CallStrategy | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["call_strategy", b"call_strategy", "max_num_results", b"max_num_results", "rephraser_options", b"rephraser_options"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["call_strategy", b"call_strategy", "max_num_results", b"max_num_results", "rephraser_options", b"rephraser_options", "search_index_ids", b"search_index_ids"]) -> None: ...

global___SearchIndexTool = SearchIndexTool

@typing.final
class CallStrategy(google.protobuf.message.Message):
    """Defines when the assistant uses the search tool."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class AlwaysCall(google.protobuf.message.Message):
        """Always includes retrieved search results in the prompt."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        def __init__(
            self,
        ) -> None: ...

    @typing.final
    class AutoCall(google.protobuf.message.Message):
        """Exposes the tool as a callable function.
        The model decides when to trigger search based on the instruction.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        INSTRUCTION_FIELD_NUMBER: builtins.int
        name: builtins.str
        """The name of the tool as exposed to the model."""
        instruction: builtins.str
        """Required instruction that helps the model decide when to call the tool."""
        def __init__(
            self,
            *,
            name: builtins.str = ...,
            instruction: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["instruction", b"instruction", "name", b"name"]) -> None: ...

    ALWAYS_CALL_FIELD_NUMBER: builtins.int
    AUTO_CALL_FIELD_NUMBER: builtins.int
    @property
    def always_call(self) -> global___CallStrategy.AlwaysCall: ...
    @property
    def auto_call(self) -> global___CallStrategy.AutoCall: ...
    def __init__(
        self,
        *,
        always_call: global___CallStrategy.AlwaysCall | None = ...,
        auto_call: global___CallStrategy.AutoCall | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["Strategy", b"Strategy", "always_call", b"always_call", "auto_call", b"auto_call"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["Strategy", b"Strategy", "always_call", b"always_call", "auto_call", b"auto_call"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["Strategy", b"Strategy"]) -> typing.Literal["always_call", "auto_call"] | None: ...

global___CallStrategy = CallStrategy

@typing.final
class FunctionTool(google.protobuf.message.Message):
    """Represents a function tool that can be invoked by the assistant."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    PARAMETERS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the function."""
    description: builtins.str
    """A description of the function's purpose or behavior."""
    @property
    def parameters(self) -> google.protobuf.struct_pb2.Struct:
        """A JSON Schema that defines the expected parameters for the function.
        The schema should describe the required fields, their types, and any constraints or default values.
        """

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        description: builtins.str = ...,
        parameters: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["parameters", b"parameters"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "name", b"name", "parameters", b"parameters"]) -> None: ...

global___FunctionTool = FunctionTool

@typing.final
class FunctionCall(google.protobuf.message.Message):
    """Represents the invocation of a function with specific arguments."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    ARGUMENTS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the function being called."""
    @property
    def arguments(self) -> google.protobuf.struct_pb2.Struct:
        """The structured arguments passed to the function.
        These arguments must adhere to the JSON Schema defined in the corresponding function's parameters.
        """

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        arguments: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["arguments", b"arguments"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["arguments", b"arguments", "name", b"name"]) -> None: ...

global___FunctionCall = FunctionCall

@typing.final
class FunctionResult(google.protobuf.message.Message):
    """Represents the result of a function call."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the function that was executed."""
    content: builtins.str
    """The result of the function call, represented as a string.
    This field can be used to store the output of the function.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        content: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["ContentType", b"ContentType", "content", b"content"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["ContentType", b"ContentType", "content", b"content", "name", b"name"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["ContentType", b"ContentType"]) -> typing.Literal["content"] | None: ...

global___FunctionResult = FunctionResult

@typing.final
class RephraserOptions(google.protobuf.message.Message):
    """Options for configuring the rephrasing the last user message for search using context from previous conversation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REPHRASER_URI_FIELD_NUMBER: builtins.int
    rephraser_uri: builtins.str
    """The ID of the model used to rephrase the last user message for search."""
    def __init__(
        self,
        *,
        rephraser_uri: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["rephraser_uri", b"rephraser_uri"]) -> None: ...

global___RephraserOptions = RephraserOptions

@typing.final
class JsonSchema(google.protobuf.message.Message):
    """Represents the expected structure of the model's response using a JSON Schema."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SCHEMA_FIELD_NUMBER: builtins.int
    @property
    def schema(self) -> google.protobuf.struct_pb2.Struct:
        """The JSON Schema that the model's output must conform to."""

    def __init__(
        self,
        *,
        schema: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["schema", b"schema"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["schema", b"schema"]) -> None: ...

global___JsonSchema = JsonSchema

@typing.final
class ResponseFormat(google.protobuf.message.Message):
    """Specifies the format of the model's response."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    JSON_OBJECT_FIELD_NUMBER: builtins.int
    JSON_SCHEMA_FIELD_NUMBER: builtins.int
    json_object: builtins.bool
    """When set to true, the model will respond with a valid JSON object.
    Be sure to explicitly ask the model for JSON.
    Otherwise, it may generate excessive whitespace and run indefinitely until it reaches the token limit.
    """
    @property
    def json_schema(self) -> global___JsonSchema:
        """Enforces a specific JSON structure for the model's response based on a provided schema."""

    def __init__(
        self,
        *,
        json_object: builtins.bool = ...,
        json_schema: global___JsonSchema | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["ResponseFormat", b"ResponseFormat", "json_object", b"json_object", "json_schema", b"json_schema"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["ResponseFormat", b"ResponseFormat", "json_object", b"json_object", "json_schema", b"json_schema"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["ResponseFormat", b"ResponseFormat"]) -> typing.Literal["json_object", "json_schema"] | None: ...

global___ResponseFormat = ResponseFormat

@typing.final
class GenSearchTool(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPTIONS_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    description: builtins.str
    """description of the purpose"""
    @property
    def options(self) -> global___GenSearchOptions:
        """Scoping and filtering rules for the search query"""

    def __init__(
        self,
        *,
        options: global___GenSearchOptions | None = ...,
        description: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["options", b"options"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "options", b"options"]) -> None: ...

global___GenSearchTool = GenSearchTool

@typing.final
class GenSearchOptions(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class SiteOption(google.protobuf.message.Message):
        """Restricts the search to the specific websites."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        SITE_FIELD_NUMBER: builtins.int
        @property
        def site(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
        def __init__(
            self,
            *,
            site: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["site", b"site"]) -> None: ...

    @typing.final
    class UrlOption(google.protobuf.message.Message):
        """Restricts the search to the specific pages."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        URL_FIELD_NUMBER: builtins.int
        @property
        def url(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
        def __init__(
            self,
            *,
            url: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["url", b"url"]) -> None: ...

    @typing.final
    class HostOption(google.protobuf.message.Message):
        """Restricts the search to the specific hosts."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        HOST_FIELD_NUMBER: builtins.int
        @property
        def host(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
        def __init__(
            self,
            *,
            host: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["host", b"host"]) -> None: ...

    @typing.final
    class SearchFilter(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _DocFormat:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _DocFormatEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[GenSearchOptions.SearchFilter._DocFormat.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            DOC_FORMAT_UNSPECIFIED: GenSearchOptions.SearchFilter._DocFormat.ValueType  # 0
            DOC_FORMAT_PDF: GenSearchOptions.SearchFilter._DocFormat.ValueType  # 1
            DOC_FORMAT_XLS: GenSearchOptions.SearchFilter._DocFormat.ValueType  # 2
            DOC_FORMAT_ODS: GenSearchOptions.SearchFilter._DocFormat.ValueType  # 3
            DOC_FORMAT_RTF: GenSearchOptions.SearchFilter._DocFormat.ValueType  # 4
            DOC_FORMAT_PPT: GenSearchOptions.SearchFilter._DocFormat.ValueType  # 5
            DOC_FORMAT_ODP: GenSearchOptions.SearchFilter._DocFormat.ValueType  # 6
            DOC_FORMAT_SWF: GenSearchOptions.SearchFilter._DocFormat.ValueType  # 7
            DOC_FORMAT_ODT: GenSearchOptions.SearchFilter._DocFormat.ValueType  # 8
            DOC_FORMAT_ODG: GenSearchOptions.SearchFilter._DocFormat.ValueType  # 9
            DOC_FORMAT_DOC: GenSearchOptions.SearchFilter._DocFormat.ValueType  # 10

        class DocFormat(_DocFormat, metaclass=_DocFormatEnumTypeWrapper): ...
        DOC_FORMAT_UNSPECIFIED: GenSearchOptions.SearchFilter.DocFormat.ValueType  # 0
        DOC_FORMAT_PDF: GenSearchOptions.SearchFilter.DocFormat.ValueType  # 1
        DOC_FORMAT_XLS: GenSearchOptions.SearchFilter.DocFormat.ValueType  # 2
        DOC_FORMAT_ODS: GenSearchOptions.SearchFilter.DocFormat.ValueType  # 3
        DOC_FORMAT_RTF: GenSearchOptions.SearchFilter.DocFormat.ValueType  # 4
        DOC_FORMAT_PPT: GenSearchOptions.SearchFilter.DocFormat.ValueType  # 5
        DOC_FORMAT_ODP: GenSearchOptions.SearchFilter.DocFormat.ValueType  # 6
        DOC_FORMAT_SWF: GenSearchOptions.SearchFilter.DocFormat.ValueType  # 7
        DOC_FORMAT_ODT: GenSearchOptions.SearchFilter.DocFormat.ValueType  # 8
        DOC_FORMAT_ODG: GenSearchOptions.SearchFilter.DocFormat.ValueType  # 9
        DOC_FORMAT_DOC: GenSearchOptions.SearchFilter.DocFormat.ValueType  # 10

        DATE_FIELD_NUMBER: builtins.int
        LANG_FIELD_NUMBER: builtins.int
        FORMAT_FIELD_NUMBER: builtins.int
        date: builtins.str
        """Restrict by document date"""
        lang: builtins.str
        """Restrict by document language. Use ISO 639-1 language codes."""
        format: global___GenSearchOptions.SearchFilter.DocFormat.ValueType
        """Restrict by document format."""
        def __init__(
            self,
            *,
            date: builtins.str = ...,
            lang: builtins.str = ...,
            format: global___GenSearchOptions.SearchFilter.DocFormat.ValueType = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["date", b"date", "filter_options", b"filter_options", "format", b"format", "lang", b"lang"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["date", b"date", "filter_options", b"filter_options", "format", b"format", "lang", b"lang"]) -> None: ...
        def WhichOneof(self, oneof_group: typing.Literal["filter_options", b"filter_options"]) -> typing.Literal["date", "lang", "format"] | None: ...

    SITE_FIELD_NUMBER: builtins.int
    HOST_FIELD_NUMBER: builtins.int
    URL_FIELD_NUMBER: builtins.int
    ENABLE_NRFM_DOCS_FIELD_NUMBER: builtins.int
    SEARCH_FILTERS_FIELD_NUMBER: builtins.int
    enable_nrfm_docs: builtins.bool
    """Use the documents inaccessible from the front page."""
    @property
    def site(self) -> global___GenSearchOptions.SiteOption: ...
    @property
    def host(self) -> global___GenSearchOptions.HostOption: ...
    @property
    def url(self) -> global___GenSearchOptions.UrlOption: ...
    @property
    def search_filters(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GenSearchOptions.SearchFilter]:
        """Restricts the search by date, document formats or language."""

    def __init__(
        self,
        *,
        site: global___GenSearchOptions.SiteOption | None = ...,
        host: global___GenSearchOptions.HostOption | None = ...,
        url: global___GenSearchOptions.UrlOption | None = ...,
        enable_nrfm_docs: builtins.bool = ...,
        search_filters: collections.abc.Iterable[global___GenSearchOptions.SearchFilter] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["host", b"host", "site", b"site", "site_options", b"site_options", "url", b"url"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["enable_nrfm_docs", b"enable_nrfm_docs", "host", b"host", "search_filters", b"search_filters", "site", b"site", "site_options", b"site_options", "url", b"url"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["site_options", b"site_options"]) -> typing.Literal["site", "host", "url"] | None: ...

global___GenSearchOptions = GenSearchOptions
