"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing
import yandex.cloud.ai.assistants.v1.common_pb2
import yandex.cloud.ai.assistants.v1.threads.message_pb2
import yandex.cloud.ai.common.common_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Run(google.protobuf.message.Message):
    """Represents a run of an assistant over a specific thread of messages."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    ASSISTANT_ID_FIELD_NUMBER: builtins.int
    THREAD_ID_FIELD_NUMBER: builtins.int
    CREATED_BY_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    USAGE_FIELD_NUMBER: builtins.int
    CUSTOM_PROMPT_TRUNCATION_OPTIONS_FIELD_NUMBER: builtins.int
    CUSTOM_COMPLETION_OPTIONS_FIELD_NUMBER: builtins.int
    TOOLS_FIELD_NUMBER: builtins.int
    CUSTOM_RESPONSE_FORMAT_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Unique identifier of the run."""
    assistant_id: builtins.str
    """Identifier for the assistant that is being run."""
    thread_id: builtins.str
    """Identifier for the thread of messages that this run is associated with."""
    created_by: builtins.str
    """Identifier of the subject who created this run."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp representing when the run was created."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Set of key-value pairs that can be used to organize and categorize the run."""

    @property
    def state(self) -> global___RunState:
        """Current state of the run, including its status and any associated data."""

    @property
    def usage(self) -> global___ContentUsage:
        """Information about the content usage during the run, such as the number of [tokens](/docs/foundation-models/concepts/yandexgpt/tokens) used by the completion model."""

    @property
    def custom_prompt_truncation_options(self) -> yandex.cloud.ai.assistants.v1.common_pb2.PromptTruncationOptions:
        """Configuration options for truncating the prompt when the token count exceeds a specified limit.
        If specified, these options will override the assistant's prompt truncation settings for this run.
        """

    @property
    def custom_completion_options(self) -> yandex.cloud.ai.assistants.v1.common_pb2.CompletionOptions:
        """Configuration options for completion generation.
        If specified, these options will override the assistant's completion settings for this run.
        """

    @property
    def tools(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.ai.assistants.v1.common_pb2.Tool]:
        """List of tools that are available for the assistant to use in this run."""

    @property
    def custom_response_format(self) -> yandex.cloud.ai.assistants.v1.common_pb2.ResponseFormat:
        """Specifies the format of the model's response."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        assistant_id: builtins.str = ...,
        thread_id: builtins.str = ...,
        created_by: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        state: global___RunState | None = ...,
        usage: global___ContentUsage | None = ...,
        custom_prompt_truncation_options: yandex.cloud.ai.assistants.v1.common_pb2.PromptTruncationOptions | None = ...,
        custom_completion_options: yandex.cloud.ai.assistants.v1.common_pb2.CompletionOptions | None = ...,
        tools: collections.abc.Iterable[yandex.cloud.ai.assistants.v1.common_pb2.Tool] | None = ...,
        custom_response_format: yandex.cloud.ai.assistants.v1.common_pb2.ResponseFormat | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at", "custom_completion_options", b"custom_completion_options", "custom_prompt_truncation_options", b"custom_prompt_truncation_options", "custom_response_format", b"custom_response_format", "state", b"state", "usage", b"usage"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["assistant_id", b"assistant_id", "created_at", b"created_at", "created_by", b"created_by", "custom_completion_options", b"custom_completion_options", "custom_prompt_truncation_options", b"custom_prompt_truncation_options", "custom_response_format", b"custom_response_format", "id", b"id", "labels", b"labels", "state", b"state", "thread_id", b"thread_id", "tools", b"tools", "usage", b"usage"]) -> None: ...

global___Run = Run

@typing.final
class RunState(google.protobuf.message.Message):
    """Represents the current state of a run."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _RunStatus:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _RunStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[RunState._RunStatus.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        RUN_STATUS_UNSPECIFIED: RunState._RunStatus.ValueType  # 0
        """Default unspecified status."""
        PENDING: RunState._RunStatus.ValueType  # 1
        """Run has been created but has not started yet."""
        IN_PROGRESS: RunState._RunStatus.ValueType  # 2
        """Run is currently in progress."""
        FAILED: RunState._RunStatus.ValueType  # 3
        """Run has failed due to an error."""
        COMPLETED: RunState._RunStatus.ValueType  # 4
        """Run has completed successfully."""
        TOOL_CALLS: RunState._RunStatus.ValueType  # 5
        """The run is waiting for tool calls to be executed and their results to be submitted."""

    class RunStatus(_RunStatus, metaclass=_RunStatusEnumTypeWrapper):
        """Enum representing the status of a run."""

    RUN_STATUS_UNSPECIFIED: RunState.RunStatus.ValueType  # 0
    """Default unspecified status."""
    PENDING: RunState.RunStatus.ValueType  # 1
    """Run has been created but has not started yet."""
    IN_PROGRESS: RunState.RunStatus.ValueType  # 2
    """Run is currently in progress."""
    FAILED: RunState.RunStatus.ValueType  # 3
    """Run has failed due to an error."""
    COMPLETED: RunState.RunStatus.ValueType  # 4
    """Run has completed successfully."""
    TOOL_CALLS: RunState.RunStatus.ValueType  # 5
    """The run is waiting for tool calls to be executed and their results to be submitted."""

    STATUS_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    COMPLETED_MESSAGE_FIELD_NUMBER: builtins.int
    TOOL_CALL_LIST_FIELD_NUMBER: builtins.int
    status: global___RunState.RunStatus.ValueType
    """Current status of a run."""
    @property
    def error(self) -> yandex.cloud.ai.common.common_pb2.Error:
        """Error information if a run has failed."""

    @property
    def completed_message(self) -> yandex.cloud.ai.assistants.v1.threads.message_pb2.Message:
        """Final message generated by an assistant if a run has completed successfully."""

    @property
    def tool_call_list(self) -> yandex.cloud.ai.assistants.v1.common_pb2.ToolCallList:
        """A list of tool calls requested by the assistant."""

    def __init__(
        self,
        *,
        status: global___RunState.RunStatus.ValueType = ...,
        error: yandex.cloud.ai.common.common_pb2.Error | None = ...,
        completed_message: yandex.cloud.ai.assistants.v1.threads.message_pb2.Message | None = ...,
        tool_call_list: yandex.cloud.ai.assistants.v1.common_pb2.ToolCallList | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["StateData", b"StateData", "completed_message", b"completed_message", "error", b"error", "tool_call_list", b"tool_call_list"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["StateData", b"StateData", "completed_message", b"completed_message", "error", b"error", "status", b"status", "tool_call_list", b"tool_call_list"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["StateData", b"StateData"]) -> typing.Literal["error", "completed_message", "tool_call_list"] | None: ...

global___RunState = RunState

@typing.final
class ContentUsage(google.protobuf.message.Message):
    """Represents the content usage during a run, such as the number of [tokens](/docs/foundation-models/concepts/yandexgpt/tokens) used by the completion model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROMPT_TOKENS_FIELD_NUMBER: builtins.int
    COMPLETION_TOKENS_FIELD_NUMBER: builtins.int
    TOTAL_TOKENS_FIELD_NUMBER: builtins.int
    prompt_tokens: builtins.int
    """The number of tokens used in the prompt."""
    completion_tokens: builtins.int
    """The number of tokens used in the completion response."""
    total_tokens: builtins.int
    """The total number of tokens used (prompt + completion)."""
    def __init__(
        self,
        *,
        prompt_tokens: builtins.int = ...,
        completion_tokens: builtins.int = ...,
        total_tokens: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["completion_tokens", b"completion_tokens", "prompt_tokens", b"prompt_tokens", "total_tokens", b"total_tokens"]) -> None: ...

global___ContentUsage = ContentUsage
