"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.ai.dataset.v1.dataset_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class DescribeDatasetRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATASET_ID_FIELD_NUMBER: builtins.int
    dataset_id: builtins.str
    """ID of the dataset to describe."""
    def __init__(
        self,
        *,
        dataset_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["dataset_id", b"dataset_id"]) -> None: ...

global___DescribeDatasetRequest = DescribeDatasetRequest

@typing.final
class DescribeDatasetResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATASET_FIELD_NUMBER: builtins.int
    @property
    def dataset(self) -> yandex.cloud.ai.dataset.v1.dataset_pb2.DatasetInfo:
        """Information about the dataset."""

    def __init__(
        self,
        *,
        dataset: yandex.cloud.ai.dataset.v1.dataset_pb2.DatasetInfo | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["dataset", b"dataset"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["dataset", b"dataset"]) -> None: ...

global___DescribeDatasetResponse = DescribeDatasetResponse

@typing.final
class ValidateDatasetRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATASET_ID_FIELD_NUMBER: builtins.int
    dataset_id: builtins.str
    """ID of the dataset to validate."""
    def __init__(
        self,
        *,
        dataset_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["dataset_id", b"dataset_id"]) -> None: ...

global___ValidateDatasetRequest = ValidateDatasetRequest

@typing.final
class ValidateDatasetMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATASET_ID_FIELD_NUMBER: builtins.int
    VALID_ROWS_FIELD_NUMBER: builtins.int
    PROCESSED_ROWS_FIELD_NUMBER: builtins.int
    TOTAL_ROWS_FIELD_NUMBER: builtins.int
    dataset_id: builtins.str
    """ID of the dataset."""
    valid_rows: builtins.int
    """Count of valid rows among currently processed rows in the dataset."""
    processed_rows: builtins.int
    """Count of currently processed rows in the dataset."""
    total_rows: builtins.int
    """Total count of rows in the dataset"""
    def __init__(
        self,
        *,
        dataset_id: builtins.str = ...,
        valid_rows: builtins.int = ...,
        processed_rows: builtins.int = ...,
        total_rows: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["dataset_id", b"dataset_id", "processed_rows", b"processed_rows", "total_rows", b"total_rows", "valid_rows", b"valid_rows"]) -> None: ...

global___ValidateDatasetMetadata = ValidateDatasetMetadata

@typing.final
class ValidateDatasetResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATASET_ID_FIELD_NUMBER: builtins.int
    IS_VALID_FIELD_NUMBER: builtins.int
    ERRORS_FIELD_NUMBER: builtins.int
    dataset_id: builtins.str
    """ID of the dataset."""
    is_valid: builtins.bool
    """Validity marker."""
    @property
    def errors(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.ai.dataset.v1.dataset_pb2.ValidationError]:
        """A list of the dataset validation errors."""

    def __init__(
        self,
        *,
        dataset_id: builtins.str = ...,
        is_valid: builtins.bool = ...,
        errors: collections.abc.Iterable[yandex.cloud.ai.dataset.v1.dataset_pb2.ValidationError] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["dataset_id", b"dataset_id", "errors", b"errors", "is_valid", b"is_valid"]) -> None: ...

global___ValidateDatasetResponse = ValidateDatasetResponse

@typing.final
class DeleteDatasetRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATASET_ID_FIELD_NUMBER: builtins.int
    dataset_id: builtins.str
    """ID of the dataset to delete."""
    def __init__(
        self,
        *,
        dataset_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["dataset_id", b"dataset_id"]) -> None: ...

global___DeleteDatasetRequest = DeleteDatasetRequest

@typing.final
class DeleteDatasetResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteDatasetResponse = DeleteDatasetResponse

@typing.final
class CreateDatasetRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    TASK_TYPE_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    UPLOAD_FORMAT_FIELD_NUMBER: builtins.int
    ALLOW_DATA_LOG_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the dataset."""
    folder_id: builtins.str
    """Folder ID of the dataset."""
    description: builtins.str
    """Description of the dataset. Optional."""
    metadata: builtins.str
    """Metadata of the dataset. Optional."""
    task_type: builtins.str
    """Task type of the dataset."""
    upload_format: builtins.str
    """Upload format of the dataset.
    The list of supported upload formats can be retrieved via ListUploadFormats method.
    """
    allow_data_log: builtins.bool
    """Allow to use the dataset to improve the models quality. Default false."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Labels of the dataset. Optional."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        folder_id: builtins.str = ...,
        description: builtins.str = ...,
        metadata: builtins.str = ...,
        task_type: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        upload_format: builtins.str = ...,
        allow_data_log: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["allow_data_log", b"allow_data_log", "description", b"description", "folder_id", b"folder_id", "labels", b"labels", "metadata", b"metadata", "name", b"name", "task_type", b"task_type", "upload_format", b"upload_format"]) -> None: ...

global___CreateDatasetRequest = CreateDatasetRequest

@typing.final
class CreateDatasetResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATASET_ID_FIELD_NUMBER: builtins.int
    DATASET_FIELD_NUMBER: builtins.int
    dataset_id: builtins.str
    """ID of the created dataset."""
    @property
    def dataset(self) -> yandex.cloud.ai.dataset.v1.dataset_pb2.DatasetInfo:
        """Information about the dataset."""

    def __init__(
        self,
        *,
        dataset_id: builtins.str = ...,
        dataset: yandex.cloud.ai.dataset.v1.dataset_pb2.DatasetInfo | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["dataset", b"dataset"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["dataset", b"dataset", "dataset_id", b"dataset_id"]) -> None: ...

global___CreateDatasetResponse = CreateDatasetResponse

@typing.final
class UpdateDatasetRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    DATASET_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    dataset_id: builtins.str
    """ID of the dataset to update."""
    name: builtins.str
    """Name of the dataset."""
    description: builtins.str
    """Description of the dataset."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """gRPC field mask."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Labels of the dataset."""

    def __init__(
        self,
        *,
        dataset_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["dataset_id", b"dataset_id", "description", b"description", "labels", b"labels", "name", b"name", "update_mask", b"update_mask"]) -> None: ...

global___UpdateDatasetRequest = UpdateDatasetRequest

@typing.final
class UpdateDatasetResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATASET_FIELD_NUMBER: builtins.int
    @property
    def dataset(self) -> yandex.cloud.ai.dataset.v1.dataset_pb2.DatasetInfo:
        """Information about updated dataset."""

    def __init__(
        self,
        *,
        dataset: yandex.cloud.ai.dataset.v1.dataset_pb2.DatasetInfo | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["dataset", b"dataset"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["dataset", b"dataset"]) -> None: ...

global___UpdateDatasetResponse = UpdateDatasetResponse

@typing.final
class GetUploadDraftUrlRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATASET_ID_FIELD_NUMBER: builtins.int
    SIZE_BYTES_FIELD_NUMBER: builtins.int
    dataset_id: builtins.str
    """ID of the dataset to upload."""
    size_bytes: builtins.int
    """Size in bytes of the dataset to upload."""
    def __init__(
        self,
        *,
        dataset_id: builtins.str = ...,
        size_bytes: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["dataset_id", b"dataset_id", "size_bytes", b"size_bytes"]) -> None: ...

global___GetUploadDraftUrlRequest = GetUploadDraftUrlRequest

@typing.final
class GetUploadDraftUrlResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATASET_ID_FIELD_NUMBER: builtins.int
    UPLOAD_URL_FIELD_NUMBER: builtins.int
    dataset_id: builtins.str
    """ID of the dataset."""
    upload_url: builtins.str
    """S3 presigned URL for upload."""
    def __init__(
        self,
        *,
        dataset_id: builtins.str = ...,
        upload_url: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["dataset_id", b"dataset_id", "upload_url", b"upload_url"]) -> None: ...

global___GetUploadDraftUrlResponse = GetUploadDraftUrlResponse

@typing.final
class StartMultipartUploadDraftRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATASET_ID_FIELD_NUMBER: builtins.int
    SIZE_BYTES_FIELD_NUMBER: builtins.int
    PARTS_FIELD_NUMBER: builtins.int
    dataset_id: builtins.str
    """ID of the dataset to multipart upload."""
    size_bytes: builtins.int
    """Size in bytes of the dataset to upload."""
    parts: builtins.int
    """Number of parts in multipart upload. Optional.
    Dataset's part size should be between 5MB and 5GB.
    If not specified will be configured automatically.
    """
    def __init__(
        self,
        *,
        dataset_id: builtins.str = ...,
        size_bytes: builtins.int = ...,
        parts: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["dataset_id", b"dataset_id", "parts", b"parts", "size_bytes", b"size_bytes"]) -> None: ...

global___StartMultipartUploadDraftRequest = StartMultipartUploadDraftRequest

@typing.final
class StartMultipartUploadDraftResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATASET_ID_FIELD_NUMBER: builtins.int
    MULTIPART_UPLOAD_URLS_FIELD_NUMBER: builtins.int
    dataset_id: builtins.str
    """ID of the dataset."""
    @property
    def multipart_upload_urls(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of S3 presigned URLs for multipart upload."""

    def __init__(
        self,
        *,
        dataset_id: builtins.str = ...,
        multipart_upload_urls: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["dataset_id", b"dataset_id", "multipart_upload_urls", b"multipart_upload_urls"]) -> None: ...

global___StartMultipartUploadDraftResponse = StartMultipartUploadDraftResponse

@typing.final
class UploadedPartInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PART_NUM_FIELD_NUMBER: builtins.int
    ETAG_FIELD_NUMBER: builtins.int
    part_num: builtins.int
    """Sequence number of the uploaded part."""
    etag: builtins.str
    """Etag of the uploaded part."""
    def __init__(
        self,
        *,
        part_num: builtins.int = ...,
        etag: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["etag", b"etag", "part_num", b"part_num"]) -> None: ...

global___UploadedPartInfo = UploadedPartInfo

@typing.final
class FinishMultipartUploadDraftRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATASET_ID_FIELD_NUMBER: builtins.int
    UPLOADED_PARTS_FIELD_NUMBER: builtins.int
    dataset_id: builtins.str
    """ID of the dataset."""
    @property
    def uploaded_parts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___UploadedPartInfo]:
        """Information about uploaded parts from S3 API."""

    def __init__(
        self,
        *,
        dataset_id: builtins.str = ...,
        uploaded_parts: collections.abc.Iterable[global___UploadedPartInfo] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["dataset_id", b"dataset_id", "uploaded_parts", b"uploaded_parts"]) -> None: ...

global___FinishMultipartUploadDraftRequest = FinishMultipartUploadDraftRequest

@typing.final
class FinishMultipartUploadDraftResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATASET_ID_FIELD_NUMBER: builtins.int
    dataset_id: builtins.str
    """ID of the dataset."""
    def __init__(
        self,
        *,
        dataset_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["dataset_id", b"dataset_id"]) -> None: ...

global___FinishMultipartUploadDraftResponse = FinishMultipartUploadDraftResponse

@typing.final
class ListDatasetsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    DATASET_NAME_PATTERN_FIELD_NUMBER: builtins.int
    TASK_TYPE_FILTER_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    DATASET_IDS_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """Folder ID of the datasets to list."""
    dataset_name_pattern: builtins.str
    """Name substring of the datasets to list. Optional."""
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size],
    the service returns a [ListDatasetsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests. Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the
    [ListDatasetsResponse.next_page_token] returned by a previous list request.
    """
    @property
    def status(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[yandex.cloud.ai.dataset.v1.dataset_pb2.DatasetInfo.Status.ValueType]:
        """Statuses of the datasets to list. Optional."""

    @property
    def task_type_filter(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Task types of the datasets to list. Optional."""

    @property
    def dataset_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Dataset Id of the datasets to list. Optional."""

    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        status: collections.abc.Iterable[yandex.cloud.ai.dataset.v1.dataset_pb2.DatasetInfo.Status.ValueType] | None = ...,
        dataset_name_pattern: builtins.str = ...,
        task_type_filter: collections.abc.Iterable[builtins.str] | None = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        dataset_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["dataset_ids", b"dataset_ids", "dataset_name_pattern", b"dataset_name_pattern", "folder_id", b"folder_id", "page_size", b"page_size", "page_token", b"page_token", "status", b"status", "task_type_filter", b"task_type_filter"]) -> None: ...

global___ListDatasetsRequest = ListDatasetsRequest

@typing.final
class ListDatasetsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATASETS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """[next_page_token] token allows you to get the next page of results for list requests.
    If the number of results is larger than [ListDatasetsRequest.page_size], use
    the [next_page_token] as the value for the [ListDatasetsRequest.page_token] query parameter
    in the next list request. Each subsequent list request will have its own
    [next_page_token] to continue paging through the results.
    """
    @property
    def datasets(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.ai.dataset.v1.dataset_pb2.DatasetInfo]:
        """Information about listed datasets."""

    def __init__(
        self,
        *,
        datasets: collections.abc.Iterable[yandex.cloud.ai.dataset.v1.dataset_pb2.DatasetInfo] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["datasets", b"datasets", "next_page_token", b"next_page_token"]) -> None: ...

global___ListDatasetsResponse = ListDatasetsResponse

@typing.final
class ListUploadFormatsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TASK_TYPE_FIELD_NUMBER: builtins.int
    task_type: builtins.str
    """Dataset task type to list upload formats."""
    def __init__(
        self,
        *,
        task_type: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["task_type", b"task_type"]) -> None: ...

global___ListUploadFormatsRequest = ListUploadFormatsRequest

@typing.final
class ListUploadFormatsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FORMATS_FIELD_NUMBER: builtins.int
    @property
    def formats(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of upload formats for the specified dataset task type."""

    def __init__(
        self,
        *,
        formats: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["formats", b"formats"]) -> None: ...

global___ListUploadFormatsResponse = ListUploadFormatsResponse

@typing.final
class ListUploadSchemasRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TASK_TYPE_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    task_type: builtins.str
    """Dataset task type to list schemas."""
    folder_id: builtins.str
    """Folder to search task type (if empty only public types allowed)"""
    def __init__(
        self,
        *,
        task_type: builtins.str = ...,
        folder_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["folder_id", b"folder_id", "task_type", b"task_type"]) -> None: ...

global___ListUploadSchemasRequest = ListUploadSchemasRequest

@typing.final
class ListUploadSchemasResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SCHEMAS_FIELD_NUMBER: builtins.int
    @property
    def schemas(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.ai.dataset.v1.dataset_pb2.DatasetUploadSchema]:
        """List of dataset schemas for the specified dataset task type."""

    def __init__(
        self,
        *,
        schemas: collections.abc.Iterable[yandex.cloud.ai.dataset.v1.dataset_pb2.DatasetUploadSchema] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["schemas", b"schemas"]) -> None: ...

global___ListUploadSchemasResponse = ListUploadSchemasResponse

@typing.final
class ListTypesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """Folder to search task types (if empty only public types will be returned)"""
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["folder_id", b"folder_id"]) -> None: ...

global___ListTypesRequest = ListTypesRequest

@typing.final
class ListTypesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TYPES_FIELD_NUMBER: builtins.int
    @property
    def types(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of dataset type"""

    def __init__(
        self,
        *,
        types: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["types", b"types"]) -> None: ...

global___ListTypesResponse = ListTypesResponse

@typing.final
class GetDatasetPreviewRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATASET_ID_FIELD_NUMBER: builtins.int
    dataset_id: builtins.str
    """ID of the dataset."""
    def __init__(
        self,
        *,
        dataset_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["dataset_id", b"dataset_id"]) -> None: ...

global___GetDatasetPreviewRequest = GetDatasetPreviewRequest

@typing.final
class GetDatasetPreviewResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATASET_ID_FIELD_NUMBER: builtins.int
    PREVIEW_LINES_FIELD_NUMBER: builtins.int
    dataset_id: builtins.str
    """ID of the dataset."""
    @property
    def preview_lines(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of dataset preview lines"""

    def __init__(
        self,
        *,
        dataset_id: builtins.str = ...,
        preview_lines: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["dataset_id", b"dataset_id", "preview_lines", b"preview_lines"]) -> None: ...

global___GetDatasetPreviewResponse = GetDatasetPreviewResponse

@typing.final
class GetDownloadUrlsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATASET_ID_FIELD_NUMBER: builtins.int
    dataset_id: builtins.str
    """ID of the dataset."""
    def __init__(
        self,
        *,
        dataset_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["dataset_id", b"dataset_id"]) -> None: ...

global___GetDownloadUrlsRequest = GetDownloadUrlsRequest

@typing.final
class GetDownloadUrlsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATASET_ID_FIELD_NUMBER: builtins.int
    DOWNLOAD_URLS_FIELD_NUMBER: builtins.int
    dataset_id: builtins.str
    """ID of the dataset."""
    @property
    def download_urls(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.ai.dataset.v1.dataset_pb2.DatasetFileDownloadUrl]: ...
    def __init__(
        self,
        *,
        dataset_id: builtins.str = ...,
        download_urls: collections.abc.Iterable[yandex.cloud.ai.dataset.v1.dataset_pb2.DatasetFileDownloadUrl] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["dataset_id", b"dataset_id", "download_urls", b"download_urls"]) -> None: ...

global___GetDownloadUrlsResponse = GetDownloadUrlsResponse

@typing.final
class ListOperationsIdsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATASET_ID_FIELD_NUMBER: builtins.int
    @property
    def dataset_id(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        dataset_id: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["dataset_id", b"dataset_id"]) -> None: ...

global___ListOperationsIdsRequest = ListOperationsIdsRequest

@typing.final
class ListOperationsIdsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class DatasetIdToOperationIdEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    DATASET_ID_TO_OPERATION_ID_FIELD_NUMBER: builtins.int
    @property
    def dataset_id_to_operation_id(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]: ...
    def __init__(
        self,
        *,
        dataset_id_to_operation_id: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["dataset_id_to_operation_id", b"dataset_id_to_operation_id"]) -> None: ...

global___ListOperationsIdsResponse = ListOperationsIdsResponse
