"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.struct_pb2
import google.protobuf.wrappers_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class CompletionOptions(google.protobuf.message.Message):
    """Defines the options for completion generation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STREAM_FIELD_NUMBER: builtins.int
    TEMPERATURE_FIELD_NUMBER: builtins.int
    MAX_TOKENS_FIELD_NUMBER: builtins.int
    REASONING_OPTIONS_FIELD_NUMBER: builtins.int
    stream: builtins.bool
    """Enables streaming of partially generated text."""
    @property
    def temperature(self) -> google.protobuf.wrappers_pb2.DoubleValue:
        """Affects creativity and randomness of responses. Should be a double number between 0 (inclusive) and 1 (inclusive).
        Lower values produce more straightforward responses while higher values lead to increased creativity and randomness.
        Default temperature: 0.3
        """

    @property
    def max_tokens(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The limit on the number of tokens used for single completion generation.
        Must be greater than zero. This maximum allowed parameter value may depend on the model being used.
        """

    @property
    def reasoning_options(self) -> global___ReasoningOptions:
        """Configures reasoning capabilities for the model, allowing it to perform internal reasoning before responding."""

    def __init__(
        self,
        *,
        stream: builtins.bool = ...,
        temperature: google.protobuf.wrappers_pb2.DoubleValue | None = ...,
        max_tokens: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        reasoning_options: global___ReasoningOptions | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["max_tokens", b"max_tokens", "reasoning_options", b"reasoning_options", "temperature", b"temperature"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["max_tokens", b"max_tokens", "reasoning_options", b"reasoning_options", "stream", b"stream", "temperature", b"temperature"]) -> None: ...

global___CompletionOptions = CompletionOptions

@typing.final
class ReasoningOptions(google.protobuf.message.Message):
    """Represents reasoning options that enable the model's ability to perform internal reasoning before generating a response."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _ReasoningMode:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ReasoningModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ReasoningOptions._ReasoningMode.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        REASONING_MODE_UNSPECIFIED: ReasoningOptions._ReasoningMode.ValueType  # 0
        """Unspecified reasoning mode."""
        DISABLED: ReasoningOptions._ReasoningMode.ValueType  # 1
        """Disables reasoning. The model will generate a response without performing any internal reasoning."""
        ENABLED_HIDDEN: ReasoningOptions._ReasoningMode.ValueType  # 2
        """Enables reasoning in a hidden manner without exposing the reasoning steps to the user."""

    class ReasoningMode(_ReasoningMode, metaclass=_ReasoningModeEnumTypeWrapper):
        """Enum representing the reasoning mode."""

    REASONING_MODE_UNSPECIFIED: ReasoningOptions.ReasoningMode.ValueType  # 0
    """Unspecified reasoning mode."""
    DISABLED: ReasoningOptions.ReasoningMode.ValueType  # 1
    """Disables reasoning. The model will generate a response without performing any internal reasoning."""
    ENABLED_HIDDEN: ReasoningOptions.ReasoningMode.ValueType  # 2
    """Enables reasoning in a hidden manner without exposing the reasoning steps to the user."""

    MODE_FIELD_NUMBER: builtins.int
    mode: global___ReasoningOptions.ReasoningMode.ValueType
    """Specifies the reasoning mode to be used."""
    def __init__(
        self,
        *,
        mode: global___ReasoningOptions.ReasoningMode.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["mode", b"mode"]) -> None: ...

global___ReasoningOptions = ReasoningOptions

@typing.final
class Message(google.protobuf.message.Message):
    """A message object representing a wrapper over the inputs and outputs of the completion model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROLE_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int
    TOOL_CALL_LIST_FIELD_NUMBER: builtins.int
    TOOL_RESULT_LIST_FIELD_NUMBER: builtins.int
    role: builtins.str
    """The ID of the message sender. Supported roles:
    * `system`: Special role used to define the behavior of the completion model.
    * `assistant`: A role used by the model to generate responses.
    * `user`: A role used by the user to describe requests to the model.
    """
    text: builtins.str
    """Textual content of the message."""
    @property
    def tool_call_list(self) -> global___ToolCallList:
        """List of tool calls made by the model as part of the response generation."""

    @property
    def tool_result_list(self) -> global___ToolResultList:
        """List of tool results returned from external tools that were invoked by the model."""

    def __init__(
        self,
        *,
        role: builtins.str = ...,
        text: builtins.str = ...,
        tool_call_list: global___ToolCallList | None = ...,
        tool_result_list: global___ToolResultList | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["Content", b"Content", "text", b"text", "tool_call_list", b"tool_call_list", "tool_result_list", b"tool_result_list"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["Content", b"Content", "role", b"role", "text", b"text", "tool_call_list", b"tool_call_list", "tool_result_list", b"tool_result_list"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["Content", b"Content"]) -> typing.Literal["text", "tool_call_list", "tool_result_list"] | None: ...

global___Message = Message

@typing.final
class ContentUsage(google.protobuf.message.Message):
    """An object representing the number of content [tokens](/docs/foundation-models/concepts/yandexgpt/tokens) used by the completion model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class CompletionTokensDetails(google.protobuf.message.Message):
        """Provides additional information about how the completion tokens were utilized."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        REASONING_TOKENS_FIELD_NUMBER: builtins.int
        reasoning_tokens: builtins.int
        """The number of tokens used specifically for internal reasoning performed by the model."""
        def __init__(
            self,
            *,
            reasoning_tokens: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["reasoning_tokens", b"reasoning_tokens"]) -> None: ...

    INPUT_TEXT_TOKENS_FIELD_NUMBER: builtins.int
    COMPLETION_TOKENS_FIELD_NUMBER: builtins.int
    TOTAL_TOKENS_FIELD_NUMBER: builtins.int
    COMPLETION_TOKENS_DETAILS_FIELD_NUMBER: builtins.int
    input_text_tokens: builtins.int
    """The number of tokens in the textual part of the model input."""
    completion_tokens: builtins.int
    """The number of tokens in the generated completion."""
    total_tokens: builtins.int
    """The total number of tokens, including all input tokens and all generated tokens."""
    @property
    def completion_tokens_details(self) -> global___ContentUsage.CompletionTokensDetails:
        """Provides additional information about how the completion tokens were utilized."""

    def __init__(
        self,
        *,
        input_text_tokens: builtins.int = ...,
        completion_tokens: builtins.int = ...,
        total_tokens: builtins.int = ...,
        completion_tokens_details: global___ContentUsage.CompletionTokensDetails | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["completion_tokens_details", b"completion_tokens_details"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["completion_tokens", b"completion_tokens", "completion_tokens_details", b"completion_tokens_details", "input_text_tokens", b"input_text_tokens", "total_tokens", b"total_tokens"]) -> None: ...

global___ContentUsage = ContentUsage

@typing.final
class Alternative(google.protobuf.message.Message):
    """Represents a generated completion alternative, including its content and generation status."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _AlternativeStatus:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _AlternativeStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Alternative._AlternativeStatus.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        ALTERNATIVE_STATUS_UNSPECIFIED: Alternative._AlternativeStatus.ValueType  # 0
        """Unspecified generation status."""
        ALTERNATIVE_STATUS_PARTIAL: Alternative._AlternativeStatus.ValueType  # 1
        """Partially generated alternative."""
        ALTERNATIVE_STATUS_TRUNCATED_FINAL: Alternative._AlternativeStatus.ValueType  # 2
        """Incomplete final alternative resulting from reaching the maximum allowed number of tokens."""
        ALTERNATIVE_STATUS_FINAL: Alternative._AlternativeStatus.ValueType  # 3
        """Final alternative generated without running into any limits."""
        ALTERNATIVE_STATUS_CONTENT_FILTER: Alternative._AlternativeStatus.ValueType  # 4
        """Generation was stopped due to the discovery of potentially sensitive content in the prompt or generated response.
        To fix, modify the prompt and restart generation.
        """
        ALTERNATIVE_STATUS_TOOL_CALLS: Alternative._AlternativeStatus.ValueType  # 5
        """Tools were invoked during the completion generation."""

    class AlternativeStatus(_AlternativeStatus, metaclass=_AlternativeStatusEnumTypeWrapper):
        """Enum representing the generation status of the alternative."""

    ALTERNATIVE_STATUS_UNSPECIFIED: Alternative.AlternativeStatus.ValueType  # 0
    """Unspecified generation status."""
    ALTERNATIVE_STATUS_PARTIAL: Alternative.AlternativeStatus.ValueType  # 1
    """Partially generated alternative."""
    ALTERNATIVE_STATUS_TRUNCATED_FINAL: Alternative.AlternativeStatus.ValueType  # 2
    """Incomplete final alternative resulting from reaching the maximum allowed number of tokens."""
    ALTERNATIVE_STATUS_FINAL: Alternative.AlternativeStatus.ValueType  # 3
    """Final alternative generated without running into any limits."""
    ALTERNATIVE_STATUS_CONTENT_FILTER: Alternative.AlternativeStatus.ValueType  # 4
    """Generation was stopped due to the discovery of potentially sensitive content in the prompt or generated response.
    To fix, modify the prompt and restart generation.
    """
    ALTERNATIVE_STATUS_TOOL_CALLS: Alternative.AlternativeStatus.ValueType  # 5
    """Tools were invoked during the completion generation."""

    MESSAGE_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    status: global___Alternative.AlternativeStatus.ValueType
    """The generation status of the alternative."""
    @property
    def message(self) -> global___Message:
        """A message with the content of the alternative."""

    def __init__(
        self,
        *,
        message: global___Message | None = ...,
        status: global___Alternative.AlternativeStatus.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["message", b"message"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["message", b"message", "status", b"status"]) -> None: ...

global___Alternative = Alternative

@typing.final
class Token(google.protobuf.message.Message):
    """Represents a token, the basic unit of content, used by the foundation model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int
    SPECIAL_FIELD_NUMBER: builtins.int
    id: builtins.int
    """An internal token identifier."""
    text: builtins.str
    """The textual representation of the token."""
    special: builtins.bool
    """Indicates whether the token is special or not. Special tokens may define the model's behavior and are not visible to users."""
    def __init__(
        self,
        *,
        id: builtins.int = ...,
        text: builtins.str = ...,
        special: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["id", b"id", "special", b"special", "text", b"text"]) -> None: ...

global___Token = Token

@typing.final
class Tool(google.protobuf.message.Message):
    """Represents a tool that can be invoked during completion generation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FUNCTION_FIELD_NUMBER: builtins.int
    @property
    def function(self) -> global___FunctionTool:
        """Represents a function that can be called."""

    def __init__(
        self,
        *,
        function: global___FunctionTool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["ToolType", b"ToolType", "function", b"function"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["ToolType", b"ToolType", "function", b"function"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["ToolType", b"ToolType"]) -> typing.Literal["function"] | None: ...

global___Tool = Tool

@typing.final
class FunctionTool(google.protobuf.message.Message):
    """Represents a function tool that can be invoked during completion generation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    PARAMETERS_FIELD_NUMBER: builtins.int
    STRICT_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the function."""
    description: builtins.str
    """A description of the function's purpose or behavior."""
    strict: builtins.bool
    """Enforces strict adherence to the function schema, ensuring only defined parameters are used."""
    @property
    def parameters(self) -> google.protobuf.struct_pb2.Struct:
        """A JSON Schema that defines the expected parameters for the function.
        The schema should describe the required fields, their types, and any constraints or default values.
        """

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        description: builtins.str = ...,
        parameters: google.protobuf.struct_pb2.Struct | None = ...,
        strict: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["parameters", b"parameters"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "name", b"name", "parameters", b"parameters", "strict", b"strict"]) -> None: ...

global___FunctionTool = FunctionTool

@typing.final
class ToolCall(google.protobuf.message.Message):
    """Represents a call to a tool."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FUNCTION_CALL_FIELD_NUMBER: builtins.int
    @property
    def function_call(self) -> global___FunctionCall:
        """Represents a call to a function."""

    def __init__(
        self,
        *,
        function_call: global___FunctionCall | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["ToolCallType", b"ToolCallType", "function_call", b"function_call"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["ToolCallType", b"ToolCallType", "function_call", b"function_call"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["ToolCallType", b"ToolCallType"]) -> typing.Literal["function_call"] | None: ...

global___ToolCall = ToolCall

@typing.final
class FunctionCall(google.protobuf.message.Message):
    """Represents the invocation of a function with specific arguments."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    ARGUMENTS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the function being called."""
    @property
    def arguments(self) -> google.protobuf.struct_pb2.Struct:
        """The structured arguments passed to the function.
        These arguments must adhere to the JSON Schema defined in the corresponding function's parameters.
        """

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        arguments: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["arguments", b"arguments"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["arguments", b"arguments", "name", b"name"]) -> None: ...

global___FunctionCall = FunctionCall

@typing.final
class ToolCallList(google.protobuf.message.Message):
    """Represents a list of tool calls."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOOL_CALLS_FIELD_NUMBER: builtins.int
    @property
    def tool_calls(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ToolCall]:
        """A list of tool calls to be executed."""

    def __init__(
        self,
        *,
        tool_calls: collections.abc.Iterable[global___ToolCall] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["tool_calls", b"tool_calls"]) -> None: ...

global___ToolCallList = ToolCallList

@typing.final
class ToolResult(google.protobuf.message.Message):
    """Represents the result of a tool call."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FUNCTION_RESULT_FIELD_NUMBER: builtins.int
    @property
    def function_result(self) -> global___FunctionResult:
        """Represents the result of a function call."""

    def __init__(
        self,
        *,
        function_result: global___FunctionResult | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["ToolResultType", b"ToolResultType", "function_result", b"function_result"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["ToolResultType", b"ToolResultType", "function_result", b"function_result"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["ToolResultType", b"ToolResultType"]) -> typing.Literal["function_result"] | None: ...

global___ToolResult = ToolResult

@typing.final
class FunctionResult(google.protobuf.message.Message):
    """Represents the result of a function call."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the function that was executed."""
    content: builtins.str
    """The result of the function call, represented as a string.
    This field can be used to store the output of the function.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        content: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["ContentType", b"ContentType", "content", b"content"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["ContentType", b"ContentType", "content", b"content", "name", b"name"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["ContentType", b"ContentType"]) -> typing.Literal["content"] | None: ...

global___FunctionResult = FunctionResult

@typing.final
class ToolResultList(google.protobuf.message.Message):
    """Represents a list of tool results."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOOL_RESULTS_FIELD_NUMBER: builtins.int
    @property
    def tool_results(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ToolResult]:
        """A list of tool results."""

    def __init__(
        self,
        *,
        tool_results: collections.abc.Iterable[global___ToolResult] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["tool_results", b"tool_results"]) -> None: ...

global___ToolResultList = ToolResultList

@typing.final
class JsonSchema(google.protobuf.message.Message):
    """Represents the expected structure of the model's response using a JSON Schema."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SCHEMA_FIELD_NUMBER: builtins.int
    @property
    def schema(self) -> google.protobuf.struct_pb2.Struct:
        """The JSON Schema that the model's output must conform to."""

    def __init__(
        self,
        *,
        schema: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["schema", b"schema"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["schema", b"schema"]) -> None: ...

global___JsonSchema = JsonSchema

@typing.final
class ToolChoice(google.protobuf.message.Message):
    """Specifies how the model should select which tool (or tools) to use when generating a response."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _ToolChoiceMode:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ToolChoiceModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ToolChoice._ToolChoiceMode.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TOOL_CHOICE_MODE_UNSPECIFIED: ToolChoice._ToolChoiceMode.ValueType  # 0
        """The server will choose the default behavior, which is AUTO."""
        NONE: ToolChoice._ToolChoiceMode.ValueType  # 1
        """The model will not call any tool and will generate a standard text response."""
        AUTO: ToolChoice._ToolChoiceMode.ValueType  # 2
        """The model can choose between generating a text response or calling one or more tools.
        This is the default behavior.
        """
        REQUIRED: ToolChoice._ToolChoiceMode.ValueType  # 3
        """The model is required to call one or more tools."""

    class ToolChoiceMode(_ToolChoiceMode, metaclass=_ToolChoiceModeEnumTypeWrapper):
        """Defines the different modes for tool calling."""

    TOOL_CHOICE_MODE_UNSPECIFIED: ToolChoice.ToolChoiceMode.ValueType  # 0
    """The server will choose the default behavior, which is AUTO."""
    NONE: ToolChoice.ToolChoiceMode.ValueType  # 1
    """The model will not call any tool and will generate a standard text response."""
    AUTO: ToolChoice.ToolChoiceMode.ValueType  # 2
    """The model can choose between generating a text response or calling one or more tools.
    This is the default behavior.
    """
    REQUIRED: ToolChoice.ToolChoiceMode.ValueType  # 3
    """The model is required to call one or more tools."""

    MODE_FIELD_NUMBER: builtins.int
    FUNCTION_NAME_FIELD_NUMBER: builtins.int
    mode: global___ToolChoice.ToolChoiceMode.ValueType
    """Specifies the overall tool-calling mode."""
    function_name: builtins.str
    """Forces the model to call a specific function.
    The provided string must match the name of a function in the API request.
    """
    def __init__(
        self,
        *,
        mode: global___ToolChoice.ToolChoiceMode.ValueType = ...,
        function_name: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["ToolChoice", b"ToolChoice", "function_name", b"function_name", "mode", b"mode"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["ToolChoice", b"ToolChoice", "function_name", b"function_name", "mode", b"mode"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["ToolChoice", b"ToolChoice"]) -> typing.Literal["mode", "function_name"] | None: ...

global___ToolChoice = ToolChoice
