"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _LoudnessNormalizationType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _LoudnessNormalizationTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_LoudnessNormalizationType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    LOUDNESS_NORMALIZATION_TYPE_UNSPECIFIED: _LoudnessNormalizationType.ValueType  # 0
    """Unspecified loudness normalization. The default behavior will be used."""
    MAX_PEAK: _LoudnessNormalizationType.ValueType  # 1
    """The type of normalization, wherein the gain is changed to bring the highest PCM sample value or analog signal peak to a given level."""
    LUFS: _LoudnessNormalizationType.ValueType  # 2
    """The type of normalization based on EBU R 128 recommendation."""

class LoudnessNormalizationType(_LoudnessNormalizationType, metaclass=_LoudnessNormalizationTypeEnumTypeWrapper):
    """Specifies the loudness normalization algorithm to use when synthesizing audio."""

LOUDNESS_NORMALIZATION_TYPE_UNSPECIFIED: LoudnessNormalizationType.ValueType  # 0
"""Unspecified loudness normalization. The default behavior will be used."""
MAX_PEAK: LoudnessNormalizationType.ValueType  # 1
"""The type of normalization, wherein the gain is changed to bring the highest PCM sample value or analog signal peak to a given level."""
LUFS: LoudnessNormalizationType.ValueType  # 2
"""The type of normalization based on EBU R 128 recommendation."""
global___LoudnessNormalizationType = LoudnessNormalizationType

@typing.final
class AudioContent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTENT_FIELD_NUMBER: builtins.int
    AUDIO_SPEC_FIELD_NUMBER: builtins.int
    content: builtins.bytes
    """Bytes with audio data."""
    @property
    def audio_spec(self) -> global___AudioFormatOptions:
        """Description of the audio format."""

    def __init__(
        self,
        *,
        content: builtins.bytes = ...,
        audio_spec: global___AudioFormatOptions | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["AudioSource", b"AudioSource", "audio_spec", b"audio_spec", "content", b"content"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["AudioSource", b"AudioSource", "audio_spec", b"audio_spec", "content", b"content"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["AudioSource", b"AudioSource"]) -> typing.Literal["content"] | None: ...

global___AudioContent = AudioContent

@typing.final
class AudioFormatOptions(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RAW_AUDIO_FIELD_NUMBER: builtins.int
    CONTAINER_AUDIO_FIELD_NUMBER: builtins.int
    @property
    def raw_audio(self) -> global___RawAudio:
        """The audio format specified in request parameters."""

    @property
    def container_audio(self) -> global___ContainerAudio:
        """The audio format specified inside the container metadata."""

    def __init__(
        self,
        *,
        raw_audio: global___RawAudio | None = ...,
        container_audio: global___ContainerAudio | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["AudioFormat", b"AudioFormat", "container_audio", b"container_audio", "raw_audio", b"raw_audio"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["AudioFormat", b"AudioFormat", "container_audio", b"container_audio", "raw_audio", b"raw_audio"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["AudioFormat", b"AudioFormat"]) -> typing.Literal["raw_audio", "container_audio"] | None: ...

global___AudioFormatOptions = AudioFormatOptions

@typing.final
class RawAudio(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _AudioEncoding:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _AudioEncodingEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[RawAudio._AudioEncoding.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        AUDIO_ENCODING_UNSPECIFIED: RawAudio._AudioEncoding.ValueType  # 0
        LINEAR16_PCM: RawAudio._AudioEncoding.ValueType  # 1
        """Audio bit depth 16-bit signed little-endian (Linear PCM)."""

    class AudioEncoding(_AudioEncoding, metaclass=_AudioEncodingEnumTypeWrapper): ...
    AUDIO_ENCODING_UNSPECIFIED: RawAudio.AudioEncoding.ValueType  # 0
    LINEAR16_PCM: RawAudio.AudioEncoding.ValueType  # 1
    """Audio bit depth 16-bit signed little-endian (Linear PCM)."""

    AUDIO_ENCODING_FIELD_NUMBER: builtins.int
    SAMPLE_RATE_HERTZ_FIELD_NUMBER: builtins.int
    audio_encoding: global___RawAudio.AudioEncoding.ValueType
    """Encoding type."""
    sample_rate_hertz: builtins.int
    """Sampling frequency of the signal."""
    def __init__(
        self,
        *,
        audio_encoding: global___RawAudio.AudioEncoding.ValueType = ...,
        sample_rate_hertz: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["audio_encoding", b"audio_encoding", "sample_rate_hertz", b"sample_rate_hertz"]) -> None: ...

global___RawAudio = RawAudio

@typing.final
class ContainerAudio(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _ContainerAudioType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ContainerAudioTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ContainerAudio._ContainerAudioType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        CONTAINER_AUDIO_TYPE_UNSPECIFIED: ContainerAudio._ContainerAudioType.ValueType  # 0
        WAV: ContainerAudio._ContainerAudioType.ValueType  # 1
        """Audio bit depth 16-bit signed little-endian (Linear PCM)."""
        OGG_OPUS: ContainerAudio._ContainerAudioType.ValueType  # 2
        """Data is encoded using the OPUS audio codec and compressed using the OGG container format."""
        MP3: ContainerAudio._ContainerAudioType.ValueType  # 3
        """Data is encoded using MPEG-1/2 Layer III and compressed using the MP3 container format."""

    class ContainerAudioType(_ContainerAudioType, metaclass=_ContainerAudioTypeEnumTypeWrapper): ...
    CONTAINER_AUDIO_TYPE_UNSPECIFIED: ContainerAudio.ContainerAudioType.ValueType  # 0
    WAV: ContainerAudio.ContainerAudioType.ValueType  # 1
    """Audio bit depth 16-bit signed little-endian (Linear PCM)."""
    OGG_OPUS: ContainerAudio.ContainerAudioType.ValueType  # 2
    """Data is encoded using the OPUS audio codec and compressed using the OGG container format."""
    MP3: ContainerAudio.ContainerAudioType.ValueType  # 3
    """Data is encoded using MPEG-1/2 Layer III and compressed using the MP3 container format."""

    CONTAINER_AUDIO_TYPE_FIELD_NUMBER: builtins.int
    container_audio_type: global___ContainerAudio.ContainerAudioType.ValueType
    def __init__(
        self,
        *,
        container_audio_type: global___ContainerAudio.ContainerAudioType.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["container_audio_type", b"container_audio_type"]) -> None: ...

global___ContainerAudio = ContainerAudio

@typing.final
class TextVariable(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VARIABLE_NAME_FIELD_NUMBER: builtins.int
    VARIABLE_VALUE_FIELD_NUMBER: builtins.int
    variable_name: builtins.str
    """The name of the variable."""
    variable_value: builtins.str
    """The text of the variable."""
    def __init__(
        self,
        *,
        variable_name: builtins.str = ...,
        variable_value: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["variable_name", b"variable_name", "variable_value", b"variable_value"]) -> None: ...

global___TextVariable = TextVariable

@typing.final
class AudioVariable(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VARIABLE_NAME_FIELD_NUMBER: builtins.int
    VARIABLE_START_MS_FIELD_NUMBER: builtins.int
    VARIABLE_LENGTH_MS_FIELD_NUMBER: builtins.int
    variable_name: builtins.str
    """The name of the variable."""
    variable_start_ms: builtins.int
    """Start time of the variable in milliseconds."""
    variable_length_ms: builtins.int
    """Length of the variable in milliseconds."""
    def __init__(
        self,
        *,
        variable_name: builtins.str = ...,
        variable_start_ms: builtins.int = ...,
        variable_length_ms: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["variable_length_ms", b"variable_length_ms", "variable_name", b"variable_name", "variable_start_ms", b"variable_start_ms"]) -> None: ...

global___AudioVariable = AudioVariable

@typing.final
class UtteranceSynthesisResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AUDIO_CHUNK_FIELD_NUMBER: builtins.int
    TEXT_CHUNK_FIELD_NUMBER: builtins.int
    START_MS_FIELD_NUMBER: builtins.int
    LENGTH_MS_FIELD_NUMBER: builtins.int
    start_ms: builtins.int
    """Start time of the audio chunk in milliseconds."""
    length_ms: builtins.int
    """Length of the audio chunk in milliseconds."""
    @property
    def audio_chunk(self) -> global___AudioChunk:
        """Part of synthesized audio."""

    @property
    def text_chunk(self) -> global___TextChunk:
        """Part of synthesized text."""

    def __init__(
        self,
        *,
        audio_chunk: global___AudioChunk | None = ...,
        text_chunk: global___TextChunk | None = ...,
        start_ms: builtins.int = ...,
        length_ms: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["audio_chunk", b"audio_chunk", "text_chunk", b"text_chunk"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["audio_chunk", b"audio_chunk", "length_ms", b"length_ms", "start_ms", b"start_ms", "text_chunk", b"text_chunk"]) -> None: ...

global___UtteranceSynthesisResponse = UtteranceSynthesisResponse

@typing.final
class AudioTemplate(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AUDIO_FIELD_NUMBER: builtins.int
    TEXT_TEMPLATE_FIELD_NUMBER: builtins.int
    VARIABLES_FIELD_NUMBER: builtins.int
    @property
    def audio(self) -> global___AudioContent:
        """Audio file."""

    @property
    def text_template(self) -> global___TextTemplate:
        """Template and description of its variables."""

    @property
    def variables(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AudioVariable]:
        """Describing variables in audio."""

    def __init__(
        self,
        *,
        audio: global___AudioContent | None = ...,
        text_template: global___TextTemplate | None = ...,
        variables: collections.abc.Iterable[global___AudioVariable] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["audio", b"audio", "text_template", b"text_template"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["audio", b"audio", "text_template", b"text_template", "variables", b"variables"]) -> None: ...

global___AudioTemplate = AudioTemplate

@typing.final
class AudioChunk(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATA_FIELD_NUMBER: builtins.int
    data: builtins.bytes
    """Sequence of bytes of the synthesized audio in format specified in output_audio_spec."""
    def __init__(
        self,
        *,
        data: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["data", b"data"]) -> None: ...

global___AudioChunk = AudioChunk

@typing.final
class TextChunk(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEXT_FIELD_NUMBER: builtins.int
    text: builtins.str
    """Synthesized text."""
    def __init__(
        self,
        *,
        text: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["text", b"text"]) -> None: ...

global___TextChunk = TextChunk

@typing.final
class TextTemplate(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEXT_TEMPLATE_FIELD_NUMBER: builtins.int
    VARIABLES_FIELD_NUMBER: builtins.int
    text_template: builtins.str
    """Template text.

    Sample:`The {animal} goes to the {place}.`
    """
    @property
    def variables(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TextVariable]:
        """Defining variables in template text.

        Sample: `{animal: cat, place: forest}`
        """

    def __init__(
        self,
        *,
        text_template: builtins.str = ...,
        variables: collections.abc.Iterable[global___TextVariable] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["text_template", b"text_template", "variables", b"variables"]) -> None: ...

global___TextTemplate = TextTemplate

@typing.final
class DurationHint(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _DurationHintPolicy:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _DurationHintPolicyEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[DurationHint._DurationHintPolicy.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        DURATION_HINT_POLICY_UNSPECIFIED: DurationHint._DurationHintPolicy.ValueType  # 0
        EXACT_DURATION: DurationHint._DurationHintPolicy.ValueType  # 1
        """Limit audio duration to exact value."""
        MIN_DURATION: DurationHint._DurationHintPolicy.ValueType  # 2
        """Limit the minimum audio duration."""
        MAX_DURATION: DurationHint._DurationHintPolicy.ValueType  # 3
        """Limit the maximum audio duration."""

    class DurationHintPolicy(_DurationHintPolicy, metaclass=_DurationHintPolicyEnumTypeWrapper): ...
    DURATION_HINT_POLICY_UNSPECIFIED: DurationHint.DurationHintPolicy.ValueType  # 0
    EXACT_DURATION: DurationHint.DurationHintPolicy.ValueType  # 1
    """Limit audio duration to exact value."""
    MIN_DURATION: DurationHint.DurationHintPolicy.ValueType  # 2
    """Limit the minimum audio duration."""
    MAX_DURATION: DurationHint.DurationHintPolicy.ValueType  # 3
    """Limit the maximum audio duration."""

    POLICY_FIELD_NUMBER: builtins.int
    DURATION_MS_FIELD_NUMBER: builtins.int
    policy: global___DurationHint.DurationHintPolicy.ValueType
    """Type of duration constraint."""
    duration_ms: builtins.int
    """Constraint on audio duration in milliseconds."""
    def __init__(
        self,
        *,
        policy: global___DurationHint.DurationHintPolicy.ValueType = ...,
        duration_ms: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["duration_ms", b"duration_ms", "policy", b"policy"]) -> None: ...

global___DurationHint = DurationHint

@typing.final
class Hints(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VOICE_FIELD_NUMBER: builtins.int
    AUDIO_TEMPLATE_FIELD_NUMBER: builtins.int
    SPEED_FIELD_NUMBER: builtins.int
    VOLUME_FIELD_NUMBER: builtins.int
    ROLE_FIELD_NUMBER: builtins.int
    PITCH_SHIFT_FIELD_NUMBER: builtins.int
    DURATION_FIELD_NUMBER: builtins.int
    voice: builtins.str
    """Name of speaker to use."""
    speed: builtins.float
    """Hint to change speed."""
    volume: builtins.float
    """Hint to regulate normalization level.
    * For `MAX_PEAK` loudness_normalization_type: volume changes in a range (0;1], default value is 0.7.
    * For `LUFS` loudness_normalization_type: volume changes in a range [-145;0), default value is -19.
    """
    role: builtins.str
    """Hint to specify pronunciation character for the speaker."""
    pitch_shift: builtins.float
    """Hint to increase (or decrease) speaker's pitch, measured in Hz. Valid values are in range [-1000;1000], default value is 0."""
    @property
    def audio_template(self) -> global___AudioTemplate:
        """Template for synthesizing."""

    @property
    def duration(self) -> global___DurationHint:
        """Hint to limit both minimum and maximum audio duration."""

    def __init__(
        self,
        *,
        voice: builtins.str = ...,
        audio_template: global___AudioTemplate | None = ...,
        speed: builtins.float = ...,
        volume: builtins.float = ...,
        role: builtins.str = ...,
        pitch_shift: builtins.float = ...,
        duration: global___DurationHint | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["Hint", b"Hint", "audio_template", b"audio_template", "duration", b"duration", "pitch_shift", b"pitch_shift", "role", b"role", "speed", b"speed", "voice", b"voice", "volume", b"volume"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["Hint", b"Hint", "audio_template", b"audio_template", "duration", b"duration", "pitch_shift", b"pitch_shift", "role", b"role", "speed", b"speed", "voice", b"voice", "volume", b"volume"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["Hint", b"Hint"]) -> typing.Literal["voice", "audio_template", "speed", "volume", "role", "pitch_shift", "duration"] | None: ...

global___Hints = Hints

@typing.final
class UtteranceSynthesisRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _LoudnessNormalizationType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _LoudnessNormalizationTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[UtteranceSynthesisRequest._LoudnessNormalizationType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        LOUDNESS_NORMALIZATION_TYPE_UNSPECIFIED: UtteranceSynthesisRequest._LoudnessNormalizationType.ValueType  # 0
        MAX_PEAK: UtteranceSynthesisRequest._LoudnessNormalizationType.ValueType  # 1
        """The type of normalization, wherein the gain is changed to bring the highest PCM sample value or analog signal peak to a given level."""
        LUFS: UtteranceSynthesisRequest._LoudnessNormalizationType.ValueType  # 2
        """The type of normalization based on EBU R 128 recommendation."""

    class LoudnessNormalizationType(_LoudnessNormalizationType, metaclass=_LoudnessNormalizationTypeEnumTypeWrapper): ...
    LOUDNESS_NORMALIZATION_TYPE_UNSPECIFIED: UtteranceSynthesisRequest.LoudnessNormalizationType.ValueType  # 0
    MAX_PEAK: UtteranceSynthesisRequest.LoudnessNormalizationType.ValueType  # 1
    """The type of normalization, wherein the gain is changed to bring the highest PCM sample value or analog signal peak to a given level."""
    LUFS: UtteranceSynthesisRequest.LoudnessNormalizationType.ValueType  # 2
    """The type of normalization based on EBU R 128 recommendation."""

    MODEL_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int
    TEXT_TEMPLATE_FIELD_NUMBER: builtins.int
    HINTS_FIELD_NUMBER: builtins.int
    OUTPUT_AUDIO_SPEC_FIELD_NUMBER: builtins.int
    LOUDNESS_NORMALIZATION_TYPE_FIELD_NUMBER: builtins.int
    UNSAFE_MODE_FIELD_NUMBER: builtins.int
    model: builtins.str
    """The name of the model.
    This parameter is only required for specific functionalities, such as [SpeechKit Brand Voice Lite](/docs/speechkit/tts/brand-voice/) or SpeechKit Brand Voice Call Center. If you are not sure whether your use case needs this parameter, do not include it.
    """
    text: builtins.str
    """Raw text (e.g. "Hello, Alice")."""
    loudness_normalization_type: global___UtteranceSynthesisRequest.LoudnessNormalizationType.ValueType
    """Specifies type of loudness normalization.
    Optional. Default: `LUFS`.
    """
    unsafe_mode: builtins.bool
    """Optional. Automatically split long text to several utterances and bill accordingly. Some degradation in service quality is possible."""
    @property
    def text_template(self) -> global___TextTemplate:
        """Text template instance, e.g. `{"Hello, {username}" with username="Alice"}`."""

    @property
    def hints(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Hints]:
        """Optional hints for synthesis."""

    @property
    def output_audio_spec(self) -> global___AudioFormatOptions:
        """Optional. Default: 22050 Hz, linear 16-bit signed little-endian PCM, with WAV header"""

    def __init__(
        self,
        *,
        model: builtins.str = ...,
        text: builtins.str = ...,
        text_template: global___TextTemplate | None = ...,
        hints: collections.abc.Iterable[global___Hints] | None = ...,
        output_audio_spec: global___AudioFormatOptions | None = ...,
        loudness_normalization_type: global___UtteranceSynthesisRequest.LoudnessNormalizationType.ValueType = ...,
        unsafe_mode: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["Utterance", b"Utterance", "output_audio_spec", b"output_audio_spec", "text", b"text", "text_template", b"text_template"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["Utterance", b"Utterance", "hints", b"hints", "loudness_normalization_type", b"loudness_normalization_type", "model", b"model", "output_audio_spec", b"output_audio_spec", "text", b"text", "text_template", b"text_template", "unsafe_mode", b"unsafe_mode"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["Utterance", b"Utterance"]) -> typing.Literal["text", "text_template"] | None: ...

global___UtteranceSynthesisRequest = UtteranceSynthesisRequest

@typing.final
class SynthesisOptions(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    VOICE_FIELD_NUMBER: builtins.int
    ROLE_FIELD_NUMBER: builtins.int
    SPEED_FIELD_NUMBER: builtins.int
    VOLUME_FIELD_NUMBER: builtins.int
    PITCH_SHIFT_FIELD_NUMBER: builtins.int
    OUTPUT_AUDIO_SPEC_FIELD_NUMBER: builtins.int
    LOUDNESS_NORMALIZATION_TYPE_FIELD_NUMBER: builtins.int
    model: builtins.str
    """The name of the TTS model to use for synthesis. Currently should be empty. Do not use it."""
    voice: builtins.str
    """The voice to use for speech synthesis."""
    role: builtins.str
    """The role or speaking style. Can be used to specify pronunciation character for the speaker."""
    speed: builtins.float
    """Speed multiplier (default: 1.0)."""
    volume: builtins.float
    """Volume adjustment:
    * For `MAX_PEAK`: range is (0, 1], default 0.7.
    * For `LUFS`: range is [-145, 0), default -19.
    """
    pitch_shift: builtins.float
    """Pitch adjustment, in Hz, range [-1000, 1000], default 0."""
    loudness_normalization_type: global___LoudnessNormalizationType.ValueType
    """Loudness normalization type for output (default: `LUFS`)."""
    @property
    def output_audio_spec(self) -> global___AudioFormatOptions:
        """Specifies output audio format. Default: 22050Hz, linear 16-bit signed little-endian PCM, with WAV header."""

    def __init__(
        self,
        *,
        model: builtins.str = ...,
        voice: builtins.str = ...,
        role: builtins.str = ...,
        speed: builtins.float = ...,
        volume: builtins.float = ...,
        pitch_shift: builtins.float = ...,
        output_audio_spec: global___AudioFormatOptions | None = ...,
        loudness_normalization_type: global___LoudnessNormalizationType.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["output_audio_spec", b"output_audio_spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["loudness_normalization_type", b"loudness_normalization_type", "model", b"model", "output_audio_spec", b"output_audio_spec", "pitch_shift", b"pitch_shift", "role", b"role", "speed", b"speed", "voice", b"voice", "volume", b"volume"]) -> None: ...

global___SynthesisOptions = SynthesisOptions

@typing.final
class SynthesisInput(google.protobuf.message.Message):
    """The input for synthesis."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEXT_FIELD_NUMBER: builtins.int
    text: builtins.str
    """The text string to be synthesized."""
    def __init__(
        self,
        *,
        text: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["text", b"text"]) -> None: ...

global___SynthesisInput = SynthesisInput

@typing.final
class ForceSynthesisEvent(google.protobuf.message.Message):
    """Event to forcibly trigger synthesis."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ForceSynthesisEvent = ForceSynthesisEvent

@typing.final
class StreamSynthesisRequest(google.protobuf.message.Message):
    """Sent by client to control or provide data during streaming synthesis."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPTIONS_FIELD_NUMBER: builtins.int
    SYNTHESIS_INPUT_FIELD_NUMBER: builtins.int
    FORCE_SYNTHESIS_FIELD_NUMBER: builtins.int
    @property
    def options(self) -> global___SynthesisOptions:
        """Synthesis options. Must be provided in the first request of the stream and cannot be updated afterwards."""

    @property
    def synthesis_input(self) -> global___SynthesisInput:
        """Input to be synthesized."""

    @property
    def force_synthesis(self) -> global___ForceSynthesisEvent:
        """Triggers immediate synthesis of buffered input."""

    def __init__(
        self,
        *,
        options: global___SynthesisOptions | None = ...,
        synthesis_input: global___SynthesisInput | None = ...,
        force_synthesis: global___ForceSynthesisEvent | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["Event", b"Event", "force_synthesis", b"force_synthesis", "options", b"options", "synthesis_input", b"synthesis_input"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["Event", b"Event", "force_synthesis", b"force_synthesis", "options", b"options", "synthesis_input", b"synthesis_input"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["Event", b"Event"]) -> typing.Literal["options", "synthesis_input", "force_synthesis"] | None: ...

global___StreamSynthesisRequest = StreamSynthesisRequest

@typing.final
class StreamSynthesisResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AUDIO_CHUNK_FIELD_NUMBER: builtins.int
    TEXT_CHUNK_FIELD_NUMBER: builtins.int
    START_MS_FIELD_NUMBER: builtins.int
    LENGTH_MS_FIELD_NUMBER: builtins.int
    start_ms: builtins.int
    """Start time of the audio chunk in milliseconds."""
    length_ms: builtins.int
    """Length of the audio chunk in milliseconds."""
    @property
    def audio_chunk(self) -> global___AudioChunk:
        """Part of synthesized audio."""

    @property
    def text_chunk(self) -> global___TextChunk:
        """Part of synthesized text."""

    def __init__(
        self,
        *,
        audio_chunk: global___AudioChunk | None = ...,
        text_chunk: global___TextChunk | None = ...,
        start_ms: builtins.int = ...,
        length_ms: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["audio_chunk", b"audio_chunk", "text_chunk", b"text_chunk"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["audio_chunk", b"audio_chunk", "length_ms", b"length_ms", "start_ms", b"start_ms", "text_chunk", b"text_chunk"]) -> None: ...

global___StreamSynthesisResponse = StreamSynthesisResponse
