"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.airflow.v1.cluster_pb2
import yandex.cloud.airflow.v1.maintenance_pb2
import yandex.cloud.operation.operation_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Apache Airflow Cluster resource to return."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___GetClusterRequest = GetClusterRequest

@typing.final
class ListClustersRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to list Apache Airflow clusters in."""
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size], the service returns a [ListClustersResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the [ListClustersResponse.next_page_token]
    returned by the previous list request.
    """
    filter: builtins.str
    """A filter expression that filters resources listed in the response.
    The expression must specify:
    1. The field name. Currently you can only use filtering with the [Cluster.name] field.
    2. An `=` operator.
    3. The value in double quotes (`"`). Must be 1-63 characters long and match the regular expression `[a-zA-Z0-9_-]+`.
    """
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "folder_id", b"folder_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListClustersRequest = ListClustersRequest

@typing.final
class ListClustersResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTERS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListClustersRequest.page_size], use the [next_page_token] as the value
    for the [ListClustersRequest.page_token] parameter in the next list request. Each subsequent
    list request will have its own [next_page_token] to continue paging through the results.
    """
    @property
    def clusters(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.airflow.v1.cluster_pb2.Cluster]:
        """List of Apache Airflow Cluster resources."""

    def __init__(
        self,
        *,
        clusters: collections.abc.Iterable[yandex.cloud.airflow.v1.cluster_pb2.Cluster] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clusters", b"clusters", "next_page_token", b"next_page_token"]) -> None: ...

global___ListClustersResponse = ListClustersResponse

@typing.final
class CreateClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    NETWORK_FIELD_NUMBER: builtins.int
    CODE_SYNC_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    LOGGING_FIELD_NUMBER: builtins.int
    ADMIN_PASSWORD_FIELD_NUMBER: builtins.int
    MAINTENANCE_WINDOW_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to create Apache Airflow cluster in."""
    name: builtins.str
    """Name of the Apache Airflow cluster. The name must be unique within the folder."""
    description: builtins.str
    """Description of the Apache Airflow cluster."""
    deletion_protection: builtins.bool
    """Deletion Protection inhibits deletion of the cluster."""
    service_account_id: builtins.str
    """Service account used to access Cloud resources.
    For more information, see [documentation](/docs/managed-airflow/concepts/impersonation).
    """
    admin_password: builtins.str
    """Password of user `admin`."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Custom labels for the Apache Airflow cluster as `` key:value `` pairs. For example, "env": "prod"."""

    @property
    def config(self) -> yandex.cloud.airflow.v1.cluster_pb2.ClusterConfig:
        """Configuration of Apache Airflow components."""

    @property
    def network(self) -> yandex.cloud.airflow.v1.cluster_pb2.NetworkConfig:
        """Network related configuration options."""

    @property
    def code_sync(self) -> yandex.cloud.airflow.v1.cluster_pb2.CodeSyncConfig:
        """Parameters of the location and access to the code that will be executed in the cluster."""

    @property
    def logging(self) -> yandex.cloud.airflow.v1.cluster_pb2.LoggingConfig:
        """Cloud Logging configuration."""

    @property
    def maintenance_window(self) -> yandex.cloud.airflow.v1.maintenance_pb2.MaintenanceWindow:
        """Window of maintenance operations."""

    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        config: yandex.cloud.airflow.v1.cluster_pb2.ClusterConfig | None = ...,
        network: yandex.cloud.airflow.v1.cluster_pb2.NetworkConfig | None = ...,
        code_sync: yandex.cloud.airflow.v1.cluster_pb2.CodeSyncConfig | None = ...,
        deletion_protection: builtins.bool = ...,
        service_account_id: builtins.str = ...,
        logging: yandex.cloud.airflow.v1.cluster_pb2.LoggingConfig | None = ...,
        admin_password: builtins.str = ...,
        maintenance_window: yandex.cloud.airflow.v1.maintenance_pb2.MaintenanceWindow | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["code_sync", b"code_sync", "config", b"config", "logging", b"logging", "maintenance_window", b"maintenance_window", "network", b"network"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["admin_password", b"admin_password", "code_sync", b"code_sync", "config", b"config", "deletion_protection", b"deletion_protection", "description", b"description", "folder_id", b"folder_id", "labels", b"labels", "logging", b"logging", "maintenance_window", b"maintenance_window", "name", b"name", "network", b"network", "service_account_id", b"service_account_id"]) -> None: ...

global___CreateClusterRequest = CreateClusterRequest

@typing.final
class CreateClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Apache Airflow cluster that is being created."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___CreateClusterMetadata = CreateClusterMetadata

@typing.final
class UpdateClusterConfigSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AIRFLOW_FIELD_NUMBER: builtins.int
    WEBSERVER_FIELD_NUMBER: builtins.int
    SCHEDULER_FIELD_NUMBER: builtins.int
    TRIGGERER_FIELD_NUMBER: builtins.int
    WORKER_FIELD_NUMBER: builtins.int
    DEPENDENCIES_FIELD_NUMBER: builtins.int
    LOCKBOX_FIELD_NUMBER: builtins.int
    AIRFLOW_VERSION_FIELD_NUMBER: builtins.int
    PYTHON_VERSION_FIELD_NUMBER: builtins.int
    DAG_PROCESSOR_FIELD_NUMBER: builtins.int
    airflow_version: builtins.str
    """Apache Airflow version. Format: "Major.Minor" """
    python_version: builtins.str
    """Python version. Format: "Major.Minor" """
    @property
    def airflow(self) -> yandex.cloud.airflow.v1.cluster_pb2.AirflowConfig:
        """Configuration of the Apache Airflow application itself."""

    @property
    def webserver(self) -> yandex.cloud.airflow.v1.cluster_pb2.WebserverConfig:
        """Configuration of webserver instances."""

    @property
    def scheduler(self) -> yandex.cloud.airflow.v1.cluster_pb2.SchedulerConfig:
        """Configuration of scheduler instances."""

    @property
    def triggerer(self) -> yandex.cloud.airflow.v1.cluster_pb2.TriggererConfig:
        """Configuration of triggerer instances."""

    @property
    def worker(self) -> yandex.cloud.airflow.v1.cluster_pb2.WorkerConfig:
        """Configuration of worker instances."""

    @property
    def dependencies(self) -> yandex.cloud.airflow.v1.cluster_pb2.Dependencies:
        """The list of additional packages installed in the cluster."""

    @property
    def lockbox(self) -> yandex.cloud.airflow.v1.cluster_pb2.LockboxConfig:
        """Configuration of Lockbox Secret Backend."""

    @property
    def dag_processor(self) -> yandex.cloud.airflow.v1.cluster_pb2.DagProcessorConfig:
        """Configuration of dag-processor instances."""

    def __init__(
        self,
        *,
        airflow: yandex.cloud.airflow.v1.cluster_pb2.AirflowConfig | None = ...,
        webserver: yandex.cloud.airflow.v1.cluster_pb2.WebserverConfig | None = ...,
        scheduler: yandex.cloud.airflow.v1.cluster_pb2.SchedulerConfig | None = ...,
        triggerer: yandex.cloud.airflow.v1.cluster_pb2.TriggererConfig | None = ...,
        worker: yandex.cloud.airflow.v1.cluster_pb2.WorkerConfig | None = ...,
        dependencies: yandex.cloud.airflow.v1.cluster_pb2.Dependencies | None = ...,
        lockbox: yandex.cloud.airflow.v1.cluster_pb2.LockboxConfig | None = ...,
        airflow_version: builtins.str = ...,
        python_version: builtins.str = ...,
        dag_processor: yandex.cloud.airflow.v1.cluster_pb2.DagProcessorConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["airflow", b"airflow", "dag_processor", b"dag_processor", "dependencies", b"dependencies", "lockbox", b"lockbox", "scheduler", b"scheduler", "triggerer", b"triggerer", "webserver", b"webserver", "worker", b"worker"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["airflow", b"airflow", "airflow_version", b"airflow_version", "dag_processor", b"dag_processor", "dependencies", b"dependencies", "lockbox", b"lockbox", "python_version", b"python_version", "scheduler", b"scheduler", "triggerer", b"triggerer", "webserver", b"webserver", "worker", b"worker"]) -> None: ...

global___UpdateClusterConfigSpec = UpdateClusterConfigSpec

@typing.final
class UpdateNetworkConfigSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SECURITY_GROUP_IDS_FIELD_NUMBER: builtins.int
    @property
    def security_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """User security groups."""

    def __init__(
        self,
        *,
        security_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["security_group_ids", b"security_group_ids"]) -> None: ...

global___UpdateNetworkConfigSpec = UpdateNetworkConfigSpec

@typing.final
class UpdateClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    CONFIG_SPEC_FIELD_NUMBER: builtins.int
    CODE_SYNC_FIELD_NUMBER: builtins.int
    NETWORK_SPEC_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    LOGGING_FIELD_NUMBER: builtins.int
    MAINTENANCE_WINDOW_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Apache Airflow Cluster resource to update."""
    name: builtins.str
    """New name of the cluster."""
    description: builtins.str
    """New description of the Apache Airflow cluster."""
    deletion_protection: builtins.bool
    """Deletion Protection inhibits deletion of the cluster"""
    service_account_id: builtins.str
    """Service account used to access Cloud resources.
    For more information, see [documentation](/docs/managed-airflow/concepts/impersonation).
    """
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which fields of the Apache Airflow Cluster resource should be updated."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Custom labels for the Apache Airflow cluster as `` key:value `` pairs. For example, "env": "prod".

        The new set of labels will completely replace the old ones. To add a label, request the current
        set with the [ClusterService.Get] method, then send an [ClusterService.Update] request with the new label added to the set.
        """

    @property
    def config_spec(self) -> global___UpdateClusterConfigSpec:
        """Configuration of Apache Airflow components."""

    @property
    def code_sync(self) -> yandex.cloud.airflow.v1.cluster_pb2.CodeSyncConfig:
        """Parameters of the location and access to the code that will be executed in the cluster."""

    @property
    def network_spec(self) -> global___UpdateNetworkConfigSpec:
        """Network related configuration options."""

    @property
    def logging(self) -> yandex.cloud.airflow.v1.cluster_pb2.LoggingConfig:
        """Cloud Logging configuration."""

    @property
    def maintenance_window(self) -> yandex.cloud.airflow.v1.maintenance_pb2.MaintenanceWindow:
        """Window of maintenance operations."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        config_spec: global___UpdateClusterConfigSpec | None = ...,
        code_sync: yandex.cloud.airflow.v1.cluster_pb2.CodeSyncConfig | None = ...,
        network_spec: global___UpdateNetworkConfigSpec | None = ...,
        deletion_protection: builtins.bool = ...,
        service_account_id: builtins.str = ...,
        logging: yandex.cloud.airflow.v1.cluster_pb2.LoggingConfig | None = ...,
        maintenance_window: yandex.cloud.airflow.v1.maintenance_pb2.MaintenanceWindow | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["code_sync", b"code_sync", "config_spec", b"config_spec", "logging", b"logging", "maintenance_window", b"maintenance_window", "network_spec", b"network_spec", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "code_sync", b"code_sync", "config_spec", b"config_spec", "deletion_protection", b"deletion_protection", "description", b"description", "labels", b"labels", "logging", b"logging", "maintenance_window", b"maintenance_window", "name", b"name", "network_spec", b"network_spec", "service_account_id", b"service_account_id", "update_mask", b"update_mask"]) -> None: ...

global___UpdateClusterRequest = UpdateClusterRequest

@typing.final
class UpdateClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Apache Airflow Cluster resource that is being updated."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___UpdateClusterMetadata = UpdateClusterMetadata

@typing.final
class DeleteClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Apache Airflow cluster to delete."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___DeleteClusterRequest = DeleteClusterRequest

@typing.final
class DeleteClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Apache Airflow cluster that is being deleted."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___DeleteClusterMetadata = DeleteClusterMetadata

@typing.final
class StartClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Apache Airflow cluster to start."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___StartClusterRequest = StartClusterRequest

@typing.final
class StartClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Apache Airflow cluster that is being started."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___StartClusterMetadata = StartClusterMetadata

@typing.final
class StopClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Apache Airflow cluster to stop."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___StopClusterRequest = StopClusterRequest

@typing.final
class StopClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Apache Airflow cluster that is being stopped."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___StopClusterMetadata = StopClusterMetadata

@typing.final
class ListClusterOperationsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Apache Airflow Cluster resource to list operations for."""
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size], the service returns a [ListClusterOperationsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token.  To get the next page of results, set [page_token] to the [ListClusterOperationsResponse.next_page_token]
    returned by the previous list request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListClusterOperationsRequest = ListClusterOperationsRequest

@typing.final
class ListClusterOperationsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListClusterOperationsRequest.page_size], use the [next_page_token] as the value
    for the [ListClusterOperationsRequest.page_token] query parameter in the next list request.
    Each subsequent list request will have its own [next_page_token] to continue paging through the results.
    """
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.operation.operation_pb2.Operation]:
        """List of Operation resources for the specified Apache Airflow cluster."""

    def __init__(
        self,
        *,
        operations: collections.abc.Iterable[yandex.cloud.operation.operation_pb2.Operation] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "operations", b"operations"]) -> None: ...

global___ListClusterOperationsResponse = ListClusterOperationsResponse
