"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.apploadbalancer.v1.http_router_pb2
import yandex.cloud.apploadbalancer.v1.virtual_host_pb2
import yandex.cloud.operation.operation_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetHttpRouterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HTTP_ROUTER_ID_FIELD_NUMBER: builtins.int
    http_router_id: builtins.str
    """ID of the HTTP router to return.

    To get the HTTP router ID, make a [HttpRouterService.List] request.
    """
    def __init__(
        self,
        *,
        http_router_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["http_router_id", b"http_router_id"]) -> None: ...

global___GetHttpRouterRequest = GetHttpRouterRequest

@typing.final
class ListHttpRoutersRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to list HTTP routers in.

    To get the folder ID, make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than `page_size`, the service returns a [ListHttpRoutersResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set `page_token` to the
    [ListHttpRoutersResponse.next_page_token] returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters HTTP routers listed in the response.

    The expression must specify:
    1. The field name. Currently you can use filtering only on [HttpRouter.name] field.
    2. An `=` operator.
    3. The value in double quotes (`"`). Must be 3-63 characters long and match the regular expression `[a-z][-a-z0-9]{1,61}[a-z0-9]`.
    Example of a filter: `name=my-http-router`.
    """
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "folder_id", b"folder_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListHttpRoutersRequest = ListHttpRoutersRequest

@typing.final
class ListHttpRoutersResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HTTP_ROUTERS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    the specified [ListHttpRoutersRequest.page_size], use `next_page_token` as the value
    for the [ListHttpRoutersRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `next_page_token` to continue paging through the results.
    """
    @property
    def http_routers(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.apploadbalancer.v1.http_router_pb2.HttpRouter]:
        """List of HTTP routers in the specified folder."""

    def __init__(
        self,
        *,
        http_routers: collections.abc.Iterable[yandex.cloud.apploadbalancer.v1.http_router_pb2.HttpRouter] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["http_routers", b"http_routers", "next_page_token", b"next_page_token"]) -> None: ...

global___ListHttpRoutersResponse = ListHttpRoutersResponse

@typing.final
class DeleteHttpRouterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HTTP_ROUTER_ID_FIELD_NUMBER: builtins.int
    http_router_id: builtins.str
    """ID of the HTTP router to delete.

    To get the HTTP router ID, make a [HttpRouterService.List] request.
    """
    def __init__(
        self,
        *,
        http_router_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["http_router_id", b"http_router_id"]) -> None: ...

global___DeleteHttpRouterRequest = DeleteHttpRouterRequest

@typing.final
class DeleteHttpRouterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HTTP_ROUTER_ID_FIELD_NUMBER: builtins.int
    http_router_id: builtins.str
    """ID of the HTTP router that is being deleted."""
    def __init__(
        self,
        *,
        http_router_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["http_router_id", b"http_router_id"]) -> None: ...

global___DeleteHttpRouterMetadata = DeleteHttpRouterMetadata

@typing.final
class UpdateHttpRouterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    HTTP_ROUTER_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    VIRTUAL_HOSTS_FIELD_NUMBER: builtins.int
    ROUTE_OPTIONS_FIELD_NUMBER: builtins.int
    http_router_id: builtins.str
    """ID of the HTTP router to update.

    To get the HTTP router ID, make a [HttpRouterService.List] request.
    """
    name: builtins.str
    """New name for the HTTP router.
    The name must be unique within the folder.
    """
    description: builtins.str
    """New description of the HTTP router."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which attributes of the HTTP router should be updated."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """HTTP router labels as `key:value` pairs.
        For details about the concept, see [documentation](/docs/overview/concepts/services#labels).

        Existing set of labels is completely replaced by the provided set, so if you just want
        to add or remove a label:
        1. Get the current set of labels with a [HttpRouterService.Get] request.
        2. Add or remove a label in this set.
        3. Send the new set in this field.
        """

    @property
    def virtual_hosts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.apploadbalancer.v1.virtual_host_pb2.VirtualHost]:
        """New virtual hosts that combine routes inside the router.
        For details about the concept, see [documentation](/docs/application-load-balancer/concepts/http-router#virtual-host).

        Only one virtual host with no authority (default match) can be specified.

        Existing list of virtual hosts is completely replaced by the specified list, so if you just want to add or remove
        a virtual host, make a [VirtualHostService.Create] request or a [VirtualHostService.Delete] request.
        """

    @property
    def route_options(self) -> yandex.cloud.apploadbalancer.v1.virtual_host_pb2.RouteOptions:
        """New route options for the HTTP router."""

    def __init__(
        self,
        *,
        http_router_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        virtual_hosts: collections.abc.Iterable[yandex.cloud.apploadbalancer.v1.virtual_host_pb2.VirtualHost] | None = ...,
        route_options: yandex.cloud.apploadbalancer.v1.virtual_host_pb2.RouteOptions | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["route_options", b"route_options", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "http_router_id", b"http_router_id", "labels", b"labels", "name", b"name", "route_options", b"route_options", "update_mask", b"update_mask", "virtual_hosts", b"virtual_hosts"]) -> None: ...

global___UpdateHttpRouterRequest = UpdateHttpRouterRequest

@typing.final
class UpdateHttpRouterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HTTP_ROUTER_ID_FIELD_NUMBER: builtins.int
    http_router_id: builtins.str
    """ID of the HTTP router that is being updated."""
    def __init__(
        self,
        *,
        http_router_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["http_router_id", b"http_router_id"]) -> None: ...

global___UpdateHttpRouterMetadata = UpdateHttpRouterMetadata

@typing.final
class CreateHttpRouterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    VIRTUAL_HOSTS_FIELD_NUMBER: builtins.int
    ROUTE_OPTIONS_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to create an HTTP router in.

    To get the folder ID, make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    name: builtins.str
    """Name of the HTTP router.
    The name must be unique within the folder.
    """
    description: builtins.str
    """Description of the HTTP router."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """HTTP router labels as `key:value` pairs.
        For details about the concept, see [documentation](/docs/overview/concepts/services#labels).
        """

    @property
    def virtual_hosts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.apploadbalancer.v1.virtual_host_pb2.VirtualHost]:
        """Virtual hosts that combine routes inside the router.
        For details about the concept, see [documentation](/docs/application-load-balancer/concepts/http-router#virtual-host).

        Only one virtual host with no authority (default match) can be specified.
        """

    @property
    def route_options(self) -> yandex.cloud.apploadbalancer.v1.virtual_host_pb2.RouteOptions:
        """Route options for the HTTP router."""

    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        virtual_hosts: collections.abc.Iterable[yandex.cloud.apploadbalancer.v1.virtual_host_pb2.VirtualHost] | None = ...,
        route_options: yandex.cloud.apploadbalancer.v1.virtual_host_pb2.RouteOptions | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["route_options", b"route_options"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "folder_id", b"folder_id", "labels", b"labels", "name", b"name", "route_options", b"route_options", "virtual_hosts", b"virtual_hosts"]) -> None: ...

global___CreateHttpRouterRequest = CreateHttpRouterRequest

@typing.final
class CreateHttpRouterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HTTP_ROUTER_ID_FIELD_NUMBER: builtins.int
    http_router_id: builtins.str
    """ID of the HTTP router that is being created."""
    def __init__(
        self,
        *,
        http_router_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["http_router_id", b"http_router_id"]) -> None: ...

global___CreateHttpRouterMetadata = CreateHttpRouterMetadata

@typing.final
class ListHttpRouterOperationsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HTTP_ROUTER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    http_router_id: builtins.str
    """ID of the HTTP router to get operations for.

    To get the HTTP router ID, use a [HttpRouterService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page that should be returned. If the number of available
    results is larger than [page_size], the service returns a [ListHttpRouterOperationsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the
    [ListHttpRouterOperationsResponse.next_page_token] returned by a previous list request.
    """
    def __init__(
        self,
        *,
        http_router_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["http_router_id", b"http_router_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListHttpRouterOperationsRequest = ListHttpRouterOperationsRequest

@typing.final
class ListHttpRouterOperationsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    the specified [ListHttpRouterOperationsRequest.page_size], use `next_page_token` as the value
    for the [ListHttpRouterOperationsRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `next_page_token` to continue paging through the results.
    """
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.operation.operation_pb2.Operation]:
        """List of operations for the specified HTTP router."""

    def __init__(
        self,
        *,
        operations: collections.abc.Iterable[yandex.cloud.operation.operation_pb2.Operation] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "operations", b"operations"]) -> None: ...

global___ListHttpRouterOperationsResponse = ListHttpRouterOperationsResponse
