"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.apploadbalancer.v1.load_balancer_pb2
import yandex.cloud.apploadbalancer.v1.logging_pb2
import yandex.cloud.operation.operation_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetLoadBalancerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOAD_BALANCER_ID_FIELD_NUMBER: builtins.int
    load_balancer_id: builtins.str
    """ID of the application load balancer to return.

    To get the application load balancer ID, make a [LoadBalancerService.List] request.
    """
    def __init__(
        self,
        *,
        load_balancer_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["load_balancer_id", b"load_balancer_id"]) -> None: ...

global___GetLoadBalancerRequest = GetLoadBalancerRequest

@typing.final
class ListLoadBalancersRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to list application load balancers in.

    To get the folder ID, make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than `page_size`, the service returns a [ListLoadBalancersResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set `page_token` to the
    [ListLoadBalancersResponse.next_page_token] returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters application load balancers listed in the response.

    The expression must specify:
    1. The field name. Currently you can use filtering only on [LoadBalancer.name] field.
    2. An `=` operator.
    3. The value in double quotes (`"`). Must be 3-63 characters long and match the regular expression `[a-z][-a-z0-9]{1,61}[a-z0-9]`.
    Example of a filter: `name=my-load-balancer`.
    """
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "folder_id", b"folder_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListLoadBalancersRequest = ListLoadBalancersRequest

@typing.final
class ListLoadBalancersResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOAD_BALANCERS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    the specified [ListLoadBalancersRequest.page_size], use `next_page_token` as the value
    for the [ListLoadBalancersRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `next_page_token` to continue paging through the results.
    """
    @property
    def load_balancers(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.apploadbalancer.v1.load_balancer_pb2.LoadBalancer]:
        """List of application load balancers in the specified folder."""

    def __init__(
        self,
        *,
        load_balancers: collections.abc.Iterable[yandex.cloud.apploadbalancer.v1.load_balancer_pb2.LoadBalancer] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["load_balancers", b"load_balancers", "next_page_token", b"next_page_token"]) -> None: ...

global___ListLoadBalancersResponse = ListLoadBalancersResponse

@typing.final
class DeleteLoadBalancerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOAD_BALANCER_ID_FIELD_NUMBER: builtins.int
    load_balancer_id: builtins.str
    """ID of the application load balancer to delete.

    To get the application load balancer ID, make a [LoadBalancerService.List] request.
    """
    def __init__(
        self,
        *,
        load_balancer_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["load_balancer_id", b"load_balancer_id"]) -> None: ...

global___DeleteLoadBalancerRequest = DeleteLoadBalancerRequest

@typing.final
class DeleteLoadBalancerMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOAD_BALANCER_ID_FIELD_NUMBER: builtins.int
    load_balancer_id: builtins.str
    """ID of the application load balancer that is being deleted."""
    def __init__(
        self,
        *,
        load_balancer_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["load_balancer_id", b"load_balancer_id"]) -> None: ...

global___DeleteLoadBalancerMetadata = DeleteLoadBalancerMetadata

@typing.final
class UpdateLoadBalancerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    LOAD_BALANCER_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    LISTENER_SPECS_FIELD_NUMBER: builtins.int
    ALLOCATION_POLICY_FIELD_NUMBER: builtins.int
    SECURITY_GROUP_IDS_FIELD_NUMBER: builtins.int
    AUTO_SCALE_POLICY_FIELD_NUMBER: builtins.int
    LOG_OPTIONS_FIELD_NUMBER: builtins.int
    ALLOW_ZONAL_SHIFT_FIELD_NUMBER: builtins.int
    load_balancer_id: builtins.str
    """ID of the application load balancer to update.

    To get the application load balancer ID, make a [LoadBalancerService.List] request.
    """
    name: builtins.str
    """New name for the application load balancer.
    The name must be unique within the folder.
    """
    description: builtins.str
    """New description of the application load balancer."""
    allow_zonal_shift: builtins.bool
    """Specifies whether application load balancer is available to zonal shift."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which attributes of the application load balancer should be updated."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """New application load balancer labels as `key:value` pairs.
        For details about the concept, see [documentation](/docs/overview/concepts/services#labels).

        Existing set of labels is completely replaced by the provided set, so if you just want
        to add or remove a label:
        1. Get the current set of labels with a [LoadBalancerService.Get] request.
        2. Add or remove a label in this set.
        3. Send the new set in this field.
        """

    @property
    def listener_specs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ListenerSpec]:
        """New listeners for the application load balancer.

        For details about the concept,
        see [documentation](/docs/application-load-balancer/concepts/application-load-balancer#listener).

        Existing list of listeners is completely replaced by the specified list, so if you just want to add, update,
        or remove a listener, make a [LoadBalancerService.AddListener] request,
        a [LoadBalancerService.UpdateListener] request, or a [LoadBalancerService.RemoveListener] request.
        """

    @property
    def allocation_policy(self) -> yandex.cloud.apploadbalancer.v1.load_balancer_pb2.AllocationPolicy:
        """New locality settings of the application load balancer.

        For details about the concept,
        see [documentation](/docs/application-load-balancer/concepts/application-load-balancer#lb-location).

        Existing locality settings are completely replaced by the specified settings,
        so if you just want to add or remove an allocation policy:
        1. Get the current settings with a [LoadBalancerService.Get] request.
        2. Add or remove a policy in this set.
        3. Send the new set in this field.
        """

    @property
    def security_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """ID's of new security groups attributed to the application load balancer.

        For details about the concept,
        see [documentation](/docs/application-load-balancer/concepts/application-load-balancer#security-groups).

        Existing list of security groups is completely replaced by the specified list,
        so if you just want to add or remove an allocation policy:
        1. Get the current set of security groups with a [LoadBalancerService.Get] request.
        2. Add or remove a group in this set.
        3. Send the new set in this field.
        """

    @property
    def auto_scale_policy(self) -> yandex.cloud.apploadbalancer.v1.load_balancer_pb2.AutoScalePolicy:
        """New scaling settings of the application load balancer.

        The scaling settings relate to a special internal instance group which facilitates the balancer's work.
        Instances in this group are called _resource units_. The group is scaled automatically based on incoming load
        and within limitations specified in these settings.

        For details about the concept,
        see [documentation](/docs/application-load-balancer/concepts/application-load-balancer#lcu-scaling).
        """

    @property
    def log_options(self) -> yandex.cloud.apploadbalancer.v1.logging_pb2.LogOptions:
        """Cloud logging settings of the application load balancer."""

    def __init__(
        self,
        *,
        load_balancer_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        listener_specs: collections.abc.Iterable[global___ListenerSpec] | None = ...,
        allocation_policy: yandex.cloud.apploadbalancer.v1.load_balancer_pb2.AllocationPolicy | None = ...,
        security_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
        auto_scale_policy: yandex.cloud.apploadbalancer.v1.load_balancer_pb2.AutoScalePolicy | None = ...,
        log_options: yandex.cloud.apploadbalancer.v1.logging_pb2.LogOptions | None = ...,
        allow_zonal_shift: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["allocation_policy", b"allocation_policy", "auto_scale_policy", b"auto_scale_policy", "log_options", b"log_options", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["allocation_policy", b"allocation_policy", "allow_zonal_shift", b"allow_zonal_shift", "auto_scale_policy", b"auto_scale_policy", "description", b"description", "labels", b"labels", "listener_specs", b"listener_specs", "load_balancer_id", b"load_balancer_id", "log_options", b"log_options", "name", b"name", "security_group_ids", b"security_group_ids", "update_mask", b"update_mask"]) -> None: ...

global___UpdateLoadBalancerRequest = UpdateLoadBalancerRequest

@typing.final
class UpdateLoadBalancerMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOAD_BALANCER_ID_FIELD_NUMBER: builtins.int
    load_balancer_id: builtins.str
    """ID of the application load balancer that is being updated."""
    def __init__(
        self,
        *,
        load_balancer_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["load_balancer_id", b"load_balancer_id"]) -> None: ...

global___UpdateLoadBalancerMetadata = UpdateLoadBalancerMetadata

@typing.final
class CreateLoadBalancerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    REGION_ID_FIELD_NUMBER: builtins.int
    NETWORK_ID_FIELD_NUMBER: builtins.int
    LISTENER_SPECS_FIELD_NUMBER: builtins.int
    ALLOCATION_POLICY_FIELD_NUMBER: builtins.int
    SECURITY_GROUP_IDS_FIELD_NUMBER: builtins.int
    AUTO_SCALE_POLICY_FIELD_NUMBER: builtins.int
    LOG_OPTIONS_FIELD_NUMBER: builtins.int
    ALLOW_ZONAL_SHIFT_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to create an application load balancer in.

    To get the folder ID, make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    name: builtins.str
    """Name of the application load balancer.
    The name must be unique within the folder.
    """
    description: builtins.str
    """Description of the application load balancer."""
    region_id: builtins.str
    """ID of the region that the application load balancer is located at.

    The only supported value is `ru-central1`.
    """
    network_id: builtins.str
    """ID of the network that the application load balancer belongs to."""
    allow_zonal_shift: builtins.bool
    """Specifies whether application load balancer is available to zonal shift."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Application load balancer labels as `key:value` pairs.
        For details about the concept, see [documentation](/docs/overview/concepts/services#labels).
        """

    @property
    def listener_specs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ListenerSpec]:
        """Listeners that belong to the application load balancer.

        For details about the concept,
        see [documentation](/docs/application-load-balancer/concepts/application-load-balancer#listener).
        """

    @property
    def allocation_policy(self) -> yandex.cloud.apploadbalancer.v1.load_balancer_pb2.AllocationPolicy:
        """Locality settings of the application load balancer.

        For details about the concept,
        see [documentation](/docs/application-load-balancer/concepts/application-load-balancer#lb-location).
        """

    @property
    def security_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """ID's of the security groups attributed to the application load balancer.

        For details about the concept,
        see [documentation](/docs/application-load-balancer/concepts/application-load-balancer#security-groups).
        """

    @property
    def auto_scale_policy(self) -> yandex.cloud.apploadbalancer.v1.load_balancer_pb2.AutoScalePolicy:
        """Scaling settings of the application load balancer.

        The scaling settings relate to a special internal instance group which facilitates the balancer's work.
        Instances in this group are called _resource units_. The group is scaled automatically based on incoming load
        and within limitations specified in these settings.

        For details about the concept,
        see [documentation](/docs/application-load-balancer/concepts/application-load-balancer#lcu-scaling).
        """

    @property
    def log_options(self) -> yandex.cloud.apploadbalancer.v1.logging_pb2.LogOptions:
        """Cloud logging settings of the application load balancer."""

    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        region_id: builtins.str = ...,
        network_id: builtins.str = ...,
        listener_specs: collections.abc.Iterable[global___ListenerSpec] | None = ...,
        allocation_policy: yandex.cloud.apploadbalancer.v1.load_balancer_pb2.AllocationPolicy | None = ...,
        security_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
        auto_scale_policy: yandex.cloud.apploadbalancer.v1.load_balancer_pb2.AutoScalePolicy | None = ...,
        log_options: yandex.cloud.apploadbalancer.v1.logging_pb2.LogOptions | None = ...,
        allow_zonal_shift: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["allocation_policy", b"allocation_policy", "auto_scale_policy", b"auto_scale_policy", "log_options", b"log_options"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["allocation_policy", b"allocation_policy", "allow_zonal_shift", b"allow_zonal_shift", "auto_scale_policy", b"auto_scale_policy", "description", b"description", "folder_id", b"folder_id", "labels", b"labels", "listener_specs", b"listener_specs", "log_options", b"log_options", "name", b"name", "network_id", b"network_id", "region_id", b"region_id", "security_group_ids", b"security_group_ids"]) -> None: ...

global___CreateLoadBalancerRequest = CreateLoadBalancerRequest

@typing.final
class CreateLoadBalancerMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOAD_BALANCER_ID_FIELD_NUMBER: builtins.int
    load_balancer_id: builtins.str
    """ID of the application load balancer that is being created."""
    def __init__(
        self,
        *,
        load_balancer_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["load_balancer_id", b"load_balancer_id"]) -> None: ...

global___CreateLoadBalancerMetadata = CreateLoadBalancerMetadata

@typing.final
class StartLoadBalancerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOAD_BALANCER_ID_FIELD_NUMBER: builtins.int
    load_balancer_id: builtins.str
    """ID of the application load balancer to start.

    The application load balancer must have a `STOPPED` status ([LoadBalancer.status]).

    To get the application load balancer ID, make a [LoadBalancerService.List] request.
    """
    def __init__(
        self,
        *,
        load_balancer_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["load_balancer_id", b"load_balancer_id"]) -> None: ...

global___StartLoadBalancerRequest = StartLoadBalancerRequest

@typing.final
class StartLoadBalancerMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOAD_BALANCER_ID_FIELD_NUMBER: builtins.int
    load_balancer_id: builtins.str
    """ID of the application load balancer that is being started."""
    def __init__(
        self,
        *,
        load_balancer_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["load_balancer_id", b"load_balancer_id"]) -> None: ...

global___StartLoadBalancerMetadata = StartLoadBalancerMetadata

@typing.final
class StopLoadBalancerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOAD_BALANCER_ID_FIELD_NUMBER: builtins.int
    load_balancer_id: builtins.str
    """ID of the application load balancer to stop.

    The application load balancer must have an `ACTIVE` status ([LoadBalancer.status]).

    To get the application load balancer ID, make a [LoadBalancerService.List] request.
    """
    def __init__(
        self,
        *,
        load_balancer_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["load_balancer_id", b"load_balancer_id"]) -> None: ...

global___StopLoadBalancerRequest = StopLoadBalancerRequest

@typing.final
class StopLoadBalancerMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOAD_BALANCER_ID_FIELD_NUMBER: builtins.int
    load_balancer_id: builtins.str
    """ID of the application load balancer that is being stopped."""
    def __init__(
        self,
        *,
        load_balancer_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["load_balancer_id", b"load_balancer_id"]) -> None: ...

global___StopLoadBalancerMetadata = StopLoadBalancerMetadata

@typing.final
class AddListenerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOAD_BALANCER_ID_FIELD_NUMBER: builtins.int
    LISTENER_SPEC_FIELD_NUMBER: builtins.int
    load_balancer_id: builtins.str
    """ID of the application load balancer to add a listener to."""
    @property
    def listener_spec(self) -> global___ListenerSpec:
        """Listener to add to the application load balancer."""

    def __init__(
        self,
        *,
        load_balancer_id: builtins.str = ...,
        listener_spec: global___ListenerSpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["listener_spec", b"listener_spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["listener_spec", b"listener_spec", "load_balancer_id", b"load_balancer_id"]) -> None: ...

global___AddListenerRequest = AddListenerRequest

@typing.final
class AddListenerMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOAD_BALANCER_ID_FIELD_NUMBER: builtins.int
    LISTENER_NAME_FIELD_NUMBER: builtins.int
    load_balancer_id: builtins.str
    """ID of the application load balancer that the listener is being added to."""
    listener_name: builtins.str
    """Name of the listener that is being added to the application load balancer."""
    def __init__(
        self,
        *,
        load_balancer_id: builtins.str = ...,
        listener_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["listener_name", b"listener_name", "load_balancer_id", b"load_balancer_id"]) -> None: ...

global___AddListenerMetadata = AddListenerMetadata

@typing.final
class RemoveListenerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOAD_BALANCER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    load_balancer_id: builtins.str
    """ID of the application load balancer to remove the listener from."""
    name: builtins.str
    """Name of the listener to remove from the application load balancer."""
    def __init__(
        self,
        *,
        load_balancer_id: builtins.str = ...,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["load_balancer_id", b"load_balancer_id", "name", b"name"]) -> None: ...

global___RemoveListenerRequest = RemoveListenerRequest

@typing.final
class RemoveListenerMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOAD_BALANCER_ID_FIELD_NUMBER: builtins.int
    LISTENER_NAME_FIELD_NUMBER: builtins.int
    load_balancer_id: builtins.str
    """ID of the application load balancer that the listener is being removed from."""
    listener_name: builtins.str
    """Name of the listener that is being removed from the application load balancer."""
    def __init__(
        self,
        *,
        load_balancer_id: builtins.str = ...,
        listener_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["listener_name", b"listener_name", "load_balancer_id", b"load_balancer_id"]) -> None: ...

global___RemoveListenerMetadata = RemoveListenerMetadata

@typing.final
class UpdateListenerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOAD_BALANCER_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    LISTENER_SPEC_FIELD_NUMBER: builtins.int
    load_balancer_id: builtins.str
    """ID of the application load balancer to update the listener in."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which attributes of the listener should be updated."""

    @property
    def listener_spec(self) -> global___ListenerSpec:
        """New attributes of the listener."""

    def __init__(
        self,
        *,
        load_balancer_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        listener_spec: global___ListenerSpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["listener_spec", b"listener_spec", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["listener_spec", b"listener_spec", "load_balancer_id", b"load_balancer_id", "update_mask", b"update_mask"]) -> None: ...

global___UpdateListenerRequest = UpdateListenerRequest

@typing.final
class UpdateListenerMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOAD_BALANCER_ID_FIELD_NUMBER: builtins.int
    LISTENER_NAME_FIELD_NUMBER: builtins.int
    load_balancer_id: builtins.str
    """ID of the application load balancer that the listener is being updated in."""
    listener_name: builtins.str
    """Name of the listener that is being updated."""
    def __init__(
        self,
        *,
        load_balancer_id: builtins.str = ...,
        listener_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["listener_name", b"listener_name", "load_balancer_id", b"load_balancer_id"]) -> None: ...

global___UpdateListenerMetadata = UpdateListenerMetadata

@typing.final
class AddressSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EXTERNAL_IPV4_ADDRESS_SPEC_FIELD_NUMBER: builtins.int
    INTERNAL_IPV4_ADDRESS_SPEC_FIELD_NUMBER: builtins.int
    EXTERNAL_IPV6_ADDRESS_SPEC_FIELD_NUMBER: builtins.int
    @property
    def external_ipv4_address_spec(self) -> global___ExternalIpv4AddressSpec:
        """Public IPv4 endpoint address."""

    @property
    def internal_ipv4_address_spec(self) -> global___InternalIpv4AddressSpec:
        """Internal IPv4 endpoint address.

        To enable the use of listeners with internal addresses, [contact support](/docs/support/overview#response-time).
        """

    @property
    def external_ipv6_address_spec(self) -> global___ExternalIpv6AddressSpec:
        """Public IPv6 endpoint address."""

    def __init__(
        self,
        *,
        external_ipv4_address_spec: global___ExternalIpv4AddressSpec | None = ...,
        internal_ipv4_address_spec: global___InternalIpv4AddressSpec | None = ...,
        external_ipv6_address_spec: global___ExternalIpv6AddressSpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["address_spec", b"address_spec", "external_ipv4_address_spec", b"external_ipv4_address_spec", "external_ipv6_address_spec", b"external_ipv6_address_spec", "internal_ipv4_address_spec", b"internal_ipv4_address_spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["address_spec", b"address_spec", "external_ipv4_address_spec", b"external_ipv4_address_spec", "external_ipv6_address_spec", b"external_ipv6_address_spec", "internal_ipv4_address_spec", b"internal_ipv4_address_spec"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["address_spec", b"address_spec"]) -> typing.Literal["external_ipv4_address_spec", "internal_ipv4_address_spec", "external_ipv6_address_spec"] | None: ...

global___AddressSpec = AddressSpec

@typing.final
class ExternalIpv4AddressSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ADDRESS_FIELD_NUMBER: builtins.int
    address: builtins.str
    """IPv4 address."""
    def __init__(
        self,
        *,
        address: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["address", b"address"]) -> None: ...

global___ExternalIpv4AddressSpec = ExternalIpv4AddressSpec

@typing.final
class InternalIpv4AddressSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ADDRESS_FIELD_NUMBER: builtins.int
    SUBNET_ID_FIELD_NUMBER: builtins.int
    address: builtins.str
    """IPv4 address."""
    subnet_id: builtins.str
    """ID of the subnet that the address belongs to."""
    def __init__(
        self,
        *,
        address: builtins.str = ...,
        subnet_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["address", b"address", "subnet_id", b"subnet_id"]) -> None: ...

global___InternalIpv4AddressSpec = InternalIpv4AddressSpec

@typing.final
class ExternalIpv6AddressSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ADDRESS_FIELD_NUMBER: builtins.int
    address: builtins.str
    """IPv6 address."""
    def __init__(
        self,
        *,
        address: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["address", b"address"]) -> None: ...

global___ExternalIpv6AddressSpec = ExternalIpv6AddressSpec

@typing.final
class EndpointSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ADDRESS_SPECS_FIELD_NUMBER: builtins.int
    PORTS_FIELD_NUMBER: builtins.int
    @property
    def address_specs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AddressSpec]:
        """Endpoint public (external) and internal addresses."""

    @property
    def ports(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """Endpoint ports."""

    def __init__(
        self,
        *,
        address_specs: collections.abc.Iterable[global___AddressSpec] | None = ...,
        ports: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["address_specs", b"address_specs", "ports", b"ports"]) -> None: ...

global___EndpointSpec = EndpointSpec

@typing.final
class ListenerSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    ENDPOINT_SPECS_FIELD_NUMBER: builtins.int
    HTTP_FIELD_NUMBER: builtins.int
    TLS_FIELD_NUMBER: builtins.int
    STREAM_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the listener. The name is unique within the application load balancer."""
    @property
    def endpoint_specs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___EndpointSpec]:
        """Endpoints of the listener.

        Endpoints are defined by their IP addresses and ports.
        """

    @property
    def http(self) -> yandex.cloud.apploadbalancer.v1.load_balancer_pb2.HttpListener:
        """Unencrypted HTTP listener settings."""

    @property
    def tls(self) -> yandex.cloud.apploadbalancer.v1.load_balancer_pb2.TlsListener:
        """TLS-encrypted HTTP or TCP stream listener settings.

        All handlers within a listener ([TlsListener.default_handler] and [TlsListener.sni_handlers]) must be of one
        type, [HttpHandler] or [StreamHandler]. Mixing HTTP and TCP stream traffic in a TLS-encrypted listener is not
        supported.
        """

    @property
    def stream(self) -> yandex.cloud.apploadbalancer.v1.load_balancer_pb2.StreamListener:
        """Unencrypted stream (TCP) listener settings."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        endpoint_specs: collections.abc.Iterable[global___EndpointSpec] | None = ...,
        http: yandex.cloud.apploadbalancer.v1.load_balancer_pb2.HttpListener | None = ...,
        tls: yandex.cloud.apploadbalancer.v1.load_balancer_pb2.TlsListener | None = ...,
        stream: yandex.cloud.apploadbalancer.v1.load_balancer_pb2.StreamListener | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["http", b"http", "listener", b"listener", "stream", b"stream", "tls", b"tls"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["endpoint_specs", b"endpoint_specs", "http", b"http", "listener", b"listener", "name", b"name", "stream", b"stream", "tls", b"tls"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["listener", b"listener"]) -> typing.Literal["http", "tls", "stream"] | None: ...

global___ListenerSpec = ListenerSpec

@typing.final
class GetTargetStatesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOAD_BALANCER_ID_FIELD_NUMBER: builtins.int
    BACKEND_GROUP_ID_FIELD_NUMBER: builtins.int
    TARGET_GROUP_ID_FIELD_NUMBER: builtins.int
    load_balancer_id: builtins.str
    """ID of the application load balancer that the backend group is attributed to."""
    backend_group_id: builtins.str
    """ID of the backend group that the target group is attributed to."""
    target_group_id: builtins.str
    """ID of the target group to get target states of."""
    def __init__(
        self,
        *,
        load_balancer_id: builtins.str = ...,
        backend_group_id: builtins.str = ...,
        target_group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["backend_group_id", b"backend_group_id", "load_balancer_id", b"load_balancer_id", "target_group_id", b"target_group_id"]) -> None: ...

global___GetTargetStatesRequest = GetTargetStatesRequest

@typing.final
class GetTargetStatesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TARGET_STATES_FIELD_NUMBER: builtins.int
    @property
    def target_states(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.apploadbalancer.v1.load_balancer_pb2.TargetState]:
        """Target states of the specified target group."""

    def __init__(
        self,
        *,
        target_states: collections.abc.Iterable[yandex.cloud.apploadbalancer.v1.load_balancer_pb2.TargetState] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["target_states", b"target_states"]) -> None: ...

global___GetTargetStatesResponse = GetTargetStatesResponse

@typing.final
class AddSniMatchRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOAD_BALANCER_ID_FIELD_NUMBER: builtins.int
    LISTENER_NAME_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    SERVER_NAMES_FIELD_NUMBER: builtins.int
    HANDLER_FIELD_NUMBER: builtins.int
    load_balancer_id: builtins.str
    """ID of the application load balancer to add a SNI handler to."""
    listener_name: builtins.str
    """Name of the listener to add a SNI handler to."""
    name: builtins.str
    """Name of the SNI handler to add."""
    @property
    def server_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Server names that are matched by the SNI handler."""

    @property
    def handler(self) -> yandex.cloud.apploadbalancer.v1.load_balancer_pb2.TlsHandler:
        """Settings for handling requests with Server Name Indication (SNI) matching one of [server_names] values."""

    def __init__(
        self,
        *,
        load_balancer_id: builtins.str = ...,
        listener_name: builtins.str = ...,
        name: builtins.str = ...,
        server_names: collections.abc.Iterable[builtins.str] | None = ...,
        handler: yandex.cloud.apploadbalancer.v1.load_balancer_pb2.TlsHandler | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["handler", b"handler"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["handler", b"handler", "listener_name", b"listener_name", "load_balancer_id", b"load_balancer_id", "name", b"name", "server_names", b"server_names"]) -> None: ...

global___AddSniMatchRequest = AddSniMatchRequest

@typing.final
class AddSniMatchMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOAD_BALANCER_ID_FIELD_NUMBER: builtins.int
    LISTENER_NAME_FIELD_NUMBER: builtins.int
    SNI_MATCH_NAME_FIELD_NUMBER: builtins.int
    load_balancer_id: builtins.str
    """ID of the application load balancer that the SNI handler is being added to."""
    listener_name: builtins.str
    """Name of the listener that the SNI handler is being added to."""
    sni_match_name: builtins.str
    """Name of the SNI handler that is being added to the listener."""
    def __init__(
        self,
        *,
        load_balancer_id: builtins.str = ...,
        listener_name: builtins.str = ...,
        sni_match_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["listener_name", b"listener_name", "load_balancer_id", b"load_balancer_id", "sni_match_name", b"sni_match_name"]) -> None: ...

global___AddSniMatchMetadata = AddSniMatchMetadata

@typing.final
class RemoveSniMatchRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOAD_BALANCER_ID_FIELD_NUMBER: builtins.int
    LISTENER_NAME_FIELD_NUMBER: builtins.int
    SNI_MATCH_NAME_FIELD_NUMBER: builtins.int
    load_balancer_id: builtins.str
    """ID of the application load balancer to remove the SNI handler from."""
    listener_name: builtins.str
    """Name of the listener te remove the SNI handler from."""
    sni_match_name: builtins.str
    """Name of the SNI handler to remove."""
    def __init__(
        self,
        *,
        load_balancer_id: builtins.str = ...,
        listener_name: builtins.str = ...,
        sni_match_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["listener_name", b"listener_name", "load_balancer_id", b"load_balancer_id", "sni_match_name", b"sni_match_name"]) -> None: ...

global___RemoveSniMatchRequest = RemoveSniMatchRequest

@typing.final
class RemoveSniMatchMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOAD_BALANCER_ID_FIELD_NUMBER: builtins.int
    LISTENER_NAME_FIELD_NUMBER: builtins.int
    SNI_MATCH_NAME_FIELD_NUMBER: builtins.int
    load_balancer_id: builtins.str
    """ID of the application load balancer that the SNI handler is being removed from."""
    listener_name: builtins.str
    """Name of the listener that the SNI handler is being removed from."""
    sni_match_name: builtins.str
    """Name of the SNI handler that is being removed."""
    def __init__(
        self,
        *,
        load_balancer_id: builtins.str = ...,
        listener_name: builtins.str = ...,
        sni_match_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["listener_name", b"listener_name", "load_balancer_id", b"load_balancer_id", "sni_match_name", b"sni_match_name"]) -> None: ...

global___RemoveSniMatchMetadata = RemoveSniMatchMetadata

@typing.final
class UpdateSniMatchRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOAD_BALANCER_ID_FIELD_NUMBER: builtins.int
    LISTENER_NAME_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    SERVER_NAMES_FIELD_NUMBER: builtins.int
    HANDLER_FIELD_NUMBER: builtins.int
    load_balancer_id: builtins.str
    """ID of the application load balancer to update the SNI handler in."""
    listener_name: builtins.str
    """Name of the listener to update the SNI handler in."""
    name: builtins.str
    """Name of the SNI handler to update."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which attributes of the SNI handler should be updated."""

    @property
    def server_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """New server names that are matched by the SNI handler.

        Existing set of server names is completely replaced by the provided set, so if you just want
        to add or remove a server name:
        1. Get the current set of server names with a [LoadBalancerService.Get] request.
        2. Add or remove a server name in this set.
        3. Send the new set in this field.
        """

    @property
    def handler(self) -> yandex.cloud.apploadbalancer.v1.load_balancer_pb2.TlsHandler:
        """New settings for handling requests with Server Name Indication (SNI) matching one of [server_names] values."""

    def __init__(
        self,
        *,
        load_balancer_id: builtins.str = ...,
        listener_name: builtins.str = ...,
        name: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        server_names: collections.abc.Iterable[builtins.str] | None = ...,
        handler: yandex.cloud.apploadbalancer.v1.load_balancer_pb2.TlsHandler | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["handler", b"handler", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["handler", b"handler", "listener_name", b"listener_name", "load_balancer_id", b"load_balancer_id", "name", b"name", "server_names", b"server_names", "update_mask", b"update_mask"]) -> None: ...

global___UpdateSniMatchRequest = UpdateSniMatchRequest

@typing.final
class UpdateSniMatchMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOAD_BALANCER_ID_FIELD_NUMBER: builtins.int
    LISTENER_NAME_FIELD_NUMBER: builtins.int
    SNI_MATCH_NAME_FIELD_NUMBER: builtins.int
    load_balancer_id: builtins.str
    """ID of the application load balancer that the SNI handler is being updated in."""
    listener_name: builtins.str
    """Name of the listener that the SNI handler is being updated in."""
    sni_match_name: builtins.str
    """Name of the SNI handler that is being updated."""
    def __init__(
        self,
        *,
        load_balancer_id: builtins.str = ...,
        listener_name: builtins.str = ...,
        sni_match_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["listener_name", b"listener_name", "load_balancer_id", b"load_balancer_id", "sni_match_name", b"sni_match_name"]) -> None: ...

global___UpdateSniMatchMetadata = UpdateSniMatchMetadata

@typing.final
class ListLoadBalancerOperationsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOAD_BALANCER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    load_balancer_id: builtins.str
    """ID of the application load balancer to get operations for.

    To get the application load balancer ID, use a [LoadBalancerService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page that should be returned. If the number of available
    results is larger than [page_size], the service returns a [ListLoadBalancerOperationsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the
    [ListLoadBalancerOperationsResponse.next_page_token] returned by a previous list request.
    """
    def __init__(
        self,
        *,
        load_balancer_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["load_balancer_id", b"load_balancer_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListLoadBalancerOperationsRequest = ListLoadBalancerOperationsRequest

@typing.final
class ListLoadBalancerOperationsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    the specified [ListLoadBalancerOperationsRequest.page_size], use `next_page_token` as the value
    for the [ListLoadBalancerOperationsRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `next_page_token` to continue paging through the results.
    """
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.operation.operation_pb2.Operation]:
        """List of operations for the specified application load balancer."""

    def __init__(
        self,
        *,
        operations: collections.abc.Iterable[yandex.cloud.operation.operation_pb2.Operation] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "operations", b"operations"]) -> None: ...

global___ListLoadBalancerOperationsResponse = ListLoadBalancerOperationsResponse

@typing.final
class StartZonalShiftRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOAD_BALANCER_ID_FIELD_NUMBER: builtins.int
    ZONE_IDS_FIELD_NUMBER: builtins.int
    load_balancer_id: builtins.str
    """ID of the application load balancer to start zonal shift."""
    @property
    def zone_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Zone IDs to start zonal shift."""

    def __init__(
        self,
        *,
        load_balancer_id: builtins.str = ...,
        zone_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["load_balancer_id", b"load_balancer_id", "zone_ids", b"zone_ids"]) -> None: ...

global___StartZonalShiftRequest = StartZonalShiftRequest

@typing.final
class StartZonalShiftMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOAD_BALANCER_ID_FIELD_NUMBER: builtins.int
    ZONE_IDS_FIELD_NUMBER: builtins.int
    load_balancer_id: builtins.str
    """ID of the application load balancer that the zonal shift is being started to."""
    @property
    def zone_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Zone IDs where zonal shift was started."""

    def __init__(
        self,
        *,
        load_balancer_id: builtins.str = ...,
        zone_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["load_balancer_id", b"load_balancer_id", "zone_ids", b"zone_ids"]) -> None: ...

global___StartZonalShiftMetadata = StartZonalShiftMetadata

@typing.final
class CancelZonalShiftRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOAD_BALANCER_ID_FIELD_NUMBER: builtins.int
    ZONE_IDS_FIELD_NUMBER: builtins.int
    load_balancer_id: builtins.str
    """ID of the application load balancer to cancel zonal shift."""
    @property
    def zone_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Zone IDs to cancel zonal shift."""

    def __init__(
        self,
        *,
        load_balancer_id: builtins.str = ...,
        zone_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["load_balancer_id", b"load_balancer_id", "zone_ids", b"zone_ids"]) -> None: ...

global___CancelZonalShiftRequest = CancelZonalShiftRequest

@typing.final
class CancelZonalShiftMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOAD_BALANCER_ID_FIELD_NUMBER: builtins.int
    ZONE_IDS_FIELD_NUMBER: builtins.int
    load_balancer_id: builtins.str
    """ID of the application load balancer that the zonal shift is being canceled to."""
    @property
    def zone_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Zone IDs where zonal shift was cancelled."""

    def __init__(
        self,
        *,
        load_balancer_id: builtins.str = ...,
        zone_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["load_balancer_id", b"load_balancer_id", "zone_ids", b"zone_ids"]) -> None: ...

global___CancelZonalShiftMetadata = CancelZonalShiftMetadata

@typing.final
class DisableZonesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOAD_BALANCER_ID_FIELD_NUMBER: builtins.int
    ZONE_IDS_FIELD_NUMBER: builtins.int
    DURATION_FIELD_NUMBER: builtins.int
    load_balancer_id: builtins.str
    """ID of the application load balancer to disable traffic in zones."""
    @property
    def zone_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Zone IDs to disable traffic."""

    @property
    def duration(self) -> google.protobuf.duration_pb2.Duration:
        """The interval during which the zones will be disabled (1m-72h). If not set then until EnableZones call."""

    def __init__(
        self,
        *,
        load_balancer_id: builtins.str = ...,
        zone_ids: collections.abc.Iterable[builtins.str] | None = ...,
        duration: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["duration", b"duration"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["duration", b"duration", "load_balancer_id", b"load_balancer_id", "zone_ids", b"zone_ids"]) -> None: ...

global___DisableZonesRequest = DisableZonesRequest

@typing.final
class DisableZonesMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOAD_BALANCER_ID_FIELD_NUMBER: builtins.int
    ZONE_IDS_FIELD_NUMBER: builtins.int
    load_balancer_id: builtins.str
    """ID of the application load balancer to disable traffic in zones."""
    @property
    def zone_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Zone IDs where traffic was disabled."""

    def __init__(
        self,
        *,
        load_balancer_id: builtins.str = ...,
        zone_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["load_balancer_id", b"load_balancer_id", "zone_ids", b"zone_ids"]) -> None: ...

global___DisableZonesMetadata = DisableZonesMetadata

@typing.final
class EnableZonesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOAD_BALANCER_ID_FIELD_NUMBER: builtins.int
    ZONE_IDS_FIELD_NUMBER: builtins.int
    load_balancer_id: builtins.str
    """ID of the application load balancer to enable traffic in zones."""
    @property
    def zone_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Zone IDs to enable traffic."""

    def __init__(
        self,
        *,
        load_balancer_id: builtins.str = ...,
        zone_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["load_balancer_id", b"load_balancer_id", "zone_ids", b"zone_ids"]) -> None: ...

global___EnableZonesRequest = EnableZonesRequest

@typing.final
class EnableZonesMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOAD_BALANCER_ID_FIELD_NUMBER: builtins.int
    ZONE_IDS_FIELD_NUMBER: builtins.int
    load_balancer_id: builtins.str
    """ID of the application load balancer to enable traffic in zones."""
    @property
    def zone_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Zone IDs where traffic was enabled."""

    def __init__(
        self,
        *,
        load_balancer_id: builtins.str = ...,
        zone_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["load_balancer_id", b"load_balancer_id", "zone_ids", b"zone_ids"]) -> None: ...

global___EnableZonesMetadata = EnableZonesMetadata
