"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Trail(google.protobuf.message.Message):
    """Trail describes the filtering and destination configuration of the process of sending Audit events"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Trail._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: Trail._Status.ValueType  # 0
        ACTIVE: Trail._Status.ValueType  # 1
        """The trail is active and Audit events are processed"""
        ERROR: Trail._Status.ValueType  # 2
        """The trail configuration has issues that are preventing Audit Trails from delivering events"""
        DELETED: Trail._Status.ValueType  # 3
        """The trail is being deleted"""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNSPECIFIED: Trail.Status.ValueType  # 0
    ACTIVE: Trail.Status.ValueType  # 1
    """The trail is active and Audit events are processed"""
    ERROR: Trail.Status.ValueType  # 2
    """The trail configuration has issues that are preventing Audit Trails from delivering events"""
    DELETED: Trail.Status.ValueType  # 3
    """The trail is being deleted"""

    class _EventCategoryFilter:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EventCategoryFilterEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Trail._EventCategoryFilter.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        EVENT_CATEGORY_FILTER_UNSPECIFIED: Trail._EventCategoryFilter.ValueType  # 0
        CONTROL_PLANE: Trail._EventCategoryFilter.ValueType  # 1
        """The events that are generated during the interaction with the service's resources"""
        DATA_PLANE: Trail._EventCategoryFilter.ValueType  # 2
        """Events that are generated during interaction with data within the service's resources"""

    class EventCategoryFilter(_EventCategoryFilter, metaclass=_EventCategoryFilterEnumTypeWrapper): ...
    EVENT_CATEGORY_FILTER_UNSPECIFIED: Trail.EventCategoryFilter.ValueType  # 0
    CONTROL_PLANE: Trail.EventCategoryFilter.ValueType  # 1
    """The events that are generated during the interaction with the service's resources"""
    DATA_PLANE: Trail.EventCategoryFilter.ValueType  # 2
    """Events that are generated during interaction with data within the service's resources"""

    class _EventAccessTypeFilter:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EventAccessTypeFilterEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Trail._EventAccessTypeFilter.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        EVENT_ACCESS_TYPE_FILTER_UNSPECIFIED: Trail._EventAccessTypeFilter.ValueType  # 0
        WRITE: Trail._EventAccessTypeFilter.ValueType  # 1
        """Events for operations that do perform some modification"""
        READ: Trail._EventAccessTypeFilter.ValueType  # 2
        """Events for operations that do not perform any modifications"""

    class EventAccessTypeFilter(_EventAccessTypeFilter, metaclass=_EventAccessTypeFilterEnumTypeWrapper): ...
    EVENT_ACCESS_TYPE_FILTER_UNSPECIFIED: Trail.EventAccessTypeFilter.ValueType  # 0
    WRITE: Trail.EventAccessTypeFilter.ValueType  # 1
    """Events for operations that do perform some modification"""
    READ: Trail.EventAccessTypeFilter.ValueType  # 2
    """Events for operations that do not perform any modifications"""

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing.final
    class Destination(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        OBJECT_STORAGE_FIELD_NUMBER: builtins.int
        CLOUD_LOGGING_FIELD_NUMBER: builtins.int
        DATA_STREAM_FIELD_NUMBER: builtins.int
        EVENTROUTER_FIELD_NUMBER: builtins.int
        @property
        def object_storage(self) -> global___Trail.ObjectStorage:
            """Configuration for event delivery to Object Storage

            Uploaded objects will have prefix <trail_id>/ by default
            """

        @property
        def cloud_logging(self) -> global___Trail.CloudLogging:
            """Configuration for event delivery to Cloud Logging"""

        @property
        def data_stream(self) -> global___Trail.DataStream:
            """Configuration for event delivery to YDS"""

        @property
        def eventrouter(self) -> global___Trail.EventRouter:
            """Configuration for event delivery to EventRouter"""

        def __init__(
            self,
            *,
            object_storage: global___Trail.ObjectStorage | None = ...,
            cloud_logging: global___Trail.CloudLogging | None = ...,
            data_stream: global___Trail.DataStream | None = ...,
            eventrouter: global___Trail.EventRouter | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["cloud_logging", b"cloud_logging", "data_stream", b"data_stream", "destination", b"destination", "eventrouter", b"eventrouter", "object_storage", b"object_storage"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["cloud_logging", b"cloud_logging", "data_stream", b"data_stream", "destination", b"destination", "eventrouter", b"eventrouter", "object_storage", b"object_storage"]) -> None: ...
        def WhichOneof(self, oneof_group: typing.Literal["destination", b"destination"]) -> typing.Literal["object_storage", "cloud_logging", "data_stream", "eventrouter"] | None: ...

    @typing.final
    class ObjectStorage(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        BUCKET_ID_FIELD_NUMBER: builtins.int
        OBJECT_PREFIX_FIELD_NUMBER: builtins.int
        bucket_id: builtins.str
        """Name of the destination bucket"""
        object_prefix: builtins.str
        """Prefix for exported objects. Optional
        If specified, uploaded objects will have prefix <object_prefix>/<trail_id>/
        """
        def __init__(
            self,
            *,
            bucket_id: builtins.str = ...,
            object_prefix: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["bucket_id", b"bucket_id", "object_prefix", b"object_prefix"]) -> None: ...

    @typing.final
    class CloudLogging(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        LOG_GROUP_ID_FIELD_NUMBER: builtins.int
        log_group_id: builtins.str
        """ID of the Cloud Logging destination group"""
        def __init__(
            self,
            *,
            log_group_id: builtins.str = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["destination", b"destination", "log_group_id", b"log_group_id"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["destination", b"destination", "log_group_id", b"log_group_id"]) -> None: ...
        def WhichOneof(self, oneof_group: typing.Literal["destination", b"destination"]) -> typing.Literal["log_group_id"] | None: ...

    @typing.final
    class DataStream(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        DATABASE_ID_FIELD_NUMBER: builtins.int
        STREAM_NAME_FIELD_NUMBER: builtins.int
        database_id: builtins.str
        """ID of the database hosting the destination YDS"""
        stream_name: builtins.str
        """Name of the destination YDS"""
        def __init__(
            self,
            *,
            database_id: builtins.str = ...,
            stream_name: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["database_id", b"database_id", "stream_name", b"stream_name"]) -> None: ...

    @typing.final
    class EventRouter(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        EVENTROUTER_CONNECTOR_ID_FIELD_NUMBER: builtins.int
        eventrouter_connector_id: builtins.str
        """ID of the EventRouter Connector"""
        def __init__(
            self,
            *,
            eventrouter_connector_id: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["eventrouter_connector_id", b"eventrouter_connector_id"]) -> None: ...

    @typing.final
    class Filter(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        PATH_FILTER_FIELD_NUMBER: builtins.int
        EVENT_FILTER_FIELD_NUMBER: builtins.int
        @property
        def path_filter(self) -> global___Trail.PathFilter:
            """Configuration of default events gathering for the trail
            If not specified, default events won't be gathered for the trail
            """

        @property
        def event_filter(self) -> global___Trail.EventFilter:
            """Configuration of additional events gathering from specific services"""

        def __init__(
            self,
            *,
            path_filter: global___Trail.PathFilter | None = ...,
            event_filter: global___Trail.EventFilter | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["event_filter", b"event_filter", "path_filter", b"path_filter"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["event_filter", b"event_filter", "path_filter", b"path_filter"]) -> None: ...

    @typing.final
    class PathFilter(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ROOT_FIELD_NUMBER: builtins.int
        @property
        def root(self) -> global___Trail.PathFilterElement:
            """Root element of the resource path filter for the trail
            Resource described in that filter node must contain the trail itself
            """

        def __init__(
            self,
            *,
            root: global___Trail.PathFilterElement | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["root", b"root"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["root", b"root"]) -> None: ...

    @typing.final
    class PathFilterElement(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ANY_FILTER_FIELD_NUMBER: builtins.int
        SOME_FILTER_FIELD_NUMBER: builtins.int
        @property
        def any_filter(self) -> global___Trail.PathFilterElementAny:
            """Filter element with ANY type. If used, configures the trail to gather any events from the resource"""

        @property
        def some_filter(self) -> global___Trail.PathFilterElementSome:
            """Filter element with SOME type. If used, configures the trail to gather some of the events from the resource"""

        def __init__(
            self,
            *,
            any_filter: global___Trail.PathFilterElementAny | None = ...,
            some_filter: global___Trail.PathFilterElementSome | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["any_filter", b"any_filter", "element", b"element", "some_filter", b"some_filter"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["any_filter", b"any_filter", "element", b"element", "some_filter", b"some_filter"]) -> None: ...
        def WhichOneof(self, oneof_group: typing.Literal["element", b"element"]) -> typing.Literal["any_filter", "some_filter"] | None: ...

    @typing.final
    class PathFilterElementAny(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        RESOURCE_FIELD_NUMBER: builtins.int
        @property
        def resource(self) -> global___Trail.Resource:
            """Resource definition"""

        def __init__(
            self,
            *,
            resource: global___Trail.Resource | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["resource", b"resource"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["resource", b"resource"]) -> None: ...

    @typing.final
    class PathFilterElementSome(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        RESOURCE_FIELD_NUMBER: builtins.int
        FILTERS_FIELD_NUMBER: builtins.int
        @property
        def resource(self) -> global___Trail.Resource:
            """Definition of the resource that contains nested resources"""

        @property
        def filters(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Trail.PathFilterElement]:
            """Filters for the resources contained in the parent resource"""

        def __init__(
            self,
            *,
            resource: global___Trail.Resource | None = ...,
            filters: collections.abc.Iterable[global___Trail.PathFilterElement] | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["resource", b"resource"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["filters", b"filters", "resource", b"resource"]) -> None: ...

    @typing.final
    class Resource(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ID_FIELD_NUMBER: builtins.int
        TYPE_FIELD_NUMBER: builtins.int
        id: builtins.str
        """ID of the resource"""
        type: builtins.str
        """Type of the resource"""
        def __init__(
            self,
            *,
            id: builtins.str = ...,
            type: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["id", b"id", "type", b"type"]) -> None: ...

    @typing.final
    class EventFilter(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        FILTERS_FIELD_NUMBER: builtins.int
        @property
        def filters(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Trail.EventFilterElement]:
            """List of filters for services"""

        def __init__(
            self,
            *,
            filters: collections.abc.Iterable[global___Trail.EventFilterElement] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["filters", b"filters"]) -> None: ...

    @typing.final
    class EventFilterElement(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        SERVICE_FIELD_NUMBER: builtins.int
        CATEGORIES_FIELD_NUMBER: builtins.int
        PATH_FILTER_FIELD_NUMBER: builtins.int
        service: builtins.str
        """Service ID of the gathered events"""
        @property
        def categories(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Trail.EventFilterElementCategory]:
            """List of the event categories gathered for a specified service"""

        @property
        def path_filter(self) -> global___Trail.PathFilter:
            """Resource path filter for a specified service"""

        def __init__(
            self,
            *,
            service: builtins.str = ...,
            categories: collections.abc.Iterable[global___Trail.EventFilterElementCategory] | None = ...,
            path_filter: global___Trail.PathFilter | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["path_filter", b"path_filter"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["categories", b"categories", "path_filter", b"path_filter", "service", b"service"]) -> None: ...

    @typing.final
    class EventFilterElementCategory(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        PLANE_FIELD_NUMBER: builtins.int
        TYPE_FIELD_NUMBER: builtins.int
        plane: global___Trail.EventCategoryFilter.ValueType
        """Plane of the gathered category"""
        type: global___Trail.EventAccessTypeFilter.ValueType
        """Type of the gathered category"""
        def __init__(
            self,
            *,
            plane: global___Trail.EventCategoryFilter.ValueType = ...,
            type: global___Trail.EventAccessTypeFilter.ValueType = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["plane", b"plane", "type", b"type"]) -> None: ...

    @typing.final
    class DataEventsFiltering(google.protobuf.message.Message):
        """Policy for gathering data events"""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        SERVICE_FIELD_NUMBER: builtins.int
        INCLUDED_EVENTS_FIELD_NUMBER: builtins.int
        EXCLUDED_EVENTS_FIELD_NUMBER: builtins.int
        DNS_FILTER_FIELD_NUMBER: builtins.int
        RESOURCE_SCOPES_FIELD_NUMBER: builtins.int
        service: builtins.str
        """Name of the service whose events will be delivered"""
        @property
        def included_events(self) -> global___Trail.EventTypes:
            """Explicitly included events of specified service
            New events of the service won't be delivered by default
            """

        @property
        def excluded_events(self) -> global___Trail.EventTypes:
            """Explicitly excluded events of specified service
            New events of the service will be delivered by default
            """

        @property
        def dns_filter(self) -> global___Trail.DnsDataEventsFilter:
            """Filter is allowed only if service = dns"""

        @property
        def resource_scopes(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Trail.Resource]:
            """A list of resources which will be monitored by the trail"""

        def __init__(
            self,
            *,
            service: builtins.str = ...,
            included_events: global___Trail.EventTypes | None = ...,
            excluded_events: global___Trail.EventTypes | None = ...,
            dns_filter: global___Trail.DnsDataEventsFilter | None = ...,
            resource_scopes: collections.abc.Iterable[global___Trail.Resource] | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["additional_rules", b"additional_rules", "dns_filter", b"dns_filter", "excluded_events", b"excluded_events", "included_events", b"included_events", "service_specific_rules", b"service_specific_rules"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["additional_rules", b"additional_rules", "dns_filter", b"dns_filter", "excluded_events", b"excluded_events", "included_events", b"included_events", "resource_scopes", b"resource_scopes", "service", b"service", "service_specific_rules", b"service_specific_rules"]) -> None: ...
        @typing.overload
        def WhichOneof(self, oneof_group: typing.Literal["additional_rules", b"additional_rules"]) -> typing.Literal["included_events", "excluded_events"] | None: ...
        @typing.overload
        def WhichOneof(self, oneof_group: typing.Literal["service_specific_rules", b"service_specific_rules"]) -> typing.Literal["dns_filter"] | None: ...

    @typing.final
    class EventTypes(google.protobuf.message.Message):
        """Policy with explicitly specified event group"""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        EVENT_TYPES_FIELD_NUMBER: builtins.int
        @property
        def event_types(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
        def __init__(
            self,
            *,
            event_types: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["event_types", b"event_types"]) -> None: ...

    @typing.final
    class ManagementEventsFiltering(google.protobuf.message.Message):
        """Policy for gathering management events"""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        RESOURCE_SCOPES_FIELD_NUMBER: builtins.int
        @property
        def resource_scopes(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Trail.Resource]:
            """A list of resources which will be monitored by the trail"""

        def __init__(
            self,
            *,
            resource_scopes: collections.abc.Iterable[global___Trail.Resource] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["resource_scopes", b"resource_scopes"]) -> None: ...

    @typing.final
    class FilteringPolicy(google.protobuf.message.Message):
        """Combination of policies describing event filtering process of the trail
        At least one filed must be filled
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        MANAGEMENT_EVENTS_FILTER_FIELD_NUMBER: builtins.int
        DATA_EVENTS_FILTERS_FIELD_NUMBER: builtins.int
        @property
        def management_events_filter(self) -> global___Trail.ManagementEventsFiltering:
            """Singular filter describing gathering management events"""

        @property
        def data_events_filters(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Trail.DataEventsFiltering]:
            """List of filters describing gathering data events"""

        def __init__(
            self,
            *,
            management_events_filter: global___Trail.ManagementEventsFiltering | None = ...,
            data_events_filters: collections.abc.Iterable[global___Trail.DataEventsFiltering] | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["management_events_filter", b"management_events_filter"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["data_events_filters", b"data_events_filters", "management_events_filter", b"management_events_filter"]) -> None: ...

    @typing.final
    class DnsDataEventsFilter(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        INCLUDE_NONRECURSIVE_QUERIES_FIELD_NUMBER: builtins.int
        include_nonrecursive_queries: builtins.bool
        """Not only recursive queries will be delivered"""
        def __init__(
            self,
            *,
            include_nonrecursive_queries: builtins.bool = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["include_nonrecursive_queries", b"include_nonrecursive_queries"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    UPDATED_AT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    DESTINATION_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    STATUS_ERROR_MESSAGE_FIELD_NUMBER: builtins.int
    CLOUD_ID_FIELD_NUMBER: builtins.int
    FILTERING_POLICY_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the trail"""
    folder_id: builtins.str
    """ID of the folder that the trail belongs to"""
    name: builtins.str
    """Name of the trail"""
    description: builtins.str
    """Description of the trail"""
    service_account_id: builtins.str
    """Service account ID of the trail"""
    status: global___Trail.Status.ValueType
    """Status of the trail"""
    status_error_message: builtins.str
    """Current error message of the trail. Empty in case if the trail is active"""
    cloud_id: builtins.str
    """ID of the cloud that the trail belongs to"""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The timestamp for the creation operation"""

    @property
    def updated_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The timestamp of the last update operation"""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Custom labels of the trail as `key:value` pairs. Maximum 64 per key"""

    @property
    def destination(self) -> global___Trail.Destination:
        """Destination configuration of the trail"""

    @property
    def filter(self) -> global___Trail.Filter:
        """Filtering configuration of the trail
        deprecated: use filtering_policy instead
        """

    @property
    def filtering_policy(self) -> global___Trail.FilteringPolicy:
        """Event filtering policy
        Describes which groups of events will be sent and which resources will be monitored
        """

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        updated_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        destination: global___Trail.Destination | None = ...,
        service_account_id: builtins.str = ...,
        status: global___Trail.Status.ValueType = ...,
        filter: global___Trail.Filter | None = ...,
        status_error_message: builtins.str = ...,
        cloud_id: builtins.str = ...,
        filtering_policy: global___Trail.FilteringPolicy | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at", "destination", b"destination", "filter", b"filter", "filtering_policy", b"filtering_policy", "updated_at", b"updated_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cloud_id", b"cloud_id", "created_at", b"created_at", "description", b"description", "destination", b"destination", "filter", b"filter", "filtering_policy", b"filtering_policy", "folder_id", b"folder_id", "id", b"id", "labels", b"labels", "name", b"name", "service_account_id", b"service_account_id", "status", b"status", "status_error_message", b"status_error_message", "updated_at", b"updated_at"]) -> None: ...

global___Trail = Trail
