"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.audittrails.v1.trail_pb2
import yandex.cloud.operation.operation_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetTrailRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRAIL_ID_FIELD_NUMBER: builtins.int
    trail_id: builtins.str
    """ID of the trail to return.

    To get a trail ID make a [List] request.
    """
    def __init__(
        self,
        *,
        trail_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["trail_id", b"trail_id"]) -> None: ...

global___GetTrailRequest = GetTrailRequest

@typing.final
class ListTrailsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to list trails in."""
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than `page_size`, the service returns a [ListTrailsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set `page_token` to the
    [ListTrailsRequest.next_page_token] returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters subscription locks listed in the response.

    The expression must specify:
    1. The field name. Currently you can use filtering on [Trail.name, Trail.created_at] fields.
    2. An operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN` for lists of values.
    3. The value. Must be in double quotes `""`. Must be 3-63 characters long and match the regular expression `^[a-z][-a-z0-9]{1,61}[a-z0-9]`.
    Example of a filter: `name="my-name"`.
    """
    order_by: builtins.str
    """By which column the listing should be ordered and in which direction.
    format is "<field> desc|acs"
    """
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
        order_by: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "folder_id", b"folder_id", "order_by", b"order_by", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListTrailsRequest = ListTrailsRequest

@typing.final
class ListTrailsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRAILS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number
    of results is greater than the specified [ListTrailsRequest.page_size], use
    the `next_page_token` as the value for the [ListTrailsRequest.page_token] query parameter
    in the next list request. Each subsequent list request will have its own
    `next_page_token` to continue paging through the results.
    """
    @property
    def trails(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.audittrails.v1.trail_pb2.Trail]:
        """List of trails in the specified folder."""

    def __init__(
        self,
        *,
        trails: collections.abc.Iterable[yandex.cloud.audittrails.v1.trail_pb2.Trail] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "trails", b"trails"]) -> None: ...

global___ListTrailsResponse = ListTrailsResponse

@typing.final
class CreateTrailRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    DESTINATION_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    FILTERING_POLICY_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to create a trail in."""
    name: builtins.str
    """Name of the trail."""
    description: builtins.str
    """Description of the trail."""
    service_account_id: builtins.str
    """Service account ID of the trail"""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Custom labels for the secret as `key:value` pairs. Maximum 64 per key.
        For example, `"type": "critical"` or `"source": "dictionary"`.
        """

    @property
    def destination(self) -> yandex.cloud.audittrails.v1.trail_pb2.Trail.Destination:
        """Destination configuration for the trail"""

    @property
    def filter(self) -> yandex.cloud.audittrails.v1.trail_pb2.Trail.Filter:
        """Event filtering configuration of the trail
        deprecated: use filtering_policy instead
        """

    @property
    def filtering_policy(self) -> yandex.cloud.audittrails.v1.trail_pb2.Trail.FilteringPolicy:
        """Event filtering policy of the trail"""

    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        destination: yandex.cloud.audittrails.v1.trail_pb2.Trail.Destination | None = ...,
        service_account_id: builtins.str = ...,
        filter: yandex.cloud.audittrails.v1.trail_pb2.Trail.Filter | None = ...,
        filtering_policy: yandex.cloud.audittrails.v1.trail_pb2.Trail.FilteringPolicy | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["destination", b"destination", "filter", b"filter", "filtering_policy", b"filtering_policy"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "destination", b"destination", "filter", b"filter", "filtering_policy", b"filtering_policy", "folder_id", b"folder_id", "labels", b"labels", "name", b"name", "service_account_id", b"service_account_id"]) -> None: ...

global___CreateTrailRequest = CreateTrailRequest

@typing.final
class UpdateTrailRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    TRAIL_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    DESTINATION_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    FILTERING_POLICY_FIELD_NUMBER: builtins.int
    trail_id: builtins.str
    """ID of the trail to update."""
    name: builtins.str
    """New name of the trail."""
    description: builtins.str
    """New description of the trail."""
    service_account_id: builtins.str
    """New service account ID of the trail"""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which attributes of the trail are going to be updated."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """New custom labels for the secret as `key:value` pairs. Maximum 64 per key."""

    @property
    def destination(self) -> yandex.cloud.audittrails.v1.trail_pb2.Trail.Destination:
        """New destination configuration for the trail"""

    @property
    def filter(self) -> yandex.cloud.audittrails.v1.trail_pb2.Trail.Filter:
        """Updated filtering configuration of the trail
        deprecated: use filtering_policy instead
        """

    @property
    def filtering_policy(self) -> yandex.cloud.audittrails.v1.trail_pb2.Trail.FilteringPolicy:
        """Updated event filtering policy"""

    def __init__(
        self,
        *,
        trail_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        destination: yandex.cloud.audittrails.v1.trail_pb2.Trail.Destination | None = ...,
        service_account_id: builtins.str = ...,
        filter: yandex.cloud.audittrails.v1.trail_pb2.Trail.Filter | None = ...,
        filtering_policy: yandex.cloud.audittrails.v1.trail_pb2.Trail.FilteringPolicy | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["destination", b"destination", "filter", b"filter", "filtering_policy", b"filtering_policy", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "destination", b"destination", "filter", b"filter", "filtering_policy", b"filtering_policy", "labels", b"labels", "name", b"name", "service_account_id", b"service_account_id", "trail_id", b"trail_id", "update_mask", b"update_mask"]) -> None: ...

global___UpdateTrailRequest = UpdateTrailRequest

@typing.final
class DeleteTrailRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRAIL_ID_FIELD_NUMBER: builtins.int
    trail_id: builtins.str
    """ID of the trail to be deleted."""
    def __init__(
        self,
        *,
        trail_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["trail_id", b"trail_id"]) -> None: ...

global___DeleteTrailRequest = DeleteTrailRequest

@typing.final
class CreateTrailMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRAIL_ID_FIELD_NUMBER: builtins.int
    trail_id: builtins.str
    """ID of the trail that is being created"""
    def __init__(
        self,
        *,
        trail_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["trail_id", b"trail_id"]) -> None: ...

global___CreateTrailMetadata = CreateTrailMetadata

@typing.final
class UpdateTrailMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRAIL_ID_FIELD_NUMBER: builtins.int
    trail_id: builtins.str
    """ID of the trail that is being updated"""
    def __init__(
        self,
        *,
        trail_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["trail_id", b"trail_id"]) -> None: ...

global___UpdateTrailMetadata = UpdateTrailMetadata

@typing.final
class DeleteTrailMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRAIL_ID_FIELD_NUMBER: builtins.int
    trail_id: builtins.str
    """ID of the trail that is being deleted"""
    def __init__(
        self,
        *,
        trail_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["trail_id", b"trail_id"]) -> None: ...

global___DeleteTrailMetadata = DeleteTrailMetadata

@typing.final
class ListTrailOperationsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRAIL_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    trail_id: builtins.str
    """ID of the trail to get operations for."""
    page_size: builtins.int
    """The maximum number of results per page that should be returned. If the number of available
    results is larger than `page_size`, the service returns a [ListTrailOperationsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set `page_token` to the
    [ListTrailOperationsRequest.next_page_token] returned by a previous list request.
    """
    def __init__(
        self,
        *,
        trail_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["page_size", b"page_size", "page_token", b"page_token", "trail_id", b"trail_id"]) -> None: ...

global___ListTrailOperationsRequest = ListTrailOperationsRequest

@typing.final
class ListTrailOperationsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListTrailOperationsResponse.page_size], use the `next_page_token` as the value
    for the [ListTrailOperationsResponse.page_token] query parameter in the next list request.
    Each subsequent list request will have its own `next_page_token` to continue paging through the results.
    """
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.operation.operation_pb2.Operation]:
        """List of operations for the specified trail."""

    def __init__(
        self,
        *,
        operations: collections.abc.Iterable[yandex.cloud.operation.operation_pb2.Operation] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "operations", b"operations"]) -> None: ...

global___ListTrailOperationsResponse = ListTrailOperationsResponse
