"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import google.protobuf.wrappers_pb2
import sys
import typing
import yandex.cloud.backup.v1.policy_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Archive(google.protobuf.message.Message):
    """Archive is a container that holds backups of Compute Cloud instance."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _EncryptionAlgorithm:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EncryptionAlgorithmEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Archive._EncryptionAlgorithm.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        ENCRYPTION_ALGORITHM_UNSPECIFIED: Archive._EncryptionAlgorithm.ValueType  # 0
        NONE: Archive._EncryptionAlgorithm.ValueType  # 1
        AES128: Archive._EncryptionAlgorithm.ValueType  # 2
        AES192: Archive._EncryptionAlgorithm.ValueType  # 3
        AES256: Archive._EncryptionAlgorithm.ValueType  # 4

    class EncryptionAlgorithm(_EncryptionAlgorithm, metaclass=_EncryptionAlgorithmEnumTypeWrapper):
        """Encryption Algorithm for underlying backups: 
        `ENCRYPTION_ALGORITHM_UNSPECIFIED`, `NONE`, `AES128`, `AES192`, 
        `AES256`.
        """

    ENCRYPTION_ALGORITHM_UNSPECIFIED: Archive.EncryptionAlgorithm.ValueType  # 0
    NONE: Archive.EncryptionAlgorithm.ValueType  # 1
    AES128: Archive.EncryptionAlgorithm.ValueType  # 2
    AES192: Archive.EncryptionAlgorithm.ValueType  # 3
    AES256: Archive.EncryptionAlgorithm.ValueType  # 4

    class _Action:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ActionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Archive._Action.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        ACTION_UNSPECIFIED: Archive._Action.ValueType  # 0
        REFRESH: Archive._Action.ValueType  # 1
        DELETE_BY_AGENT: Archive._Action.ValueType  # 2

    class Action(_Action, metaclass=_ActionEnumTypeWrapper):
        """Action with archive backup: `ACTION_UNSPECIFIED`, `REFRESH`,
        `DELETE_BY_AGENT`.
        """

    ACTION_UNSPECIFIED: Archive.Action.ValueType  # 0
    REFRESH: Archive.Action.ValueType  # 1
    DELETE_BY_AGENT: Archive.Action.ValueType  # 2

    @typing.final
    class ArchiveAttributes(google.protobuf.message.Message):
        """Archive attributes."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        AAIB_FIELD_NUMBER: builtins.int
        URI_FIELD_NUMBER: builtins.int
        aaib: builtins.str
        """Archive attribute. Default value: `0`."""
        uri: builtins.str
        """URI of the backup archive."""
        def __init__(
            self,
            *,
            aaib: builtins.str = ...,
            uri: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["aaib", b"aaib", "uri", b"uri"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    VAULT_ID_FIELD_NUMBER: builtins.int
    ATTRIBUTES_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    COMPRESSED_DATA_SIZE_FIELD_NUMBER: builtins.int
    DATA_SIZE_FIELD_NUMBER: builtins.int
    ORIGINAL_DATA_SIZE_FIELD_NUMBER: builtins.int
    LOGICAL_SIZE_FIELD_NUMBER: builtins.int
    FORMAT_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    UPDATED_AT_FIELD_NUMBER: builtins.int
    LAST_BACKUP_CREATED_AT_FIELD_NUMBER: builtins.int
    LAST_SEEN_AT_FIELD_NUMBER: builtins.int
    PROTECTED_BY_PASSWORD_FIELD_NUMBER: builtins.int
    ENCRYPTION_ALGORITHM_FIELD_NUMBER: builtins.int
    ACTIONS_FIELD_NUMBER: builtins.int
    BACKUP_PLAN_ID_FIELD_NUMBER: builtins.int
    BACKUP_PLAN_NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    DISPLAY_NAME_FIELD_NUMBER: builtins.int
    COMPUTE_INSTANCE_ID_FIELD_NUMBER: builtins.int
    CONSISTENT_FIELD_NUMBER: builtins.int
    DELETED_FIELD_NUMBER: builtins.int
    RESOURCE_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the backup."""
    name: builtins.str
    """Name of the backup."""
    vault_id: builtins.str
    """ID of the backup vault."""
    size: builtins.int
    """Archive size."""
    compressed_data_size: builtins.int
    """Compressed data size."""
    data_size: builtins.int
    """Data size."""
    original_data_size: builtins.int
    """Original data size."""
    logical_size: builtins.int
    """Logical size."""
    format: yandex.cloud.backup.v1.policy_pb2.Format.ValueType
    protected_by_password: builtins.bool
    """If this field is true, it means that any of encryption algorithm
    has been chosen.
    """
    encryption_algorithm: global___Archive.EncryptionAlgorithm.ValueType
    backup_plan_id: builtins.str
    """Backup plan ID."""
    backup_plan_name: builtins.str
    """Backup plan name."""
    description: builtins.str
    """Backup plan description."""
    display_name: builtins.str
    """Display name, e.g. `INSTANCE_NAME - POLICY_NAME`."""
    compute_instance_id: builtins.str
    """Compute Cloud instance ID."""
    consistent: builtins.bool
    """If this field is true, it means that the archive is consistent."""
    deleted: builtins.bool
    """If this field is true, it means that the archive was deleted."""
    resource_id: builtins.str
    """Resource ID."""
    @property
    def attributes(self) -> global___Archive.ArchiveAttributes:
        """Archive attributes."""

    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def updated_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def last_backup_created_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def last_seen_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def actions(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___Archive.Action.ValueType]: ...
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        vault_id: builtins.str = ...,
        attributes: global___Archive.ArchiveAttributes | None = ...,
        size: builtins.int = ...,
        compressed_data_size: builtins.int = ...,
        data_size: builtins.int = ...,
        original_data_size: builtins.int = ...,
        logical_size: builtins.int = ...,
        format: yandex.cloud.backup.v1.policy_pb2.Format.ValueType = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        updated_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        last_backup_created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        last_seen_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        protected_by_password: builtins.bool = ...,
        encryption_algorithm: global___Archive.EncryptionAlgorithm.ValueType = ...,
        actions: collections.abc.Iterable[global___Archive.Action.ValueType] | None = ...,
        backup_plan_id: builtins.str = ...,
        backup_plan_name: builtins.str = ...,
        description: builtins.str = ...,
        display_name: builtins.str = ...,
        compute_instance_id: builtins.str = ...,
        consistent: builtins.bool = ...,
        deleted: builtins.bool = ...,
        resource_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["attributes", b"attributes", "created_at", b"created_at", "last_backup_created_at", b"last_backup_created_at", "last_seen_at", b"last_seen_at", "updated_at", b"updated_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["actions", b"actions", "attributes", b"attributes", "backup_plan_id", b"backup_plan_id", "backup_plan_name", b"backup_plan_name", "compressed_data_size", b"compressed_data_size", "compute_instance_id", b"compute_instance_id", "consistent", b"consistent", "created_at", b"created_at", "data_size", b"data_size", "deleted", b"deleted", "description", b"description", "display_name", b"display_name", "encryption_algorithm", b"encryption_algorithm", "format", b"format", "id", b"id", "last_backup_created_at", b"last_backup_created_at", "last_seen_at", b"last_seen_at", "logical_size", b"logical_size", "name", b"name", "original_data_size", b"original_data_size", "protected_by_password", b"protected_by_password", "resource_id", b"resource_id", "size", b"size", "updated_at", b"updated_at", "vault_id", b"vault_id"]) -> None: ...

global___Archive = Archive

@typing.final
class Volume(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FREE_SPACE_FIELD_NUMBER: builtins.int
    IS_BOOTABLE_FIELD_NUMBER: builtins.int
    IS_SYSTEM_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    MOUNT_STRID_FIELD_NUMBER: builtins.int
    free_space: builtins.int
    """Free space in the volume."""
    is_bootable: builtins.bool
    """If this field is true, it means that the volume is bootable."""
    is_system: builtins.bool
    """If this field is true, it means that the volume is a system volume."""
    name: builtins.str
    """Volume name."""
    size: builtins.int
    """Volume size."""
    mount_strid: builtins.str
    """Mount string ID."""
    def __init__(
        self,
        *,
        free_space: builtins.int = ...,
        is_bootable: builtins.bool = ...,
        is_system: builtins.bool = ...,
        name: builtins.str = ...,
        size: builtins.int = ...,
        mount_strid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["free_space", b"free_space", "is_bootable", b"is_bootable", "is_system", b"is_system", "mount_strid", b"mount_strid", "name", b"name", "size", b"size"]) -> None: ...

global___Volume = Volume

@typing.final
class Disk(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DEVICE_MODEL_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    VOLUMES_FIELD_NUMBER: builtins.int
    device_model: builtins.str
    """Device model."""
    name: builtins.str
    """Disk name."""
    size: builtins.int
    """Disk size."""
    @property
    def volumes(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Volume]: ...
    def __init__(
        self,
        *,
        device_model: builtins.str = ...,
        name: builtins.str = ...,
        size: builtins.int = ...,
        volumes: collections.abc.Iterable[global___Volume] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["device_model", b"device_model", "name", b"name", "size", b"size", "volumes", b"volumes"]) -> None: ...

global___Disk = Disk

@typing.final
class Backup(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Type:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Backup._Type.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TYPE_UNSPECIFIED: Backup._Type.ValueType  # 0
        FULL: Backup._Type.ValueType  # 1
        INCREMENTAL: Backup._Type.ValueType  # 2

    class Type(_Type, metaclass=_TypeEnumTypeWrapper):
        """Backup type.
        For detailed information, please see [Backup types](/docs/backup/concepts/backup#types).
        """

    TYPE_UNSPECIFIED: Backup.Type.ValueType  # 0
    FULL: Backup.Type.ValueType  # 1
    INCREMENTAL: Backup.Type.ValueType  # 2

    @typing.final
    class BackupAttributes(google.protobuf.message.Message):
        """Backup attributes."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        STREAM_NAME_FIELD_NUMBER: builtins.int
        URI_FIELD_NUMBER: builtins.int
        stream_name: builtins.str
        """Backup stream name."""
        uri: builtins.str
        """URI of the backup archive."""
        def __init__(
            self,
            *,
            stream_name: builtins.str = ...,
            uri: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["stream_name", b"stream_name", "uri", b"uri"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    VAULT_ID_FIELD_NUMBER: builtins.int
    ARCHIVE_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    LAST_SEEN_AT_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    DEDUPLICATED_SIZE_FIELD_NUMBER: builtins.int
    BACKED_UP_DATA_SIZE_FIELD_NUMBER: builtins.int
    ORIGINAL_DATA_SIZE_FIELD_NUMBER: builtins.int
    ATTRIBUTES_FIELD_NUMBER: builtins.int
    COMPUTE_INSTANCE_ID_FIELD_NUMBER: builtins.int
    DISKS_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    DELETED_FIELD_NUMBER: builtins.int
    POLICY_ID_FIELD_NUMBER: builtins.int
    RESOURCE_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the backup."""
    vault_id: builtins.str
    """ID of the backup vault."""
    archive_id: builtins.str
    """ID of the backup archive."""
    size: builtins.int
    """Backup size."""
    deduplicated_size: builtins.int
    """Deduplicated backup size."""
    backed_up_data_size: builtins.int
    """Backed up data size."""
    original_data_size: builtins.int
    """Original data size."""
    compute_instance_id: builtins.str
    """Compute Cloud instance ID."""
    type: global___Backup.Type.ValueType
    deleted: builtins.bool
    """If this field is true, it means that the backup was deleted."""
    policy_id: builtins.str
    """[Policy](/docs/backup/concepts/policy) ID."""
    resource_id: builtins.str
    """Resource ID. It identifies Compute Cloud instance in backup service."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def last_seen_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def attributes(self) -> global___Backup.BackupAttributes: ...
    @property
    def disks(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Disk]: ...
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        vault_id: builtins.str = ...,
        archive_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        last_seen_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        size: builtins.int = ...,
        deduplicated_size: builtins.int = ...,
        backed_up_data_size: builtins.int = ...,
        original_data_size: builtins.int = ...,
        attributes: global___Backup.BackupAttributes | None = ...,
        compute_instance_id: builtins.str = ...,
        disks: collections.abc.Iterable[global___Disk] | None = ...,
        type: global___Backup.Type.ValueType = ...,
        deleted: builtins.bool = ...,
        policy_id: builtins.str = ...,
        resource_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["attributes", b"attributes", "created_at", b"created_at", "last_seen_at", b"last_seen_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["archive_id", b"archive_id", "attributes", b"attributes", "backed_up_data_size", b"backed_up_data_size", "compute_instance_id", b"compute_instance_id", "created_at", b"created_at", "deduplicated_size", b"deduplicated_size", "deleted", b"deleted", "disks", b"disks", "id", b"id", "last_seen_at", b"last_seen_at", "original_data_size", b"original_data_size", "policy_id", b"policy_id", "resource_id", b"resource_id", "size", b"size", "type", b"type", "vault_id", b"vault_id"]) -> None: ...

global___Backup = Backup

@typing.final
class BackupFile(google.protobuf.message.Message):
    """BackupFile represents a single unit of file or directory system inside the backup."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Type:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[BackupFile._Type.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TYPE_UNSPECIFIED: BackupFile._Type.ValueType  # 0
        TYPE_DIR: BackupFile._Type.ValueType  # 1
        TYPE_FILE: BackupFile._Type.ValueType  # 2

    class Type(_Type, metaclass=_TypeEnumTypeWrapper):
        """Type of the file."""

    TYPE_UNSPECIFIED: BackupFile.Type.ValueType  # 0
    TYPE_DIR: BackupFile.Type.ValueType  # 1
    TYPE_FILE: BackupFile.Type.ValueType  # 2

    @typing.final
    class Actions(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        RESTORE_TO_DISK_FIELD_NUMBER: builtins.int
        GO_TO_LOCATION_FIELD_NUMBER: builtins.int
        restore_to_disk: builtins.bool
        """Allows to send request to restore item to disk"""
        go_to_location: builtins.bool
        """Allows to move to location by id."""
        def __init__(
            self,
            *,
            restore_to_disk: builtins.bool = ...,
            go_to_location: builtins.bool = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["go_to_location", b"go_to_location", "restore_to_disk", b"restore_to_disk"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    PARENT_ID_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    FULL_PATH_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    ACTIONS_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the item. Should be used as source ID in case of listing."""
    type: global___BackupFile.Type.ValueType
    """Type of the item."""
    full_path: builtins.str
    """Absolute path of the item."""
    name: builtins.str
    """Name of the directory / file."""
    size: builtins.int
    """Size in bytes of the item."""
    @property
    def parent_id(self) -> google.protobuf.wrappers_pb2.StringValue:
        """Might be empty if this is root directory."""

    @property
    def actions(self) -> global___BackupFile.Actions:
        """Actions that might be done on the object."""

    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        parent_id: google.protobuf.wrappers_pb2.StringValue | None = ...,
        type: global___BackupFile.Type.ValueType = ...,
        full_path: builtins.str = ...,
        name: builtins.str = ...,
        size: builtins.int = ...,
        actions: global___BackupFile.Actions | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["actions", b"actions", "modified_at", b"modified_at", "parent_id", b"parent_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["actions", b"actions", "full_path", b"full_path", "id", b"id", "modified_at", b"modified_at", "name", b"name", "parent_id", b"parent_id", "size", b"size", "type", b"type"]) -> None: ...

global___BackupFile = BackupFile
