"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing
import yandex.cloud.backup.v1.backup_pb2
import yandex.cloud.backup.v1.resource_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class ListArchivesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    COMPUTE_INSTANCE_ID_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """List of archives in specified folder."""
    compute_instance_id: builtins.str
    """List of archives of the specified Compute Cloud instance."""
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        compute_instance_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["compute_instance_id", b"compute_instance_id", "folder_id", b"folder_id", "id", b"id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["compute_instance_id", b"compute_instance_id", "folder_id", b"folder_id", "id", b"id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["id", b"id"]) -> typing.Literal["folder_id", "compute_instance_id"] | None: ...

global___ListArchivesRequest = ListArchivesRequest

@typing.final
class ListArchivesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ARCHIVES_FIELD_NUMBER: builtins.int
    @property
    def archives(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.backup.v1.backup_pb2.Archive]: ...
    def __init__(
        self,
        *,
        archives: collections.abc.Iterable[yandex.cloud.backup.v1.backup_pb2.Archive] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["archives", b"archives"]) -> None: ...

global___ListArchivesResponse = ListArchivesResponse

@typing.final
class ListBackupsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class ArchiveParameters(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ARCHIVE_ID_FIELD_NUMBER: builtins.int
        FOLDER_ID_FIELD_NUMBER: builtins.int
        archive_id: builtins.str
        """Archive ID."""
        folder_id: builtins.str
        """Folder ID."""
        def __init__(
            self,
            *,
            archive_id: builtins.str = ...,
            folder_id: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["archive_id", b"archive_id", "folder_id", b"folder_id"]) -> None: ...

    @typing.final
    class InstancePolicy(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        COMPUTE_INSTANCE_ID_FIELD_NUMBER: builtins.int
        POLICY_ID_FIELD_NUMBER: builtins.int
        compute_instance_id: builtins.str
        """Compute Cloud instance ID."""
        policy_id: builtins.str
        """Policy ID."""
        def __init__(
            self,
            *,
            compute_instance_id: builtins.str = ...,
            policy_id: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["compute_instance_id", b"compute_instance_id", "policy_id", b"policy_id"]) -> None: ...

    @typing.final
    class BackupParameters(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        BACKUP_ID_FIELD_NUMBER: builtins.int
        FOLDER_ID_FIELD_NUMBER: builtins.int
        backup_id: builtins.str
        folder_id: builtins.str
        def __init__(
            self,
            *,
            backup_id: builtins.str = ...,
            folder_id: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["backup_id", b"backup_id", "folder_id", b"folder_id"]) -> None: ...

    COMPUTE_INSTANCE_ID_FIELD_NUMBER: builtins.int
    ARCHIVE_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    INSTANCE_POLICY_FIELD_NUMBER: builtins.int
    RESOURCE_ID_FIELD_NUMBER: builtins.int
    POLICY_ID_FIELD_NUMBER: builtins.int
    BACKUP_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    compute_instance_id: builtins.str
    """List backups that belongs to specific Compute Cloud instance."""
    folder_id: builtins.str
    """List backups that belongs to specific folder."""
    resource_id: builtins.str
    """List backups by specific resource ID."""
    policy_id: builtins.str
    """List backups by specific policy ID."""
    order_by: builtins.str
    """By which column the listing should be ordered and in which direction,
    format is "createdAt desc". "createdAt desc" if omitted.
    """
    filter: builtins.str
    """Filter list by various parameters.
    Supported parameters are:
    * created_at

    Supported logic operators:
    * AND
    """
    type: yandex.cloud.backup.v1.resource_pb2.ResourceType.ValueType
    """Type of resource. Could be compute VM or baremetal server."""
    page_size: builtins.int
    """Number of results per page."""
    page_token: builtins.str
    """Token for the results page. Not allowed to use if listing is performed by specific policy ID."""
    @property
    def archive(self) -> global___ListBackupsRequest.ArchiveParameters:
        """List backups that belongs to specific archive of specific folder."""

    @property
    def instance_policy(self) -> global___ListBackupsRequest.InstancePolicy:
        """List backups that belongs to specific instance and policy at the same time."""

    @property
    def backup(self) -> global___ListBackupsRequest.BackupParameters:
        """List backups by specific backup ID."""

    def __init__(
        self,
        *,
        compute_instance_id: builtins.str = ...,
        archive: global___ListBackupsRequest.ArchiveParameters | None = ...,
        folder_id: builtins.str = ...,
        instance_policy: global___ListBackupsRequest.InstancePolicy | None = ...,
        resource_id: builtins.str = ...,
        policy_id: builtins.str = ...,
        backup: global___ListBackupsRequest.BackupParameters | None = ...,
        order_by: builtins.str = ...,
        filter: builtins.str = ...,
        type: yandex.cloud.backup.v1.resource_pb2.ResourceType.ValueType = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["archive", b"archive", "backup", b"backup", "compute_instance_id", b"compute_instance_id", "folder_id", b"folder_id", "id", b"id", "instance_policy", b"instance_policy", "policy_id", b"policy_id", "resource_id", b"resource_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["archive", b"archive", "backup", b"backup", "compute_instance_id", b"compute_instance_id", "filter", b"filter", "folder_id", b"folder_id", "id", b"id", "instance_policy", b"instance_policy", "order_by", b"order_by", "page_size", b"page_size", "page_token", b"page_token", "policy_id", b"policy_id", "resource_id", b"resource_id", "type", b"type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["id", b"id"]) -> typing.Literal["compute_instance_id", "archive", "folder_id", "instance_policy", "resource_id", "policy_id", "backup"] | None: ...

global___ListBackupsRequest = ListBackupsRequest

@typing.final
class ListBackupsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BACKUPS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for the next results page."""
    @property
    def backups(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.backup.v1.backup_pb2.Backup]: ...
    def __init__(
        self,
        *,
        backups: collections.abc.Iterable[yandex.cloud.backup.v1.backup_pb2.Backup] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["backups", b"backups", "next_page_token", b"next_page_token"]) -> None: ...

global___ListBackupsResponse = ListBackupsResponse

@typing.final
class ListFilesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    BACKUP_ID_FIELD_NUMBER: builtins.int
    SOURCE_ID_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """Folder ID."""
    backup_id: builtins.str
    """Backup ID."""
    source_id: builtins.str
    """Empty source will list disks of the backup."""
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        backup_id: builtins.str = ...,
        source_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["backup_id", b"backup_id", "folder_id", b"folder_id", "source_id", b"source_id"]) -> None: ...

global___ListFilesRequest = ListFilesRequest

@typing.final
class ListFilesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILES_FIELD_NUMBER: builtins.int
    @property
    def files(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.backup.v1.backup_pb2.BackupFile]: ...
    def __init__(
        self,
        *,
        files: collections.abc.Iterable[yandex.cloud.backup.v1.backup_pb2.BackupFile] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["files", b"files"]) -> None: ...

global___ListFilesResponse = ListFilesResponse

@typing.final
class GetBackupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BACKUP_ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    backup_id: builtins.str
    """Backup ID."""
    folder_id: builtins.str
    """Folder ID."""
    def __init__(
        self,
        *,
        backup_id: builtins.str = ...,
        folder_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["backup_id", b"backup_id", "folder_id", b"folder_id"]) -> None: ...

global___GetBackupRequest = GetBackupRequest

@typing.final
class StartRecoveryRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMPUTE_INSTANCE_ID_FIELD_NUMBER: builtins.int
    BACKUP_ID_FIELD_NUMBER: builtins.int
    compute_instance_id: builtins.str
    """Destination Compute Cloud instance ID to which backup should be applied."""
    backup_id: builtins.str
    """Backup ID that will be applied to destination Compute Cloud instance."""
    def __init__(
        self,
        *,
        compute_instance_id: builtins.str = ...,
        backup_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["backup_id", b"backup_id", "compute_instance_id", b"compute_instance_id"]) -> None: ...

global___StartRecoveryRequest = StartRecoveryRequest

@typing.final
class StartRecoveryMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROGRESS_PERCENTAGE_FIELD_NUMBER: builtins.int
    SRC_BACKUP_ID_FIELD_NUMBER: builtins.int
    DST_COMPUTE_INSTANCE_ID_FIELD_NUMBER: builtins.int
    progress_percentage: builtins.float
    """Progress of the backup process."""
    src_backup_id: builtins.str
    """Source Backup ID that will be applied."""
    dst_compute_instance_id: builtins.str
    """Destination Compute Cloud instance ID to which backup will be applied."""
    def __init__(
        self,
        *,
        progress_percentage: builtins.float = ...,
        src_backup_id: builtins.str = ...,
        dst_compute_instance_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["dst_compute_instance_id", b"dst_compute_instance_id", "progress_percentage", b"progress_percentage", "src_backup_id", b"src_backup_id"]) -> None: ...

global___StartRecoveryMetadata = StartRecoveryMetadata

@typing.final
class TargetPathOriginal(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___TargetPathOriginal = TargetPathOriginal

@typing.final
class TargetPathCustom(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PATH_FIELD_NUMBER: builtins.int
    path: builtins.str
    """Custom folder for file recovery."""
    def __init__(
        self,
        *,
        path: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["path", b"path"]) -> None: ...

global___TargetPathCustom = TargetPathCustom

@typing.final
class FilesRecoveryOptions(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Overwrite:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _OverwriteEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[FilesRecoveryOptions._Overwrite.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        OVERWRITE_UNSPECIFIED: FilesRecoveryOptions._Overwrite.ValueType  # 0
        """Unspecified value treated as Overwrite all"""
        OVERWRITE_ALL: FilesRecoveryOptions._Overwrite.ValueType  # 1
        """All overwrites all existing files by recovered ones."""
        OVERWRITE_OLDER: FilesRecoveryOptions._Overwrite.ValueType  # 2
        """Older overwrites older files only."""
        OVERWRITE_NONE: FilesRecoveryOptions._Overwrite.ValueType  # 3
        """None does not overwrites files at all."""

    class Overwrite(_Overwrite, metaclass=_OverwriteEnumTypeWrapper): ...
    OVERWRITE_UNSPECIFIED: FilesRecoveryOptions.Overwrite.ValueType  # 0
    """Unspecified value treated as Overwrite all"""
    OVERWRITE_ALL: FilesRecoveryOptions.Overwrite.ValueType  # 1
    """All overwrites all existing files by recovered ones."""
    OVERWRITE_OLDER: FilesRecoveryOptions.Overwrite.ValueType  # 2
    """Older overwrites older files only."""
    OVERWRITE_NONE: FilesRecoveryOptions.Overwrite.ValueType  # 3
    """None does not overwrites files at all."""

    OVERWRITE_FIELD_NUMBER: builtins.int
    REBOOT_IF_NEEDED_FIELD_NUMBER: builtins.int
    ORIGINAL_FIELD_NUMBER: builtins.int
    CUSTOM_FIELD_NUMBER: builtins.int
    overwrite: global___FilesRecoveryOptions.Overwrite.ValueType
    """Overwrite options declares the behavior for files that already exists on the file system."""
    reboot_if_needed: builtins.bool
    """specifies whether the recovery plan is able to reboot host if needed."""
    @property
    def original(self) -> global___TargetPathOriginal:
        """Keep original paths of files."""

    @property
    def custom(self) -> global___TargetPathCustom:
        """Set custom folder for file recovery."""

    def __init__(
        self,
        *,
        overwrite: global___FilesRecoveryOptions.Overwrite.ValueType = ...,
        reboot_if_needed: builtins.bool = ...,
        original: global___TargetPathOriginal | None = ...,
        custom: global___TargetPathCustom | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["custom", b"custom", "original", b"original", "type", b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["custom", b"custom", "original", b"original", "overwrite", b"overwrite", "reboot_if_needed", b"reboot_if_needed", "type", b"type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["type", b"type"]) -> typing.Literal["original", "custom"] | None: ...

global___FilesRecoveryOptions = FilesRecoveryOptions

@typing.final
class StartFilesRecoveryRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMPUTE_INSTANCE_ID_FIELD_NUMBER: builtins.int
    BACKUP_ID_FIELD_NUMBER: builtins.int
    OPTS_FIELD_NUMBER: builtins.int
    SOURCE_IDS_FIELD_NUMBER: builtins.int
    compute_instance_id: builtins.str
    """Destination instance ID."""
    backup_id: builtins.str
    """Backup ID."""
    @property
    def opts(self) -> global___FilesRecoveryOptions: ...
    @property
    def source_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        compute_instance_id: builtins.str = ...,
        backup_id: builtins.str = ...,
        opts: global___FilesRecoveryOptions | None = ...,
        source_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["opts", b"opts"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["backup_id", b"backup_id", "compute_instance_id", b"compute_instance_id", "opts", b"opts", "source_ids", b"source_ids"]) -> None: ...

global___StartFilesRecoveryRequest = StartFilesRecoveryRequest

@typing.final
class StartFilesRecoveryMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROGRESS_PERCENTAGE_FIELD_NUMBER: builtins.int
    COMPUTE_INSTANCE_ID_FIELD_NUMBER: builtins.int
    BACKUP_ID_FIELD_NUMBER: builtins.int
    SOURCE_IDS_FIELD_NUMBER: builtins.int
    progress_percentage: builtins.float
    compute_instance_id: builtins.str
    """Destination instance ID."""
    backup_id: builtins.str
    """Backup ID."""
    @property
    def source_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        progress_percentage: builtins.float = ...,
        compute_instance_id: builtins.str = ...,
        backup_id: builtins.str = ...,
        source_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["backup_id", b"backup_id", "compute_instance_id", b"compute_instance_id", "progress_percentage", b"progress_percentage", "source_ids", b"source_ids"]) -> None: ...

global___StartFilesRecoveryMetadata = StartFilesRecoveryMetadata

@typing.final
class DeleteBackupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMPUTE_INSTANCE_ID_FIELD_NUMBER: builtins.int
    BACKUP_ID_FIELD_NUMBER: builtins.int
    compute_instance_id: builtins.str
    """Compute Cloud instance ID of the Backup."""
    backup_id: builtins.str
    """Backup ID that should be deleted."""
    def __init__(
        self,
        *,
        compute_instance_id: builtins.str = ...,
        backup_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["backup_id", b"backup_id", "compute_instance_id", b"compute_instance_id"]) -> None: ...

global___DeleteBackupRequest = DeleteBackupRequest

@typing.final
class DeleteBackupMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMPUTE_INSTANCE_ID_FIELD_NUMBER: builtins.int
    BACKUP_ID_FIELD_NUMBER: builtins.int
    compute_instance_id: builtins.str
    """Compute Cloud instance ID of the Backup."""
    backup_id: builtins.str
    """Backup ID that should be deleted."""
    def __init__(
        self,
        *,
        compute_instance_id: builtins.str = ...,
        backup_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["backup_id", b"backup_id", "compute_instance_id", b"compute_instance_id"]) -> None: ...

global___DeleteBackupMetadata = DeleteBackupMetadata

@typing.final
class DeleteArchiveRequest(google.protobuf.message.Message):
    """must be specified archive_id and folder/instance_id
    or pair of policy id and instance_id
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ARCHIVE_ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    INSTANCE_ID_FIELD_NUMBER: builtins.int
    POLICY_ID_FIELD_NUMBER: builtins.int
    archive_id: builtins.str
    """Archive ID that should be deleted."""
    folder_id: builtins.str
    """Folder ID of the archive to delete."""
    instance_id: builtins.str
    """Instance ID of the Archive."""
    policy_id: builtins.str
    """Policy ID of the Archive."""
    def __init__(
        self,
        *,
        archive_id: builtins.str = ...,
        folder_id: builtins.str = ...,
        instance_id: builtins.str = ...,
        policy_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["archive_id", b"archive_id", "folder_id", b"folder_id", "instance_id", b"instance_id", "policy_id", b"policy_id"]) -> None: ...

global___DeleteArchiveRequest = DeleteArchiveRequest

@typing.final
class DeleteArchiveMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ARCHIVE_ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    archive_id: builtins.str
    """Archive ID that should be deleted."""
    folder_id: builtins.str
    """Folder ID of the archive."""
    def __init__(
        self,
        *,
        archive_id: builtins.str = ...,
        folder_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["archive_id", b"archive_id", "folder_id", b"folder_id"]) -> None: ...

global___DeleteArchiveMetadata = DeleteArchiveMetadata
