"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import google.protobuf.descriptor
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _ResourceType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ResourceTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ResourceType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    RESOURCE_TYPE_UNSPECIFIED: _ResourceType.ValueType  # 0
    COMPUTE: _ResourceType.ValueType  # 1
    """Resource is Compute Cloud VM"""
    BMS: _ResourceType.ValueType  # 2
    """Resource is baremetal server"""
    EXTERNAL_VM: _ResourceType.ValueType  # 3
    """Resource is VM"""
    EXTERNAL_SERVER: _ResourceType.ValueType  # 4
    """Resource is server"""

class ResourceType(_ResourceType, metaclass=_ResourceTypeEnumTypeWrapper): ...

RESOURCE_TYPE_UNSPECIFIED: ResourceType.ValueType  # 0
COMPUTE: ResourceType.ValueType  # 1
"""Resource is Compute Cloud VM"""
BMS: ResourceType.ValueType  # 2
"""Resource is baremetal server"""
EXTERNAL_VM: ResourceType.ValueType  # 3
"""Resource is VM"""
EXTERNAL_SERVER: ResourceType.ValueType  # 4
"""Resource is server"""
global___ResourceType = ResourceType

@typing.final
class TenantInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PERSONAL_TENANT_ID_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """Folder ID"""
    personal_tenant_id: builtins.str
    """Personal tenant id from backup provider"""
    user_id: builtins.str
    """User id from provider"""
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        personal_tenant_id: builtins.str = ...,
        user_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["folder_id", b"folder_id", "personal_tenant_id", b"personal_tenant_id", "user_id", b"user_id"]) -> None: ...

global___TenantInfo = TenantInfo

@typing.final
class AgentInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CURRENT_VERSION_FIELD_NUMBER: builtins.int
    LATEST_VERSION_FIELD_NUMBER: builtins.int
    CAN_UPDATE_FIELD_NUMBER: builtins.int
    current_version: builtins.str
    latest_version: builtins.str
    can_update: builtins.bool
    def __init__(
        self,
        *,
        current_version: builtins.str = ...,
        latest_version: builtins.str = ...,
        can_update: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["can_update", b"can_update", "current_version", b"current_version", "latest_version", b"latest_version"]) -> None: ...

global___AgentInfo = AgentInfo

@typing.final
class Resource(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Resource._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: Resource._Status.ValueType  # 0
        IDLE: Resource._Status.ValueType  # 1
        """Compute Cloud instance is doing nothing right now."""
        BACKUPING: Resource._Status.ValueType  # 2
        """Compute Cloud instance is currently backing up itself."""
        RECOVERING: Resource._Status.ValueType  # 3
        """Compute Cloud instance is currently recovering itself."""
        FAILED: Resource._Status.ValueType  # 4
        """Compute Cloud instance is in failure state, check content of
        `status_details` field for more information.
        """
        OTHER: Resource._Status.ValueType  # 5
        """Unspecified state, check `status_details` field
        for more information.
        """

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNSPECIFIED: Resource.Status.ValueType  # 0
    IDLE: Resource.Status.ValueType  # 1
    """Compute Cloud instance is doing nothing right now."""
    BACKUPING: Resource.Status.ValueType  # 2
    """Compute Cloud instance is currently backing up itself."""
    RECOVERING: Resource.Status.ValueType  # 3
    """Compute Cloud instance is currently recovering itself."""
    FAILED: Resource.Status.ValueType  # 4
    """Compute Cloud instance is in failure state, check content of
    `status_details` field for more information.
    """
    OTHER: Resource.Status.ValueType  # 5
    """Unspecified state, check `status_details` field
    for more information.
    """

    class _InitStatus:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _InitStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Resource._InitStatus.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        INIT_STATUS_UNSPECIFIED: Resource._InitStatus.ValueType  # 0
        REGISTERING: Resource._InitStatus.ValueType  # 1
        """Registration of instance in cloud backups have started."""
        REGISTRED: Resource._InitStatus.ValueType  # 2
        """Instance is registered in cloud backups."""
        FAILED_REGISTRATION: Resource._InitStatus.ValueType  # 3
        """Instance registration failed."""
        DELETED: Resource._InitStatus.ValueType  # 4
        """Instance is deleted from cloud backup service."""

    class InitStatus(_InitStatus, metaclass=_InitStatusEnumTypeWrapper): ...
    INIT_STATUS_UNSPECIFIED: Resource.InitStatus.ValueType  # 0
    REGISTERING: Resource.InitStatus.ValueType  # 1
    """Registration of instance in cloud backups have started."""
    REGISTRED: Resource.InitStatus.ValueType  # 2
    """Instance is registered in cloud backups."""
    FAILED_REGISTRATION: Resource.InitStatus.ValueType  # 3
    """Instance registration failed."""
    DELETED: Resource.InitStatus.ValueType  # 4
    """Instance is deleted from cloud backup service."""

    COMPUTE_INSTANCE_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    UPDATED_AT_FIELD_NUMBER: builtins.int
    ONLINE_FIELD_NUMBER: builtins.int
    ENABLED_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    STATUS_DETAILS_FIELD_NUMBER: builtins.int
    STATUS_PROGRESS_FIELD_NUMBER: builtins.int
    LAST_BACKUP_TIME_FIELD_NUMBER: builtins.int
    NEXT_BACKUP_TIME_FIELD_NUMBER: builtins.int
    RESOURCE_ID_FIELD_NUMBER: builtins.int
    IS_ACTIVE_FIELD_NUMBER: builtins.int
    INIT_STATUS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    TENANT_INFO_FIELD_NUMBER: builtins.int
    AGENT_INFO_FIELD_NUMBER: builtins.int
    compute_instance_id: builtins.str
    """Compute Cloud instance ID."""
    online: builtins.bool
    """If this field is true, it means that instance is online."""
    enabled: builtins.bool
    """If this field is true, it means that backup is enabled to instance."""
    status: global___Resource.Status.ValueType
    status_details: builtins.str
    """If status value is one of `OTHER` or `FAILED`,
    detailed info might be stored here.
    """
    status_progress: builtins.int
    """In case status is one of `BACKUPING` or `RECOVERING`,
    progress value might be found here.
    """
    resource_id: builtins.str
    """Resource ID is used to identify Compute Cloud instance in backup service."""
    is_active: builtins.bool
    """Status `is_active` shows whether current Compute Cloud instance controls Cloud Backup resource.
    If status `is_active` is false it means Compute Cloud instance is not able to manipulate
    Cloud Backup resource.
    """
    init_status: global___Resource.InitStatus.ValueType
    """Status of resource initialization in cloud backup service."""
    metadata: builtins.str
    """Metadata to provide details about instance registration process
    if status is FAILED_REGISTRATION or REGISTERING
    """
    type: global___ResourceType.ValueType
    """Type of resource. Could be compute VM or baremetal server."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def updated_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def last_backup_time(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def next_backup_time(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def tenant_info(self) -> global___TenantInfo:
        """Additional info about tenant which resource belongs to"""

    @property
    def agent_info(self) -> global___AgentInfo:
        """Additional Info about agent version"""

    def __init__(
        self,
        *,
        compute_instance_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        updated_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        online: builtins.bool = ...,
        enabled: builtins.bool = ...,
        status: global___Resource.Status.ValueType = ...,
        status_details: builtins.str = ...,
        status_progress: builtins.int = ...,
        last_backup_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        next_backup_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        resource_id: builtins.str = ...,
        is_active: builtins.bool = ...,
        init_status: global___Resource.InitStatus.ValueType = ...,
        metadata: builtins.str = ...,
        type: global___ResourceType.ValueType = ...,
        tenant_info: global___TenantInfo | None = ...,
        agent_info: global___AgentInfo | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["agent_info", b"agent_info", "created_at", b"created_at", "last_backup_time", b"last_backup_time", "next_backup_time", b"next_backup_time", "tenant_info", b"tenant_info", "updated_at", b"updated_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["agent_info", b"agent_info", "compute_instance_id", b"compute_instance_id", "created_at", b"created_at", "enabled", b"enabled", "init_status", b"init_status", "is_active", b"is_active", "last_backup_time", b"last_backup_time", "metadata", b"metadata", "next_backup_time", b"next_backup_time", "online", b"online", "resource_id", b"resource_id", "status", b"status", "status_details", b"status_details", "status_progress", b"status_progress", "tenant_info", b"tenant_info", "type", b"type", "updated_at", b"updated_at"]) -> None: ...

global___Resource = Resource

@typing.final
class Progress(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CURRENT_FIELD_NUMBER: builtins.int
    TOTAL_FIELD_NUMBER: builtins.int
    current: builtins.int
    total: builtins.int
    def __init__(
        self,
        *,
        current: builtins.int = ...,
        total: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["current", b"current", "total", b"total"]) -> None: ...

global___Progress = Progress

@typing.final
class Task(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Type:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Task._Type.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TYPE_UNSPECIFIED: Task._Type.ValueType  # 0
        BACKUP: Task._Type.ValueType  # 1
        RETENTION: Task._Type.ValueType  # 2
        RECOVERY: Task._Type.ValueType  # 3
        APPLY_POLICY: Task._Type.ValueType  # 4
        REVOKE_POLICY: Task._Type.ValueType  # 5

    class Type(_Type, metaclass=_TypeEnumTypeWrapper): ...
    TYPE_UNSPECIFIED: Task.Type.ValueType  # 0
    BACKUP: Task.Type.ValueType  # 1
    RETENTION: Task.Type.ValueType  # 2
    RECOVERY: Task.Type.ValueType  # 3
    APPLY_POLICY: Task.Type.ValueType  # 4
    REVOKE_POLICY: Task.Type.ValueType  # 5

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Task._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: Task._Status.ValueType  # 0
        ENQUEUED: Task._Status.ValueType  # 1
        ASSIGNED: Task._Status.ValueType  # 2
        STARTED: Task._Status.ValueType  # 3
        PAUSED: Task._Status.ValueType  # 4
        COMPLETED: Task._Status.ValueType  # 5

    class Status(_Status, metaclass=_StatusEnumTypeWrapper):
        """Status of task."""

    STATUS_UNSPECIFIED: Task.Status.ValueType  # 0
    ENQUEUED: Task.Status.ValueType  # 1
    ASSIGNED: Task.Status.ValueType  # 2
    STARTED: Task.Status.ValueType  # 3
    PAUSED: Task.Status.ValueType  # 4
    COMPLETED: Task.Status.ValueType  # 5

    class _Code:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _CodeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Task._Code.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        CODE_UNSPECIFIED: Task._Code.ValueType  # 0
        OK: Task._Code.ValueType  # 1
        ERROR: Task._Code.ValueType  # 2
        WARNING: Task._Code.ValueType  # 3
        CANCELLED: Task._Code.ValueType  # 4
        ABANDONED: Task._Code.ValueType  # 5
        TIMEDOUT: Task._Code.ValueType  # 6

    class Code(_Code, metaclass=_CodeEnumTypeWrapper):
        """Result code of task"""

    CODE_UNSPECIFIED: Task.Code.ValueType  # 0
    OK: Task.Code.ValueType  # 1
    ERROR: Task.Code.ValueType  # 2
    WARNING: Task.Code.ValueType  # 3
    CANCELLED: Task.Code.ValueType  # 4
    ABANDONED: Task.Code.ValueType  # 5
    TIMEDOUT: Task.Code.ValueType  # 6

    ID_FIELD_NUMBER: builtins.int
    CANCELLABLE_FIELD_NUMBER: builtins.int
    POLICY_ID_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    PROGRESS_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    ENQUEUED_AT_FIELD_NUMBER: builtins.int
    STARTED_AT_FIELD_NUMBER: builtins.int
    UPDATED_AT_FIELD_NUMBER: builtins.int
    COMPLETED_AT_FIELD_NUMBER: builtins.int
    COMPUTE_INSTANCE_ID_FIELD_NUMBER: builtins.int
    RESULT_CODE_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    id: builtins.int
    """Task ID."""
    cancellable: builtins.bool
    """Shows whether the task is cancellable.
    Note: task cancellation is not supported yet.
    """
    policy_id: builtins.str
    """Policy ID."""
    type: global___Task.Type.ValueType
    """Type of the task."""
    status: global___Task.Status.ValueType
    """Task status."""
    compute_instance_id: builtins.str
    """Compute Cloud instance ID."""
    result_code: global___Task.Code.ValueType
    """Task result code."""
    error: builtins.str
    """Task error message if task finished with not OK code"""
    @property
    def progress(self) -> global___Progress:
        """Task progress."""

    @property
    def enqueued_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def started_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def updated_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def completed_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    def __init__(
        self,
        *,
        id: builtins.int = ...,
        cancellable: builtins.bool = ...,
        policy_id: builtins.str = ...,
        type: global___Task.Type.ValueType = ...,
        progress: global___Progress | None = ...,
        status: global___Task.Status.ValueType = ...,
        enqueued_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        started_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        updated_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        completed_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        compute_instance_id: builtins.str = ...,
        result_code: global___Task.Code.ValueType = ...,
        error: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["completed_at", b"completed_at", "enqueued_at", b"enqueued_at", "progress", b"progress", "started_at", b"started_at", "updated_at", b"updated_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cancellable", b"cancellable", "completed_at", b"completed_at", "compute_instance_id", b"compute_instance_id", "enqueued_at", b"enqueued_at", "error", b"error", "id", b"id", "policy_id", b"policy_id", "progress", b"progress", "result_code", b"result_code", "started_at", b"started_at", "status", b"status", "type", b"type", "updated_at", b"updated_at"]) -> None: ...

global___Task = Task
