"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import google.protobuf.descriptor
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class PrivateCloudConnection(google.protobuf.message.Message):
    """A Private cloud connection resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[PrivateCloudConnection._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: PrivateCloudConnection._Status.ValueType  # 0
        """Unspecified private cloud connection status."""
        CREATING: PrivateCloudConnection._Status.ValueType  # 1
        """Private cloud connection is waiting for network resources to be allocated."""
        READY: PrivateCloudConnection._Status.ValueType  # 2
        """Private cloud connection is ready to use."""
        ERROR: PrivateCloudConnection._Status.ValueType  # 3
        """Private cloud connection encountered a problem and cannot operate."""
        DELETING: PrivateCloudConnection._Status.ValueType  # 4
        """Private cloud connection is being deleted."""
        UPDATING: PrivateCloudConnection._Status.ValueType  # 5
        """Private cloud connection is being updated."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper):
        """Private cloud connection status."""

    STATUS_UNSPECIFIED: PrivateCloudConnection.Status.ValueType  # 0
    """Unspecified private cloud connection status."""
    CREATING: PrivateCloudConnection.Status.ValueType  # 1
    """Private cloud connection is waiting for network resources to be allocated."""
    READY: PrivateCloudConnection.Status.ValueType  # 2
    """Private cloud connection is ready to use."""
    ERROR: PrivateCloudConnection.Status.ValueType  # 3
    """Private cloud connection encountered a problem and cannot operate."""
    DELETING: PrivateCloudConnection.Status.ValueType  # 4
    """Private cloud connection is being deleted."""
    UPDATING: PrivateCloudConnection.Status.ValueType  # 5
    """Private cloud connection is being updated."""

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    CLOUD_ID_FIELD_NUMBER: builtins.int
    ROUTING_INSTANCE_ID_FIELD_NUMBER: builtins.int
    VRF_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the private cloud connection."""
    folder_id: builtins.str
    """ID of the folder that the private cloud connection belongs to."""
    cloud_id: builtins.str
    """ID of the cloud that the private cloud connection belongs to."""
    routing_instance_id: builtins.str
    """ID of Cloud Router Routing Instance."""
    vrf_id: builtins.str
    """ID of VRF that is connected to routing Instance."""
    status: global___PrivateCloudConnection.Status.ValueType
    """Status of the private cloud connection."""
    name: builtins.str
    """Name of the private cloud connection."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        cloud_id: builtins.str = ...,
        routing_instance_id: builtins.str = ...,
        vrf_id: builtins.str = ...,
        status: global___PrivateCloudConnection.Status.ValueType = ...,
        name: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cloud_id", b"cloud_id", "created_at", b"created_at", "folder_id", b"folder_id", "id", b"id", "name", b"name", "routing_instance_id", b"routing_instance_id", "status", b"status", "vrf_id", b"vrf_id"]) -> None: ...

global___PrivateCloudConnection = PrivateCloudConnection
