"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing
import yandex.cloud.baremetal.v1alpha.dhcp_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class PrivateSubnet(google.protobuf.message.Message):
    """A PrivateSubnet resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[PrivateSubnet._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: PrivateSubnet._Status.ValueType  # 0
        """Unspecified private subnet status."""
        CREATING: PrivateSubnet._Status.ValueType  # 1
        """Private subnet is being created."""
        READY: PrivateSubnet._Status.ValueType  # 2
        """Private subnet is ready to use."""
        UPDATING: PrivateSubnet._Status.ValueType  # 3
        """Private subnet is being updated."""
        DELETING: PrivateSubnet._Status.ValueType  # 4
        """Private subnet is being deleted."""
        ERROR: PrivateSubnet._Status.ValueType  # 5
        """Private subnet encountered a problem and cannot operate."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper):
        """Private subnet status."""

    STATUS_UNSPECIFIED: PrivateSubnet.Status.ValueType  # 0
    """Unspecified private subnet status."""
    CREATING: PrivateSubnet.Status.ValueType  # 1
    """Private subnet is being created."""
    READY: PrivateSubnet.Status.ValueType  # 2
    """Private subnet is ready to use."""
    UPDATING: PrivateSubnet.Status.ValueType  # 3
    """Private subnet is being updated."""
    DELETING: PrivateSubnet.Status.ValueType  # 4
    """Private subnet is being deleted."""
    ERROR: PrivateSubnet.Status.ValueType  # 5
    """Private subnet encountered a problem and cannot operate."""

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing.final
    class VrfOptions(google.protobuf.message.Message):
        """VRF options for the private subnet."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        VRF_ID_FIELD_NUMBER: builtins.int
        CIDR_FIELD_NUMBER: builtins.int
        DHCP_OPTIONS_FIELD_NUMBER: builtins.int
        GATEWAY_IP_FIELD_NUMBER: builtins.int
        vrf_id: builtins.str
        """ID of the VRF."""
        cidr: builtins.str
        """CIDR block for the subnet."""
        gateway_ip: builtins.str
        """Gateway IP address for the subnet."""
        @property
        def dhcp_options(self) -> yandex.cloud.baremetal.v1alpha.dhcp_pb2.DhcpOptions:
            """DHCP options for the subnet."""

        def __init__(
            self,
            *,
            vrf_id: builtins.str = ...,
            cidr: builtins.str = ...,
            dhcp_options: yandex.cloud.baremetal.v1alpha.dhcp_pb2.DhcpOptions | None = ...,
            gateway_ip: builtins.str = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["dhcp_options", b"dhcp_options"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["cidr", b"cidr", "dhcp_options", b"dhcp_options", "gateway_ip", b"gateway_ip", "vrf_id", b"vrf_id"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    CLOUD_ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    ZONE_ID_FIELD_NUMBER: builtins.int
    HARDWARE_POOL_ID_FIELD_NUMBER: builtins.int
    VRF_OPTIONS_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the private subnet."""
    cloud_id: builtins.str
    """ID of the cloud that the private subnet belongs to."""
    folder_id: builtins.str
    """ID of the folder that the private subnet belongs to."""
    name: builtins.str
    """Name of the private subnet.
    The name is unique within the folder.
    """
    description: builtins.str
    """Optional description of the private subnet."""
    status: global___PrivateSubnet.Status.ValueType
    """Status of the private subnet."""
    zone_id: builtins.str
    """ID of the availability zone where the server resides."""
    hardware_pool_id: builtins.str
    """ID of the hardware pool that the private subnet belongs to."""
    @property
    def vrf_options(self) -> global___PrivateSubnet.VrfOptions:
        """Optional VRF options for the private subnet. If missing, the private subnet will be unrouted,
        i.e. it will lack a DHCP server and routing capabilities between this subnet and other private
        subnets.
        """

    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `key:value` pairs."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        cloud_id: builtins.str = ...,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        status: global___PrivateSubnet.Status.ValueType = ...,
        zone_id: builtins.str = ...,
        hardware_pool_id: builtins.str = ...,
        vrf_options: global___PrivateSubnet.VrfOptions | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at", "vrf_options", b"vrf_options"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cloud_id", b"cloud_id", "created_at", b"created_at", "description", b"description", "folder_id", b"folder_id", "hardware_pool_id", b"hardware_pool_id", "id", b"id", "labels", b"labels", "name", b"name", "status", b"status", "vrf_options", b"vrf_options", "zone_id", b"zone_id"]) -> None: ...

global___PrivateSubnet = PrivateSubnet
