"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.baremetal.v1alpha.private_subnet_pb2
import yandex.cloud.operation.operation_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetPrivateSubnetRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PRIVATE_SUBNET_ID_FIELD_NUMBER: builtins.int
    private_subnet_id: builtins.str
    """ID of the PrivateSubnet resource to return.

    To get the private subnet ID use a [PrivateSubnetService.List] request.
    """
    def __init__(
        self,
        *,
        private_subnet_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["private_subnet_id", b"private_subnet_id"]) -> None: ...

global___GetPrivateSubnetRequest = GetPrivateSubnetRequest

@typing.final
class ListPrivateSubnetRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to list private subnets in.

    To get the folder ID use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is greater than `page_size`,
    the service returns a [ListConfigurationsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    Default value is 20.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set `page_token` to the
    [ListConfigurationsResponse.next_page_token] returned by a previous list request.
    """
    order_by: builtins.str
    """By which column the listing should be ordered and in which direction,
    format is "createdAt desc". "id asc" if omitted.
    Supported fields: ["id", "name", "createdAt"].
    Both snake_case and camelCase are supported for fields.
    """
    filter: builtins.str
    """A filter expression that filters resources listed in the response.
    The expression consists of one or more conditions united by `AND` operator: `<condition1> [AND <condition2> [<...> AND <conditionN>]]`.

    Each condition has the form `<field> <operator> <value>`, where:
    1. `<field>` is the field name. Currently you can use filtering only on the limited number of fields.
    2. `<operator>` is a logical operator, one of `=` (equal), `:` (substring).
    3. `<value>` represents a value.
    String values should be written in double (`"`) or single (`'`) quotes. C-style escape sequences are supported (`\\"` turns to `"`, `\\'` to `'`, `\\\\` to backslash).
    Example: "key1='value' AND key2='value'"
    Supported operators: ["AND"].
    Supported fields: ["id", "name", "zoneId", "hardwarePoolId"].
    Both snake_case and camelCase are supported for fields.
    """
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        order_by: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "folder_id", b"folder_id", "order_by", b"order_by", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListPrivateSubnetRequest = ListPrivateSubnetRequest

@typing.final
class ListPrivateSubnetResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PRIVATE_SUBNETS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    [ListImagesRequest.page_size], use `next_page_token` as the value
    for the [ListImagesRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `next_page_token` to continue paging through the results.
    """
    @property
    def private_subnets(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.baremetal.v1alpha.private_subnet_pb2.PrivateSubnet]:
        """List of PrivateSubnet resources."""

    def __init__(
        self,
        *,
        private_subnets: collections.abc.Iterable[yandex.cloud.baremetal.v1alpha.private_subnet_pb2.PrivateSubnet] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "private_subnets", b"private_subnets"]) -> None: ...

global___ListPrivateSubnetResponse = ListPrivateSubnetResponse

@typing.final
class CreatePrivateSubnetRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    HARDWARE_POOL_ID_FIELD_NUMBER: builtins.int
    VRF_OPTIONS_SPEC_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the private subnet.
    The name must be unique within the folder.
    """
    description: builtins.str
    """Description of the private subnet."""
    hardware_pool_id: builtins.str
    """ID of the hardware pool where the private subnet resides.

    To get a list of available hardware pools, use the [HardwarePoolService.List] request.
    """
    folder_id: builtins.str
    """ID of the folder to create a private subnet in.

    To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    @property
    def vrf_options_spec(self) -> global___VrfOptionsSpec:
        """VRF options. Optional."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `key:value` pairs."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        description: builtins.str = ...,
        hardware_pool_id: builtins.str = ...,
        vrf_options_spec: global___VrfOptionsSpec | None = ...,
        folder_id: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["vrf_options_spec", b"vrf_options_spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "folder_id", b"folder_id", "hardware_pool_id", b"hardware_pool_id", "labels", b"labels", "name", b"name", "vrf_options_spec", b"vrf_options_spec"]) -> None: ...

global___CreatePrivateSubnetRequest = CreatePrivateSubnetRequest

@typing.final
class VrfOptionsSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VRF_ID_FIELD_NUMBER: builtins.int
    CIDR_FIELD_NUMBER: builtins.int
    DHCP_OPTIONS_FIELD_NUMBER: builtins.int
    GATEWAY_IP_FIELD_NUMBER: builtins.int
    vrf_id: builtins.str
    """ID of the VRF to create private subnet in.

    To get the VRF ID, use a [VrfService.List] request.
    """
    cidr: builtins.str
    """CIDR block.
    The range of internal addresses that are defined for this private subnet, as
    specified in [RFC1918](https://datatracker.ietf.org/doc/html/rfc1918#section-3).
    For example, 10.0.0.0/22 or 192.168.0.0/24.
    """
    gateway_ip: builtins.str
    """Gateway IP address for the subnet."""
    @property
    def dhcp_options(self) -> global___DhcpOptionsSpec:
        """DHCP options for the subnet.
        The absence or null value indicates that DHCP is disabled.
        """

    def __init__(
        self,
        *,
        vrf_id: builtins.str = ...,
        cidr: builtins.str = ...,
        dhcp_options: global___DhcpOptionsSpec | None = ...,
        gateway_ip: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["dhcp_options", b"dhcp_options"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cidr", b"cidr", "dhcp_options", b"dhcp_options", "gateway_ip", b"gateway_ip", "vrf_id", b"vrf_id"]) -> None: ...

global___VrfOptionsSpec = VrfOptionsSpec

@typing.final
class DhcpOptionsSpec(google.protobuf.message.Message):
    """DHCP options for the private subnet."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    START_IP_FIELD_NUMBER: builtins.int
    END_IP_FIELD_NUMBER: builtins.int
    start_ip: builtins.str
    """Start IP address of the DHCP range (inclusive).
    The absence or null value indicates that calculation will be performed based on CIDR.
    """
    end_ip: builtins.str
    """End IP address of the DHCP range (inclusive).
    The absence or null value indicates that calculation will be performed based on CIDR.
    """
    def __init__(
        self,
        *,
        start_ip: builtins.str = ...,
        end_ip: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["end_ip", b"end_ip", "start_ip", b"start_ip"]) -> None: ...

global___DhcpOptionsSpec = DhcpOptionsSpec

@typing.final
class CreatePrivateSubnetMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PRIVATE_SUBNET_ID_FIELD_NUMBER: builtins.int
    private_subnet_id: builtins.str
    """ID of the private subnet that is being created."""
    def __init__(
        self,
        *,
        private_subnet_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["private_subnet_id", b"private_subnet_id"]) -> None: ...

global___CreatePrivateSubnetMetadata = CreatePrivateSubnetMetadata

@typing.final
class UpdatePrivateSubnetRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    PRIVATE_SUBNET_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    VRF_OPTIONS_SPEC_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    private_subnet_id: builtins.str
    """ID of the PrivateSubnet resource to update.

    To get the private subnet ID, use a [PrivateSubnetService.List] request.
    """
    name: builtins.str
    """Name of the private subnet.
    The name must be unique within the folder.
    """
    description: builtins.str
    """Description of the private subnet."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which fields of the PrivateSubnet resource are going to be updated."""

    @property
    def vrf_options_spec(self) -> global___VrfOptionsSpec:
        """VRF options. Optional."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `key:value` pairs.

        Existing set of `labels` is completely replaced by the provided set.
        """

    def __init__(
        self,
        *,
        private_subnet_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        vrf_options_spec: global___VrfOptionsSpec | None = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["update_mask", b"update_mask", "vrf_options_spec", b"vrf_options_spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "labels", b"labels", "name", b"name", "private_subnet_id", b"private_subnet_id", "update_mask", b"update_mask", "vrf_options_spec", b"vrf_options_spec"]) -> None: ...

global___UpdatePrivateSubnetRequest = UpdatePrivateSubnetRequest

@typing.final
class UpdatePrivateSubnetMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PRIVATE_SUBNET_ID_FIELD_NUMBER: builtins.int
    private_subnet_id: builtins.str
    """ID of the PrivateSubnet resource that is being updated."""
    def __init__(
        self,
        *,
        private_subnet_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["private_subnet_id", b"private_subnet_id"]) -> None: ...

global___UpdatePrivateSubnetMetadata = UpdatePrivateSubnetMetadata

@typing.final
class DeletePrivateSubnetRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PRIVATE_SUBNET_ID_FIELD_NUMBER: builtins.int
    private_subnet_id: builtins.str
    """ID of the private subnet to delete.

    To get the private subnet ID, use a [PrivateSubnetService.List] request.
    """
    def __init__(
        self,
        *,
        private_subnet_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["private_subnet_id", b"private_subnet_id"]) -> None: ...

global___DeletePrivateSubnetRequest = DeletePrivateSubnetRequest

@typing.final
class DeletePrivateSubnetMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PRIVATE_SUBNET_ID_FIELD_NUMBER: builtins.int
    private_subnet_id: builtins.str
    """ID of the PrivateSubnet resource that is being deleted."""
    def __init__(
        self,
        *,
        private_subnet_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["private_subnet_id", b"private_subnet_id"]) -> None: ...

global___DeletePrivateSubnetMetadata = DeletePrivateSubnetMetadata

@typing.final
class ListPrivateSubnetOperationsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PRIVATE_SUBNET_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    private_subnet_id: builtins.str
    """ID of the PrivateSubnet resource to list operations for."""
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is greater than `page_size`,
    the service returns a [ListImageOperationsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    Default value is 20.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set `page_token` to the
    [ListPrivateSubnetOperationsResponse.next_page_token] returned by a previous list request.
    """
    def __init__(
        self,
        *,
        private_subnet_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["page_size", b"page_size", "page_token", b"page_token", "private_subnet_id", b"private_subnet_id"]) -> None: ...

global___ListPrivateSubnetOperationsRequest = ListPrivateSubnetOperationsRequest

@typing.final
class ListPrivateSubnetOperationsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    [ListImageOperationsRequest.page_size], use `next_page_token` as the value
    for the [ListImageOperationsRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `next_page_token` to continue paging through the results.
    """
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.operation.operation_pb2.Operation]:
        """List of operations for the specified PrivateSubnet resource."""

    def __init__(
        self,
        *,
        operations: collections.abc.Iterable[yandex.cloud.operation.operation_pb2.Operation] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "operations", b"operations"]) -> None: ...

global___ListPrivateSubnetOperationsResponse = ListPrivateSubnetOperationsResponse
