"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing
import yandex.cloud.baremetal.v1alpha.disk_pb2
import yandex.cloud.baremetal.v1alpha.storage_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Server(google.protobuf.message.Message):
    """A Server resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Server._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: Server._Status.ValueType  # 0
        """Unspecified server status."""
        PROVISIONING: Server._Status.ValueType  # 1
        """Server is waiting for to be allocated from the hardware pool."""
        STOPPING: Server._Status.ValueType  # 3
        """Server is being stopped."""
        STOPPED: Server._Status.ValueType  # 4
        """Server has been stopped."""
        STARTING: Server._Status.ValueType  # 5
        """Server is being started."""
        RESTARTING: Server._Status.ValueType  # 6
        """Server is being restarted."""
        ERROR: Server._Status.ValueType  # 7
        """Server encountered a problem and cannot operate."""
        DELETING: Server._Status.ValueType  # 8
        """Server is being deleted."""
        REINSTALLING: Server._Status.ValueType  # 9
        """Server operating system is being reinstalled."""
        UPDATING: Server._Status.ValueType  # 10
        """Server is being updated."""
        QUARANTINED: Server._Status.ValueType  # 12
        """Server has been quarantined"""
        RUNNING: Server._Status.ValueType  # 14
        """Server is running normaly"""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper):
        """Server status."""

    STATUS_UNSPECIFIED: Server.Status.ValueType  # 0
    """Unspecified server status."""
    PROVISIONING: Server.Status.ValueType  # 1
    """Server is waiting for to be allocated from the hardware pool."""
    STOPPING: Server.Status.ValueType  # 3
    """Server is being stopped."""
    STOPPED: Server.Status.ValueType  # 4
    """Server has been stopped."""
    STARTING: Server.Status.ValueType  # 5
    """Server is being started."""
    RESTARTING: Server.Status.ValueType  # 6
    """Server is being restarted."""
    ERROR: Server.Status.ValueType  # 7
    """Server encountered a problem and cannot operate."""
    DELETING: Server.Status.ValueType  # 8
    """Server is being deleted."""
    REINSTALLING: Server.Status.ValueType  # 9
    """Server operating system is being reinstalled."""
    UPDATING: Server.Status.ValueType  # 10
    """Server is being updated."""
    QUARANTINED: Server.Status.ValueType  # 12
    """Server has been quarantined"""
    RUNNING: Server.Status.ValueType  # 14
    """Server is running normaly"""

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    CLOUD_ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    ZONE_ID_FIELD_NUMBER: builtins.int
    HARDWARE_POOL_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    OS_SETTINGS_FIELD_NUMBER: builtins.int
    NETWORK_INTERFACES_FIELD_NUMBER: builtins.int
    CONFIGURATION_ID_FIELD_NUMBER: builtins.int
    DISKS_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the server."""
    cloud_id: builtins.str
    """ID of the cloud that the server belongs to."""
    folder_id: builtins.str
    """ID of the folder that the server belongs to."""
    name: builtins.str
    """Name of the server.
    The name is unique within the folder.
    """
    description: builtins.str
    """Description of the server."""
    zone_id: builtins.str
    """ID of the availability zone where the server is resides."""
    hardware_pool_id: builtins.str
    """ID of the hardware pool that the server belongs to."""
    status: global___Server.Status.ValueType
    """Status of the server."""
    configuration_id: builtins.str
    """ID of the configuration that was used to create the server."""
    @property
    def os_settings(self) -> global___OsSettings:
        """Operating system specific settings of the server. Optional, will be empty if the server is
        provisioned without an operating system.
        """

    @property
    def network_interfaces(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___NetworkInterface]:
        """Array of network interfaces that are attached to the instance."""

    @property
    def disks(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.baremetal.v1alpha.disk_pb2.Disk]:
        """Array of disks that are attached to the server."""

    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `key:value` pairs."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        cloud_id: builtins.str = ...,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        zone_id: builtins.str = ...,
        hardware_pool_id: builtins.str = ...,
        status: global___Server.Status.ValueType = ...,
        os_settings: global___OsSettings | None = ...,
        network_interfaces: collections.abc.Iterable[global___NetworkInterface] | None = ...,
        configuration_id: builtins.str = ...,
        disks: collections.abc.Iterable[yandex.cloud.baremetal.v1alpha.disk_pb2.Disk] | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at", "os_settings", b"os_settings"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cloud_id", b"cloud_id", "configuration_id", b"configuration_id", "created_at", b"created_at", "description", b"description", "disks", b"disks", "folder_id", b"folder_id", "hardware_pool_id", b"hardware_pool_id", "id", b"id", "labels", b"labels", "name", b"name", "network_interfaces", b"network_interfaces", "os_settings", b"os_settings", "status", b"status", "zone_id", b"zone_id"]) -> None: ...

global___Server = Server

@typing.final
class NetworkInterface(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    MAC_ADDRESS_FIELD_NUMBER: builtins.int
    IP_ADDRESS_FIELD_NUMBER: builtins.int
    PRIVATE_SUBNET_FIELD_NUMBER: builtins.int
    PUBLIC_SUBNET_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the network interface."""
    mac_address: builtins.str
    """MAC address that is assigned to the network interface."""
    ip_address: builtins.str
    """IPv4 address that is assigned to the server for this network interface."""
    @property
    def private_subnet(self) -> global___PrivateSubnetNetworkInterface:
        """Private subnet."""

    @property
    def public_subnet(self) -> global___PublicSubnetNetworkInterface:
        """Public subnet."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        mac_address: builtins.str = ...,
        ip_address: builtins.str = ...,
        private_subnet: global___PrivateSubnetNetworkInterface | None = ...,
        public_subnet: global___PublicSubnetNetworkInterface | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["private_subnet", b"private_subnet", "public_subnet", b"public_subnet", "subnet", b"subnet"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["id", b"id", "ip_address", b"ip_address", "mac_address", b"mac_address", "private_subnet", b"private_subnet", "public_subnet", b"public_subnet", "subnet", b"subnet"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["subnet", b"subnet"]) -> typing.Literal["private_subnet", "public_subnet"] | None: ...

global___NetworkInterface = NetworkInterface

@typing.final
class PrivateSubnetNetworkInterface(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PRIVATE_SUBNET_ID_FIELD_NUMBER: builtins.int
    private_subnet_id: builtins.str
    """ID of the private subnet."""
    def __init__(
        self,
        *,
        private_subnet_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["private_subnet_id", b"private_subnet_id"]) -> None: ...

global___PrivateSubnetNetworkInterface = PrivateSubnetNetworkInterface

@typing.final
class PublicSubnetNetworkInterface(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PUBLIC_SUBNET_ID_FIELD_NUMBER: builtins.int
    public_subnet_id: builtins.str
    """ID of the public subnet.

    A new ephemeral public subnet will be created if not specified.
    """
    def __init__(
        self,
        *,
        public_subnet_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["public_subnet_id", b"public_subnet_id"]) -> None: ...

global___PublicSubnetNetworkInterface = PublicSubnetNetworkInterface

@typing.final
class OsSettings(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IMAGE_ID_FIELD_NUMBER: builtins.int
    SSH_PUBLIC_KEY_FIELD_NUMBER: builtins.int
    STORAGES_FIELD_NUMBER: builtins.int
    image_id: builtins.str
    """ID of the image that the server was created from."""
    ssh_public_key: builtins.str
    """Public SSH key of the server."""
    @property
    def storages(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.baremetal.v1alpha.storage_pb2.Storage]:
        """List of storages."""

    def __init__(
        self,
        *,
        image_id: builtins.str = ...,
        ssh_public_key: builtins.str = ...,
        storages: collections.abc.Iterable[yandex.cloud.baremetal.v1alpha.storage_pb2.Storage] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["image_id", b"image_id", "ssh_public_key", b"ssh_public_key", "storages", b"storages"]) -> None: ...

global___OsSettings = OsSettings
