"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing
import yandex.cloud.baremetal.v1alpha.disk_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _StoragePartitionType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _StoragePartitionTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_StoragePartitionType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    STORAGE_PARTITION_TYPE_UNSPECIFIED: _StoragePartitionType.ValueType  # 0
    """Unspecified storage partition type."""
    EXT4: _StoragePartitionType.ValueType  # 1
    """ext4 file system partition type."""
    SWAP: _StoragePartitionType.ValueType  # 2
    """Swap partition type."""
    EXT3: _StoragePartitionType.ValueType  # 3
    """ext3 file system partition type."""
    XFS: _StoragePartitionType.ValueType  # 4
    """XFS file system partition type."""

class StoragePartitionType(_StoragePartitionType, metaclass=_StoragePartitionTypeEnumTypeWrapper):
    """Storage partition type."""

STORAGE_PARTITION_TYPE_UNSPECIFIED: StoragePartitionType.ValueType  # 0
"""Unspecified storage partition type."""
EXT4: StoragePartitionType.ValueType  # 1
"""ext4 file system partition type."""
SWAP: StoragePartitionType.ValueType  # 2
"""Swap partition type."""
EXT3: StoragePartitionType.ValueType  # 3
"""ext3 file system partition type."""
XFS: StoragePartitionType.ValueType  # 4
"""XFS file system partition type."""
global___StoragePartitionType = StoragePartitionType

class _RaidType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _RaidTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_RaidType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    RAID_TYPE_UNSPECIFIED: _RaidType.ValueType  # 0
    """Unspecified RAID configuration."""
    RAID0: _RaidType.ValueType  # 1
    """RAID0 configuration."""
    RAID1: _RaidType.ValueType  # 2
    """RAID1 configuration."""
    RAID10: _RaidType.ValueType  # 3
    """RAID10 configuration."""

class RaidType(_RaidType, metaclass=_RaidTypeEnumTypeWrapper):
    """RaidType represents different RAID configurations."""

RAID_TYPE_UNSPECIFIED: RaidType.ValueType  # 0
"""Unspecified RAID configuration."""
RAID0: RaidType.ValueType  # 1
"""RAID0 configuration."""
RAID1: RaidType.ValueType  # 2
"""RAID1 configuration."""
RAID10: RaidType.ValueType  # 3
"""RAID10 configuration."""
global___RaidType = RaidType

@typing.final
class StoragePartition(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TYPE_FIELD_NUMBER: builtins.int
    SIZE_GIB_FIELD_NUMBER: builtins.int
    MOUNT_POINT_FIELD_NUMBER: builtins.int
    type: global___StoragePartitionType.ValueType
    """Partition type."""
    size_gib: builtins.int
    """Size of the storage partition in gibibytes (2^30 bytes)."""
    mount_point: builtins.str
    """Storage mount point."""
    def __init__(
        self,
        *,
        type: global___StoragePartitionType.ValueType = ...,
        size_gib: builtins.int = ...,
        mount_point: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["mount_point", b"mount_point", "size_gib", b"size_gib", "type", b"type"]) -> None: ...

global___StoragePartition = StoragePartition

@typing.final
class Storage(google.protobuf.message.Message):
    """Storage, a OS-level storage entity used for creating partitions. For example, this could
    represent a plain disk or a software RAID of disks.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARTITIONS_FIELD_NUMBER: builtins.int
    DISK_FIELD_NUMBER: builtins.int
    RAID_FIELD_NUMBER: builtins.int
    @property
    def partitions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___StoragePartition]:
        """Array of partitions created on the storage."""

    @property
    def disk(self) -> yandex.cloud.baremetal.v1alpha.disk_pb2.Disk:
        """Disk storage."""

    @property
    def raid(self) -> global___Raid:
        """RAID storage."""

    def __init__(
        self,
        *,
        partitions: collections.abc.Iterable[global___StoragePartition] | None = ...,
        disk: yandex.cloud.baremetal.v1alpha.disk_pb2.Disk | None = ...,
        raid: global___Raid | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["disk", b"disk", "raid", b"raid", "storage_type", b"storage_type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["disk", b"disk", "partitions", b"partitions", "raid", b"raid", "storage_type", b"storage_type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["storage_type", b"storage_type"]) -> typing.Literal["disk", "raid"] | None: ...

global___Storage = Storage

@typing.final
class Raid(google.protobuf.message.Message):
    """RAID storage."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TYPE_FIELD_NUMBER: builtins.int
    DISKS_FIELD_NUMBER: builtins.int
    type: global___RaidType.ValueType
    """RAID type."""
    @property
    def disks(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.baremetal.v1alpha.disk_pb2.Disk]:
        """Array of disks in the RAID configuration."""

    def __init__(
        self,
        *,
        type: global___RaidType.ValueType = ...,
        disks: collections.abc.Iterable[yandex.cloud.baremetal.v1alpha.disk_pb2.Disk] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["disks", b"disks", "type", b"type"]) -> None: ...

global___Raid = Raid
