"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.baremetal.v1alpha.vrf_pb2
import yandex.cloud.operation.operation_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetVrfRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VRF_ID_FIELD_NUMBER: builtins.int
    vrf_id: builtins.str
    """ID of the VRF to return.

    To get the VRF ID, use a [VrfService.List] request.
    """
    def __init__(
        self,
        *,
        vrf_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["vrf_id", b"vrf_id"]) -> None: ...

global___GetVrfRequest = GetVrfRequest

@typing.final
class ListVrfRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to list VRFs in.

    To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is greater than `page_size`,
    the service returns a [ListConfigurationsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    Default value is 20.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set `page_token` to the
    [ListConfigurationsResponse.next_page_token] returned by a previous list request.
    """
    order_by: builtins.str
    """By which column the listing should be ordered and in which direction,
    format is "createdAt desc". "id asc" if omitted.
    Supported fields: ["id", "name", "createdAt"].
    Both snake_case and camelCase are supported for fields.
    """
    filter: builtins.str
    """A filter expression that filters resources listed in the response.
    The expression consists of one or more conditions united by `AND` operator: `<condition1> [AND <condition2> [<...> AND <conditionN>]]`.

    Each condition has the form `<field> <operator> <value>`, where:
    1. `<field>` is the field name. Currently you can use filtering only on the limited number of fields.
    2. `<operator>` is a logical operator, one of `=` (equal), `:` (substring).
    3. `<value>` represents a value.
    String values should be written in double (`"`) or single (`'`) quotes. C-style escape sequences are supported (`\\"` turns to `"`, `\\'` to `'`, `\\\\` to backslash).
    Example: "key1='value' AND key2='value'"
    Supported operators: ["AND"].
    Supported fields: ["id", "name"].
    Both snake_case and camelCase are supported for fields.
    """
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        order_by: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "folder_id", b"folder_id", "order_by", b"order_by", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListVrfRequest = ListVrfRequest

@typing.final
class ListVrfResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VRFS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    [ListVrfRequest.page_size], use `next_page_token` as the value
    for the [ListVrfRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `next_page_token` to continue paging through the results.
    """
    @property
    def vrfs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.baremetal.v1alpha.vrf_pb2.Vrf]:
        """List of VRF resources."""

    def __init__(
        self,
        *,
        vrfs: collections.abc.Iterable[yandex.cloud.baremetal.v1alpha.vrf_pb2.Vrf] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "vrfs", b"vrfs"]) -> None: ...

global___ListVrfResponse = ListVrfResponse

@typing.final
class CreateVrfRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to create a VRF in.

    To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    name: builtins.str
    """Name of the VRF.
    The name must be unique within the folder.
    """
    description: builtins.str
    """Description of the VRF."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `key:value` pairs."""

    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "folder_id", b"folder_id", "labels", b"labels", "name", b"name"]) -> None: ...

global___CreateVrfRequest = CreateVrfRequest

@typing.final
class CreateVrfMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VRF_ID_FIELD_NUMBER: builtins.int
    vrf_id: builtins.str
    """ID of the VRF that is being created."""
    def __init__(
        self,
        *,
        vrf_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["vrf_id", b"vrf_id"]) -> None: ...

global___CreateVrfMetadata = CreateVrfMetadata

@typing.final
class UpdateVrfRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    VRF_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    vrf_id: builtins.str
    """ID of the VRF to update.

    To get the VRF ID, use a [VrfService.List] request.
    """
    name: builtins.str
    """Name of the VRF.
    The name must be unique within the folder.
    """
    description: builtins.str
    """Description of the VRF."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which attributes of the VRF should be updated."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `key:value` pairs.

        Existing set of labels is completely replaced by the provided set.
        """

    def __init__(
        self,
        *,
        vrf_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "labels", b"labels", "name", b"name", "update_mask", b"update_mask", "vrf_id", b"vrf_id"]) -> None: ...

global___UpdateVrfRequest = UpdateVrfRequest

@typing.final
class UpdateVrfMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VRF_ID_FIELD_NUMBER: builtins.int
    vrf_id: builtins.str
    """ID of the VRF that is being updated."""
    def __init__(
        self,
        *,
        vrf_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["vrf_id", b"vrf_id"]) -> None: ...

global___UpdateVrfMetadata = UpdateVrfMetadata

@typing.final
class DeleteVrfRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VRF_ID_FIELD_NUMBER: builtins.int
    vrf_id: builtins.str
    """ID of the VRF to delete.

    To get the VRF ID, use a [VrfService.List] request.
    """
    def __init__(
        self,
        *,
        vrf_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["vrf_id", b"vrf_id"]) -> None: ...

global___DeleteVrfRequest = DeleteVrfRequest

@typing.final
class DeleteVrfMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VRF_ID_FIELD_NUMBER: builtins.int
    vrf_id: builtins.str
    """ID of the VRF resource that is being deleted."""
    def __init__(
        self,
        *,
        vrf_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["vrf_id", b"vrf_id"]) -> None: ...

global___DeleteVrfMetadata = DeleteVrfMetadata

@typing.final
class ListVrfOperationsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VRF_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    vrf_id: builtins.str
    """ID of the VRF resource to list operations for."""
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is greater than `page_size`,
    the service returns a [ListVrfOperationsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    Default value is 20.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set `page_token` to the
    [ListVrfOperationsResponse.next_page_token] returned by a previous list request.
    """
    def __init__(
        self,
        *,
        vrf_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["page_size", b"page_size", "page_token", b"page_token", "vrf_id", b"vrf_id"]) -> None: ...

global___ListVrfOperationsRequest = ListVrfOperationsRequest

@typing.final
class ListVrfOperationsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    [ListVrfOperationsRequest.page_size], use `next_page_token` as the value
    for the [ListVrfOperationsRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `next_page_token` to continue paging through the results.
    """
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.operation.operation_pb2.Operation]:
        """List of operations for the specified VRF resource."""

    def __init__(
        self,
        *,
        operations: collections.abc.Iterable[yandex.cloud.operation.operation_pb2.Operation] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "operations", b"operations"]) -> None: ...

global___ListVrfOperationsResponse = ListVrfOperationsResponse
