"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _PricingVersionType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _PricingVersionTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_PricingVersionType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    PRICING_VERSION_TYPE_UNSPECIFIED: _PricingVersionType.ValueType  # 0
    STREET_PRICE: _PricingVersionType.ValueType  # 1
    """Regular price."""
    CONTRACT_PRICE: _PricingVersionType.ValueType  # 2
    """Price is overridden by a contract. Defined in the scope of a billing account."""

class PricingVersionType(_PricingVersionType, metaclass=_PricingVersionTypeEnumTypeWrapper):
    """Type of the pricing version."""

PRICING_VERSION_TYPE_UNSPECIFIED: PricingVersionType.ValueType  # 0
STREET_PRICE: PricingVersionType.ValueType  # 1
"""Regular price."""
CONTRACT_PRICE: PricingVersionType.ValueType  # 2
"""Price is overridden by a contract. Defined in the scope of a billing account."""
global___PricingVersionType = PricingVersionType

@typing.final
class Sku(google.protobuf.message.Message):
    """A Stock keeping unit resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    SERVICE_ID_FIELD_NUMBER: builtins.int
    PRICING_UNIT_FIELD_NUMBER: builtins.int
    PRICING_VERSIONS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the SKU."""
    name: builtins.str
    """Name of the SKU."""
    description: builtins.str
    """Description of the sku."""
    service_id: builtins.str
    """ID of the service that sku belongs to."""
    pricing_unit: builtins.str
    """Pricing unit of the SKU, e.g. `core*hour`, `gbyte*hour`."""
    @property
    def pricing_versions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PricingVersion]:
        """List of pricing versions."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        service_id: builtins.str = ...,
        pricing_unit: builtins.str = ...,
        pricing_versions: collections.abc.Iterable[global___PricingVersion] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "id", b"id", "name", b"name", "pricing_unit", b"pricing_unit", "pricing_versions", b"pricing_versions", "service_id", b"service_id"]) -> None: ...

global___Sku = Sku

@typing.final
class PricingVersion(google.protobuf.message.Message):
    """Pricing version of the SKU.
    Defines current and past prices for the sku.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TYPE_FIELD_NUMBER: builtins.int
    EFFECTIVE_TIME_FIELD_NUMBER: builtins.int
    PRICING_EXPRESSIONS_FIELD_NUMBER: builtins.int
    type: global___PricingVersionType.ValueType
    """Type of the pricing version."""
    @property
    def effective_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp pricing version is active since inclusive.
        The pricing version is active until next pricing version effective time exclusive.
        """

    @property
    def pricing_expressions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PricingExpression]:
        """List of pricing expressions."""

    def __init__(
        self,
        *,
        type: global___PricingVersionType.ValueType = ...,
        effective_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        pricing_expressions: collections.abc.Iterable[global___PricingExpression] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["effective_time", b"effective_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["effective_time", b"effective_time", "pricing_expressions", b"pricing_expressions", "type", b"type"]) -> None: ...

global___PricingVersion = PricingVersion

@typing.final
class PricingExpression(google.protobuf.message.Message):
    """Pricing expression of the pricing version.
    Defines price for the sku.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RATES_FIELD_NUMBER: builtins.int
    @property
    def rates(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Rate]:
        """List of rates."""

    def __init__(
        self,
        *,
        rates: collections.abc.Iterable[global___Rate] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["rates", b"rates"]) -> None: ...

global___PricingExpression = PricingExpression

@typing.final
class Rate(google.protobuf.message.Message):
    """Rate of the pricing expression.
    Define unit price for pricing quantity interval.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    START_PRICING_QUANTITY_FIELD_NUMBER: builtins.int
    UNIT_PRICE_FIELD_NUMBER: builtins.int
    CURRENCY_FIELD_NUMBER: builtins.int
    start_pricing_quantity: builtins.str
    """Start of the pricing quantity interval. The end of the interval is the start pricing quantity of the next rate."""
    unit_price: builtins.str
    """Unit price for the pricing quantity interval."""
    currency: builtins.str
    """Currency of the unit price.
    Can be one of the following:
    * `RUB`
    * `USD`
    * `KZT`
    """
    def __init__(
        self,
        *,
        start_pricing_quantity: builtins.str = ...,
        unit_price: builtins.str = ...,
        currency: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["currency", b"currency", "start_pricing_quantity", b"start_pricing_quantity", "unit_price", b"unit_price"]) -> None: ...

global___Rate = Rate
