"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _OriginProtocol:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _OriginProtocolEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_OriginProtocol.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ORIGIN_PROTOCOL_UNSPECIFIED: _OriginProtocol.ValueType  # 0
    HTTP: _OriginProtocol.ValueType  # 1
    """CDN servers will connect to your origin via HTTP."""
    HTTPS: _OriginProtocol.ValueType  # 2
    """CDN servers will connect to your origin via HTTPS."""
    MATCH: _OriginProtocol.ValueType  # 3
    """Connection protocol will be chosen automatically (content on the
    origin source should be available for the CDN both through HTTP and HTTPS).
    """

class OriginProtocol(_OriginProtocol, metaclass=_OriginProtocolEnumTypeWrapper):
    """This option defines the protocol that will be used by CDN servers to request
    content from an origin source. If not specified, we will use HTTP to connect
    to an origin server.
    """

ORIGIN_PROTOCOL_UNSPECIFIED: OriginProtocol.ValueType  # 0
HTTP: OriginProtocol.ValueType  # 1
"""CDN servers will connect to your origin via HTTP."""
HTTPS: OriginProtocol.ValueType  # 2
"""CDN servers will connect to your origin via HTTPS."""
MATCH: OriginProtocol.ValueType  # 3
"""Connection protocol will be chosen automatically (content on the
origin source should be available for the CDN both through HTTP and HTTPS).
"""
global___OriginProtocol = OriginProtocol

class _RewriteFlag:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _RewriteFlagEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_RewriteFlag.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    REWRITE_FLAG_UNSPECIFIED: _RewriteFlag.ValueType  # 0
    LAST: _RewriteFlag.ValueType  # 1
    """Stops processing of the current set of ngx_http_rewrite_module directives and
    starts a search for a new location matching changed URI.
    """
    BREAK: _RewriteFlag.ValueType  # 2
    """Stops processing of the current set of the Rewrite option."""
    REDIRECT: _RewriteFlag.ValueType  # 3
    """Returns a temporary redirect with the 302 code; It is used when a replacement string does not start
    with "http://", "https://", or "$scheme".
    """
    PERMANENT: _RewriteFlag.ValueType  # 4
    """Returns a permanent redirect with the 301 code."""

class RewriteFlag(_RewriteFlag, metaclass=_RewriteFlagEnumTypeWrapper):
    """RewriteFlag defines flag for the Rewrite option."""

REWRITE_FLAG_UNSPECIFIED: RewriteFlag.ValueType  # 0
LAST: RewriteFlag.ValueType  # 1
"""Stops processing of the current set of ngx_http_rewrite_module directives and
starts a search for a new location matching changed URI.
"""
BREAK: RewriteFlag.ValueType  # 2
"""Stops processing of the current set of the Rewrite option."""
REDIRECT: RewriteFlag.ValueType  # 3
"""Returns a temporary redirect with the 302 code; It is used when a replacement string does not start
with "http://", "https://", or "$scheme".
"""
PERMANENT: RewriteFlag.ValueType  # 4
"""Returns a permanent redirect with the 301 code."""
global___RewriteFlag = RewriteFlag

class _SecureKeyURLType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _SecureKeyURLTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_SecureKeyURLType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    SECURE_KEY_URL_TYPE_UNSPECIFIED: _SecureKeyURLType.ValueType  # 0
    ENABLE_IP_SIGNING: _SecureKeyURLType.ValueType  # 1
    """Use scpecific IP address in URL signing. URL will be availible only for this IP."""
    DISABLE_IP_SIGNING: _SecureKeyURLType.ValueType  # 2
    """Sign URL without using IP address. URL will be available for all IP addresses."""

class SecureKeyURLType(_SecureKeyURLType, metaclass=_SecureKeyURLTypeEnumTypeWrapper):
    """SecureKeyURLType defines type of the URL signing."""

SECURE_KEY_URL_TYPE_UNSPECIFIED: SecureKeyURLType.ValueType  # 0
ENABLE_IP_SIGNING: SecureKeyURLType.ValueType  # 1
"""Use scpecific IP address in URL signing. URL will be availible only for this IP."""
DISABLE_IP_SIGNING: SecureKeyURLType.ValueType  # 2
"""Sign URL without using IP address. URL will be available for all IP addresses."""
global___SecureKeyURLType = SecureKeyURLType

class _PolicyType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _PolicyTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_PolicyType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    POLICY_TYPE_UNSPECIFIED: _PolicyType.ValueType  # 0
    POLICY_TYPE_ALLOW: _PolicyType.ValueType  # 1
    """Allow access to all IP addresses except the ones specified in the excepted_values field."""
    POLICY_TYPE_DENY: _PolicyType.ValueType  # 2
    """Block access to all IP addresses except the ones specified in the excepted_values field."""

class PolicyType(_PolicyType, metaclass=_PolicyTypeEnumTypeWrapper):
    """PolicyType defines type of the policy in IP address acl rules."""

POLICY_TYPE_UNSPECIFIED: PolicyType.ValueType  # 0
POLICY_TYPE_ALLOW: PolicyType.ValueType  # 1
"""Allow access to all IP addresses except the ones specified in the excepted_values field."""
POLICY_TYPE_DENY: PolicyType.ValueType  # 2
"""Block access to all IP addresses except the ones specified in the excepted_values field."""
global___PolicyType = PolicyType

class _SSLCertificateType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _SSLCertificateTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_SSLCertificateType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    SSL_CERTIFICATE_TYPE_UNSPECIFIED: _SSLCertificateType.ValueType  # 0
    """SSL certificate is unspecified."""
    DONT_USE: _SSLCertificateType.ValueType  # 1
    """No SSL certificate is added, the requests are sent via HTTP."""
    LETS_ENCRYPT_GCORE: _SSLCertificateType.ValueType  # 2
    """The option is deprecated. Works only if you have already pointed your domain name to the protected IP address in your DNS."""
    CM: _SSLCertificateType.ValueType  # 3
    """Add your SSL certificate by uploading the certificate in PEM format and your private key."""

class SSLCertificateType(_SSLCertificateType, metaclass=_SSLCertificateTypeEnumTypeWrapper):
    """A certificate type parameters."""

SSL_CERTIFICATE_TYPE_UNSPECIFIED: SSLCertificateType.ValueType  # 0
"""SSL certificate is unspecified."""
DONT_USE: SSLCertificateType.ValueType  # 1
"""No SSL certificate is added, the requests are sent via HTTP."""
LETS_ENCRYPT_GCORE: SSLCertificateType.ValueType  # 2
"""The option is deprecated. Works only if you have already pointed your domain name to the protected IP address in your DNS."""
CM: SSLCertificateType.ValueType  # 3
"""Add your SSL certificate by uploading the certificate in PEM format and your private key."""
global___SSLCertificateType = SSLCertificateType

class _SSLCertificateStatus:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _SSLCertificateStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_SSLCertificateStatus.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    SSL_CERTIFICATE_STATUS_UNSPECIFIED: _SSLCertificateStatus.ValueType  # 0
    """SSL certificate is unspecified."""
    READY: _SSLCertificateStatus.ValueType  # 1
    """SSL certificate is ready to use."""
    CREATING: _SSLCertificateStatus.ValueType  # 2
    """The option is deprecated. SSL certificate is creating."""

class SSLCertificateStatus(_SSLCertificateStatus, metaclass=_SSLCertificateStatusEnumTypeWrapper):
    """A certificate status parameters."""

SSL_CERTIFICATE_STATUS_UNSPECIFIED: SSLCertificateStatus.ValueType  # 0
"""SSL certificate is unspecified."""
READY: SSLCertificateStatus.ValueType  # 1
"""SSL certificate is ready to use."""
CREATING: SSLCertificateStatus.ValueType  # 2
"""The option is deprecated. SSL certificate is creating."""
global___SSLCertificateStatus = SSLCertificateStatus

@typing.final
class SecondaryHostnames(google.protobuf.message.Message):
    """List of secondary (alternative) CNAMEs."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALUES_FIELD_NUMBER: builtins.int
    @property
    def values(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of secondary hostname values."""

    def __init__(
        self,
        *,
        values: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["values", b"values"]) -> None: ...

global___SecondaryHostnames = SecondaryHostnames

@typing.final
class Resource(google.protobuf.message.Message):
    """
    A CDN resource - representation of providers resource.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    CNAME_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    UPDATED_AT_FIELD_NUMBER: builtins.int
    ACTIVE_FIELD_NUMBER: builtins.int
    OPTIONS_FIELD_NUMBER: builtins.int
    SECONDARY_HOSTNAMES_FIELD_NUMBER: builtins.int
    ORIGIN_GROUP_ID_FIELD_NUMBER: builtins.int
    ORIGIN_GROUP_NAME_FIELD_NUMBER: builtins.int
    ORIGIN_PROTOCOL_FIELD_NUMBER: builtins.int
    SSL_CERTIFICATE_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    PROVIDER_TYPE_FIELD_NUMBER: builtins.int
    PROVIDER_CNAME_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the resource."""
    folder_id: builtins.str
    """Folder id."""
    cname: builtins.str
    """CDN endpoint CNAME, must be unique among resources."""
    active: builtins.bool
    """Flag to create Resource either in active or disabled state.
    True - the content from CDN is available to clients.
    False - the content from CDN isn't available to clients.
    """
    origin_group_id: builtins.int
    """ID of the origin group."""
    origin_group_name: builtins.str
    """Name of the origin group."""
    origin_protocol: global___OriginProtocol.ValueType
    """Specify the protocol schema to be used in communication with origin."""
    provider_type: builtins.str
    """Type of the CDN provider for this resource."""
    provider_cname: builtins.str
    """CNAME provided by the CDN provider for this resource."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp."""

    @property
    def updated_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Update timestamp."""

    @property
    def options(self) -> global___ResourceOptions:
        """Resource settings and options to tune CDN edge behavior."""

    @property
    def secondary_hostnames(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of secondary hostname strings."""

    @property
    def ssl_certificate(self) -> global___SSLCertificate:
        """SSL certificate options."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Labels of the resource."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        cname: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        updated_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        active: builtins.bool = ...,
        options: global___ResourceOptions | None = ...,
        secondary_hostnames: collections.abc.Iterable[builtins.str] | None = ...,
        origin_group_id: builtins.int = ...,
        origin_group_name: builtins.str = ...,
        origin_protocol: global___OriginProtocol.ValueType = ...,
        ssl_certificate: global___SSLCertificate | None = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        provider_type: builtins.str = ...,
        provider_cname: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at", "options", b"options", "ssl_certificate", b"ssl_certificate", "updated_at", b"updated_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["active", b"active", "cname", b"cname", "created_at", b"created_at", "folder_id", b"folder_id", "id", b"id", "labels", b"labels", "options", b"options", "origin_group_id", b"origin_group_id", "origin_group_name", b"origin_group_name", "origin_protocol", b"origin_protocol", "provider_cname", b"provider_cname", "provider_type", b"provider_type", "secondary_hostnames", b"secondary_hostnames", "ssl_certificate", b"ssl_certificate", "updated_at", b"updated_at"]) -> None: ...

global___Resource = Resource

@typing.final
class ResourceOptions(google.protobuf.message.Message):
    """A major set of various resource options."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class BoolOption(google.protobuf.message.Message):
        """Set up bool values."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ENABLED_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        enabled: builtins.bool
        """True - the option is enabled and its [value] is applied to the resource.
        False - the option is disabled and its default value is used for the resource.
        """
        value: builtins.bool
        """Value of the option."""
        def __init__(
            self,
            *,
            enabled: builtins.bool = ...,
            value: builtins.bool = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["enabled", b"enabled", "value", b"value"]) -> None: ...

    @typing.final
    class StringOption(google.protobuf.message.Message):
        """A set of the string parameters."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ENABLED_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        enabled: builtins.bool
        """True - the option is enabled and its [value] is applied to the resource.
        False - the option is disabled and its default value is used for the resource.
        """
        value: builtins.str
        """Value of the option."""
        def __init__(
            self,
            *,
            enabled: builtins.bool = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["enabled", b"enabled", "value", b"value"]) -> None: ...

    @typing.final
    class Int64Option(google.protobuf.message.Message):
        """A set of the numeric parameters."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ENABLED_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        enabled: builtins.bool
        """True - the option is enabled and its [value] is applied to the resource.
        False - the option is disabled and its default value is used for the resource.
        """
        value: builtins.int
        """Value of the option."""
        def __init__(
            self,
            *,
            enabled: builtins.bool = ...,
            value: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["enabled", b"enabled", "value", b"value"]) -> None: ...

    @typing.final
    class StringsListOption(google.protobuf.message.Message):
        """A set of the string list parameters."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ENABLED_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        enabled: builtins.bool
        """True - the option is enabled and its [value] is applied to the resource.
        False - the option is disabled and its default value is used for the resource.
        """
        @property
        def value(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """Value of the option."""

        def __init__(
            self,
            *,
            enabled: builtins.bool = ...,
            value: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["enabled", b"enabled", "value", b"value"]) -> None: ...

    @typing.final
    class StringsMapOption(google.protobuf.message.Message):
        """A set of the strings map parameters."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        @typing.final
        class ValueEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: builtins.str
            value: builtins.str
            def __init__(
                self,
                *,
                key: builtins.str = ...,
                value: builtins.str = ...,
            ) -> None: ...
            def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

        ENABLED_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        enabled: builtins.bool
        """True - the option is enabled and its [value] is applied to the resource.
        False - the option is disabled and its default value is used for the resource.
        """
        @property
        def value(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
            """Value of the option."""

        def __init__(
            self,
            *,
            enabled: builtins.bool = ...,
            value: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["enabled", b"enabled", "value", b"value"]) -> None: ...

    @typing.final
    class CachingTimes(google.protobuf.message.Message):
        """A set of the caching response time parameters."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        @typing.final
        class CustomValuesEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: builtins.str
            value: builtins.int
            def __init__(
                self,
                *,
                key: builtins.str = ...,
                value: builtins.int = ...,
            ) -> None: ...
            def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

        SIMPLE_VALUE_FIELD_NUMBER: builtins.int
        CUSTOM_VALUES_FIELD_NUMBER: builtins.int
        simple_value: builtins.int
        """Caching time for a response with codes 200, 206, 301, 302.
        Responses with codes 4xx, 5xx will not be cached. Use `0s` disable to caching.
        Use [custom_values] field to specify a custom caching time for a response with specific codes.
        """
        @property
        def custom_values(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.int]:
            """Caching time for a response with specific codes. These settings have a higher priority than the value field.
            Response code (`304`, `404` for example). Use `any` to specify caching time for all response codes.
            Caching time in seconds (`0s`, `600s` for example). Use `0s` to disable caching for a specific response code.
            """

        def __init__(
            self,
            *,
            simple_value: builtins.int = ...,
            custom_values: collections.abc.Mapping[builtins.str, builtins.int] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["custom_values", b"custom_values", "simple_value", b"simple_value"]) -> None: ...

    @typing.final
    class EdgeCacheSettings(google.protobuf.message.Message):
        """A set of the edge cache parameters."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ENABLED_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        DEFAULT_VALUE_FIELD_NUMBER: builtins.int
        enabled: builtins.bool
        """True - the option is enabled and its `values_variant` is applied to the resource.
        False - the option is disabled and its default value is used for the resource.
        """
        default_value: builtins.int
        """Content will be cached according to origin cache settings.
        The value applies for a response with codes 200, 201, 204, 206, 301, 302, 303, 304, 307, 308
        if an origin server does not have caching HTTP headers.
        Responses with other codes will not be cached.
        """
        @property
        def value(self) -> global___ResourceOptions.CachingTimes:
            """Value of the option."""

        def __init__(
            self,
            *,
            enabled: builtins.bool = ...,
            value: global___ResourceOptions.CachingTimes | None = ...,
            default_value: builtins.int = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["default_value", b"default_value", "value", b"value", "values_variant", b"values_variant"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["default_value", b"default_value", "enabled", b"enabled", "value", b"value", "values_variant", b"values_variant"]) -> None: ...
        def WhichOneof(self, oneof_group: typing.Literal["values_variant", b"values_variant"]) -> typing.Literal["value", "default_value"] | None: ...

    @typing.final
    class StringVariableMapOption(google.protobuf.message.Message):
        """A set of the string variable map parameters."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        @typing.final
        class OneofString(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            VALUE_FIELD_NUMBER: builtins.int
            VALUES_FIELD_NUMBER: builtins.int
            @property
            def value(self) -> global___ResourceOptions.StringOption:
                """Using [StringOption] to set value."""

            @property
            def values(self) -> global___ResourceOptions.StringsListOption:
                """Using [StringsListOption] to set values."""

            def __init__(
                self,
                *,
                value: global___ResourceOptions.StringOption | None = ...,
                values: global___ResourceOptions.StringsListOption | None = ...,
            ) -> None: ...
            def HasField(self, field_name: typing.Literal["string_option", b"string_option", "value", b"value", "values", b"values"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing.Literal["string_option", b"string_option", "value", b"value", "values", b"values"]) -> None: ...
            def WhichOneof(self, oneof_group: typing.Literal["string_option", b"string_option"]) -> typing.Literal["value", "values"] | None: ...

        @typing.final
        class ValueEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: builtins.str
            @property
            def value(self) -> global___ResourceOptions.StringVariableMapOption.OneofString: ...
            def __init__(
                self,
                *,
                key: builtins.str = ...,
                value: global___ResourceOptions.StringVariableMapOption.OneofString | None = ...,
            ) -> None: ...
            def HasField(self, field_name: typing.Literal["value", b"value"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

        ENABLED_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        enabled: builtins.bool
        """True - the option is enabled and its [value] is applied to the resource.
        False - the option is disabled and its default value is used for the resource.
        """
        @property
        def value(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___ResourceOptions.StringVariableMapOption.OneofString]:
            """Value of the option."""

        def __init__(
            self,
            *,
            enabled: builtins.bool = ...,
            value: collections.abc.Mapping[builtins.str, global___ResourceOptions.StringVariableMapOption.OneofString] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["enabled", b"enabled", "value", b"value"]) -> None: ...

    @typing.final
    class QueryParamsOptions(google.protobuf.message.Message):
        """A set of the query parameters."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        IGNORE_QUERY_STRING_FIELD_NUMBER: builtins.int
        QUERY_PARAMS_WHITELIST_FIELD_NUMBER: builtins.int
        QUERY_PARAMS_BLACKLIST_FIELD_NUMBER: builtins.int
        @property
        def ignore_query_string(self) -> global___ResourceOptions.BoolOption:
            """Using [BoolOption]. Selected by default. Files with different query parameters are cached as objects with the same key regardless of the parameter value."""

        @property
        def query_params_whitelist(self) -> global___ResourceOptions.StringsListOption:
            """Ignore All Except.
            Files with the specified query parameters are cached as objects with different keys,
            files with other parameters are cached as objects with the same key.
            """

        @property
        def query_params_blacklist(self) -> global___ResourceOptions.StringsListOption:
            """Ignore only. Files with the specified query parameters are cached as objects with the same key,
            files with other parameters are cached as objects with different keys.
            """

        def __init__(
            self,
            *,
            ignore_query_string: global___ResourceOptions.BoolOption | None = ...,
            query_params_whitelist: global___ResourceOptions.StringsListOption | None = ...,
            query_params_blacklist: global___ResourceOptions.StringsListOption | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["ignore_query_string", b"ignore_query_string", "query_params_blacklist", b"query_params_blacklist", "query_params_variant", b"query_params_variant", "query_params_whitelist", b"query_params_whitelist"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["ignore_query_string", b"ignore_query_string", "query_params_blacklist", b"query_params_blacklist", "query_params_variant", b"query_params_variant", "query_params_whitelist", b"query_params_whitelist"]) -> None: ...
        def WhichOneof(self, oneof_group: typing.Literal["query_params_variant", b"query_params_variant"]) -> typing.Literal["ignore_query_string", "query_params_whitelist", "query_params_blacklist"] | None: ...

    @typing.final
    class RedirectOptions(google.protobuf.message.Message):
        """A set of the redirect parameters."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        REDIRECT_HTTP_TO_HTTPS_FIELD_NUMBER: builtins.int
        REDIRECT_HTTPS_TO_HTTP_FIELD_NUMBER: builtins.int
        @property
        def redirect_http_to_https(self) -> global___ResourceOptions.BoolOption:
            """Using [BoolOption]. Set up a redirect from HTTPS to HTTP."""

        @property
        def redirect_https_to_http(self) -> global___ResourceOptions.BoolOption:
            """Using [BoolOption]. Set up a redirect from HTTP to HTTPS."""

        def __init__(
            self,
            *,
            redirect_http_to_https: global___ResourceOptions.BoolOption | None = ...,
            redirect_https_to_http: global___ResourceOptions.BoolOption | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["redirect_http_to_https", b"redirect_http_to_https", "redirect_https_to_http", b"redirect_https_to_http", "redirect_variant", b"redirect_variant"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["redirect_http_to_https", b"redirect_http_to_https", "redirect_https_to_http", b"redirect_https_to_http", "redirect_variant", b"redirect_variant"]) -> None: ...
        def WhichOneof(self, oneof_group: typing.Literal["redirect_variant", b"redirect_variant"]) -> typing.Literal["redirect_http_to_https", "redirect_https_to_http"] | None: ...

    @typing.final
    class HostOptions(google.protobuf.message.Message):
        """A set of the host parameters."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        HOST_FIELD_NUMBER: builtins.int
        FORWARD_HOST_HEADER_FIELD_NUMBER: builtins.int
        @property
        def host(self) -> global___ResourceOptions.StringOption:
            """Custom value for the Host header.

            Your server must be able to process requests with the chosen header.

            Default value (if [StringOption.enabled] is `false`) is [Resource.cname].
            """

        @property
        def forward_host_header(self) -> global___ResourceOptions.BoolOption:
            """Using [BoolOption]. Choose the Forward Host header option if is important to send in the request to the Origin
            the same Host header as was sent in the request to CDN server.
            """

        def __init__(
            self,
            *,
            host: global___ResourceOptions.StringOption | None = ...,
            forward_host_header: global___ResourceOptions.BoolOption | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["forward_host_header", b"forward_host_header", "host", b"host", "host_variant", b"host_variant"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["forward_host_header", b"forward_host_header", "host", b"host", "host_variant", b"host_variant"]) -> None: ...
        def WhichOneof(self, oneof_group: typing.Literal["host_variant", b"host_variant"]) -> typing.Literal["host", "forward_host_header"] | None: ...

    @typing.final
    class CompressionOptions(google.protobuf.message.Message):
        """A set of the compression variant parameters."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        FETCH_COMPRESSED_FIELD_NUMBER: builtins.int
        GZIP_ON_FIELD_NUMBER: builtins.int
        BROTLI_COMPRESSION_FIELD_NUMBER: builtins.int
        @property
        def fetch_compressed(self) -> global___ResourceOptions.BoolOption:
            """The Fetch compressed option helps you to reduce
            the bandwidth between origin and CDN servers.
            Also, content delivery speed becomes higher because of reducing the time
            for compressing files in a CDN.
            """

        @property
        def gzip_on(self) -> global___ResourceOptions.BoolOption:
            """Using [BoolOption]. GZip compression at CDN servers reduces file size by 70% and can be as high as 90%."""

        @property
        def brotli_compression(self) -> global___ResourceOptions.StringsListOption:
            """The option allows to compress content with brotli on the CDN's end.

            Compression is performed on the Origin Shielding. If a pre-cache server doesn't active for a resource, compression does not occur even if the option is enabled.

            Specify the content-type for each type of content you wish to have compressed. CDN servers will request only uncompressed content from the origin.
            """

        def __init__(
            self,
            *,
            fetch_compressed: global___ResourceOptions.BoolOption | None = ...,
            gzip_on: global___ResourceOptions.BoolOption | None = ...,
            brotli_compression: global___ResourceOptions.StringsListOption | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["brotli_compression", b"brotli_compression", "compression_variant", b"compression_variant", "fetch_compressed", b"fetch_compressed", "gzip_on", b"gzip_on"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["brotli_compression", b"brotli_compression", "compression_variant", b"compression_variant", "fetch_compressed", b"fetch_compressed", "gzip_on", b"gzip_on"]) -> None: ...
        def WhichOneof(self, oneof_group: typing.Literal["compression_variant", b"compression_variant"]) -> typing.Literal["fetch_compressed", "gzip_on", "brotli_compression"] | None: ...

    @typing.final
    class RewriteOption(google.protobuf.message.Message):
        """An option for changing or redirecting query paths."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ENABLED_FIELD_NUMBER: builtins.int
        BODY_FIELD_NUMBER: builtins.int
        FLAG_FIELD_NUMBER: builtins.int
        enabled: builtins.bool
        """True - the option is enabled and its [flag] is applied to the resource.
        False - the option is disabled and its default value of the [flag] is used for the resource.
        """
        body: builtins.str
        """Pattern for rewrite.

        The value must have the following format: `<source path> <destination path>`, where both paths are regular expressions which use at least one group. E.g., `/foo/(.*) /bar/$1`.
        """
        flag: global___RewriteFlag.ValueType
        """Break flag is applied to the option by default.
        It is not shown in the field.
        """
        def __init__(
            self,
            *,
            enabled: builtins.bool = ...,
            body: builtins.str = ...,
            flag: global___RewriteFlag.ValueType = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["body", b"body", "enabled", b"enabled", "flag", b"flag"]) -> None: ...

    @typing.final
    class SecureKeyOption(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ENABLED_FIELD_NUMBER: builtins.int
        KEY_FIELD_NUMBER: builtins.int
        TYPE_FIELD_NUMBER: builtins.int
        enabled: builtins.bool
        """True - the option is enabled and its [flag] is applied to the resource.
        False - the option is disabled and its default value of the [flag] is used for the resource.
        """
        key: builtins.str
        """The key for the URL signing."""
        type: global___SecureKeyURLType.ValueType
        """The type of the URL signing. The URL could be available for all IP addresses or for the only one IP."""
        def __init__(
            self,
            *,
            enabled: builtins.bool = ...,
            key: builtins.str = ...,
            type: global___SecureKeyURLType.ValueType = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["enabled", b"enabled", "key", b"key", "type", b"type"]) -> None: ...

    @typing.final
    class IPAddressACLOption(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ENABLED_FIELD_NUMBER: builtins.int
        POLICY_TYPE_FIELD_NUMBER: builtins.int
        EXCEPTED_VALUES_FIELD_NUMBER: builtins.int
        enabled: builtins.bool
        """True - the option is enabled and its [flag] is applied to the resource.
        False - the option is disabled and its default value of the [flag] is used for the resource.
        """
        policy_type: global___PolicyType.ValueType
        """The policy type. One of allow or deny value."""
        @property
        def excepted_values(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """The list of IP addresses to be allowed or denied."""

        def __init__(
            self,
            *,
            enabled: builtins.bool = ...,
            policy_type: global___PolicyType.ValueType = ...,
            excepted_values: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["enabled", b"enabled", "excepted_values", b"excepted_values", "policy_type", b"policy_type"]) -> None: ...

    DISABLE_CACHE_FIELD_NUMBER: builtins.int
    EDGE_CACHE_SETTINGS_FIELD_NUMBER: builtins.int
    BROWSER_CACHE_SETTINGS_FIELD_NUMBER: builtins.int
    CACHE_HTTP_HEADERS_FIELD_NUMBER: builtins.int
    QUERY_PARAMS_OPTIONS_FIELD_NUMBER: builtins.int
    SLICE_FIELD_NUMBER: builtins.int
    COMPRESSION_OPTIONS_FIELD_NUMBER: builtins.int
    REDIRECT_OPTIONS_FIELD_NUMBER: builtins.int
    HOST_OPTIONS_FIELD_NUMBER: builtins.int
    STATIC_HEADERS_FIELD_NUMBER: builtins.int
    CORS_FIELD_NUMBER: builtins.int
    STALE_FIELD_NUMBER: builtins.int
    ALLOWED_HTTP_METHODS_FIELD_NUMBER: builtins.int
    PROXY_CACHE_METHODS_SET_FIELD_NUMBER: builtins.int
    DISABLE_PROXY_FORCE_RANGES_FIELD_NUMBER: builtins.int
    STATIC_REQUEST_HEADERS_FIELD_NUMBER: builtins.int
    CUSTOM_SERVER_NAME_FIELD_NUMBER: builtins.int
    IGNORE_COOKIE_FIELD_NUMBER: builtins.int
    REWRITE_FIELD_NUMBER: builtins.int
    SECURE_KEY_FIELD_NUMBER: builtins.int
    IP_ADDRESS_ACL_FIELD_NUMBER: builtins.int
    @property
    def disable_cache(self) -> global___ResourceOptions.BoolOption:
        """Set up a cache status."""

    @property
    def edge_cache_settings(self) -> global___ResourceOptions.EdgeCacheSettings:
        """Set up [EdgeCacheSettings]."""

    @property
    def browser_cache_settings(self) -> global___ResourceOptions.Int64Option:
        """Using [Int64Option]. Set up a cache period for the end-users browser.
        Content will be cached due to origin settings.
        If there are no cache settings on your origin, the content will not be cached.
        The list of HTTP response codes that can be cached in browsers: 200, 201, 204, 206, 301, 302, 303, 304, 307, 308.
        Other response codes will not be cached.
        The default value is 4 days.
        """

    @property
    def cache_http_headers(self) -> global___ResourceOptions.StringsListOption:
        """List HTTP headers that must be included in responses to clients."""

    @property
    def query_params_options(self) -> global___ResourceOptions.QueryParamsOptions:
        """Set up [QueryParamsOptions]."""

    @property
    def slice(self) -> global___ResourceOptions.BoolOption:
        """Files larger than 10 MB will be requested and cached in parts (no larger than 10 MB each part). It reduces time to first byte.

        The origin must support HTTP Range requests.

        By default the option is disabled.
        """

    @property
    def compression_options(self) -> global___ResourceOptions.CompressionOptions:
        """Set up compression variant."""

    @property
    def redirect_options(self) -> global___ResourceOptions.RedirectOptions:
        """Set up redirects."""

    @property
    def host_options(self) -> global___ResourceOptions.HostOptions:
        """Set up host parameters."""

    @property
    def static_headers(self) -> global___ResourceOptions.StringsMapOption:
        """Set up static headers that CDN servers send in responses to clients."""

    @property
    def cors(self) -> global___ResourceOptions.StringsListOption:
        """Parameter that lets browsers get access to selected resources from a domain
        different to a domain from which the request is received.
        [Read more](/docs/cdn/concepts/cors).
        """

    @property
    def stale(self) -> global___ResourceOptions.StringsListOption:
        """List of errors which instruct CDN servers to serve stale content to clients.

        Possible values: `error`, `http_403`, `http_404`, `http_429`, `http_500`, `http_502`, `http_503`, `http_504`, `invalid_header`, `timeout`, `updating`.
        """

    @property
    def allowed_http_methods(self) -> global___ResourceOptions.StringsListOption:
        """HTTP methods for your CDN content. By default the following methods
        are allowed: GET, HEAD, POST, PUT, PATCH, DELETE, OPTIONS.
        In case some methods are not allowed to the user, they will get the 405
        (Method Not Allowed) response. If the method is not supported,
        the user gets the 501 (Not Implemented) response.
        """

    @property
    def proxy_cache_methods_set(self) -> global___ResourceOptions.BoolOption:
        """Allows caching for GET, HEAD and POST requests."""

    @property
    def disable_proxy_force_ranges(self) -> global___ResourceOptions.BoolOption:
        """Disabling proxy force ranges."""

    @property
    def static_request_headers(self) -> global___ResourceOptions.StringsMapOption:
        """Set up custom headers that CDN servers send in requests to origins.
        The Header name field can contain letters (A-Z, a-z), numbers (0-9), dashes (-) and underscores (_).
        The Value field can contain letters (A-Z, a-z), numbers (0-9), dashes (-),
        underscores (_), slashes (/), colons (:), equal (=), dots (.), and spaces.
        """

    @property
    def custom_server_name(self) -> global___ResourceOptions.StringOption:
        """Wildcard additional CNAME.
        If a resource has a wildcard additional CNAME, you can use your own certificate for content delivery via HTTPS. Read-only.
        """

    @property
    def ignore_cookie(self) -> global___ResourceOptions.BoolOption:
        """Using [BoolOption] for ignoring cookie."""

    @property
    def rewrite(self) -> global___ResourceOptions.RewriteOption:
        """Changing or redirecting query paths."""

    @property
    def secure_key(self) -> global___ResourceOptions.SecureKeyOption:
        """Secure token to protect contect and limit access by IP addresses and time limits."""

    @property
    def ip_address_acl(self) -> global___ResourceOptions.IPAddressACLOption:
        """Manage the state of the IP access policy option.
        The option controls access to content from the specified IP addresses.
        """

    def __init__(
        self,
        *,
        disable_cache: global___ResourceOptions.BoolOption | None = ...,
        edge_cache_settings: global___ResourceOptions.EdgeCacheSettings | None = ...,
        browser_cache_settings: global___ResourceOptions.Int64Option | None = ...,
        cache_http_headers: global___ResourceOptions.StringsListOption | None = ...,
        query_params_options: global___ResourceOptions.QueryParamsOptions | None = ...,
        slice: global___ResourceOptions.BoolOption | None = ...,
        compression_options: global___ResourceOptions.CompressionOptions | None = ...,
        redirect_options: global___ResourceOptions.RedirectOptions | None = ...,
        host_options: global___ResourceOptions.HostOptions | None = ...,
        static_headers: global___ResourceOptions.StringsMapOption | None = ...,
        cors: global___ResourceOptions.StringsListOption | None = ...,
        stale: global___ResourceOptions.StringsListOption | None = ...,
        allowed_http_methods: global___ResourceOptions.StringsListOption | None = ...,
        proxy_cache_methods_set: global___ResourceOptions.BoolOption | None = ...,
        disable_proxy_force_ranges: global___ResourceOptions.BoolOption | None = ...,
        static_request_headers: global___ResourceOptions.StringsMapOption | None = ...,
        custom_server_name: global___ResourceOptions.StringOption | None = ...,
        ignore_cookie: global___ResourceOptions.BoolOption | None = ...,
        rewrite: global___ResourceOptions.RewriteOption | None = ...,
        secure_key: global___ResourceOptions.SecureKeyOption | None = ...,
        ip_address_acl: global___ResourceOptions.IPAddressACLOption | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["allowed_http_methods", b"allowed_http_methods", "browser_cache_settings", b"browser_cache_settings", "cache_http_headers", b"cache_http_headers", "compression_options", b"compression_options", "cors", b"cors", "custom_server_name", b"custom_server_name", "disable_cache", b"disable_cache", "disable_proxy_force_ranges", b"disable_proxy_force_ranges", "edge_cache_settings", b"edge_cache_settings", "host_options", b"host_options", "ignore_cookie", b"ignore_cookie", "ip_address_acl", b"ip_address_acl", "proxy_cache_methods_set", b"proxy_cache_methods_set", "query_params_options", b"query_params_options", "redirect_options", b"redirect_options", "rewrite", b"rewrite", "secure_key", b"secure_key", "slice", b"slice", "stale", b"stale", "static_headers", b"static_headers", "static_request_headers", b"static_request_headers"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["allowed_http_methods", b"allowed_http_methods", "browser_cache_settings", b"browser_cache_settings", "cache_http_headers", b"cache_http_headers", "compression_options", b"compression_options", "cors", b"cors", "custom_server_name", b"custom_server_name", "disable_cache", b"disable_cache", "disable_proxy_force_ranges", b"disable_proxy_force_ranges", "edge_cache_settings", b"edge_cache_settings", "host_options", b"host_options", "ignore_cookie", b"ignore_cookie", "ip_address_acl", b"ip_address_acl", "proxy_cache_methods_set", b"proxy_cache_methods_set", "query_params_options", b"query_params_options", "redirect_options", b"redirect_options", "rewrite", b"rewrite", "secure_key", b"secure_key", "slice", b"slice", "stale", b"stale", "static_headers", b"static_headers", "static_request_headers", b"static_request_headers"]) -> None: ...

global___ResourceOptions = ResourceOptions

@typing.final
class SSLTargetCertificate(google.protobuf.message.Message):
    """A set of the personal SSL certificate parameters."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TYPE_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    type: global___SSLCertificateType.ValueType
    """Type of the certificate."""
    @property
    def data(self) -> global___SSLCertificateData:
        """Certificate data."""

    def __init__(
        self,
        *,
        type: global___SSLCertificateType.ValueType = ...,
        data: global___SSLCertificateData | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["data", b"data"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["data", b"data", "type", b"type"]) -> None: ...

global___SSLTargetCertificate = SSLTargetCertificate

@typing.final
class SSLCertificate(google.protobuf.message.Message):
    """A SSL certificate parameters."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TYPE_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    type: global___SSLCertificateType.ValueType
    """Type of the certificate."""
    status: global___SSLCertificateStatus.ValueType
    """Active status."""
    @property
    def data(self) -> global___SSLCertificateData:
        """Certificate data."""

    def __init__(
        self,
        *,
        type: global___SSLCertificateType.ValueType = ...,
        status: global___SSLCertificateStatus.ValueType = ...,
        data: global___SSLCertificateData | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["data", b"data"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["data", b"data", "status", b"status", "type", b"type"]) -> None: ...

global___SSLCertificate = SSLCertificate

@typing.final
class SSLCertificateData(google.protobuf.message.Message):
    """A certificate data parameters."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CM_FIELD_NUMBER: builtins.int
    @property
    def cm(self) -> global___SSLCertificateCMData:
        """Custom (add your SSL certificate by uploading the certificate
        in PEM format and your private key).
        """

    def __init__(
        self,
        *,
        cm: global___SSLCertificateCMData | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["cm", b"cm", "ssl_certificate_data_variant", b"ssl_certificate_data_variant"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cm", b"cm", "ssl_certificate_data_variant", b"ssl_certificate_data_variant"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["ssl_certificate_data_variant", b"ssl_certificate_data_variant"]) -> typing.Literal["cm"] | None: ...

global___SSLCertificateData = SSLCertificateData

@typing.final
class SSLCertificateCMData(google.protobuf.message.Message):
    """A certificate data custom parameters."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the custom certificate."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["id", b"id"]) -> None: ...

global___SSLCertificateCMData = SSLCertificateCMData
