"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _CertificateType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _CertificateTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_CertificateType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    CERTIFICATE_TYPE_UNSPECIFIED: _CertificateType.ValueType  # 0
    IMPORTED: _CertificateType.ValueType  # 1
    """The certificate is imported by user."""
    MANAGED: _CertificateType.ValueType  # 2
    """The certificate is created by service."""

class CertificateType(_CertificateType, metaclass=_CertificateTypeEnumTypeWrapper):
    """Supported certificate types."""

CERTIFICATE_TYPE_UNSPECIFIED: CertificateType.ValueType  # 0
IMPORTED: CertificateType.ValueType  # 1
"""The certificate is imported by user."""
MANAGED: CertificateType.ValueType  # 2
"""The certificate is created by service."""
global___CertificateType = CertificateType

class _ChallengeType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ChallengeTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ChallengeType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    CHALLENGE_TYPE_UNSPECIFIED: _ChallengeType.ValueType  # 0
    DNS: _ChallengeType.ValueType  # 1
    """Domain validation type that using DNS-records."""
    HTTP: _ChallengeType.ValueType  # 2
    """Domain validation type that using HTTP-files."""

class ChallengeType(_ChallengeType, metaclass=_ChallengeTypeEnumTypeWrapper):
    """Supported domain validation types."""

CHALLENGE_TYPE_UNSPECIFIED: ChallengeType.ValueType  # 0
DNS: ChallengeType.ValueType  # 1
"""Domain validation type that using DNS-records."""
HTTP: ChallengeType.ValueType  # 2
"""Domain validation type that using HTTP-files."""
global___ChallengeType = ChallengeType

@typing.final
class Certificate(google.protobuf.message.Message):
    """A certificate. For details about the concept, see [documentation](/docs/certificate-manager/concepts/)."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Certificate._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: Certificate._Status.ValueType  # 0
        VALIDATING: Certificate._Status.ValueType  # 1
        """The certificate domains validation are required. Used only for managed certificates."""
        INVALID: Certificate._Status.ValueType  # 2
        """The certificate issuance is failed. Used only for managed certificates."""
        ISSUED: Certificate._Status.ValueType  # 3
        """The certificate is issued."""
        REVOKED: Certificate._Status.ValueType  # 4
        """The certificate is revoked."""
        RENEWING: Certificate._Status.ValueType  # 5
        """The certificate renewal is started. Used only for managed certificates."""
        RENEWAL_FAILED: Certificate._Status.ValueType  # 6
        """The certificate renewal is failed. Used only for managed certificates."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNSPECIFIED: Certificate.Status.ValueType  # 0
    VALIDATING: Certificate.Status.ValueType  # 1
    """The certificate domains validation are required. Used only for managed certificates."""
    INVALID: Certificate.Status.ValueType  # 2
    """The certificate issuance is failed. Used only for managed certificates."""
    ISSUED: Certificate.Status.ValueType  # 3
    """The certificate is issued."""
    REVOKED: Certificate.Status.ValueType  # 4
    """The certificate is revoked."""
    RENEWING: Certificate.Status.ValueType  # 5
    """The certificate renewal is started. Used only for managed certificates."""
    RENEWAL_FAILED: Certificate.Status.ValueType  # 6
    """The certificate renewal is failed. Used only for managed certificates."""

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    DOMAINS_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    ISSUER_FIELD_NUMBER: builtins.int
    SUBJECT_FIELD_NUMBER: builtins.int
    SERIAL_FIELD_NUMBER: builtins.int
    UPDATED_AT_FIELD_NUMBER: builtins.int
    ISSUED_AT_FIELD_NUMBER: builtins.int
    NOT_AFTER_FIELD_NUMBER: builtins.int
    NOT_BEFORE_FIELD_NUMBER: builtins.int
    CHALLENGES_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    INCOMPLETE_CHAIN_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the certificate. Generated at creation time."""
    folder_id: builtins.str
    """ID of the folder that the certificate belongs to."""
    name: builtins.str
    """Name of the certificate.
    The name is unique within the folder.
    """
    description: builtins.str
    """Description of the certificate."""
    type: global___CertificateType.ValueType
    """Type of the certificate."""
    status: global___Certificate.Status.ValueType
    """Status of the certificate."""
    issuer: builtins.str
    """[Distinguished Name](https://tools.ietf.org/html/rfc1779) of the certificate authority that issued the certificate."""
    subject: builtins.str
    """[Distinguished Name](https://tools.ietf.org/html/rfc1779) of the entity that is associated with the public key contained in the certificate."""
    serial: builtins.str
    """Serial number of the certificate."""
    deletion_protection: builtins.bool
    """Flag that protects deletion of the certificate"""
    incomplete_chain: builtins.bool
    """Mark imported certificates without uploaded chain or with chain which not lead to root certificate"""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Certificate labels as `key:value` pairs."""

    @property
    def domains(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Fully qualified domain names of the certificate."""

    @property
    def updated_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Time when the certificate is updated."""

    @property
    def issued_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Time when the certificate is issued."""

    @property
    def not_after(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Time after which the certificate is not valid."""

    @property
    def not_before(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Time before which the certificate is not valid."""

    @property
    def challenges(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Challenge]:
        """Domains validation challenges of the certificate. Used only for managed certificates."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        type: global___CertificateType.ValueType = ...,
        domains: collections.abc.Iterable[builtins.str] | None = ...,
        status: global___Certificate.Status.ValueType = ...,
        issuer: builtins.str = ...,
        subject: builtins.str = ...,
        serial: builtins.str = ...,
        updated_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        issued_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        not_after: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        not_before: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        challenges: collections.abc.Iterable[global___Challenge] | None = ...,
        deletion_protection: builtins.bool = ...,
        incomplete_chain: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at", "issued_at", b"issued_at", "not_after", b"not_after", "not_before", b"not_before", "updated_at", b"updated_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["challenges", b"challenges", "created_at", b"created_at", "deletion_protection", b"deletion_protection", "description", b"description", "domains", b"domains", "folder_id", b"folder_id", "id", b"id", "incomplete_chain", b"incomplete_chain", "issued_at", b"issued_at", "issuer", b"issuer", "labels", b"labels", "name", b"name", "not_after", b"not_after", "not_before", b"not_before", "serial", b"serial", "status", b"status", "subject", b"subject", "type", b"type", "updated_at", b"updated_at"]) -> None: ...

global___Certificate = Certificate

@typing.final
class Challenge(google.protobuf.message.Message):
    """Domain validation challenge."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Challenge._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: Challenge._Status.ValueType  # 0
        PENDING: Challenge._Status.ValueType  # 1
        """The challenge is waiting to be completed."""
        PROCESSING: Challenge._Status.ValueType  # 2
        """The challenge is awaiting approval from Let's Encrypt."""
        VALID: Challenge._Status.ValueType  # 3
        """The challenge is complete."""
        INVALID: Challenge._Status.ValueType  # 4
        """The rights check for a specific domain failed or the one-week period allocated for the check expired."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNSPECIFIED: Challenge.Status.ValueType  # 0
    PENDING: Challenge.Status.ValueType  # 1
    """The challenge is waiting to be completed."""
    PROCESSING: Challenge.Status.ValueType  # 2
    """The challenge is awaiting approval from Let's Encrypt."""
    VALID: Challenge.Status.ValueType  # 3
    """The challenge is complete."""
    INVALID: Challenge.Status.ValueType  # 4
    """The rights check for a specific domain failed or the one-week period allocated for the check expired."""

    @typing.final
    class DnsRecord(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        TYPE_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        name: builtins.str
        """Name of the DNS record."""
        type: builtins.str
        """Type of the DNS-record."""
        value: builtins.str
        """Value of the DNS-record."""
        def __init__(
            self,
            *,
            name: builtins.str = ...,
            type: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["name", b"name", "type", b"type", "value", b"value"]) -> None: ...

    @typing.final
    class HttpFile(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        URL_FIELD_NUMBER: builtins.int
        CONTENT_FIELD_NUMBER: builtins.int
        url: builtins.str
        """Location of the HTTP file."""
        content: builtins.str
        """Content of the HTTP file."""
        def __init__(
            self,
            *,
            url: builtins.str = ...,
            content: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["content", b"content", "url", b"url"]) -> None: ...

    DOMAIN_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    UPDATED_AT_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    DNS_CHALLENGE_FIELD_NUMBER: builtins.int
    HTTP_CHALLENGE_FIELD_NUMBER: builtins.int
    domain: builtins.str
    """Domain of the challenge."""
    type: global___ChallengeType.ValueType
    """Type of the challenge."""
    status: global___Challenge.Status.ValueType
    """Status of the challenge."""
    message: builtins.str
    """Description of the challenge."""
    error: builtins.str
    """Error of the challenge."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Time when the challenge is created."""

    @property
    def updated_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Time when the challenge is updated."""

    @property
    def dns_challenge(self) -> global___Challenge.DnsRecord:
        """DNS-record."""

    @property
    def http_challenge(self) -> global___Challenge.HttpFile:
        """HTTP-file."""

    def __init__(
        self,
        *,
        domain: builtins.str = ...,
        type: global___ChallengeType.ValueType = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        updated_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        status: global___Challenge.Status.ValueType = ...,
        message: builtins.str = ...,
        error: builtins.str = ...,
        dns_challenge: global___Challenge.DnsRecord | None = ...,
        http_challenge: global___Challenge.HttpFile | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["challenge", b"challenge", "created_at", b"created_at", "dns_challenge", b"dns_challenge", "http_challenge", b"http_challenge", "updated_at", b"updated_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["challenge", b"challenge", "created_at", b"created_at", "dns_challenge", b"dns_challenge", "domain", b"domain", "error", b"error", "http_challenge", b"http_challenge", "message", b"message", "status", b"status", "type", b"type", "updated_at", b"updated_at"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["challenge", b"challenge"]) -> typing.Literal["dns_challenge", "http_challenge"] | None: ...

global___Challenge = Challenge

@typing.final
class Version(google.protobuf.message.Message):
    """A certificate version"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    CERTIFICATE_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the version."""
    certificate_id: builtins.str
    """ID of the certificate that the version belongs to."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Time when the version was created."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        certificate_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["certificate_id", b"certificate_id", "created_at", b"created_at", "id", b"id"]) -> None: ...

global___Version = Version
