"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.clouddesktop.v1.desktop_group_pb2
import yandex.cloud.clouddesktop.v1.desktop_pb2
import yandex.cloud.clouddesktop.v1.disk_pb2
import yandex.cloud.operation.operation_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetDesktopGroupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DESKTOP_GROUP_ID_FIELD_NUMBER: builtins.int
    desktop_group_id: builtins.str
    """ID of the desktop group resource to return.

    To get the desktop group ID use a [DesktopGroupService.List] request.
    """
    def __init__(
        self,
        *,
        desktop_group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["desktop_group_id", b"desktop_group_id"]) -> None: ...

global___GetDesktopGroupRequest = GetDesktopGroupRequest

@typing.final
class ListDesktopGroupsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to list desktop groups in.

    To get the folder ID use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size],
    the service returns a [ListDesktopGroupsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the
    [ListDesktopGroupsResponse.next_page_token] returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters resources listed in the response.
    The expression must specify:
    1. The field name. Currently you can use filtering only on [DesktopGroup.name] field.
    2. An operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN` for lists of values.
    3. Value or a list of values to compare against the values of the field.
    """
    order_by: builtins.str
    """Sorting the list by [DesktopGroup.name], [DesktopGroup.created_at] and [DesktopGroup.status] fields.
    The default sorting order is ascending.
    """
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
        order_by: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "folder_id", b"folder_id", "order_by", b"order_by", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListDesktopGroupsRequest = ListDesktopGroupsRequest

@typing.final
class ListDesktopGroupsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DESKTOP_GROUPS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListDesktopGroupsRequest.page_size], use
    the [next_page_token] as the value
    for the [ListDesktopGroupsRequest.page_token] query parameter
    in the next list request. Each subsequent list request will have its own
    [next_page_token] to continue paging through the results.
    """
    @property
    def desktop_groups(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.clouddesktop.v1.desktop_group_pb2.DesktopGroup]:
        """List of desktop groups."""

    def __init__(
        self,
        *,
        desktop_groups: collections.abc.Iterable[yandex.cloud.clouddesktop.v1.desktop_group_pb2.DesktopGroup] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["desktop_groups", b"desktop_groups", "next_page_token", b"next_page_token"]) -> None: ...

global___ListDesktopGroupsResponse = ListDesktopGroupsResponse

@typing.final
class ListDesktopGroupDesktopsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DESKTOP_GROUP_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    desktop_group_id: builtins.str
    """ID of the desktop group."""
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size],
    the service returns a [ListDesktopGroupDesktopsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the
    [ListDesktopGroupDesktopsResponse.next_page_token] returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters resources listed in the response.
    The expression must specify:
    1. The field name. Currently you can use filtering only on [Desktop.name] field.
    2. An operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN` for lists of values.
    3. Value or a list of values to compare against the values of the field.
    """
    order_by: builtins.str
    """Sorting the list by [Desktop.name], [Desktop.created_at] and [Desktop.status] fields.
    The default sorting order is ascending.
    """
    def __init__(
        self,
        *,
        desktop_group_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
        order_by: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["desktop_group_id", b"desktop_group_id", "filter", b"filter", "order_by", b"order_by", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListDesktopGroupDesktopsRequest = ListDesktopGroupDesktopsRequest

@typing.final
class ListDesktopGroupDesktopsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DESKTOPS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListDesktopGroupDesktopsRequest.page_size], use
    the [next_page_token] as the value
    for the [ListDesktopsDGS Request.page_token] query parameter
    in the next list request. Each subsequent list request will have its own
    [next_page_token] to continue paging through the results.
    """
    @property
    def desktops(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.clouddesktop.v1.desktop_pb2.Desktop]:
        """List of desktops."""

    def __init__(
        self,
        *,
        desktops: collections.abc.Iterable[yandex.cloud.clouddesktop.v1.desktop_pb2.Desktop] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["desktops", b"desktops", "next_page_token", b"next_page_token"]) -> None: ...

global___ListDesktopGroupDesktopsResponse = ListDesktopGroupDesktopsResponse

@typing.final
class ListDesktopGroupOperationsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DESKTOP_GROUP_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    desktop_group_id: builtins.str
    """ID of the desktop group."""
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size],
    the service returns a [ListDesktopGroupOperationsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the
    [ListDesktopGroupOperationsResponse.next_page_token] returned by a previous list request.
    """
    filter: builtins.str
    """Sorting the list by [DesktopGroup.name] field.
    The default sorting order is ascending.
    """
    def __init__(
        self,
        *,
        desktop_group_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["desktop_group_id", b"desktop_group_id", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListDesktopGroupOperationsRequest = ListDesktopGroupOperationsRequest

@typing.final
class ListDesktopGroupOperationsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListDesktopGroupOperationsRequest.page_size], use
    the [next_page_token] as the value
    for the [ListDesktopGroupOperationsRequest.page_token] query parameter
    in the next list request. Each subsequent list request will have its own
    [next_page_token] to continue paging through the results.
    """
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.operation.operation_pb2.Operation]:
        """List of operations for the specified desktop group."""

    def __init__(
        self,
        *,
        operations: collections.abc.Iterable[yandex.cloud.operation.operation_pb2.Operation] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "operations", b"operations"]) -> None: ...

global___ListDesktopGroupOperationsResponse = ListDesktopGroupOperationsResponse

@typing.final
class UpdateDesktopGroupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    DESKTOP_GROUP_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    DESKTOP_IMAGE_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    RESOURCES_SPEC_FIELD_NUMBER: builtins.int
    GROUP_CONFIG_FIELD_NUMBER: builtins.int
    BOOT_DISK_SPEC_FIELD_NUMBER: builtins.int
    DATA_DISK_SPEC_FIELD_NUMBER: builtins.int
    AUTO_UPDATE_POLICY_FIELD_NUMBER: builtins.int
    MANUAL_UPDATE_POLICY_FIELD_NUMBER: builtins.int
    desktop_group_id: builtins.str
    desktop_image_id: builtins.str
    name: builtins.str
    description: builtins.str
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask: ...
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]: ...
    @property
    def resources_spec(self) -> yandex.cloud.clouddesktop.v1.desktop_group_pb2.ResourcesSpec: ...
    @property
    def group_config(self) -> yandex.cloud.clouddesktop.v1.desktop_group_pb2.DesktopGroupConfiguration:
        """Configuration of the desktop group."""

    @property
    def boot_disk_spec(self) -> yandex.cloud.clouddesktop.v1.disk_pb2.DiskSpec:
        """Boot disk specification of the desktop group."""

    @property
    def data_disk_spec(self) -> yandex.cloud.clouddesktop.v1.disk_pb2.DiskSpec:
        """Data disk specification of the desktop group."""

    @property
    def auto_update_policy(self) -> yandex.cloud.clouddesktop.v1.desktop_group_pb2.AutoUpdatePolicy: ...
    @property
    def manual_update_policy(self) -> yandex.cloud.clouddesktop.v1.desktop_group_pb2.ManualUpdatePolicy: ...
    def __init__(
        self,
        *,
        desktop_group_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        desktop_image_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        resources_spec: yandex.cloud.clouddesktop.v1.desktop_group_pb2.ResourcesSpec | None = ...,
        group_config: yandex.cloud.clouddesktop.v1.desktop_group_pb2.DesktopGroupConfiguration | None = ...,
        boot_disk_spec: yandex.cloud.clouddesktop.v1.disk_pb2.DiskSpec | None = ...,
        data_disk_spec: yandex.cloud.clouddesktop.v1.disk_pb2.DiskSpec | None = ...,
        auto_update_policy: yandex.cloud.clouddesktop.v1.desktop_group_pb2.AutoUpdatePolicy | None = ...,
        manual_update_policy: yandex.cloud.clouddesktop.v1.desktop_group_pb2.ManualUpdatePolicy | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["auto_update_policy", b"auto_update_policy", "boot_disk_spec", b"boot_disk_spec", "data_disk_spec", b"data_disk_spec", "group_config", b"group_config", "manual_update_policy", b"manual_update_policy", "resources_spec", b"resources_spec", "update_mask", b"update_mask", "update_policy", b"update_policy"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["auto_update_policy", b"auto_update_policy", "boot_disk_spec", b"boot_disk_spec", "data_disk_spec", b"data_disk_spec", "description", b"description", "desktop_group_id", b"desktop_group_id", "desktop_image_id", b"desktop_image_id", "group_config", b"group_config", "labels", b"labels", "manual_update_policy", b"manual_update_policy", "name", b"name", "resources_spec", b"resources_spec", "update_mask", b"update_mask", "update_policy", b"update_policy"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["update_policy", b"update_policy"]) -> typing.Literal["auto_update_policy", "manual_update_policy"] | None: ...

global___UpdateDesktopGroupRequest = UpdateDesktopGroupRequest

@typing.final
class CreateDesktopGroupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    DESKTOP_IMAGE_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    RESOURCES_SPEC_FIELD_NUMBER: builtins.int
    NETWORK_INTERFACE_SPEC_FIELD_NUMBER: builtins.int
    BOOT_DISK_SPEC_FIELD_NUMBER: builtins.int
    DATA_DISK_SPEC_FIELD_NUMBER: builtins.int
    GROUP_CONFIG_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to create a DesktopGroup in.

    To get a folder ID make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    desktop_image_id: builtins.str
    """An image used to create a desktop boot disk"""
    name: builtins.str
    """Name of the DesktopGroup.
    The name must be unique within the folder.
    """
    description: builtins.str
    """Description of the DesktopGroup."""
    @property
    def resources_spec(self) -> yandex.cloud.clouddesktop.v1.desktop_group_pb2.ResourcesSpec:
        """Resource specification of the desktop group."""

    @property
    def network_interface_spec(self) -> yandex.cloud.clouddesktop.v1.desktop_group_pb2.NetworkInterfaceSpec:
        """Network interface specification of the desktop group."""

    @property
    def boot_disk_spec(self) -> yandex.cloud.clouddesktop.v1.disk_pb2.DiskSpec:
        """Boot disk specification of the desktop group."""

    @property
    def data_disk_spec(self) -> yandex.cloud.clouddesktop.v1.disk_pb2.DiskSpec:
        """Data disk specification of the desktop group."""

    @property
    def group_config(self) -> yandex.cloud.clouddesktop.v1.desktop_group_pb2.DesktopGroupConfiguration:
        """Configuration of the desktop group."""

    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        desktop_image_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        resources_spec: yandex.cloud.clouddesktop.v1.desktop_group_pb2.ResourcesSpec | None = ...,
        network_interface_spec: yandex.cloud.clouddesktop.v1.desktop_group_pb2.NetworkInterfaceSpec | None = ...,
        boot_disk_spec: yandex.cloud.clouddesktop.v1.disk_pb2.DiskSpec | None = ...,
        data_disk_spec: yandex.cloud.clouddesktop.v1.disk_pb2.DiskSpec | None = ...,
        group_config: yandex.cloud.clouddesktop.v1.desktop_group_pb2.DesktopGroupConfiguration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["boot_disk_spec", b"boot_disk_spec", "data_disk_spec", b"data_disk_spec", "group_config", b"group_config", "network_interface_spec", b"network_interface_spec", "resources_spec", b"resources_spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["boot_disk_spec", b"boot_disk_spec", "data_disk_spec", b"data_disk_spec", "description", b"description", "desktop_image_id", b"desktop_image_id", "folder_id", b"folder_id", "group_config", b"group_config", "name", b"name", "network_interface_spec", b"network_interface_spec", "resources_spec", b"resources_spec"]) -> None: ...

global___CreateDesktopGroupRequest = CreateDesktopGroupRequest

@typing.final
class CreateDesktopGroupMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DESKTOP_GROUP_ID_FIELD_NUMBER: builtins.int
    desktop_group_id: builtins.str
    """ID of the desktop group that is being created."""
    def __init__(
        self,
        *,
        desktop_group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["desktop_group_id", b"desktop_group_id"]) -> None: ...

global___CreateDesktopGroupMetadata = CreateDesktopGroupMetadata

@typing.final
class DeleteDesktopGroupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DESKTOP_GROUP_ID_FIELD_NUMBER: builtins.int
    desktop_group_id: builtins.str
    """ID of the desktop group to delete.

    To get a desktop group ID make a [DesktopGroupService.List] request.
    """
    def __init__(
        self,
        *,
        desktop_group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["desktop_group_id", b"desktop_group_id"]) -> None: ...

global___DeleteDesktopGroupRequest = DeleteDesktopGroupRequest

@typing.final
class DeleteDesktopGroupMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DESKTOP_GROUP_ID_FIELD_NUMBER: builtins.int
    desktop_group_id: builtins.str
    """ID of the desktop group that is being deleted."""
    def __init__(
        self,
        *,
        desktop_group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["desktop_group_id", b"desktop_group_id"]) -> None: ...

global___DeleteDesktopGroupMetadata = DeleteDesktopGroupMetadata

@typing.final
class UpdateDesktopGroupMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DESKTOP_GROUP_ID_FIELD_NUMBER: builtins.int
    desktop_group_id: builtins.str
    """ID of the desktop group that is being updated."""
    def __init__(
        self,
        *,
        desktop_group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["desktop_group_id", b"desktop_group_id"]) -> None: ...

global___UpdateDesktopGroupMetadata = UpdateDesktopGroupMetadata
